/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.common.enums.customer.PasswordTypeEnum;
import cc.lechun.common.enums.weixin.SubscribeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.ids.UuidUtil;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.sign.PasswordUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.customer.CustomerMapper;
import cc.lechun.mall.dao.customer.CustomerOpenidMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerListVo;
import cc.lechun.mall.entity.customer.CustomerMobileEntity;
import cc.lechun.mall.entity.customer.CustomerMobileVo;
import cc.lechun.mall.entity.customer.CustomerOnlineEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidVo;
import cc.lechun.mall.entity.customer.CustomerQueryVo;
import cc.lechun.mall.entity.customer.CustomerUnionIdVo;
import cc.lechun.mall.entity.customer.SubscribeVo;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import cc.lechun.mall.iservice.customer.CustomerOnlineInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.accountBalance.AccountBalanceService;
import cc.lechun.mall.service.customer.CustomerSafeQuestionService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.weixin.WeiXinBaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.FollowResult;
import weixin.popular.bean.user.User;

@Service
public class CustomerService
extends BaseService
implements CustomerInterface {
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerOpenidMapper customerOpenidMapper;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private WeiXinBaseService weiWinBaseService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CustomerSafeQuestionService customerSafeQuestionService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private AccountBalanceService accountBalanceService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private CustomerMobileInterface customerMobileService;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    private CustomerOnlineInterface customerOnlineService;

    @Override
    public void getWeixinFollowerCount() {
        Integer platFormId = 1;
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platFormId);
        FollowResult followResult = UserAPI.userGet((String)accessToken, (String)"");
        Integer total = followResult.getTotal();
        this.customerMapper.updateFollowerCount(platFormId, total, DateUtils.now());
    }

    @Override
    public PageInfo<CustomerListVo> getCustomerList(CustomerQueryVo customerQueryVo) {
        this.logger.info("\u641c\u7d22\u6761\u4ef6:{}", (Object)customerQueryVo.toString());
        ArrayList resultList = new ArrayList();
        if (customerQueryVo.getIsOnLine()) {
            PageInfo<CustomerOnlineEntity> cusertomerOnline = this.customerOnlineService.getCustomerList(customerQueryVo);
            if (cusertomerOnline == null) {
                return null;
            }
            cusertomerOnline.getList().forEach(c -> {
                CustomerEntity customerEntity = this.getCustomer(c.getCustomerId());
                CustomerListVo customerListVo = new CustomerListVo();
                BeanUtils.copyProperties((Object)customerEntity, (Object)customerListVo);
                customerListVo.setOnLine(customerQueryVo.getIsOnLine());
                customerListVo.setConsultTime(c.getCreateTime());
                customerListVo.setOpenId(customerEntity.getChannelCustomerId());
                resultList.add(customerListVo);
            });
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(resultList);
            pageInfo.setTotal(cusertomerOnline.getTotal());
            return pageInfo;
        }
        CustomerEntity customerEntity = new CustomerEntity();
        if (StringUtils.isNotEmpty((String)customerQueryVo.getMobile())) {
            customerEntity.setMobile(customerQueryVo.getMobile());
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getOpenId())) {
            CustomerOpenidEntity query = new CustomerOpenidEntity();
            query.setOpenId(customerQueryVo.getOpenId());
            CustomerOpenidEntity customerOpenidEntity = (CustomerOpenidEntity)this.customerOpenidMapper.getSingle(query);
            if (customerOpenidEntity != null) {
                customerEntity.setCustomerId(customerOpenidEntity.getCustomerId());
            } else {
                customerEntity.setChannelCustomerId(customerQueryVo.getOpenId());
            }
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getCustomerId())) {
            customerEntity.setCustomerId(customerQueryVo.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getNickName())) {
            customerEntity.setNickName(customerQueryVo.getNickName());
        }
        customerEntity.setStatus(1);
        Page page = PageHelper.startPage((int)customerQueryVo.getCurrentPage(), (int)customerQueryVo.getPageSize());
        page.setOrderBy("CUSTOMER_ID desc");
        this.customerMapper.getCustomerList(customerEntity);
        List list = page.toPageInfo().getList();
        list.forEach(c -> {
            CustomerListVo customerListVo = new CustomerListVo();
            BeanUtils.copyProperties((Object)c, (Object)customerListVo);
            customerListVo.setOnLine(customerQueryVo.getIsOnLine());
            customerListVo.setOpenId(c.getChannelCustomerId());
            customerListVo.setNickName(c.getNickName());
            resultList.add(customerListVo);
        });
        PageInfo pg = page.toPageInfo();
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(pg.getTotal());
        return pg2;
    }

    @Override
    public PageInfo<Map<String, String>> getAllNickNameAndOpenId(int page) {
        Page list = PageHelper.startPage((int)page, (int)10000);
        this.customerMapper.getAllNickNameAndOpenId();
        return list.toPageInfo();
    }

    @Override
    public Integer getUserSubscribe(String openId, Integer platFormId) {
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platFormId);
        User user = UserAPI.userInfo((String)accessToken, (String)openId);
        return user == null ? 0 : user.getSubscribe();
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomer", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomer(@ParameterValueKeyProvider String customerId) {
        return (CustomerEntity)this.customerMapper.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerBySign", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerBySign(@ParameterValueKeyProvider String sign) {
        return this.listToEntiy(this.customerMapper.getCustomerBySign(sign));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerOpenid", expiration=7200)
    @ReadDataSource
    public CustomerOpenidEntity getCustomerOpenid(@ParameterValueKeyProvider String customerOpenId) {
        return (CustomerOpenidEntity)this.customerOpenidMapper.selectByPrimaryKey((Serializable)((Object)customerOpenId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerByMobile", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerByMobile(@ParameterValueKeyProvider(order=0) String mobile, @ParameterValueKeyProvider(order=1) int platformGroupId) {
        return this.listToEntiy(this.customerMapper.getCustomerByMobile(mobile, platformGroupId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetail", expiration=7200)
    @ReadDataSource
    public CustomerDetailVo getCustomerDetail(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetail(customerId, platformId));
    }

    @Override
    @ReadDataSource
    public CustomerDetailVo getCustomerDetailBySign(@ParameterValueKeyProvider(order=0) String sign, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailBySign(sign, platformId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetailByOpenid")
    @ReadDataSource
    public CustomerDetailVo getCustomerDetailByOpenid(@ParameterValueKeyProvider(order=0) String openId, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openId, platformId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetailByOpenid")
    public CustomerDetailVo getCustomerDetailByOpenid(@ParameterValueKeyProvider String openId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid2(openId));
    }

    @Override
    @ReadDataSource
    public List<CustomerOpenidEntity> getCustomerOpenidList(String customerId) {
        CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
        customerOpenid.setCustomerId(customerId);
        return this.customerOpenidMapper.getList(customerOpenid);
    }

    @Override
    @ReadDataSource
    public List<CustomerOpenidEntity> getCustomerOpenidList(String customerId, Integer platformId) {
        CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
        customerOpenid.setCustomerId(customerId);
        customerOpenid.setPlatformId(platformId);
        return this.customerOpenidMapper.getList(customerOpenid);
    }

    @Override
    @Transactional
    public BaseJsonVo addCustomer4Wechat(int platformId, String openID, String unionid, String userName, String fxId, User user, String bindCode, String versionDetailId) throws IOException {
        boolean lock = this.redisLock.tryLock(openID + ":customer", 10000L);
        if (lock) {
            Boolean collectionFlag = false;
            PlatFormAndGroupVo platFormAndGroup = this.platFormService.getPlatFormAndGroup(platformId);
            if (platFormAndGroup == null) {
                return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5e73\u53f0");
            }
            if (user != null) {
                if (StringUtils.isEmpty((String)openID)) {
                    openID = user.getOpenid();
                }
                if (StringUtils.isEmpty((String)unionid) && !StringUtils.isEmpty((String)user.getUnionid())) {
                    unionid = user.getUnionid();
                }
                if (StringUtils.isEmpty((String)userName)) {
                    String string = userName = user.getNickname() == null ? "" : user.getNickname();
                }
            }
            if (!StringUtils.checkOpenID((String)openID)) {
                return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u53c2\u6570");
            }
            if (!StringUtils.isEmpty((String)unionid)) {
                this.mergeCustomer4UnionId(unionid, platFormAndGroup.getPlatformGroupId());
            }
            this.mergeCustomer4OpenId(platformId, openID);
            CustomerEntity customerEntity = null;
            CustomerOpenidEntity customerOpenid = null;
            CustomerDetailVo customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openID, platFormAndGroup.getPlatformId()));
            if (customerDeatail != null) {
                customerEntity = this.getCustomer(customerDeatail.getCustomerId());
                customerOpenid = this.getCustomerOpenid(customerDeatail.getCustomerOpenId());
            } else if (!StringUtils.isEmpty((String)unionid)) {
                customerEntity = this.listToEntiy(this.customerMapper.getCustomerByUnionid(unionid, platFormAndGroup.getPlatformGroupId()));
            }
            if (customerEntity != null) {
                this.removeCache(customerEntity);
                if (customerEntity.getSign() == null || customerEntity.getSign().length() < 60) {
                    customerEntity.setSign(this.getNewCustomerSign());
                }
                if (!StringUtils.isEmpty((String)unionid)) {
                    customerEntity.setUnionid(unionid);
                }
                if (!StringUtils.isEmpty((String)userName)) {
                    customerEntity.setNickName(userName);
                }
                if (!StringUtils.isEmpty((String)fxId)) {
                    customerEntity.setFxId(fxId);
                }
                if (user != null) {
                    this.userToCustomer(user, customerEntity);
                }
                this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            } else {
                customerEntity = new CustomerEntity();
                customerEntity.setIsNew(1);
                customerEntity.setSign(this.getNewCustomerSign());
                customerEntity.setCustomerId(this.getCustomerId(platFormAndGroup));
                customerEntity.setCreateTime(DateUtils.now());
                customerEntity.setVemail(this.getVemail());
                customerEntity.setPlatformGroupId(platFormAndGroup.getPlatformGroupId());
                customerEntity.setUnionid(unionid);
                customerEntity.setNickName(userName);
                customerEntity.setFxId(fxId);
                customerEntity.setChannelCustomerId(openID);
                if (user != null) {
                    this.userToCustomer(user, customerEntity);
                }
                customerEntity.setLoginName(customerEntity.getCustomerId());
                this.customerMapper.insertSelective(customerEntity);
                collectionFlag = true;
            }
            if (customerOpenid != null) {
                if (!StringUtils.isEmpty((String)bindCode)) {
                    customerOpenid.setBindCode(bindCode);
                }
                if (!StringUtils.isEmpty((String)versionDetailId)) {
                    customerOpenid.setVersionDetailId(versionDetailId);
                }
                if (!StringUtils.isEmpty((String)unionid)) {
                    customerOpenid.setUnionId(unionid);
                }
                if (user != null) {
                    this.userToCustomerOpenId(user, customerOpenid);
                }
                this.customerOpenidMapper.updateByPrimaryKeySelective(customerOpenid);
            } else {
                customerOpenid = new CustomerOpenidEntity();
                customerOpenid.setCustomerOpenId(this.getCustomerOpenID(platFormAndGroup));
                customerOpenid.setOpenId(openID);
                customerOpenid.setUnionId(unionid);
                customerOpenid.setPlatformId(platformId);
                customerOpenid.setCustomerId(customerEntity.getCustomerId());
                customerOpenid.setCreateTime(DateUtils.now());
                customerOpenid.setBindCode(bindCode);
                customerOpenid.setVersionDetailId(versionDetailId);
                customerOpenid.setSource(platformId == 4 ? 2 : platformId);
                if (user != null) {
                    this.userToCustomerOpenId(user, customerOpenid);
                }
                this.customerOpenidMapper.insertSelective(customerOpenid);
            }
            if (collectionFlag.booleanValue()) {
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)"", (Object)customerEntity.getCustomerId()));
            }
            return BaseJsonVo.success((Object)customerEntity);
        }
        return BaseJsonVo.error((String)"\u91cd\u590d\u6dfb\u52a0\u7528\u6237");
    }

    @Override
    public void subscribeMessageQueue(int platformId, String openId, String bindCode, String versionDetailId) {
        SubscribeVo vo = new SubscribeVo();
        vo.setPlatformId(platformId);
        vo.setOpenId(openId);
        vo.setBindCode(bindCode);
        vo.setVersionDetailId(versionDetailId);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.subscribe, MessageParam.messageParam((String)vo.getOpenId(), (Object)vo));
    }

    @Override
    public void unSubscribeMessageQueue(int platformId, String openId) {
        SubscribeVo vo = new SubscribeVo();
        vo.setPlatformId(platformId);
        vo.setOpenId(openId);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.unSubscribe, MessageParam.messageParam((String)vo.getOpenId(), (Object)vo));
    }

    @Override
    @Transactional
    public BaseJsonVo subscribe(SubscribeVo subscribeVo) throws IOException {
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(subscribeVo.getPlatformId());
        User user = UserAPI.userInfo((String)accessToken, (String)subscribeVo.getOpenId());
        BaseJsonVo vo = this.addCustomer4Wechat(subscribeVo.getPlatformId(), subscribeVo.getOpenId(), user.getUnionid(), user.getNickname(), "", user, subscribeVo.getBindCode(), subscribeVo.getVersionDetailId());
        this.customerMapper.subscribe(subscribeVo.getPlatformId(), subscribeVo.getOpenId(), SubscribeEnum.SUBSCRIBE.getValue());
        return vo;
    }

    @Override
    public BaseJsonVo unSubscribe(SubscribeVo subscribeVo) {
        this.customerMapper.subscribe(subscribeVo.getPlatformId(), subscribeVo.getOpenId(), SubscribeEnum.UNSUBSCRIBE.getValue());
        return BaseJsonVo.success((Object)"\u53d6\u6d88\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo addCustomer4Mobile(int platformId, String mobile, String bindCode, String versionDetailId) throws IOException {
        Boolean collectionFlag = false;
        PlatFormAndGroupVo platFormAndGroup = this.platFormService.getPlatFormAndGroup(platformId);
        if (platFormAndGroup == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5e73\u53f0");
        }
        if (mobile.length() != 11 || !mobile.startsWith("1")) {
            return BaseJsonVo.paramError((String)"\u624b\u673a\u683c\u5f0f\u9519\u8bef");
        }
        this.mergeCustomer4Mobile(mobile, platFormAndGroup.getPlatformGroupId());
        CustomerEntity customerEntity = null;
        CustomerDetailVo customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByMobile(mobile, platFormAndGroup.getPlatformId()));
        if (customerDeatail == null) {
            customerEntity = this.listToEntiy(this.customerMapper.getCustomerByMobile(mobile, platFormAndGroup.getPlatformGroupId()));
            if (customerEntity == null) {
                customerEntity = new CustomerEntity();
                customerEntity.setMobile(mobile);
                customerEntity.setIsNew(1);
                customerEntity.setSign(this.getNewCustomerSign());
                customerEntity.setCustomerId(this.getCustomerId(platFormAndGroup));
                customerEntity.setCreateTime(DateUtils.now());
                customerEntity.setVemail(this.getVemail());
                customerEntity.setPlatformGroupId(platFormAndGroup.getPlatformGroupId());
                customerEntity.setUnionid("");
                customerEntity.setNickName(mobile);
                customerEntity.setLoginName(customerEntity.getCustomerId());
                collectionFlag = true;
                this.customerMapper.insertSelective(customerEntity);
            }
            CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
            customerOpenid.setCustomerOpenId(this.getCustomerOpenID(platFormAndGroup));
            customerOpenid.setOpenId("");
            customerOpenid.setUnionId("");
            customerOpenid.setPlatformId(platformId);
            customerOpenid.setCustomerId(customerEntity.getCustomerId());
            customerOpenid.setCreateTime(DateUtils.now());
            customerOpenid.setBindCode(bindCode);
            customerOpenid.setVersionDetailId(versionDetailId);
            customerOpenid.setSource(platformId == 4 ? 2 : platformId);
            this.customerOpenidMapper.insertSelective(customerOpenid);
        } else {
            customerEntity = this.getCustomer(customerDeatail.getCustomerId());
        }
        if (collectionFlag.booleanValue()) {
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)"", (Object)customerEntity.getCustomerId()));
        }
        return BaseJsonVo.success((Object)customerEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo bindMobile(String mobile, String customerId, String safeQuestion) throws IOException {
        CustomerEntity customerNew = this.getCustomer(customerId);
        if (customerNew == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7528\u6237");
        }
        String old_mobile = customerNew.getMobile();
        List<CustomerEntity> customer4Mobiles = this.customerMapper.getCustomerByMobile(mobile, customerNew.getPlatformGroupId());
        if (customer4Mobiles != null && customer4Mobiles.size() > 0) {
            for (CustomerEntity customerOld : customer4Mobiles) {
                if (customerOld.getCustomerId().equals(customerNew.getCustomerId())) continue;
                this.removeCache(customerOld);
                customerOld.setMobile(null);
                customerOld.setPayPassword(null);
                this.customerMapper.updateByPrimaryKey(customerOld);
                this.customerSafeQuestionService.deleteCustomerSafeQuestion(customerOld.getCustomerId());
            }
        }
        customerNew.setMobile(mobile);
        this.removeCache(customerNew);
        int k = this.customerMapper.updateByPrimaryKeySelective(customerNew);
        if (k >= 1) {
            if (!StringUtils.isEmpty((String)safeQuestion)) {
                this.customerSafeQuestionService.saveCustomerSafeQuestion(customerId, safeQuestion);
            }
            List<CustomerMobileEntity> mobiles = this.customerMobileService.findMobile(mobile);
            if (StringUtils.isEmpty((String)old_mobile) && (mobiles == null || mobiles.size() == 0)) {
                int amount = this.dictionaryInterface.getDictionaryToInt(customerNew.getPlatformGroupId(), 101, "bindMobileBalance");
                if (amount > 0) {
                    this.accountBalanceService.activeCharge(customerId, new BigDecimal(amount), "\u7ed1\u5b9a\u624b\u673a", true, "\u7ed1\u5b9a\u624b\u673a\u8d60\u9001", mobile);
                }
                this.vipService.finishTaskBindMobile(customerId);
            }
        } else {
            return BaseJsonVo.error((String)"\u5662\u54e6~\u624b\u673a\u53f7\u7ed1\u5b9a\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return BaseJsonVo.success((Object)customerNew);
    }

    @Override
    public BaseJsonVo saveMobile(String mobile, String customerId) {
        CustomerEntity customerNew = this.getCustomer(customerId);
        if (customerNew == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7528\u6237");
        }
        String old_mobile = customerNew.getMobile();
        List<CustomerEntity> customer4Mobiles = this.customerMapper.getCustomerByMobile(mobile, customerNew.getPlatformGroupId());
        if (customer4Mobiles != null && customer4Mobiles.size() > 0) {
            return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\uff0c\u8bf7\u66f4\u6362\u4e3a\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        CustomerEntity customer = new CustomerEntity();
        customer.setCustomerId(customerId);
        customer.setMobile(mobile);
        this.removeCache(customerNew);
        int k = this.customerMapper.updateByPrimaryKeySelective(customer);
        if (k >= 1) {
            return BaseJsonVo.success((Object)"\u624b\u673a\u53f7\u4fee\u6539\u6210\u529f");
        }
        return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
    }

    @Override
    @Transactional
    public void mergerAllCustomer() throws IOException {
        List<CustomerOpenidVo> list;
        List<CustomerMobileVo> ls_mobile;
        List<CustomerUnionIdVo> ls_unionid = this.customerMapper.getCustomerUnionIdList();
        if (ls_unionid != null && ls_unionid.size() > 0) {
            for (CustomerUnionIdVo customerUnionIdVo : ls_unionid) {
                this.mergeCustomer4UnionId(customerUnionIdVo.getUnionid(), customerUnionIdVo.getPlatformGroupId());
            }
        }
        if ((ls_mobile = this.customerMapper.getCustomerMobileList()) != null && ls_mobile.size() > 0) {
            for (CustomerMobileVo customerMobileVo : ls_mobile) {
                this.mergeCustomer4Mobile(customerMobileVo.getMobile(), customerMobileVo.getPlatformGroupId());
            }
        }
        if ((list = this.customerMapper.getCustomerOpenidIdList()) != null && list.size() > 0) {
            for (CustomerOpenidVo customerMobileEntity : list) {
                this.mergeCustomer4OpenId(customerMobileEntity.getPlatformId(), customerMobileEntity.getOpenId());
            }
        }
    }

    @Override
    public BaseJsonVo validatePassword(String customerId, String password, PasswordTypeEnum passwordTypeEnum) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (StringUtils.isEmpty((String)password)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u5bc6\u7801");
        }
        CustomerEntity customer = this.getCustomer(customerId);
        if (customer == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7528\u6237");
        }
        String hashPassword = customer.getPayPassword();
        if (passwordTypeEnum.getValue() == PasswordTypeEnum.login_password.getValue()) {
            hashPassword = customer.getPassword();
        }
        if (StringUtils.isEmpty((String)hashPassword)) {
            return new BaseJsonVo(100101, "\u5c1a\u672a\u8bbe\u7f6e\u5bc6\u7801");
        }
        String key = this.getCountLimitKey(customerId, passwordTypeEnum);
        long countLimit = this.redisService.increment(key, 0L);
        if (countLimit >= 5L) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u572824\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
        boolean b = PasswordUtils.validatePassword((String)password, (String)hashPassword);
        if (b) {
            this.redisService.increment(key, -countLimit);
            return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u901a\u8fc7");
        }
        countLimit = this.redisService.increment(key, 1L);
        if (countLimit >= 5L) {
            this.logger.error("\u7528\u6237" + customerId + "\u5c1d\u8bd5\u5bc6\u7801\u6b21\u6570\u592a\u591a\uff0c\u5df2\u9501\u5b9a\u5bc6\u780124\u5c0f\u65f6" + passwordTypeEnum.getValue());
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u572824\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
        return BaseJsonVo.paramError((String)("\u5bc6\u7801\u9519\u8bef\uff0c\u518d\u9519\u8bef" + (5L - countLimit) + "\u6b21\uff0c\u8d26\u53f7\u5c06\u9501\u5b9a24\u5c0f\u65f6"));
    }

    @Override
    public BaseJsonVo updatePassword(String customerId, String newPassword, PasswordTypeEnum passwordTypeEnum) throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.logger.info("updatePassword,customerId\uff1a" + customerId + "," + newPassword);
        if (StringUtils.isEmpty((String)newPassword)) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerEntity customer = this.getCustomer(customerId);
        if (customer == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7528\u6237");
        }
        this.logger.info("updatePassword,customer\uff1a" + JsonUtils.toJson((Object)customer, (boolean)false));
        String hashPassword = PasswordUtils.generateStorngPasswordHash((String)newPassword);
        if (passwordTypeEnum.getValue() == PasswordTypeEnum.login_password.getValue()) {
            customer.setPassword(hashPassword);
        } else {
            customer.setPayPassword(hashPassword);
        }
        this.logger.info("updatePassword,customer1\uff1a" + JsonUtils.toJson((Object)customer, (boolean)false));
        this.customerMapper.updateByPrimaryKeySelective(customer);
        this.removeCache(customer);
        String key = this.getCountLimitKey(customerId, passwordTypeEnum);
        long countLimit = this.redisService.increment(key, 0L);
        countLimit = this.redisService.increment(key, -countLimit);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public void test() {
        this.logger.info("spring \u5b9a\u65f6\u4efb\u52a1\u6d4b\u8bd5");
    }

    private String getCountLimitKey(String customerId, PasswordTypeEnum passwordTypeEnum) {
        String key = customerId + "_validatepassword_count_" + passwordTypeEnum.getValue();
        return key;
    }

    private void mergeCustomer4OpenId(int platformId, String openId) throws IOException {
        if (StringUtils.isEmpty((String)openId)) {
            return;
        }
        List<CustomerEntity> ls = this.customerMapper.getCustomerByOpenid(openId, platformId);
        if (ls != null && ls.size() > 0) {
            HashSet<CustomerEntity> set = new HashSet<CustomerEntity>();
            set.addAll(ls);
            if (set != null && set.size() == 1) {
                CustomerEntity customerEntity = ls.get(0);
                this.removeCache(customerEntity);
                List<CustomerDetailVo> ls_old_openids = this.customerMapper.getCustomerDetail(customerEntity.getCustomerId(), platformId);
                if (ls_old_openids != null && ls_old_openids.size() > 0) {
                    for (int i = 1; i < ls_old_openids.size(); ++i) {
                        CustomerDetailVo customerDetailVo = ls_old_openids.get(i);
                        this.customerOpenidMapper.deleteByPrimaryKey((Serializable)((Object)customerDetailVo.getCustomerOpenId()));
                    }
                }
            } else {
                this.mergeCustomer4list(new ArrayList<CustomerEntity>(set));
            }
        }
    }

    private void mergeCustomer4Mobile(String mobile, int platformGroupId) throws IOException {
        if (StringUtils.isEmpty((String)mobile)) {
            return;
        }
        List<CustomerEntity> ls = this.customerMapper.getCustomerByMobile(mobile, platformGroupId);
        this.mergeCustomer4list(ls);
    }

    private void mergeCustomer4UnionId(String unionid, int platformGroupId) throws IOException {
        if (StringUtils.isEmpty((String)unionid)) {
            return;
        }
        List<CustomerEntity> ls = this.customerMapper.getCustomerByUnionid(unionid, platformGroupId);
        this.mergeCustomer4list(ls);
    }

    private void mergeCustomer4list(List<CustomerEntity> ls) throws IOException {
    }

    private void mergerCustomerData(String newCustomerId, String oldCustomerId) throws IOException {
        this.customerMapper.mergeCustomer(newCustomerId, oldCustomerId);
        this.mergeCustomerVip(newCustomerId, oldCustomerId);
    }

    private void mergeCustomerVip(String newCustomerId, String oldCustomerId) throws IOException {
        this.vipService.rebuildVipLevel(newCustomerId);
        this.accountBalanceService.mergeAccount(oldCustomerId, newCustomerId);
    }

    private void updateCustomerFailed(CustomerEntity customerOld, String newCustomerId) {
        this.removeCache(customerOld);
        customerOld.setStatus(StatusEnum.STATUS_FAIL.getValue());
        customerOld.setSign("\u5220" + customerOld.getMobile() + ":" + customerOld.getUnionid());
        customerOld.setUnionid("");
        customerOld.setMobile("");
        customerOld.setTrueName(newCustomerId);
        this.customerMapper.updateByPrimaryKeySelective(customerOld);
    }

    private CustomerEntity mergeCustomerDetail(List<CustomerEntity> ls) {
        CustomerEntity customerNew = null;
        if (ls != null && ls.size() > 1) {
            customerNew = ls.get(0);
            customerNew.setStatus(StatusEnum.STATUS_OK.getValue());
            CustomerEntity customerOld = null;
            for (int i = 1; i < ls.size(); ++i) {
                customerOld = ls.get(i);
                if (customerOld.getCustomerId().equals(customerNew.getCustomerId())) continue;
                if (StringUtils.isEmpty((String)customerNew.getNickName()) && StringUtils.isNotEmpty((String)customerOld.getNickName())) {
                    customerNew.setNickName(customerOld.getNickName());
                }
                if (StringUtils.isEmpty((String)customerNew.getTrueName()) && StringUtils.isNotEmpty((String)customerOld.getTrueName())) {
                    customerNew.setTrueName(customerOld.getTrueName());
                }
                if (StringUtils.isEmpty((String)customerNew.getLoginName()) && StringUtils.isNotEmpty((String)customerOld.getLoginName())) {
                    customerNew.setLoginName(customerOld.getLoginName());
                }
                if (StringUtils.isEmpty((String)customerNew.getMobile()) && StringUtils.isNotEmpty((String)customerOld.getMobile())) {
                    customerNew.setMobile(customerOld.getMobile());
                }
                if (StringUtils.isEmpty((String)customerNew.getCity()) && StringUtils.isNotEmpty((String)customerOld.getCity())) {
                    customerNew.setCity(customerOld.getCity());
                }
                if (StringUtils.isEmpty((String)customerNew.getProvince()) && StringUtils.isNotEmpty((String)customerOld.getProvince())) {
                    customerNew.setProvince(customerOld.getProvince());
                }
                if (StringUtils.isEmpty((String)customerNew.getHeadImageUrl()) && StringUtils.isNotEmpty((String)customerOld.getHeadImageUrl())) {
                    customerNew.setHeadImageUrl(customerOld.getHeadImageUrl());
                }
                if (StringUtils.isEmpty((String)customerNew.getFxId()) && StringUtils.isNotEmpty((String)customerOld.getFxId())) {
                    customerNew.setFxId(customerOld.getFxId());
                }
                if (StringUtils.isEmpty((String)customerNew.getUnionid()) && StringUtils.isNotEmpty((String)customerOld.getUnionid())) {
                    customerNew.setUnionid(customerOld.getUnionid());
                }
                if (StringUtils.isEmpty((String)customerNew.getPayPassword()) && StringUtils.isNotEmpty((String)customerOld.getPayPassword())) {
                    customerNew.setPayPassword(customerOld.getPayPassword());
                }
                if (!StringUtils.isEmpty((String)customerNew.getCustomerServiceId()) || !StringUtils.isNotEmpty((String)customerOld.getCustomerServiceId())) continue;
                customerNew.setCustomerServiceId(customerOld.getCustomerServiceId());
            }
            this.customerMapper.updateByPrimaryKeySelective(customerNew);
        }
        return customerNew;
    }

    private void userToCustomer(User user, CustomerEntity customerEntity) {
        customerEntity.setGender(user.getSex());
        customerEntity.setLanguage(user.getLanguage());
        customerEntity.setCity(user.getCity() == null ? "" : user.getCity());
        customerEntity.setProvince(user.getProvince() == null ? "" : user.getProvince());
        customerEntity.setCountry(user.getCountry() == null ? "" : user.getCountry());
        customerEntity.setHeadImageUrl(user.getHeadimgurl());
    }

    private void userToCustomerOpenId(User user, CustomerOpenidEntity customerOpenid) {
        customerOpenid.setSubscribe(user.getSubscribe() == null ? 0 : user.getSubscribe());
        if (user.getSubscribe_time() != null && user.getSubscribe_time() != 0) {
            customerOpenid.setSubscribeTime(new Date(MathUtils.mulBigDecimal((Number)user.getSubscribe_time(), (Number)1000).longValue()));
        }
    }

    private String getCustomerId(PlatFormAndGroupVo platFormAndGroup) {
        return platFormAndGroup.getPlatformGroupId() + RandomUtils.generateStrId();
    }

    private String getCustomerOpenID(PlatFormAndGroupVo platFormAndGroup) {
        return platFormAndGroup.getPlatformGroupId() + platFormAndGroup.getPlatformId() + RandomUtils.generateStrId();
    }

    private String getNewCustomerSign() {
        String sign = UuidUtil.get32UUID() + UuidUtil.get32UUID();
        return sign;
    }

    private String getVemail() {
        return "v" + RandomUtils.generateStrId() + "@lechun.cc";
    }

    private <T> T listToEntiy(List<T> ls) {
        if (ls != null && ls.size() > 0) {
            return ls.get(0);
        }
        return null;
    }

    @Override
    public void removeCache(String customerId) {
        this.removeCache(this.getCustomer(customerId));
    }

    @Override
    public void removeCache(CustomerEntity customer) {
        if (customer != null) {
            this.memcachedService.delete("getCustomer", customer.getCustomerId());
            this.memcachedService.delete("getCustomerBySign", customer.getSign());
            this.memcachedService.delete("getCustomerByMobile", new String[]{StringUtils.isEmpty((String)customer.getMobile()) ? "" : customer.getMobile(), "" + customer.getPlatformGroupId()});
            List<CustomerOpenidEntity> ls = this.getCustomerOpenidList(customer.getCustomerId());
            if (ls != null && ls.size() > 0) {
                ls.forEach(customerOpenidEntity -> {
                    this.memcachedService.delete("getCustomerOpenid", customerOpenidEntity.getCustomerOpenId());
                    this.memcachedService.delete("getCustomerDetail", new String[]{customer.getCustomerId(), customerOpenidEntity.getPlatformId() + ""});
                    this.memcachedService.delete("getCustomerDetailBySignActive", new String[]{customer.getSign(), customerOpenidEntity.getPlatformId() + ""});
                    this.memcachedService.delete("getCustomerDetailByOpenid", new String[]{customerOpenidEntity.getOpenId(), customerOpenidEntity.getPlatformId() + ""});
                });
            }
        }
    }

    @Override
    public void updateCustomerEntitySelective(CustomerEntity customerEntity) {
        if (customerEntity != null && StringUtils.isNotEmpty((String)customerEntity.getCustomerId())) {
            this.removeCache(customerEntity);
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            if (customerEntity.getIsNew() != null) {
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)customerEntity.getCustomerId(), (Object)customerEntity.getCustomerId()));
            }
        }
    }

    @Override
    public List<CustomerEntity> getCustomerByCustomerIds(List<String> ids) {
        return this.customerMapper.getCustomerByCustomerIds(ids);
    }

    @Override
    public List<CustomerEntity> getCustomerBySignIds(List<String> ids) {
        return this.customerMapper.getCustomerBySignIds(ids);
    }

    @Override
    public List<CustomerDetailVo> getCustomerDetailByOpenIds(List<String> ids, int platformId) {
        return this.customerMapper.getCustomerDetailByOpenIds(ids, platformId);
    }
}

