/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.quartz.job;

import cc.lechun.apiinvoke.mall.CashInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.quartz.AbstractJob;
import cc.lechun.mall.entity.cashticket.CashticketSendLogEntity;
import cc.lechun.mall.iservice.cashticket.CashticketSendLogInterface;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CashticketLogJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(CashticketLogJob.class);
    @Autowired
    private CashticketSendLogInterface cashticketSendLogService;
    @Autowired
    private CashInvoke cashInvoke;
    @Autowired
    private RedisService redisService;

    protected Object doExecute(JobExecutionContext context) throws JobExecutionException {
        String todayKey = DateUtils.date() + ":deleteCoupon";
        try {
            String key;
            int k;
            if (this.redisService.get(todayKey) == null && (k = this.cashticketSendLogService.deleteLog(7)) > 0) {
                this.redisService.save(todayKey, 1, 86400L);
            }
            if (this.redisService.sadd(key = "sendLogJob", todayKey)) {
                List<CashticketSendLogEntity> list = this.cashticketSendLogService.getLogList(DateUtils.now());
                if (list != null) {
                    list.forEach(t -> {
                        BaseJsonVo vo = this.cashInvoke.sendCashticket(t.getCustomerId(), t.getBindCode(), 0.0, "", 1, t.getMessageStatus(), false);
                        log.info("\u5b9a\u65f6\u4efb\u52a1\u8865\u53d1\u4f18\u60e0\u5238:{},bindcode={},\u72b6\u6001:{}", new Object[]{t.getCustomerId(), t.getBindCode(), vo.isSuccess()});
                        BaseJsonVo baseJsonVo = this.cashticketSendLogService.setSendLogSuccess(t.getId());
                        if (vo.isSuccess() || vo.getMessage().indexOf("\u5df2\u9886\u53d6,\u4e0d\u53ef\u4ee5\u91cd\u590d\u9886\u53d6") >= 0) {
                            log.info("\u8bbe\u7f6e\u8865\u53d1\u65e5\u5fd7\u72b6\u6001:{},bindcode={},\u72b6\u6001:{}", new Object[]{t.getCustomerId(), t.getBindCode(), baseJsonVo.isSuccess()});
                        }
                    });
                }
                this.redisService.sremove(key, todayKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("run CashticketLogJob ");
        return "";
    }
}

