/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.mall.YouShuOrderApiInvoke;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerMapper;
import cc.lechun.mall.dao.trade.MallOrderMainMapper;
import cc.lechun.mall.dao.trade.MallOrderMapper;
import cc.lechun.mall.dao.trade.MallOrderProductMapper;
import cc.lechun.mall.dao.trade.MallOrderSendMsgMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderSendMsgEntity;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderSendMsgInterface;
import cc.lechun.mall.service.weixin.MessageService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderSendMsgService
extends BaseService
implements MallOrderSendMsgInterface {
    @Autowired
    private MallOrderSendMsgMapper mallOrderSendMsgMapper;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MallOrderMapper mallOrderMapper;
    @Autowired
    private MallOrderProductMapper mallOrderProductMapper;
    @Autowired
    private MallOrderMainMapper mallOrderMainMapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private YouShuOrderApiInvoke youShuOrderApiInvoke;

    @Override
    public boolean insertOrderSendMsgInfo(MallOrderSendMsgEntity mallOrderSendMsgEntity) {
        int i = this.mallOrderSendMsgMapper.insert(mallOrderSendMsgEntity);
        return i == 1;
    }

    @Override
    public int updateOrderIsSendMsg(int isSendMsg, String orderNo) {
        int i = this.mallOrderSendMsgMapper.updateOrderIsSendMsg(isSendMsg, orderNo);
        return i;
    }

    @Override
    public void sendOrderTemplateMsg() {
        try {
            MallOrderSendMsgEntity mallOrderSendMsgEntity = new MallOrderSendMsgEntity();
            mallOrderSendMsgEntity.setIsSendMsg(0);
            Date dayDate = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            mallOrderSendMsgEntity.setCreateTime(DateUtils.getDateFromString((String)sd.format(dayDate), (String)"yyyy-MM-dd HH:mm:ss"));
            List<MallOrderSendMsgEntity> mallOrderSendMsgEntityList = this.mallOrderSendMsgMapper.getMsgInfoList(mallOrderSendMsgEntity);
            if (mallOrderSendMsgEntityList != null && mallOrderSendMsgEntityList.size() > 0) {
                for (MallOrderSendMsgEntity mallOrderSendMsg : mallOrderSendMsgEntityList) {
                    MallOrderEntity mallOrderEntity = this.mallOrderMapper.getOrderInfoByOrderNo(mallOrderSendMsg.getOrderNo());
                    List<MallOrderProductEntity> mallOrderProductEntityList = this.mallOrderProductMapper.getOrderProductInfoByOrderNo(mallOrderSendMsg.getOrderNo());
                    List<MallOrderMainEntity> mallOrderMainEntityList = this.mallOrderMainMapper.getOrderMainInfoByOrderMianNo(mallOrderEntity.getOrderMainNo());
                    CustomerEntity customerEntity = new CustomerEntity();
                    if (mallOrderMainEntityList != null && mallOrderMainEntityList.size() > 0) {
                        for (MallOrderMainEntity mallOrderMainEntity : mallOrderMainEntityList) {
                            customerEntity = this.customerMapper.getCustomerInfoByCustomerId(mallOrderMainEntity.getCustomerId());
                        }
                    }
                    StringBuffer sb = new StringBuffer();
                    if (mallOrderProductEntityList != null && mallOrderProductEntityList.size() > 0) {
                        for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                            if (mallOrderProductEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                                MallProductEntity mallProductEntity = this.mallProductInterface.getProduct(mallOrderProductEntity.getProductId());
                                sb.append(mallProductEntity.getProNameSx() == null ? mallOrderProductEntity.getProductName() : mallProductEntity.getProNameSx()).append(",");
                                continue;
                            }
                            sb.append(mallOrderProductEntity.getProductName()).append(",");
                        }
                    }
                    String string = sb.toString();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("orderno", mallOrderEntity.getOrderNo());
                    map.put("productName", string.substring(0, string.length() - 1));
                    if (mallOrderEntity.getDeliverName().equals("\uff08\u505c\u7528\uff09\u51b7\u8fd0\u5230\u5bb6") || mallOrderEntity.getDeliverId() == 20) {
                        map.put("deliverName", "\u987a\u4e30");
                    } else {
                        map.put("deliverName", mallOrderEntity.getDeliverName());
                    }
                    map.put("waybillNo", mallOrderEntity.getWaybillNo());
                    map.put("consigneeAddr", mallOrderEntity.getConsigneeProvincename() + mallOrderEntity.getConsigneeCityname() + mallOrderEntity.getConsigneeAreaname() + mallOrderEntity.getConsigneeAddr());
                    map.put("orderMainNo", mallOrderEntity.getOrderMainNo());
                    map.put("thing1", string.substring(0, string.length() - 1));
                    map.put("thing7", mallOrderEntity.getDeliverName());
                    map.put("character_string6", mallOrderEntity.getWaybillNo());
                    map.put("thing5", mallOrderEntity.getConsigneeProvincename() + mallOrderEntity.getConsigneeCityname() + mallOrderEntity.getConsigneeAreaname() + mallOrderEntity.getConsigneeAddr());
                    map.put("thing8", "");
                    BaseJsonVo result = this.messageService.sendWechatMessage((int)mallOrderSendMsg.getPlatformId(), "order_msg", customerEntity.getChannelCustomerId(), map);
                    if (result.isSuccess()) {
                        this.updateOrderIsSendMsg(1, mallOrderSendMsg.getOrderNo());
                    }
                    this.youShuOrderApiInvoke.addOrder(mallOrderEntity.getOrderMainNo());
                    this.logger.info("\u63a8\u9001\u6a21\u677f\u6d88\u606f\u7ed3\u679c\uff1a{},{}", (Object)result.isSuccess(), (Object)result.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("cc.lechun.mall.service.trade.sendOrderTemplateMsg:" + e.getMessage());
        }
    }
}

