/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.apiinvoke.mall.OrderSyncInvoke;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderFailsMapper;
import cc.lechun.mall.dao.trade.MallOrderSyncInfoMapper;
import cc.lechun.mall.entity.trade.MallOrderFailsEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderSyncInfoService
extends BaseService
implements MallOrderSyncInfoInterface {
    @Autowired
    private MallOrderSyncInfoMapper orderSyncInfoMapper;
    @Autowired
    private MallOrderFailsMapper orderFailsMapper;
    @Autowired
    OrderSyncInvoke orderSyncInvoke;

    @Override
    public BaseJsonVo recordInfo(MallOrderSyncInfoEntity entity) {
        if (entity == null) {
            return BaseJsonVo.error((String)"\u8c03\u7528\u4fe1\u606f\u4e3a\u7a7a");
        }
        int insertResult = this.orderSyncInfoMapper.insert(entity);
        if (insertResult > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public List<MallOrderSyncInfoEntity> getList(MallOrderSyncInfoEntity syncInfo) {
        return this.orderSyncInfoMapper.getList(syncInfo);
    }

    @Override
    public Boolean isSuccessSyncEdb(String orderMainNo, String orderNo) {
        MallOrderSyncInfoEntity syncInfoEntity = new MallOrderSyncInfoEntity();
        if (orderMainNo != null && !orderMainNo.isEmpty()) {
            syncInfoEntity.setOrderMainNo(orderMainNo);
        }
        if (orderNo != null && !orderNo.isEmpty()) {
            syncInfoEntity.setOrderNo(orderNo);
        }
        syncInfoEntity.setSuccess(1);
        List<MallOrderSyncInfoEntity> syncInfoEntities = this.getList(syncInfoEntity);
        if (syncInfoEntities == null || syncInfoEntities.size() == 0) {
            return false;
        }
        return true;
    }

    @Override
    public BaseJsonVo recordOrderFails(MallOrderFailsEntity entity) {
        int insertResult = this.orderFailsMapper.insert(entity);
        if (insertResult > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo batchSyncOrderToOMS(String orderMainNo) {
        if (StringUtils.isNotEmpty((String)orderMainNo)) {
            BaseJsonVo rst = this.orderSyncInvoke.syncOrderToOMS(orderMainNo);
            if (!rst.isSuccess()) {
                this.logger.info("[{}]\u540c\u6b65\u5230OMS\u9519\u8bef\uff1a{}", (Object)orderMainNo, (Object)rst.getError_msg());
            }
            return rst;
        }
        Boolean[] allSuccess = new Boolean[]{true};
        List<Map<String, Object>> orderMainNos = this.orderSyncInfoMapper.getUnsyncedOrderMainNos();
        orderMainNos.forEach(order -> {
            BaseJsonVo rst = this.orderSyncInvoke.syncOrderToOMS((String)order.get("ORDER_MAIN_NO"));
            if (!rst.isSuccess()) {
                allSuccess[0] = false;
                this.logger.info("[{}]\u540c\u6b65\u5230OMS\u9519\u8bef\uff1a{}", order.get("ORDER_MAIN_NO"), (Object)rst.getError_msg());
            }
        });
        return allSuccess[0] != false ? BaseJsonVo.success(null) : BaseJsonVo.error((String)"\u90e8\u5206\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u67e5\u770b");
    }

    @Override
    public PageInfo findUnSyncOrderToOMS(int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<Map<String, Object>> orderMainNos = this.orderSyncInfoMapper.getUnsyncedOrderMainNos();
        orderMainNos.forEach(order -> {
            order.put("ORDER_CLASS", OrderClassEnum.getName((Integer)order.get("ORDER_CLASS")) + "(" + order.get("ORDER_CLASS") + ")");
            order.put("ORDER_SOURCE", OrderSourceEnum.getName((Integer)order.get("ORDER_SOURCE")) + "(" + order.get("ORDER_SOURCE") + ")");
            order.put("MAIN_STATUS", OrderStatusEnum.getName((Integer)order.get("MAIN_STATUS")) + "(" + order.get("MAIN_STATUS") + ")");
            order.put("SUB_STATUS", OrderStatusEnum.getName((Integer)order.get("SUB_STATUS")) + "(" + order.get("SUB_STATUS") + ")");
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(orderMainNos);
        return pg;
    }
}

