/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.common.file.MallImportExcelService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.weixin.MessageRemainImportVo;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerInfoUploadListener
extends AnalysisEventListener<MessageRemainImportVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerInfoUploadListener.class);
    private static final int BATCH_COUNT = 2000;
    List<MessageRemainImportVo> list = new ArrayList<MessageRemainImportVo>();
    MallImportExcelService mallImportExcelService;
    private String actionId;

    public CustomerInfoUploadListener(MallImportExcelService mallImportExcelService, String actionId) {
        this.actionId = actionId;
        this.mallImportExcelService = mallImportExcelService;
    }

    public void invoke(MessageRemainImportVo data, AnalysisContext context) {
        LOGGER.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
        this.list.add(data);
        if (this.list.size() >= 2000) {
            this.saveData();
            this.list.clear();
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        LOGGER.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    private void saveData() {
        LOGGER.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.list.size());
        int type = StringUtils.isNotEmpty((String)this.list.get(0).getCustomerId()) ? 2 : (StringUtils.isNotEmpty((String)this.list.get(0).getOpenId()) ? 1 : 0);
        BaseJsonVo result = this.mallImportExcelService.importCustomerInfoUrl(this.list, this.actionId, type);
        LOGGER.info("\u5b58\u50a8\u6570\u636e\u5e93{}\uff01", (Object)result.isSuccess());
    }
}

