/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallDepartmentEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.user.MallUserEntityVo;
import cc.lechun.mall.iservice.user.SysDepartmentInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.ExcelDataVo;
import cc.lechun.organization.entity.MonthKpiVo;
import cc.lechun.organization.entity.OKRExcelDataVo;
import cc.lechun.organization.entity.OkrListVo;
import cc.lechun.organization.entity.OptionVo;
import cc.lechun.organization.entity.OrgDayReportVo;
import cc.lechun.organization.entity.OrgWeekJobVo;
import cc.lechun.organization.entity.PaperAnswerEditVo;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerLookVo;
import cc.lechun.organization.entity.PaperAnswerPeriodVo;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.PaperAnswerRelationVo;
import cc.lechun.organization.entity.PaperAnswerUrlVo;
import cc.lechun.organization.entity.PaperAnswerVo;
import cc.lechun.organization.entity.PaperAnswerWeekTaskVo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.entity.WeekJobExcelDataVo;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperAnswerRelationDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.PaperReadInterface;
import cc.lechun.organization.service.KpiService;
import cc.lechun.utils.ExcelUtil;
import cc.lechun.utils.HtmlUtil;
import com.alibaba.fastjson.JSON;
import com.dingtalk.api.response.OapiReportListResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OrgPaperAnswerService
extends BaseService
implements IOrgPaperAnswerService {
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IOrgQuestionDomain questionDomain;
    @Autowired
    private IOrgPaperAnswerRelationDomain relationDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain questionClassDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private SysDepartmentInterface departmentInterface;
    @Autowired
    private KpiService kpiService;
    @Autowired
    private IOrgPaperService iOrgPaperService;
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DingdingUtils dingdingUtils;
    @Autowired
    private PaperReadInterface paperReadInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo savePaperAnswer(List<PaperAnswerEntity> answerEntities, String userId) throws RuntimeException {
        this.logger.info(">>>>>>>>>savePaperAnswer param rows:{} >>>>>>answerEntities={}", (Object)answerEntities.size(), (Object)JSON.toJSONString(answerEntities));
        StringBuffer sb = new StringBuffer("org:").append(userId).append(answerEntities.get(0).getPaperId()).append(answerEntities.get(0).getAnswer());
        boolean lock = this.redisLock.tryLock(sb.toString(), 20000L);
        this.logger.info("******************************************lock=" + lock);
        try {
            if (lock && answerEntities != null) {
                PaperEntity paperEntity = null;
                if (answerEntities.size() > 0) {
                    paperEntity = this.orgPaperDomain.select(answerEntities.get(0).getPaperId());
                    if (paperEntity == null) {
                        throw new RuntimeException("\u95ee\u5377\u4e0d\u5b58\u5728");
                    }
                    if (paperEntity.getQuestionClassId() != 9 && answerEntities.get(0).getQuestionId() != 22 && !paperEntity.getUserId().equals(answerEntities.get(0).getUserId())) {
                        throw new RuntimeException("\u60a8\u65e0\u6743\u586b\u5199\u8be5\u95ee\u5377");
                    }
                }
                Integer questionClassId = null;
                for (PaperAnswerEntity answerEntity : answerEntities) {
                    QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
                    if (questionEntity == null) {
                        throw new RuntimeException("\u95ee\u9898\u4e0d\u5b58\u5728");
                    }
                    if (questionEntity.getStatus() != 1) {
                        // empty if block
                    }
                    if (answerEntities.size() > 1 && questionEntity.getRequired() == 1 && StringUtils.isEmpty((String)answerEntity.getAnswer().replace("[", "").replace("]", ""))) {
                        throw new RuntimeException("\u95ee\u9898[" + (StringUtils.isEmpty((String)questionEntity.getQuestionName()) ? questionEntity.getTextDefault() : questionEntity.getQuestionName()) + "]\u5fc5\u586b");
                    }
                    if (questionEntity.getQuestionType() == 16) {
                        String answer = answerEntity.getAnswer().replace("T", " ").replace(".000Z", "");
                        answerEntity.setAnswer(DateUtils.formatDate((Date)DateUtils.getAddDateBySecond((Date)DateUtils.getDateFromString((String)answer, (String)"yyyy-MM-dd"), (int)28800), (String)"yyyy-MM-dd"));
                    }
                    questionClassId = questionEntity.getQuestionClassId();
                    if (questionEntity.getId() == 70) {
                        PaperAnswerEntity ansWeekJob = this.getSinglePaperAnswer(answerEntity.getPaperId(), answerEntity.getQuestionId(), answerEntity.getUserId(), answerEntity.getCreateTime());
                        if (ansWeekJob != null) {
                            answerEntity.setId(ansWeekJob.getId());
                            this.orgPaperAnswerDomain.update(answerEntity);
                        } else {
                            answerEntity.setId(IDGenerate.getUniqueIdStr());
                            this.orgPaperAnswerDomain.insert(answerEntity);
                        }
                    } else {
                        PaperAnswerEntity ans = this.getSingle(answerEntity.getPaperId(), answerEntity.getQuestionId(), answerEntity.getUserId());
                        if (ans != null) {
                            answerEntity.setId(ans.getId());
                            this.orgPaperAnswerDomain.update(answerEntity);
                        } else {
                            answerEntity.setId(IDGenerate.getUniqueIdStr());
                            this.orgPaperAnswerDomain.insert(answerEntity);
                        }
                    }
                    if (questionEntity.getId() != 58 && questionEntity.getId() != 59 && questionEntity.getId() != 60 && questionEntity.getId() != 61 && questionEntity.getId() != 70) continue;
                    PaperEntity updatePaper = new PaperEntity();
                    updatePaper.setId(answerEntity.getPaperId());
                    updatePaper.setStatus(1);
                    updatePaper.setUpdateTime(new Date());
                    this.orgPaperDomain.update(updatePaper);
                }
                this.savePaperAnswerRelation(answerEntities.get(0).getPaperId(), userId, answerEntities.size() == 1 ? answerEntities.get(0).getId() : null);
                this.updatePaper(answerEntities.get(0).getPaperId(), questionClassId);
            }
        }
        finally {
            this.redisLock.unlock(sb.toString());
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public BaseJsonVo updatePaper(String paperId, Integer questionClassId) {
        boolean alreadyWrite = true;
        List<Object> questionEntities = new ArrayList();
        QuestionClassEntity questionClassEntity = this.questionClassDomain.getQuestionClassEntity(questionClassId);
        if (questionClassEntity != null) {
            if (questionClassEntity.getParrentClassId() != null && questionClassEntity.getParrentClassId() != 0) {
                List<QuestionClassEntity> classEntities = this.questionClassDomain.getQuestionClassEntityList(questionClassEntity.getParrentClassId());
                for (QuestionClassEntity questionClassEntity2 : classEntities) {
                    questionEntities.addAll(this.questionDomain.getQuestionList(questionClassEntity2.getClassId(), 1));
                }
            } else {
                questionEntities = this.questionDomain.getQuestionList(questionClassId, 1);
            }
        } else {
            questionEntities = this.questionDomain.getQuestionList(questionClassId, 1);
        }
        PaperAnswerEntity search = new PaperAnswerEntity();
        search.setPaperId(paperId);
        List<PaperAnswerEntity> answerEntities = this.orgPaperAnswerDomain.getList(search);
        questionEntities = questionEntities.stream().filter(c -> c.getRequired() == 1).collect(Collectors.toList());
        for (QuestionEntity questionEntity : questionEntities) {
            Optional<PaperAnswerEntity> answerEntity = answerEntities.stream().filter(c -> c.getQuestionId().intValue() == questionEntity.getId().intValue()).findFirst();
            if (answerEntity.isPresent()) {
                if (!StringUtils.isEmpty((String)answerEntity.get().getAnswer().replace("[", "").replace("]", ""))) continue;
                alreadyWrite = false;
                continue;
            }
            alreadyWrite = false;
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setUpdateTime(new Date());
        paperEntity.setId(answerEntities.get(0).getPaperId());
        if (alreadyWrite) {
            paperEntity.setStatus(1);
            PaperEntity paperEntity2 = this.orgPaperDomain.select(answerEntities.get(0).getPaperId());
            if (paperEntity2 != null && paperEntity2.getUpdateTime() == null) {
                paperEntity.setUpdateTime(new Date());
            }
            this.orgPaperDomain.update(paperEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo savePaperAnswerRelation(String paperId, String userId, String answerId) {
        this.logger.info("++++savePaperAnswerRelation++++++++paperId={},answerId={}", (Object)paperId, (Object)answerId);
        PaperAnswerEntity search = new PaperAnswerEntity();
        search.setPaperId(paperId);
        if (StringUtils.isNotEmpty((String)answerId)) {
            search.setId(answerId);
        }
        List<PaperAnswerEntity> answerEntities = this.orgPaperAnswerDomain.getList(search);
        MallUserEntity userEntity = this.sysUserInterface.getMallUser(userId);
        this.logger.info("++++savePaperAnswerRelation++++++++answerEntities={}", (Object)JSON.toJSONString(answerEntities));
        for (PaperAnswerEntity answerEntity : answerEntities) {
            MallUserEntity userEntity1;
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            this.logger.info("++++savePaperAnswerRelation++++++++questionEntity={}", (Object)JSON.toJSONString((Object)questionEntity));
            if (questionEntity == null) continue;
            if (questionEntity.getQuestionType() == 14) {
                this.logger.info("===============savePaperAnswerRelation===========answerEntity={}", (Object)JSON.toJSONString((Object)answerEntity));
                List orgDayReportVoList = JsonUtils.getListByArray(OrgDayReportVo.class, (String)answerEntity.getAnswer());
                this.logger.info("===============savePaperAnswerRelation===========orgDayReportVoList={}", (Object)JSON.toJSONString((Object)orgDayReportVoList));
                List temp = orgDayReportVoList.stream().filter(c -> c.getKpiEnable() == 0 && StringUtils.isEmpty((String)c.getTodayAnswer())).collect(Collectors.toList());
                if (temp.size() > 0 && answerId == null) {
                    throw new RuntimeException("\u8bf7\u8865\u5168\u9489\u9489\u6ca1\u6709\u586b\u5199\u7684\u65e5\u62a5");
                }
                orgDayReportVoList = orgDayReportVoList.stream().filter(c -> c.getKpiEnable() == 0 && StringUtils.isNotEmpty((String)c.getTodayAnswer())).collect(Collectors.toList());
                for (OrgDayReportVo o : orgDayReportVoList) {
                    ExcelDataVo excelDataVo = new ExcelDataVo();
                    excelDataVo.setTodayAnswer(o.getTodayAnswer());
                    excelDataVo.setTomorrowAnswer(o.getTomorrowAnswer());
                    List<PaperAnswerEntity> answerEntityList = this.saveDayReport(o.getDate(), userId, excelDataVo);
                    this.savePaperAnswer(answerEntityList, null);
                }
            }
            if (questionEntity.getQuestionType() == 19) {
                this.logger.info("===============savePaperAnswerRelation===========questionEntity type={}", (Object)questionEntity.getQuestionType());
                WeekJobExcelDataVo weekJobExcelDataVo = new WeekJobExcelDataVo();
                weekJobExcelDataVo.setWeekJob(answerEntity.getAnswer());
                List<PaperAnswerEntity> answerEntityList = this.saveWeekJob(answerEntity.getCreateTime(), userId, weekJobExcelDataVo);
                this.logger.info("===============savePaperAnswerRelation===========answerEntityList={}", (Object)JSON.toJSONString(answerEntityList));
                this.savePaperAnswer(answerEntityList, null);
            }
            if (questionEntity.getQuestionType() != 4 && questionEntity.getQuestionType() != 5 && questionEntity.getQuestionType() != 6 && questionEntity.getQuestionType() != 11 && questionEntity.getQuestionType() != 13 && questionEntity.getId() != 63 && questionEntity.getQuestionType() != 17 && questionEntity.getQuestionType() != 18) continue;
            List<PaperAnswerRelationEntity> relationEntities = new ArrayList();
            if (StringUtils.isNotEmpty((String)answerEntity.getAnswer()) || questionEntity.getQuestionClassId() == 13) {
                if (questionEntity.getQuestionType() == 5 || questionEntity.getQuestionType() == 6 || questionEntity.getQuestionType() == 13 || questionEntity.getId() == 63 || questionEntity.getQuestionType() == 17) {
                    try {
                        relationEntities = JsonUtils.getListByArray(PaperAnswerRelationEntity.class, (String)answerEntity.getAnswer());
                        relationEntities.forEach(r -> {
                            if (r.getFinished() == null) {
                                r.setFinished(0);
                            }
                            if (r.getIsLeader() != null && r.getIsLeader() == 1) {
                                r.setLeaderId(userId);
                            }
                        });
                        if (questionEntity.getId() != 22) {
                            this.logger.info("+++++relationEntities={}", (Object)JSON.toJSONString(relationEntities));
                            this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
                        }
                        if (questionEntity.getId() != 22) continue;
                        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
                        PeriodEntity periodEntity = this.periodService.getPeriodEntity(paperEntity.getPeriodId());
                        BaseJsonVo<PeriodEntity> nextPeriodJson = this.periodService.getNextPeriod(periodEntity.getId());
                        PaperEntity paperEntitySearch = new PaperEntity();
                        paperEntitySearch.setQuestionClassId(9);
                        paperEntitySearch.setUserId(userId);
                        if (nextPeriodJson.isSuccess()) {
                            paperEntitySearch.setPeriodId(((PeriodEntity)nextPeriodJson.getValue()).getId());
                        } else {
                            BaseJsonVo<PeriodEntity> periodEntityBaseJsonVo = this.periodService.currentPeriod(0);
                            if (periodEntityBaseJsonVo.isSuccess()) {
                                PeriodEntity periodEntityInfo = (PeriodEntity)periodEntityBaseJsonVo.getValue();
                                PeriodEntity nextWeekAfterPeriod = new PeriodEntity();
                                nextWeekAfterPeriod.setPeriodType(0);
                                nextWeekAfterPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)periodEntity.getPeriodEnd(), (int)1));
                                List weekAfterSearchResult = this.periodService.getList(nextWeekAfterPeriod);
                                if (weekAfterSearchResult == null || weekAfterSearchResult.size() == 0) {
                                    nextWeekAfterPeriod.setPeriodEnd(DateUtils.getAddDateByDay((Date)nextWeekAfterPeriod.getPeriodStart(), (int)6));
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setFirstDayOfWeek(2);
                                    calendar.setTime(nextWeekAfterPeriod.getPeriodStart());
                                    nextWeekAfterPeriod.setHeadPeriod(calendar.get(3));
                                    nextWeekAfterPeriod.setHeadYear(nextWeekAfterPeriod.getHeadPeriod() == 1 ? periodEntityInfo.getHeadYear() + 1 : periodEntityInfo.getHeadYear());
                                    nextWeekAfterPeriod.setPeriodDesc(nextWeekAfterPeriod.getHeadYear() + "\u5e74\u7b2c" + nextWeekAfterPeriod.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)nextWeekAfterPeriod.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)nextWeekAfterPeriod.getPeriodEnd(), (String)"MM.dd") + ")");
                                    Integer count = this.userInterface.getRoleUserCount(29);
                                    nextWeekAfterPeriod.setParticipantNumber(count);
                                    this.periodService.savePeriodInfo(nextWeekAfterPeriod);
                                    paperEntitySearch.setPeriodId(nextWeekAfterPeriod.getId());
                                }
                            }
                        }
                        List paperEntityList = this.iOrgPaperService.getList(paperEntitySearch);
                        PaperAnswerEntity paperAnswerEntity = new PaperAnswerEntity();
                        if (paperEntityList == null || paperEntityList.size() == 0) {
                            BaseJsonVo baseJsonVoPaper = this.iOrgPaperService.buildPaperByWeekAfter(userId, 9, paperEntitySearch.getPeriodId());
                            if (baseJsonVoPaper.isSuccess()) {
                                paperAnswerEntity.setPaperId(baseJsonVoPaper.getValue().toString());
                            }
                        } else {
                            paperAnswerEntity.setPaperId(((PaperEntity)paperEntityList.get(0)).getId());
                        }
                        PaperAnswerEntity ans = this.getSingle(paperAnswerEntity.getPaperId(), paperAnswerEntity.getQuestionId(), paperAnswerEntity.getUserId());
                        if (relationEntities != null && relationEntities.size() > 0) {
                            StringBuffer sb = new StringBuffer("[");
                            for (PaperAnswerRelationEntity relationEntity : relationEntities) {
                                sb.append("{");
                                if (ans != null) {
                                    sb.append("\"answerId:\"").append(ans.getId()).append(",");
                                    paperAnswerEntity.setId(ans.getId());
                                } else {
                                    sb.append("\"answerId:\"").append(paperAnswerEntity.getId()).append(",");
                                    paperAnswerEntity.setId(IDGenerate.getUniqueIdStr());
                                }
                                sb.append("\"questionId:\"").append(39).append(",");
                                sb.append("\"isLeader:\"").append(relationEntity.getIsLeader()).append(",");
                                sb.append("\"finished:\"").append(relationEntity.getFinished()).append(",");
                                sb.append("\"questionName:\"").append("\u5468\u4e8b\u5468\u6bd5").append(",");
                                sb.append("\"isnew:\"").append(relationEntity.getIsnew()).append(",");
                                sb.append("\"sort:\"").append(relationEntity.getSort()).append(",");
                                sb.append("\"content:\"").append(relationEntity.getContent()).append(",");
                                sb.append("\"createTime:\"").append(relationEntity.getCreateTime()).append(",");
                                sb.append("\"id:\"").append("").append(",");
                                sb.append("\"isAnswer:\"").append(relationEntity.getIsAnswer());
                                sb.append("},");
                            }
                            sb.append("]");
                            paperAnswerEntity.setAnswer(sb.toString());
                        } else {
                            paperAnswerEntity.setAnswer("[]");
                        }
                        paperAnswerEntity.setQuestionId(39);
                        paperAnswerEntity.setUserId(userId);
                        relationEntities = JsonUtils.getListByArray(PaperAnswerRelationEntity.class, (String)answerEntity.getAnswer());
                        relationEntities.forEach(r -> {
                            r.setId(null);
                            r.setAnswerId(paperAnswerEntity.getId());
                            r.setQuestionId(39);
                            r.setQuestionName("\u5468\u4e8b\u5468\u6bd5");
                            if (r.getFinished() == null) {
                                r.setFinished(0);
                            }
                            if (r.getIsLeader() == 1) {
                                r.setLeaderId(userId);
                            }
                        });
                        paperAnswerEntity.setCreateTime(new Date());
                        if (ans != null) {
                            paperAnswerEntity.setId(ans.getId());
                            this.orgPaperAnswerDomain.update(paperAnswerEntity);
                            PaperEntity paperEntity1 = new PaperEntity();
                            paperEntity1.setStatus(1);
                            paperEntity1.setId(paperAnswerEntity.getPaperId());
                            this.iOrgPaperService.updatePaperStatusByParam(paperEntity1);
                        } else {
                            this.orgPaperAnswerDomain.insert(paperAnswerEntity);
                        }
                        this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), paperAnswerEntity, relationEntities);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.info("+++++Exception={}", (Object)JSON.toJSONString((Object)e.getMessage()));
                        e.printStackTrace();
                    }
                }
                if (questionEntity.getId() != 22) {
                    QuestionEntity searchQuestion = new QuestionEntity();
                    searchQuestion.setRelationQuestionId(answerEntity.getQuestionId());
                    List<QuestionEntity> questionEntities = this.questionDomain.getList(searchQuestion);
                    this.logger.info("+++++questionEntities={}", (Object)JSON.toJSONString(questionEntities));
                    StringBuilder sb = new StringBuilder();
                    for (QuestionEntity q : questionEntities) {
                        List relationAnswers = answerEntities.stream().filter(c -> c.getQuestionId().equals(q.getId())).collect(Collectors.toList());
                        this.logger.info("+++++relationAnswers={}", (Object)JSON.toJSONString(relationAnswers));
                        for (PaperAnswerEntity relationAnswer : relationAnswers) {
                            sb.append("Q\uff1a" + q.getQuestionName());
                            sb.append("<br/>");
                            sb.append("A\uff1a" + relationAnswer.getAnswer());
                            sb.append("<br/>");
                        }
                    }
                    PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
                    relationEntity.setAnswerId(answerEntity.getId());
                    relationEntity.setCreateTime(new Date());
                    if (answerEntity.getQuestionId() != 39) {
                        relationEntity.setRelationUserId(answerEntity.getAnswer());
                    }
                    if (questionEntity.getQuestionClassId() == 13) {
                        PaperEntity paper = this.orgPaperDomain.select(paperId);
                        MallUserEntity mallUser = this.userInterface.getMallUser(paper.getUserId());
                        if (mallUser.getDeptId() == null || mallUser.getDeptId() == 0) {
                            relationEntity.setRelationUserId(mallUser.getLeader());
                        } else {
                            MallDepartmentEntity department = (MallDepartmentEntity)this.departmentInterface.selectByPrimaryKey(mallUser.getDeptId());
                            if (department == null || StringUtils.isEmpty((String)department.getAdministrator())) {
                                relationEntity.setRelationUserId(mallUser.getLeader());
                            } else {
                                relationEntity.setRelationUserId(department.getAdministrator());
                            }
                        }
                    }
                    relationEntity.setContent(sb.toString());
                    if (StringUtils.isNotEmpty((String)relationEntity.getContent()) || questionEntity.getQuestionClassId() == 12 || questionEntity.getQuestionClassId() == 13) {
                        relationEntities.add(relationEntity);
                    }
                    this.logger.info("+++relationEntitiesrelationEntities++relationEntities={}", (Object)JSON.toJSONString(relationEntities));
                    this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
                }
            }
            if (questionEntity.getQuestionType() != 18) continue;
            PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
            relationEntity.setContent(answerEntity.getAnswer());
            relationEntity.setQuestionId(answerEntity.getQuestionId());
            relationEntity.setQuestionName(questionEntity.getQuestionName());
            if (userEntity != null && StringUtils.isNotEmpty((String)userEntity.getLeader()) && (userEntity1 = this.sysUserInterface.getMallUser(userEntity.getLeader())) != null) {
                relationEntity.setRelationUserId(userEntity.getLeader());
                relationEntity.setRelationUserName(userEntity1.getUserNick());
                relationEntities.add(relationEntity);
            }
            relationEntity.setAnswerId(answerId);
            relationEntity.setCreateTime(new Date());
            this.relationService.savePaperAnswerRelation(questionEntity.getQuestionType(), answerEntity, relationEntities);
        }
        return BaseJsonVo.success((Object)"");
    }

    public PaperAnswerEntity getSingle(String paperId, Integer questionId, String userId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        return this.orgPaperAnswerDomain.getSingle(answerEntity);
    }

    public PaperAnswerEntity getSinglePaperAnswer(String paperId, Integer questionId, String userId, Date createTime) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        answerEntity.setCreateTime(createTime);
        return this.orgPaperAnswerDomain.getSingle(answerEntity);
    }

    @Override
    public List<PaperAnswerEntity> getList(String paperId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        return this.orgPaperAnswerDomain.getList(answerEntity);
    }

    public boolean exists(String paperId, Integer questionId, String userId) {
        PaperAnswerEntity answerEntity = new PaperAnswerEntity();
        answerEntity.setPaperId(paperId);
        answerEntity.setQuestionId(questionId);
        answerEntity.setUserId(userId);
        return this.orgPaperAnswerDomain.exists(answerEntity);
    }

    @Override
    public BaseJsonVo getPaperAnswerList(Integer questionClass, String paperId, String userId) {
        PaperEntity paperEntity = this.orgPaperDomain.select(paperId);
        if (paperEntity == null) {
            return BaseJsonVo.error((String)"\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(paperEntity.getPeriodId());
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        List<PaperAnswerEditVo> editVos = this.orgPaperAnswerDomain.getAnswerQuestion(questionClass, paperId);
        HashMap subQuestions = new HashMap();
        for (PaperAnswerEditVo e : editVos) {
            BaseJsonVo<PeriodEntity> baseJsonVo;
            BaseJsonVo<PeriodEntity> nextPeriodJson;
            String befContent;
            PaperAnswerRelationEntity search;
            BigDecimal sumWorkHours;
            BaseJsonVo baseJsonVo2;
            PaperAnswerRelationEntity search2;
            if (StringUtils.isEmpty((String)e.getPaperId())) {
                e.setPaperId(paperId);
            }
            if (e.getQuestionId() == 25 && StringUtil.isEmpty((String)e.getAnswer())) {
                String q1 = this.getCurrentPeriodField(paperEntity.getUserId(), 44, paperEntity.getPeriodId());
                String q2 = this.getCurrentPeriodField(paperEntity.getUserId(), 50, paperEntity.getPeriodId());
                if (q1 == null) {
                    q1 = "";
                }
                if (q2 == null) {
                    q2 = "";
                }
                if (editVos.stream().filter(c -> c.getQuestionId() == 1 && "0001".equals(c.getAnswer())).count() > 0L) {
                    q2 = "";
                }
                if (editVos.stream().filter(c -> c.getQuestionId() == 1 && "0002".equals(c.getAnswer())).count() > 0L) {
                    q1 = "";
                }
                if (StringUtil.isNotEmpty((String)q1)) {
                    q1 = q1 + "\n";
                }
                e.setAnswer(q1 + q2);
            }
            if (e.getQuestionType() == 5 || e.getQuestionType() == 6 || e.getQuestionType() == 13) {
                List<PaperAnswerRelationEntity> relationEntities = new ArrayList<PaperAnswerRelationEntity>();
                if (StringUtils.isNotEmpty((String)e.getId())) {
                    search2 = new PaperAnswerRelationEntity();
                    search2.setAnswerId(e.getId());
                    relationEntities = this.relationDomain.getListBySort(search2);
                    for (PaperAnswerRelationEntity r : relationEntities) {
                        String befContent2 = "";
                        if (r.getIsDissent() != null && r.getIsDissent() == 1) {
                            befContent2 = "\u3010\u5f02\u8bae\u3011";
                        }
                        if (!StringUtils.isNotEmpty((String)r.getContent())) continue;
                        r.setContent(befContent2 + r.getContent().replace("<br/>", "\n"));
                    }
                }
                if (relationEntities.size() == 0 && e.getQuestionType() != 6) {
                    relationEntities.add(new PaperAnswerRelationEntity());
                }
                e.setRelationEntityList(relationEntities);
            }
            if (e.getQuestionClassId() == 13 && e.getQuestionType() == 11 && StringUtils.isEmpty((String)e.getAnswer())) {
                MallUserEntity mallUser = this.userInterface.getMallUser(paperEntity.getUserId());
                if (mallUser.getDeptId() == null || mallUser.getDeptId() == 0) {
                    e.setAnswer(mallUser.getLeader());
                } else {
                    MallDepartmentEntity department = (MallDepartmentEntity)this.departmentInterface.selectByPrimaryKey(mallUser.getDeptId());
                    if (department == null || StringUtils.isEmpty((String)department.getAdministrator())) {
                        e.setAnswer(mallUser.getLeader());
                    } else {
                        e.setAnswer(department.getAdministrator());
                    }
                }
            }
            if (e.getQuestionId() == 63 && (baseJsonVo2 = this.getWeekThingWeekFinish(paperEntity.getPeriodId(), paperEntity.getUserId(), userId)).isSuccess()) {
                PaperEntity weekEndPaper;
                List<PaperAnswerRelationEntity> relationNewList = new ArrayList<PaperAnswerRelationEntity>();
                List tempList = (List)baseJsonVo2.getValue();
                tempList.forEach(a -> a.setCheckWeekAfterWeek(true));
                Integer finish = 0;
                if (tempList.size() > 0 && (weekEndPaper = this.orgPaperDomain.select(((PaperAnswerEditVo)tempList.get(0)).getPaperId())) != null) {
                    finish = weekEndPaper.getReportStatus();
                }
                sumWorkHours = new BigDecimal("0.00");
                for (PaperAnswerEditVo paperAnswerEditVo : tempList) {
                    if (!StringUtils.isNotEmpty((String)paperAnswerEditVo.getId())) continue;
                    search = new PaperAnswerRelationEntity();
                    search.setAnswerId(paperAnswerEditVo.getId());
                    relationNewList = this.relationDomain.getListBySort(search);
                    for (PaperAnswerRelationEntity relationEntityNew : relationNewList) {
                        befContent = "";
                        if (relationEntityNew.getIsDissent() != null && relationEntityNew.getIsDissent() == 1) {
                            befContent = "\u3010\u5f02\u8bae\u3011";
                        }
                        if (StringUtils.isNotEmpty((String)relationEntityNew.getContent())) {
                            relationEntityNew.setContent(befContent + relationEntityNew.getContent().replace("<br/>", "\n"));
                        }
                        if (StringUtils.isEmpty((String)relationEntityNew.getEmployRemark())) {
                            relationEntityNew.setEmployRemark(relationEntityNew.getConfirmWorkEmployeRemark());
                        }
                        if (StringUtils.isEmpty((String)relationEntityNew.getLeaderRemark())) {
                            relationEntityNew.setLeaderRemark(relationEntityNew.getConfirmWorkLeaderRemark());
                        }
                        relationEntityNew.setFinished(finish);
                        if (relationEntityNew.getWorkHours() == null) continue;
                        sumWorkHours = relationEntityNew.getWorkHours().add(sumWorkHours);
                    }
                }
                if (relationNewList.size() == 0) {
                    relationNewList.add(new PaperAnswerRelationEntity());
                }
                e.setRelationEntityListTwo(relationNewList);
                e.setSumWorkHours(sumWorkHours);
            }
            if (e.getQuestionType() == 17) {
                List<PaperAnswerRelationEntity> relationContentList = new ArrayList<PaperAnswerRelationEntity>();
                if (StringUtils.isNotEmpty((String)e.getId())) {
                    search2 = new PaperAnswerRelationEntity();
                    search2.setAnswerId(e.getId());
                    relationContentList = this.relationDomain.getListBySort(search2);
                }
                if (relationContentList.size() == 0) {
                    relationContentList.add(new PaperAnswerRelationEntity());
                }
                e.setRelationEntityList(relationContentList);
            }
            if (e.getQuestionId() == 22 && (nextPeriodJson = this.periodService.getNextPeriod(paperEntity.getPeriodId())).isSuccess() && (baseJsonVo = this.getWeekThingWeekFinish(((PeriodEntity)nextPeriodJson.getValue()).getId(), paperEntity.getUserId(), userId)).isSuccess()) {
                List<PaperAnswerRelationEntity> relationNewList = new ArrayList<PaperAnswerRelationEntity>();
                List tempList = (List)baseJsonVo.getValue();
                tempList.forEach(a -> a.setCheckWeekAfterWeek(true));
                sumWorkHours = new BigDecimal("0.00");
                for (PaperAnswerEditVo paperAnswerEditVo : tempList) {
                    if (!StringUtils.isNotEmpty((String)paperAnswerEditVo.getId())) continue;
                    search = new PaperAnswerRelationEntity();
                    search.setAnswerId(paperAnswerEditVo.getId());
                    relationNewList = this.relationDomain.getListBySort(search);
                    for (PaperAnswerRelationEntity relationEntityNew : relationNewList) {
                        befContent = "";
                        if (relationEntityNew.getIsDissent() != null && relationEntityNew.getIsDissent() == 1) {
                            befContent = "\u3010\u5f02\u8bae\u3011";
                        }
                        if (StringUtils.isNotEmpty((String)relationEntityNew.getContent())) {
                            relationEntityNew.setContent(befContent + relationEntityNew.getContent().replace("<br/>", "\n"));
                        }
                        if (relationEntityNew.getWorkHours() == null) continue;
                        sumWorkHours = relationEntityNew.getWorkHours().add(sumWorkHours);
                    }
                }
                e.setRelationEntityList(relationNewList);
                e.setSumWorkHours(sumWorkHours);
            }
            if (e.getQuestionType() == 9 && StringUtils.isEmpty((String)e.getAnswer())) {
                e.setAnswer(e.getQuestionOption());
            }
            if (e.getQuestionId() == 62) {
                baseJsonVo2 = this.queryDayReport(paperEntity.getPeriodId(), paperEntity.getUserId(), userId);
                if (baseJsonVo2.isSuccess()) {
                    List orgDayReportVoList = (List)baseJsonVo2.getValue();
                    String orgDayReportVoListStr = JSON.toJSON((Object)orgDayReportVoList).toString();
                    e.setDayReportVos(orgDayReportVoList);
                }
                if (StringUtils.isEmpty((String)e.getAnswer())) {
                    e.setAnswer("[]");
                }
            }
            if (e.getQuestionId() == 70) {
                baseJsonVo2 = this.queryWeekJob(paperEntity.getId(), paperEntity.getUserId());
                if (baseJsonVo2.isSuccess()) {
                    List orgWeekJobVoList = (List)baseJsonVo2.getValue();
                    this.logger.info("----------orgWeekJobVoList={}", (Object)JSON.toJSONString((Object)orgWeekJobVoList));
                    e.setOrgWeekJobVos(orgWeekJobVoList);
                }
                if (StringUtils.isEmpty((String)e.getAnswer())) {
                    e.setAnswer("[]");
                }
            }
            if (e.getQuestionClassId() == 8) {
                List<PeriodEntity> periodEntityVoList;
                if (e.getQuestionId() == 37) {
                    List<MonthKpiVo> monthKpiList = this.kpiService.getMonthKpi(paperEntity.getPeriodId(), paperEntity.getUserId());
                    this.logger.info("++++++++++++++++++++getPaperAnswerList+++++++++++++monthKpiList={}", (Object)JSON.toJSONString(monthKpiList));
                    if (monthKpiList != null && monthKpiList.size() > 0) {
                        e.setAnswer(JSON.toJSONString(monthKpiList));
                    }
                    if (StringUtils.isEmpty((String)e.getAnswer())) {
                        e.setAnswer("[]");
                    }
                }
                if (e.getQuestionId() == 36) {
                    e.setAnswer(this.getLastPeriodField(paperEntity.getUserId(), 31, paperEntity.getPeriodId()));
                }
                if (e.getQuestionId() == 35 && (periodEntityVoList = this.periodService.getPeriodInfoByDateAll(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd())) != null && periodEntityVoList.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (PeriodEntity periodVo : periodEntityVoList) {
                        sb.append("<li style=\"font-size:14px;color:black;\">\u3010" + periodVo.getPeriodDesc() + "\u3011\uff1a");
                        String s = this.getWeekThingWeekFinish(periodVo.getId(), paperEntity.getUserId());
                        if (StringUtil.isNotEmpty((String)s)) {
                            sb.append("</li>" + s);
                            continue;
                        }
                        sb.append("\u672a\u586b\u5199</li>");
                    }
                    e.setQuestionDesc("<div style=\"list-style:none;\">" + sb.toString() + "</div><br/>" + e.getQuestionDesc());
                }
            }
            QuestionEntity question = this.questionDomain.select(e.getQuestionId());
            if (e.getQuestionClassId() == 9) {
                if (userId.equals(paperEntity.getUserId()) && this.iOrgPaperService.isEdit(paperEntity, paperEntity.getUserId(), null).isSuccess() && (StringUtils.isEmpty((String)e.getAnswer()) || "[]".equals(e.getAnswer())) && (baseJsonVo = this.periodService.getLastPeriod(periodEntity.getId())).isSuccess()) {
                    ArrayList<Integer> periodIdList = new ArrayList<Integer>();
                    periodIdList.add(((PeriodEntity)baseJsonVo.getValue()).getId());
                    List<PaperEntity> paperEntityList = this.iOrgPaperService.getPaperByPeriodId(periodIdList, paperEntity.getUserId(), 3);
                    if (paperEntityList != null && paperEntityList.size() > 0) {
                        PaperEntity paperEntityNew = paperEntityList.get(0);
                        ArrayList<String> paperIdList = new ArrayList<String>();
                        paperIdList.add(paperEntityNew.getId());
                        PaperAnswerVo paperAnswerVo = new PaperAnswerVo();
                        paperAnswerVo.setQuestionId(question.getRelationQuestionId());
                        paperAnswerVo.setPaperIdList(paperIdList);
                        paperAnswerVo.setUserId(paperEntity.getUserId());
                        List<PaperAnswerPeriodVo> paperAnswerEntityList = this.orgPaperAnswerDomain.queryPaperAnswerByQuestionId(paperAnswerVo);
                        if (paperAnswerEntityList != null && paperAnswerEntityList.size() > 0) {
                            ArrayList<PaperAnswerRelationEntity> relationEntityList = new ArrayList<PaperAnswerRelationEntity>();
                            for (PaperAnswerPeriodVo paperAnswerPeriodVo : paperAnswerEntityList) {
                                String[] answerList;
                                String answer = paperAnswerPeriodVo.getAnswer();
                                for (String answerStr : answerList = answer.split("\n")) {
                                    if (!StringUtils.isNotEmpty((String)answerStr)) continue;
                                    PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
                                    relationEntity.setContent(answerStr);
                                    relationEntity.setIsLeader(0);
                                    relationEntityList.add(relationEntity);
                                }
                            }
                            e.setRelationEntityList(relationEntityList);
                        }
                    }
                }
                e.setQuestionDesc(e.getQuestionDesc() + "<p style='color:#e50011 font-size:20px'>&nbsp;&nbsp;&nbsp;\u53ef\u5728\u3010\u5468\u4e8b\u5468\u6bd5\u3011\u6a21\u5757\u4e0b\u62d6\u62fd\u6392\u5e8f</p>");
            }
            if (question.getParentQuestionId() != null && question.getParentQuestionId() != 0) {
                if (subQuestions.containsKey(question.getParentQuestionId())) {
                    ((List)subQuestions.get(question.getParentQuestionId())).add(e);
                } else {
                    ArrayList<PaperAnswerEditVo> list = new ArrayList<PaperAnswerEditVo>();
                    list.add(e);
                    subQuestions.put(question.getParentQuestionId(), list);
                }
                e.setSubAnswer(true);
            }
            if (question.getIsPublicColumn() != null && question.getIsPublicColumn() == 0) {
                e.setPublic(false);
            }
            if (question.getIsReadonlyColumn() == null || question.getIsReadonlyColumn() != 1) continue;
            e.setReadonly(true);
        }
        if (!subQuestions.isEmpty()) {
            Iterator<PaperAnswerEditVo> iterator = editVos.iterator();
            while (iterator.hasNext()) {
                PaperAnswerEditVo editVo = iterator.next();
                if (subQuestions.containsKey(editVo.getQuestionId())) {
                    editVo.setSubPaperAnswerEditVos((List)subQuestions.get(editVo.getQuestionId()));
                }
                if (!editVo.getSubAnswer().booleanValue()) continue;
                iterator.remove();
            }
        }
        this.paperReadInterface.savePaperRead(userId, paperEntity);
        return BaseJsonVo.success(editVos);
    }

    public String getWeekThingWeekFinish(Integer periodId, String userId) {
        StringBuilder sb = new StringBuilder();
        BaseJsonVo baseJsonVo = this.getWeekThingWeekFinish(periodId, userId, userId);
        if (baseJsonVo.isSuccess()) {
            List<Object> relationNewList = new ArrayList();
            List tempList = (List)baseJsonVo.getValue();
            tempList.forEach(a -> a.setCheckWeekAfterWeek(true));
            for (PaperAnswerEditVo paperAnswerEditVo : tempList) {
                if (!StringUtils.isNotEmpty((String)paperAnswerEditVo.getId())) continue;
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(paperAnswerEditVo.getId());
                relationNewList = this.relationDomain.getListBySort(search);
                for (PaperAnswerRelationEntity paperAnswerRelationEntity : relationNewList) {
                    sb.append("<li style=\"margin-left:20px;font-size:12px;\">");
                    if (paperAnswerRelationEntity.getIsFinishLeader() != null) {
                        if (paperAnswerRelationEntity.getIsFinishLeader() == 1) {
                            sb.append("\u3010\u5df2\u5b8c\u6210\u3011");
                        } else if (paperAnswerRelationEntity.getIsFinishLeader() == 2) {
                            sb.append("\u3010\u672a\u5b8c\u6210\u3011");
                        } else {
                            sb.append("\u3010\u672a\u786e\u8ba4\u3011");
                        }
                    } else {
                        sb.append("\u3010\u672a\u786e\u8ba4\u3011");
                    }
                    sb.append(paperAnswerRelationEntity.getContent().replace("<br/>", ""));
                    sb.append("</li>");
                }
            }
        }
        return sb.toString();
    }

    public String getLastPeriodField(String userId, Integer questionId, Integer periodId) {
        QuestionEntity questionEntity = this.questionDomain.select(questionId);
        int periodType = this.periodService.getPeriodTypeByQuestionClass(questionEntity.getQuestionClassId());
        BaseJsonVo<PeriodEntity> jsonVo = this.periodService.getLastPeriod(periodId);
        PeriodEntity periodEntity = null;
        if (jsonVo.isSuccess()) {
            periodEntity = this.periodService.getPeriodInfoByDateAll(periodType, ((PeriodEntity)jsonVo.getValue()).getPeriodStart(), ((PeriodEntity)jsonVo.getValue()).getPeriodStart()).get(0);
        }
        if (periodEntity != null) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodEntity.getId());
            paperEntity.setUserId(userId);
            paperEntity.setQuestionClassId(questionEntity.getQuestionClassId());
            paperEntity = this.orgPaperDomain.getSingle(paperEntity);
            if (paperEntity != null) {
                PaperAnswerEntity search = new PaperAnswerEntity();
                search.setPaperId(paperEntity.getId());
                search.setQuestionId(questionId);
                search = this.orgPaperAnswerDomain.getSingle(search);
                if (search != null) {
                    return search.getAnswer();
                }
            }
        }
        return "";
    }

    public String getCurrentPeriodField(String userId, Integer questionId, Integer periodId) {
        QuestionEntity questionEntity = this.questionDomain.select(questionId);
        int periodType = this.periodService.getPeriodTypeByQuestionClass(questionEntity.getQuestionClassId());
        BaseJsonVo<PeriodEntity> jsonVo = this.periodService.getLastPeriod(periodId);
        PeriodEntity periodEntity = null;
        if (jsonVo.isSuccess()) {
            periodEntity = this.periodService.getPeriodInfoByDateAll(periodType, ((PeriodEntity)jsonVo.getValue()).getPeriodStart(), ((PeriodEntity)jsonVo.getValue()).getPeriodStart()).get(0);
        }
        if (periodEntity != null) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(periodEntity.getId());
            paperEntity.setUserId(userId);
            paperEntity.setQuestionClassId(questionEntity.getQuestionClassId());
            paperEntity = this.orgPaperDomain.getSingle(paperEntity);
            if (paperEntity != null && this.iOrgPaperService.isEdit(paperEntity, userId, null).isSuccess()) {
                PaperAnswerEntity search = new PaperAnswerEntity();
                search.setPaperId(paperEntity.getId());
                search.setQuestionId(questionId);
                search = this.orgPaperAnswerDomain.getSingle(search);
                if (search != null) {
                    return search.getAnswer();
                }
            }
        }
        return "";
    }

    @Override
    public BaseJsonVo relationMe(Integer pageNum, Integer pageSize, String userId, String classIds, Integer ctype, Integer isself) {
        PageInfo pageInfo = this.orgPaperAnswerDomain.getRelationMe(pageNum, pageSize, userId, classIds, ctype, isself);
        List relationVos = pageInfo.getList();
        Long unReadCount = relationVos.stream().filter(c -> c.getIsnew().equals(1)).count();
        if (unReadCount == null) {
            unReadCount = 0L;
        }
        for (PaperAnswerRelationVo v : relationVos.stream().filter(c -> c.getIsnew().equals(1)).collect(Collectors.toList())) {
            v.setUnReadCount(unReadCount);
            PaperAnswerRelationEntity relationEntity = new PaperAnswerRelationEntity();
            relationEntity.setId(v.getRelationId());
            relationEntity.setIsnew(0);
            this.relationDomain.update(relationEntity);
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo lookPaperAnswer(PageForm pageForm, Integer year, Integer period, Integer classId, String userId, Integer questionId) {
        List<QuestionClassEntity> classEntities = this.questionClassDomain.getQuestionClassEntityList(0);
        if (classId == null && questionId == null) {
            return BaseJsonVo.error((String)"\u5206\u7c7b\u548c\u95ee\u9898\u81f3\u5c11\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u67e5\u8be2");
        }
        if (classId == null) {
            QuestionEntity questionEntity = this.questionDomain.select(questionId);
            classId = questionEntity == null ? Integer.valueOf(0) : questionEntity.getQuestionClassId();
        }
        ArrayList paperAnswerLookVos = new ArrayList();
        int periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        PeriodEntity periodEntity = year == null || period == null ? (PeriodEntity)this.periodService.currentPeriod(periodType).getValue() : (PeriodEntity)this.periodService.getPeriodWithNum(year, period, periodType).getValue();
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo pageInfo = this.orgPaperAnswerDomain.lookPaperAnswer(pageForm.getCurrentPage(), pageForm.getPageSize(), periodEntity.getId(), classId, users, questionId);
        for (PaperAnswerLookVo l : pageInfo.getList()) {
            List urlVos;
            Optional<OptionVo> optionVo;
            List optionVos;
            QuestionEntity questionEntity;
            StringBuilder sb;
            if (l.getQuestionType() == 4 || l.getQuestionType() == 5) {
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(l.getId());
                List<PaperAnswerRelationEntity> relationEntities = this.relationDomain.getList(search);
                sb = new StringBuilder();
                for (PaperAnswerRelationEntity r : relationEntities) {
                    sb.append("@");
                    sb.append(r.getRelationUserName());
                    sb.append("<br/>");
                    sb.append(r.getContent());
                }
                l.setAnswer(sb.toString());
            }
            if (l.getQuestionType() == 2 && (questionEntity = this.questionDomain.select(l.getQuestionId())) != null && (optionVos = JsonUtils.getListByArray(OptionVo.class, (String)questionEntity.getQuestionOption())) != null && (optionVo = optionVos.stream().filter(c -> c.getCode().equals(l.getAnswer())).findFirst()).isPresent()) {
                l.setAnswer(optionVo.get().getName());
            }
            if (l.getQuestionType() != 3 || (urlVos = JsonUtils.getListByArray(PaperAnswerUrlVo.class, (String)l.getAnswer())) == null) continue;
            String template = "<a href='%s' target='_blank'>%s</a><br/>";
            sb = new StringBuilder();
            for (PaperAnswerUrlVo u : urlVos) {
                sb.append(String.format(template, u.getUrl(), u.getName()));
            }
            l.setAnswer(sb.toString());
        }
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public BaseJsonVo getWeekThingWeekFinish(Integer period, String userId, String leaderUserId) {
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setPeriodId(period);
        paperEntity.setUserId(userId);
        paperEntity.setQuestionClassId(9);
        List<PaperEntity> paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
        if (paperList == null || paperList.size() <= 0) {
            return BaseJsonVo.error((String)"\u65e0\u6570\u636e");
        }
        paperEntity = paperList.get(0);
        List<PaperAnswerEditVo> editVos = this.orgPaperAnswerDomain.getAnswerQuestion(9, paperEntity.getId());
        boolean canRated = this.userInterface.isLeadership(leaderUserId, userId);
        for (PaperAnswerEditVo e : editVos) {
            e.setPaperId(paperEntity.getId());
            e.setCanRated(canRated);
            if (e.getQuestionType() != 5 && e.getQuestionType() != 6 && e.getQuestionType() != 13) continue;
            List<PaperAnswerRelationEntity> relationEntities = new ArrayList<PaperAnswerRelationEntity>();
            if (StringUtils.isNotEmpty((String)e.getId())) {
                PaperAnswerRelationEntity search = new PaperAnswerRelationEntity();
                search.setAnswerId(e.getId());
                relationEntities = this.relationDomain.getList(search);
                for (PaperAnswerRelationEntity r : relationEntities) {
                    String befContent = "";
                    if (r.getIsDissent() != null && r.getIsDissent() == 1) {
                        befContent = "\u3010\u5f02\u8bae\u3011";
                    }
                    String content = r.getContent() == null ? "" : r.getContent();
                    r.setContent(befContent + content.replace("<br/>", "\n"));
                }
            }
            if (relationEntities.size() == 0) {
                relationEntities.add(new PaperAnswerRelationEntity());
            }
            e.setRelationEntityList(relationEntities);
        }
        return BaseJsonVo.success(editVos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo importPaperAnswer(MultipartFile file) {
        BaseJsonVo baseJson = new BaseJsonVo();
        try (InputStream inputStream = file.getInputStream();){
            List<ExcelDataVo> excelDataVos = ExcelUtil.readExcel(new BufferedInputStream(inputStream), ExcelDataVo.class);
            this.logger.info(">>>>>>>>>importPaperAnswer rows:{} excelDataVos={}", (Object)excelDataVos.size(), (Object)JSON.toJSONString(excelDataVos));
            BaseJsonVo baseJsonVo = this.importPaperAnswer(excelDataVos);
            return baseJsonVo;
        }
        catch (Exception e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
            return baseJson;
        }
    }

    @Override
    public BaseJsonVo importPaperAnswer(List<ExcelDataVo> excelDataVos) {
        BaseJsonVo baseJson = new BaseJsonVo();
        HashSet<String> setStr = new HashSet<String>();
        try {
            if (excelDataVos != null && excelDataVos.size() > 0) {
                ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
                for (ExcelDataVo excelDataVo : excelDataVos) {
                    Date createTime;
                    String userId = "";
                    MallUserEntityVo mallUserEntityVo = new MallUserEntityVo();
                    List<MallUserEntityVo> userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, null, excelDataVo.getDingdingId(), 1000);
                    if (userEntityVos == null || userEntityVos.size() == 0) {
                        BaseJsonVo<OapiUserGetResponse> us = this.dingdingUtils.getUser(excelDataVo.getDingdingId());
                        if (us.isSuccess()) {
                            if (StringUtils.isNotEmpty((String)((OapiUserGetResponse)us.getValue()).getEmail())) {
                                userEntityVos = this.sysUserInterface.getMallUserInfoByParam(((OapiUserGetResponse)us.getValue()).getEmail(), null, null, 1000);
                            }
                            if (userEntityVos.size() == 0) {
                                if (StringUtils.isNotEmpty((String)((OapiUserGetResponse)us.getValue()).getMobile())) {
                                    userEntityVos = this.sysUserInterface.getMallUserInfoByParam(((OapiUserGetResponse)us.getValue()).getEmail(), null, null, ((OapiUserGetResponse)us.getValue()).getMobile(), 1000);
                                }
                                if (userEntityVos.size() == 0) {
                                    userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, ((OapiUserGetResponse)us.getValue()).getName(), null, 1000);
                                    userEntityVos = userEntityVos.stream().filter(c -> c.getDingdingId() != null).collect(Collectors.toList());
                                }
                            }
                        }
                        if (userEntityVos != null && userEntityVos.size() == 1) {
                            this.sysUserInterface.updateUserDingDingIdById(userEntityVos.get(0).getUserId(), excelDataVo.getDingdingId());
                        }
                    }
                    if (userEntityVos == null || userEntityVos.size() <= 0) {
                        setStr.add(excelDataVo.getUserName());
                        continue;
                    }
                    mallUserEntityVo = userEntityVos.get(0);
                    userId = mallUserEntityVo.getUserId();
                    PaperEntity paperEntity = new PaperEntity();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                    try {
                        createTime = sdf.parse(excelDataVo.getCreateTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        setStr.add(excelDataVo.getUserName());
                        continue;
                    }
                    int endTime = 36000;
                    String createTimeStr = excelDataVo.getCreateTime();
                    String str1 = createTimeStr.substring(0, createTimeStr.indexOf("\u65e5"));
                    String str2 = createTimeStr.substring(str1.length() + 1, createTimeStr.length());
                    Date createTimeStrDate = DateUtils.StrToDate((String)str2, (String)"HH:mm");
                    createTimeStr = DateUtils.formatDate((Date)createTimeStrDate, (String)"HH:mm");
                    String[] createTimeStrArry = createTimeStr.split(":");
                    Integer hour = Integer.valueOf(createTimeStrArry[0]);
                    Integer minute = Integer.valueOf(createTimeStrArry[1]);
                    Integer writeSecond = 0;
                    writeSecond = writeSecond + hour * 3600;
                    writeSecond = writeSecond + minute * 60;
                    if (writeSecond >= 0 && writeSecond <= endTime) {
                        createTime = DateUtils.getAddDateBySecond((Date)createTime, (int)-86400);
                    }
                    paperAnswerEntityList.addAll(this.saveDayReport(createTime, userId, excelDataVo));
                }
                if (paperAnswerEntityList.size() > 0) {
                    this.savePaperAnswer(paperAnswerEntityList, null);
                    paperAnswerEntityList.stream().map(c -> c.getPaperId()).distinct().forEach(paperId -> {
                        PaperEntity p = new PaperEntity();
                        p.setId((String)paperId);
                        p.setReportStatus(1);
                        this.orgPaperDomain.update(p);
                    });
                }
            }
            if (setStr != null && setStr.size() > 0) {
                baseJson.setValue(setStr);
                baseJson.setMessage("\u90e8\u5206\u7528\u6237\u5bfc\u5165\u5931\u8d25 \u7528\u6237\u540d\u79f0\u96c6\u5408\uff1a" + JSON.toJSONString(setStr));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return baseJson;
    }

    private List<PaperAnswerEntity> saveDayReport(Date createTime, String userId, ExcelDataVo excelDataVo) {
        ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
        PaperEntity paperEntity = new PaperEntity();
        PaperAnswerEntity paperAnswerEntity = new PaperAnswerEntity();
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getPeriod(createTime, 4).getValue();
        if (periodEntity != null) {
            paperEntity.setPeriodId(periodEntity.getId());
        }
        paperEntity.setUserId(userId);
        paperEntity.setQuestionClassId(11);
        List<PaperEntity> paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
        if (paperList == null || paperList.size() <= 0) {
            BaseJsonVo baseJsonVo = this.iOrgPaperService.buildPaper(userId, 11, periodEntity.getId());
            if (baseJsonVo.isSuccess()) {
                paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
            } else {
                return new ArrayList<PaperAnswerEntity>();
            }
        }
        paperEntity = paperList.get(0);
        paperAnswerEntity.setPaperId(paperEntity.getId());
        paperAnswerEntity.setUserId(userId);
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)excelDataVo.getTodayAnswer()))) {
            PaperAnswerEntity paperAnswerEntity1 = new PaperAnswerEntity();
            paperAnswerEntity1.setUserId(paperAnswerEntity.getUserId());
            paperAnswerEntity1.setPaperId(paperAnswerEntity.getPaperId());
            paperAnswerEntity1.setQuestionId(58);
            paperAnswerEntity1.setAnswer(excelDataVo.getTodayAnswer());
            paperAnswerEntity1.setCreateTime(createTime);
            paperAnswerEntityList.add(paperAnswerEntity1);
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)excelDataVo.getTomorrowAnswer()))) {
            PaperAnswerEntity paperAnswerEntity2 = new PaperAnswerEntity();
            paperAnswerEntity2.setUserId(paperAnswerEntity.getUserId());
            paperAnswerEntity2.setPaperId(paperAnswerEntity.getPaperId());
            paperAnswerEntity2.setQuestionId(59);
            paperAnswerEntity2.setAnswer(excelDataVo.getTomorrowAnswer());
            paperAnswerEntity2.setCreateTime(createTime);
            paperAnswerEntityList.add(paperAnswerEntity2);
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)excelDataVo.getNeedHelp()))) {
            PaperAnswerEntity paperAnswerEntity3 = new PaperAnswerEntity();
            paperAnswerEntity3.setUserId(paperAnswerEntity.getUserId());
            paperAnswerEntity3.setPaperId(paperAnswerEntity.getPaperId());
            paperAnswerEntity3.setQuestionId(60);
            paperAnswerEntity3.setAnswer(excelDataVo.getNeedHelp());
            paperAnswerEntity3.setCreateTime(createTime);
            paperAnswerEntityList.add(paperAnswerEntity3);
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)excelDataVo.getCompanyMail()))) {
            PaperAnswerEntity paperAnswerEntity4 = new PaperAnswerEntity();
            paperAnswerEntity4.setUserId(paperAnswerEntity.getUserId());
            paperAnswerEntity4.setPaperId(paperAnswerEntity.getPaperId());
            paperAnswerEntity4.setQuestionId(61);
            paperAnswerEntity4.setAnswer(excelDataVo.getCompanyMail());
            paperAnswerEntity4.setCreateTime(createTime);
            paperAnswerEntityList.add(paperAnswerEntity4);
        }
        return paperAnswerEntityList;
    }

    @Override
    public BaseJsonVo queryDayReport(Integer periodId, String userId, String loginId) {
        if (periodId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        ArrayList<OrgDayReportVo> orgDayReportVoList = new ArrayList<OrgDayReportVo>();
        List<PeriodEntity> periodEntityList = this.periodService.getPeriodInfoByDate(4, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        if (periodEntityList != null && periodEntityList.size() > 0) {
            List<String> paperIdList;
            List<PaperAnswerEntity> paperAnswerEntityList;
            List<PaperEntity> paperEntityList = this.iOrgPaperService.getPaperByPeriodId(periodEntityList.stream().map(c -> c.getId()).collect(Collectors.toList()), userId, 11);
            Object o = this.redisService.get(userId + periodId);
            if (o == null && userId.equals(loginId)) {
                MallUserEntity userEntity;
                Date startDate = null;
                for (PeriodEntity periodVo : periodEntityList) {
                    if (!DateUtils.getAddDateBySecond((Date)periodVo.getPeriodStart(), (int)1).after(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-1)) || !periodVo.getPeriodStart().before(DateUtils.now()) || paperEntityList.stream().filter(c -> Integer.valueOf(1).equals(c.getReportStatus()) && c.getPeriodId().equals(periodVo.getId())).count() != 0L) continue;
                    startDate = periodVo.getPeriodStart();
                    break;
                }
                if (startDate != null && (userEntity = this.sysUserInterface.getMallUser(userId)) != null && StringUtils.isNotEmpty((String)userEntity.getDingdingId())) {
                    BaseJsonVo<List<ExcelDataVo>> dataVos = this.getDingDingReport(startDate, "", userEntity.getDingdingId());
                    this.redisService.save(userId + periodId, startDate, 300L);
                    if (dataVos.isSuccess()) {
                        if (dataVos != null && ((List)dataVos.getValue()).size() > 0) {
                            this.importPaperAnswer((List)dataVos.getValue());
                            paperEntityList = this.iOrgPaperService.getPaperByPeriodId(periodEntityList.stream().map(c -> c.getId()).collect(Collectors.toList()), userId, 11);
                        }
                    } else {
                        this.logger.error("\u83b7\u53d6\u9489\u9489\u65e5\u62a5\u5f02\u5e38" + dataVos.getMessage());
                    }
                }
            }
            if (paperEntityList != null && paperEntityList.size() > 0 && (paperAnswerEntityList = this.orgPaperAnswerDomain.queryPaperAnswerByParam(paperIdList = paperEntityList.stream().map(c -> c.getId()).collect(Collectors.toList()), userId)) != null && paperAnswerEntityList.size() > 0) {
                for (PaperEntity p : paperEntityList) {
                    OrgDayReportVo orgDayReportVo = new OrgDayReportVo();
                    for (PaperAnswerEntity paperAnswerVo1 : paperAnswerEntityList) {
                        if (!p.getId().equals(paperAnswerVo1.getPaperId())) continue;
                        orgDayReportVo.setKpiEnable(p.getReportStatus());
                        if (paperAnswerVo1.getQuestionId() == 58) {
                            orgDayReportVo.setTodayAnswer(paperAnswerVo1.getAnswer());
                        }
                        if (paperAnswerVo1.getQuestionId() == 59) {
                            orgDayReportVo.setTomorrowAnswer(paperAnswerVo1.getAnswer());
                        }
                        orgDayReportVo.setDateWeek(DateUtils.getShortWeekOfDate((Date)paperAnswerVo1.getCreateTime()));
                        orgDayReportVo.setDate(paperAnswerVo1.getCreateTime());
                    }
                    if (!StringUtils.isNotEmpty((String)orgDayReportVo.getTodayAnswer())) continue;
                    orgDayReportVoList.add(orgDayReportVo);
                }
            }
        }
        for (PeriodEntity periodVo : periodEntityList) {
            String week = DateUtils.getShortWeekOfDate((Date)periodVo.getPeriodStart());
            if (DateUtils.getWeekIndexOfDate((Date)periodVo.getPeriodStart()) == 6 || DateUtils.getWeekIndexOfDate((Date)periodVo.getPeriodStart()) == 7 || orgDayReportVoList.stream().filter(c -> c.getDateWeek().equals(week)).count() != 0L) continue;
            OrgDayReportVo orgDayReportVo = new OrgDayReportVo();
            orgDayReportVo.setDateWeek(week);
            orgDayReportVo.setKpiEnable(0);
            orgDayReportVo.setDate(periodVo.getPeriodStart());
            orgDayReportVo.setTodayAnswer("");
            orgDayReportVo.setTomorrowAnswer("");
            orgDayReportVoList.add(orgDayReportVo);
        }
        return BaseJsonVo.success(orgDayReportVoList.stream().sorted((e, f) -> e.getDate().compareTo(f.getDate())).collect(Collectors.toList()));
    }

    @Override
    public List<LinkedHashMap<String, Object>> getThisMonthWeek(PaperEntity paperEntity, PeriodEntity periodEntity) {
        List<PeriodEntity> periodEntityVoList = this.periodService.getPeriodInfoByDateAll(0, periodEntity.getPeriodStart(), periodEntity.getPeriodEnd());
        ArrayList<LinkedHashMap<String, Object>> maps = new ArrayList<LinkedHashMap<String, Object>>();
        if (periodEntityVoList != null && periodEntityVoList.size() > 0) {
            for (PeriodEntity periodVo : periodEntityVoList) {
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                String content = this.getWeekThingWeekFinish(periodVo.getId(), paperEntity.getUserId());
                if (StringUtils.isEmpty((String)content)) {
                    content = "\u672a\u586b\u5199";
                }
                m.put("content", HtmlUtil.getTextFromHtml(content));
                m.put("week_index", periodVo.getHeadPeriod());
                maps.add(m);
            }
        }
        return maps;
    }

    @Override
    public List<LinkedHashMap<String, Object>> getThisWeekOfWeek(PaperEntity paperEntity, PeriodEntity periodEntity) {
        BaseJsonVo baseJsonVo = this.getWeekThingWeekFinish(periodEntity.getId(), paperEntity.getUserId(), "");
        ArrayList<LinkedHashMap<String, Object>> maps = new ArrayList<LinkedHashMap<String, Object>>();
        if (baseJsonVo.isSuccess()) {
            ArrayList relationNewList = new ArrayList();
            List tempList = (List)baseJsonVo.getValue();
            for (PaperAnswerEditVo v : tempList) {
                if (v.getRelationEntityList() == null) continue;
                for (PaperAnswerRelationEntity r : v.getRelationEntityList()) {
                    LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                    m.put("content_week", r.getContent());
                    m.put("is_finish", Integer.valueOf(1).equals(r.getIsFinishEmploye()) ? "\u662f" : "\u5426");
                    m.put("is_finish_leader", Integer.valueOf(1).equals(r.getIsFinishLeader()) ? "\u662f" : "\u5426");
                    m.put("week_index", periodEntity.getHeadPeriod());
                    maps.add(m);
                }
            }
        }
        return maps;
    }

    @Override
    public List<LinkedHashMap<String, Object>> getNextWeekOfWeek(PaperEntity paperEntity, PeriodEntity periodEntity) {
        BaseJsonVo<PeriodEntity> jsonVo = this.periodService.getNextPeriod(periodEntity.getId());
        PeriodEntity nextPeriod = null;
        if (!jsonVo.isSuccess()) {
            return new ArrayList<LinkedHashMap<String, Object>>();
        }
        nextPeriod = (PeriodEntity)jsonVo.getValue();
        BaseJsonVo baseJsonVo = this.getWeekThingWeekFinish(nextPeriod.getId(), paperEntity.getUserId(), "");
        ArrayList<LinkedHashMap<String, Object>> maps = new ArrayList<LinkedHashMap<String, Object>>();
        if (baseJsonVo.isSuccess()) {
            ArrayList relationNewList = new ArrayList();
            List tempList = (List)baseJsonVo.getValue();
            for (PaperAnswerEditVo v : tempList) {
                if (v.getRelationEntityList() == null) continue;
                for (PaperAnswerRelationEntity r : v.getRelationEntityList()) {
                    LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                    m.put("content_week_next", r.getContent());
                    m.put("is_finish_next", Integer.valueOf(1).equals(r.getIsFinishEmploye()) ? "\u662f" : "\u5426");
                    m.put("is_finish_leader_next", Integer.valueOf(1).equals(r.getIsFinishLeader()) ? "\u662f" : "\u5426");
                    m.put("week_index_next", nextPeriod.getHeadPeriod());
                    maps.add(m);
                }
            }
        }
        return maps;
    }

    @Override
    public BaseJsonVo<List<ExcelDataVo>> getDingDingReport(Date date, String userName, String dingdingId) {
        if (StringUtils.isNotEmpty((String)userName)) {
            List<MallUserEntityVo> userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, userName, null, 1000);
            if (userEntityVos != null && userEntityVos.size() > 0) {
                dingdingId = userEntityVos.get(0).getDingdingId();
                if (StringUtils.isEmpty((String)dingdingId)) {
                    return BaseJsonVo.error((String)"\u9489\u9489Id\u4e3a\u7a7a");
                }
            } else {
                return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
            }
        }
        BaseJsonVo<List<OapiReportListResponse.ReportOapiVo>> jsonVo = this.dingdingUtils.getReport("\u6bcf\u65e5\u5c0f\u7ed3", date, DateUtils.now(), dingdingId);
        ArrayList<ExcelDataVo> dataVos = new ArrayList<ExcelDataVo>();
        if (jsonVo.isSuccess()) {
            for (OapiReportListResponse.ReportOapiVo reportOapiVo : (List)jsonVo.getValue()) {
                ExcelDataVo dataVo = new ExcelDataVo();
                Optional<OapiReportListResponse.JsonObject> Content = reportOapiVo.getContents().stream().filter(c -> c.getKey().equals("\u4eca\u65e5\u5b8c\u6210\u5de5\u4f5c")).findFirst();
                dataVo.setTodayAnswer(Content.isPresent() ? Content.get().getValue() : "");
                Content = reportOapiVo.getContents().stream().filter(c -> c.getKey().equals("\u660e\u65e5\u5fc5\u5b8c\u6210\u5de5\u4f5c")).findFirst();
                dataVo.setTomorrowAnswer(Content.isPresent() ? Content.get().getValue() : "");
                Content = reportOapiVo.getContents().stream().filter(c -> c.getKey().equals("\u9700\u8981\u7684\u652f\u6301")).findFirst();
                dataVo.setNeedHelp(Content.isPresent() ? Content.get().getValue() : "");
                dataVo.setCreateTime(DateUtils.formatDate((Date)new Date(reportOapiVo.getCreateTime()), (String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
                dataVo.setDingdingId(reportOapiVo.getCreatorId());
                dataVo.setUserName(reportOapiVo.getCreatorName());
                dataVos.add(dataVo);
            }
        } else {
            return BaseJsonVo.error((String)jsonVo.getMessage());
        }
        return BaseJsonVo.success(dataVos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo importWeekJob(MultipartFile file) {
        BaseJsonVo baseJson = new BaseJsonVo();
        try (InputStream inputStream = file.getInputStream();){
            List<WeekJobExcelDataVo> weekJobExcelDataVoList = ExcelUtil.readExcel(new BufferedInputStream(inputStream), WeekJobExcelDataVo.class);
            this.logger.info(">>>>>>>>>importWeekJob rows:{} WeekJobExcelDataVo={}", (Object)weekJobExcelDataVoList.size(), (Object)JSON.toJSONString(weekJobExcelDataVoList));
            BaseJsonVo baseJsonVo = this.importWeekJob(weekJobExcelDataVoList);
            return baseJsonVo;
        }
        catch (Exception e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
            return baseJson;
        }
    }

    public BaseJsonVo importWeekJob(List<WeekJobExcelDataVo> weekJobExcelDataVoList) {
        BaseJsonVo baseJson = new BaseJsonVo();
        HashSet<String> setStr = new HashSet<String>();
        try {
            if (weekJobExcelDataVoList != null && weekJobExcelDataVoList.size() > 0) {
                ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
                for (WeekJobExcelDataVo weekJobExcelDataVo : weekJobExcelDataVoList) {
                    Date createTime;
                    String userId = "";
                    MallUserEntityVo mallUserEntityVo = new MallUserEntityVo();
                    List<MallUserEntityVo> userEntityVos = this.sysUserInterface.getMallUserInfoByParam(weekJobExcelDataVo.getCompanyMail(), null, null, 1000);
                    if (userEntityVos != null && userEntityVos.size() > 0) {
                        mallUserEntityVo = userEntityVos.get(0);
                        userId = mallUserEntityVo.getUserId();
                        if (StringUtils.isNotEmpty((String)weekJobExcelDataVo.getLevel())) {
                            this.sysUserInterface.updateUserLevelById(userEntityVos.get(0).getUserId(), weekJobExcelDataVo.getLevel());
                        }
                    } else {
                        setStr.add(weekJobExcelDataVo.getUserName());
                        continue;
                    }
                    PaperEntity paperEntity = new PaperEntity();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    try {
                        createTime = sdf.parse(weekJobExcelDataVo.getCreateTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        setStr.add(weekJobExcelDataVo.getUserName());
                        continue;
                    }
                    paperAnswerEntityList.addAll(this.saveWeekJob(createTime, userId, weekJobExcelDataVo));
                }
                if (paperAnswerEntityList.size() > 0) {
                    this.savePaperAnswer(paperAnswerEntityList, null);
                    paperAnswerEntityList.stream().map(c -> c.getPaperId()).distinct().forEach(paperId -> {
                        PaperEntity p = new PaperEntity();
                        p.setId((String)paperId);
                        p.setReportStatus(1);
                        p.setStatus(1);
                        this.orgPaperDomain.update(p);
                    });
                }
            }
            if (setStr != null && setStr.size() > 0) {
                baseJson.setValue(setStr);
                baseJson.setMessage("\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5931\u8d25 \u7528\u6237\u540d\u79f0\u96c6\u5408\uff1a" + JSON.toJSONString(setStr));
            } else {
                baseJson = BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return baseJson;
    }

    private List<PaperAnswerEntity> saveWeekJob(Date createTime, String userId, WeekJobExcelDataVo weekJobExcelDataVo) {
        ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
        PaperEntity paperEntity = new PaperEntity();
        PaperAnswerEntity paperAnswerEntity = new PaperAnswerEntity();
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getPeriod(createTime, 0).getValue();
        if (periodEntity != null) {
            paperEntity.setPeriodId(periodEntity.getId());
        }
        paperEntity.setUserId(userId);
        paperEntity.setQuestionClassId(15);
        List<PaperEntity> paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
        if (paperList == null || paperList.size() <= 0) {
            BaseJsonVo baseJsonVo = this.iOrgPaperService.buildPaper(userId, 15, periodEntity.getId());
            if (baseJsonVo.isSuccess()) {
                paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
            } else {
                return new ArrayList<PaperAnswerEntity>();
            }
        }
        paperEntity = paperList.get(0);
        paperAnswerEntity.setPaperId(paperEntity.getId());
        paperAnswerEntity.setUserId(userId);
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)weekJobExcelDataVo.getWeekJob()))) {
            PaperAnswerEntity paperAnswerEntity1 = new PaperAnswerEntity();
            paperAnswerEntity1.setUserId(paperAnswerEntity.getUserId());
            paperAnswerEntity1.setPaperId(paperAnswerEntity.getPaperId());
            paperAnswerEntity1.setQuestionId(70);
            paperAnswerEntity1.setAnswer(weekJobExcelDataVo.getWeekJob());
            paperAnswerEntity1.setCreateTime(createTime);
            paperAnswerEntityList.add(paperAnswerEntity1);
        }
        return paperAnswerEntityList;
    }

    public BaseJsonVo queryWeekJob(String id, String userId) {
        ArrayList<OrgWeekJobVo> orgWeekJobVoList = new ArrayList<OrgWeekJobVo>();
        ArrayList<String> paperIdList = new ArrayList<String>();
        paperIdList.add(id);
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(id);
        List paperEntityList = this.iOrgPaperService.getList(paperEntity);
        List<PaperAnswerEntity> paperAnswerEntityList = this.orgPaperAnswerDomain.queryPaperAnswerByParam(paperIdList, userId);
        this.logger.info("========paperEntityList={},paperAnswerEntityList={}", (Object)JSON.toJSONString((Object)paperEntityList), (Object)JSON.toJSONString(paperAnswerEntityList));
        if (paperAnswerEntityList != null && paperAnswerEntityList.size() > 0) {
            for (PaperEntity p : paperEntityList) {
                OrgWeekJobVo orgWeekJobVo = new OrgWeekJobVo();
                for (PaperAnswerEntity paperAnswerVo1 : paperAnswerEntityList) {
                    if (!p.getId().equals(paperAnswerVo1.getPaperId())) continue;
                    orgWeekJobVo.setWeekJob(paperAnswerVo1.getAnswer());
                }
                orgWeekJobVoList.add(orgWeekJobVo);
            }
        }
        this.logger.info("========orgWeekJobVoList={}", (Object)JSON.toJSONString(orgWeekJobVoList));
        return BaseJsonVo.success(orgWeekJobVoList);
    }

    @Override
    public Map<String, Object> getWeekTaskList(List<String> deptIds, List<String> levels) {
        List<PaperAnswerWeekTaskVo> taskVos = this.orgPaperAnswerDomain.getWeekTaskList(deptIds, levels);
        ArrayList<HashedMap> weeks = new ArrayList<HashedMap>();
        Integer titleLenght = 0;
        int i = 0;
        int j = 0;
        for (Object w : taskVos.stream().map(c -> c.getPeriodName()).distinct().toArray()) {
            ++i;
            HashedMap week = new HashedMap();
            week.put("week", w.toString());
            ArrayList<HashedMap> lst = new ArrayList<HashedMap>();
            for (PaperAnswerWeekTaskVo v : taskVos.stream().filter(c -> c.getPeriodName().equals(w.toString())).collect(Collectors.toList())) {
                HashedMap l = new HashedMap();
                l.put("userName", v.getDeptName() + "-" + v.getUserName());
                l.put("answer", v.getAnswer());
                lst.add(l);
            }
            week.put("lst", lst);
            if (titleLenght < lst.size() - 1) {
                titleLenght = lst.size() - 1;
                j = i;
            }
            weeks.add(week);
        }
        HashedMap obj = new HashedMap();
        obj.put("data", weeks);
        obj.put("title", j);
        return obj;
    }

    @Override
    public List<OkrListVo> getOKRList(Integer periodId) {
        return this.orgPaperAnswerDomain.getOKRList(periodId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseJsonVo importOKR(MultipartFile file) {
        BaseJsonVo baseJson = new BaseJsonVo();
        try (InputStream inputStream = file.getInputStream();){
            List<OKRExcelDataVo> dataVos = ExcelUtil.readExcel(new BufferedInputStream(inputStream), OKRExcelDataVo.class);
            this.logger.info(">>>>>>>>>importWeekJob rows:{} WeekJobExcelDataVo={}", (Object)dataVos.size(), (Object)JSON.toJSONString(dataVos));
            BaseJsonVo baseJsonVo = this.importOKR(dataVos);
            return baseJsonVo;
        }
        catch (Exception e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
            return baseJson;
        }
    }

    public BaseJsonVo importOKR(List<OKRExcelDataVo> okrExcelDataVos) {
        BaseJsonVo baseJson = new BaseJsonVo();
        HashSet<String> setStr = new HashSet<String>();
        try {
            if (okrExcelDataVos != null && okrExcelDataVos.size() > 0) {
                ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
                for (OKRExcelDataVo okrExcelDataVo : okrExcelDataVos) {
                    Date createTime;
                    String userId;
                    block11: {
                        userId = "";
                        MallUserEntityVo mallUserEntityVo = new MallUserEntityVo();
                        List<MallUserEntityVo> userEntityVos = StringUtils.isNotEmpty((String)okrExcelDataVo.getCompanyMail()) ? this.sysUserInterface.getMallUserInfoByParam(okrExcelDataVo.getCompanyMail(), null, null, 1000) : this.sysUserInterface.getMallUserInfoByParam(null, okrExcelDataVo.getUserName(), null, 1000);
                        if (userEntityVos == null || userEntityVos.size() <= 0) {
                            setStr.add(okrExcelDataVo.getUserName());
                            continue;
                        }
                        mallUserEntityVo = userEntityVos.get(0);
                        userId = mallUserEntityVo.getUserId();
                        PaperEntity paperEntity = new PaperEntity();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        if (StringUtils.isNotEmpty((String)okrExcelDataVo.getMonth())) {
                            try {
                                createTime = sdf.parse(okrExcelDataVo.getMonth());
                                break block11;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                                setStr.add(okrExcelDataVo.getUserName());
                                continue;
                            }
                        }
                        setStr.add(okrExcelDataVo.getUserName());
                        continue;
                    }
                    paperAnswerEntityList.addAll(this.saveOKR(createTime, userId, okrExcelDataVo));
                }
                if (paperAnswerEntityList.size() > 0) {
                    this.savePaperAnswer(paperAnswerEntityList, null);
                    paperAnswerEntityList.stream().map(c -> c.getPaperId()).distinct().forEach(paperId -> {
                        PaperEntity p = new PaperEntity();
                        p.setId((String)paperId);
                        p.setReportStatus(1);
                        p.setStatus(1);
                        this.orgPaperDomain.update(p);
                    });
                }
            }
            if (setStr != null && setStr.size() > 0) {
                baseJson.setValue(setStr);
                baseJson.setMessage("\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5931\u8d25 \u7528\u6237\u540d\u79f0\u96c6\u5408\uff1a" + JSON.toJSONString(setStr));
            } else {
                baseJson = BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return baseJson;
    }

    private List<PaperAnswerEntity> saveOKR(Date createTime, String userId, OKRExcelDataVo okrExcelDataVo) {
        ArrayList<PaperAnswerEntity> paperAnswerEntityList = new ArrayList<PaperAnswerEntity>();
        PaperEntity paperEntity = new PaperEntity();
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getPeriod(createTime, 1).getValue();
        if (periodEntity != null) {
            paperEntity.setPeriodId(periodEntity.getId());
        }
        paperEntity.setUserId(userId);
        paperEntity.setQuestionClassId(16);
        List<PaperEntity> paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
        if (paperList == null || paperList.size() <= 0) {
            BaseJsonVo baseJsonVo = this.iOrgPaperService.buildPaper(userId, 16, periodEntity.getId());
            if (baseJsonVo.isSuccess()) {
                paperList = this.orgPaperDomain.selectPaperInfo(paperEntity);
            } else {
                return new ArrayList<PaperAnswerEntity>();
            }
        }
        paperEntity = paperList.get(0);
        try {
            Map map = BeanUtils.describe((Object)okrExcelDataVo);
            for (String o : map.keySet()) {
                if (!o.toLowerCase().contains("field")) continue;
                PaperAnswerEntity paperAnswerEntity1 = new PaperAnswerEntity();
                paperAnswerEntity1.setUserId(userId);
                paperAnswerEntity1.setPaperId(paperEntity.getId());
                paperAnswerEntity1.setQuestionId(Integer.valueOf(o.replace("field", "")));
                String answer = (String)map.get(o);
                paperAnswerEntity1.setAnswer(answer == null ? "" : answer);
                paperAnswerEntity1.setCreateTime(createTime);
                paperAnswerEntityList.add(paperAnswerEntity1);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return paperAnswerEntityList;
    }
}

