/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.enums.organization.JianDaoyunAppEnum;
import cc.lechun.common.enums.organization.OrgQuestionClassEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.user.MallUserEntityVo;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.KpiInterface;
import cc.lechun.organization.iservice.OrgPaperImportUserVisitInterface;
import cc.lechun.utils.JianDaoYunAPIUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgPaperImportUserVisit
extends BaseService
implements OrgPaperImportUserVisitInterface {
    private JianDaoyunAppEnum jianDaoyunAppEnum = JianDaoyunAppEnum.JIANDAOYUN_User_Extend_APPID;
    @Autowired
    private IOrgPaperDomain paperDomain;
    @Autowired
    private IOrgPaperService paperService;
    @Autowired
    private IOrgPaperAnswerService paperAnswerService;
    @Autowired
    private IOrgQuestionClassDomain orgQuestionClassDomain;
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private KpiInterface kpiInterface;
    private OrgQuestionClassEnum classEnum = OrgQuestionClassEnum.valueOf("ChannelUserExtendReport");
    private JianDaoYunAPIUtils jianDaoYunAPIUtils = JianDaoYunAPIUtils.getInstance(this.jianDaoyunAppEnum, this.classEnum);

    @Override
    public List<Map<String, Object>> getFormFields() {
        return this.jianDaoYunAPIUtils.getFormWidgets();
    }

    @Override
    public BaseJsonVo getAllFormData(String sdate, String edate) {
        List<Map<String, Object>> maps = this.getFormFields();
        Object[] fields = maps.stream().map(c -> c.get("name")).toArray();
        HashedMap filter = new HashedMap();
        filter.put("rel", "and");
        ArrayList<1> lstFilter = new ArrayList<1>();
        final String[] arr = new String[]{DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)sdate, (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"), edate};
        lstFilter.add(new HashedMap(){
            {
                this.put("field", "date");
                this.put("method", "range");
                this.put("value", arr);
            }
        });
        filter.put("cond", lstFilter);
        List<Map<String, Object>> rtn = this.jianDaoYunAPIUtils.getAllFormData(fields, (Map<String, Object>)filter);
        for (Map<String, Object> m : rtn) {
            String dingdingId = m.get("name") == null ? "" : ((Map)m.get("name")).get("username").toString();
            String d = m.get("date").toString();
            d = d.replace("Z", " UTC");
            System.out.println(d);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS Z");
            Date date = null;
            try {
                date = format.parse(d);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (date == null) {
                this.logger.info("\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff1a" + d);
                continue;
            }
            List<MallUserEntityVo> userEntityVos = null;
            String userId = "";
            if (StringUtils.isNotEmpty((String)dingdingId)) {
                userEntityVos = this.sysUserInterface.getMallUserInfoByParam(null, null, dingdingId, 1000);
                if (userEntityVos != null && userEntityVos.size() > 0) {
                    userId = userEntityVos.get(0).getUserId();
                } else {
                    this.logger.info("\u9489\u9489Id:" + dingdingId + "\u65e0\u5bf9\u5e94\u7684\u7528\u6237");
                }
            } else {
                this.logger.info("\u9489\u9489Id\u4e0d\u5b58\u5728");
            }
            if (StringUtils.isNotEmpty((String)userId)) {
                BaseJsonVo<PeriodEntity> baseJsonVo = this.periodService.getPeriod(date, 0);
                if (baseJsonVo.isSuccess()) {
                    PaperEntity paperEntity = new PaperEntity();
                    paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
                    paperEntity.setUserId(userId);
                    paperEntity.setQuestionClassId(this.classEnum.getQuestionClassId());
                    paperEntity = this.paperDomain.getSingle(paperEntity);
                    if (paperEntity != null) {
                        List<PaperAnswerEntity> answerEntityList;
                        if (!Integer.valueOf(0).equals(paperEntity.getStatus())) {
                            if (!Integer.valueOf(0).equals(paperEntity.getReportStatus())) {
                                this.logger.info("\u5df2\u5408\u683c\u7684\u4e0d\u518d\u8986\u76d6\uff1a" + JsonUtils.toJson(m, (boolean)false));
                                continue;
                            }
                            this.logger.info("\u5df2\u586b\u5199\u5bfc\u5165\u8986\u76d6\uff1a" + JsonUtils.toJson(m, (boolean)false));
                        }
                        if ((answerEntityList = this.buildAnswer(m, date, userId, paperEntity.getId(), maps)).size() > 0) {
                            PaperAnswerEntity answerEntity = new PaperAnswerEntity();
                            answerEntity.setCreateTime(date);
                            answerEntity.setUserId(userId);
                            answerEntity.setAnswer("0002");
                            answerEntity.setPaperId(paperEntity.getId());
                            answerEntity.setQuestionId(1);
                            answerEntityList.add(answerEntity);
                            answerEntity = new PaperAnswerEntity();
                            answerEntity.setCreateTime(date);
                            answerEntity.setUserId(userId);
                            answerEntity.setAnswer("\u5ba2\u6237");
                            answerEntity.setPaperId(paperEntity.getId());
                            answerEntity.setQuestionId(6);
                            answerEntityList.add(answerEntity);
                            answerEntity = new PaperAnswerEntity();
                            answerEntity.setCreateTime(date);
                            answerEntity.setUserId(userId);
                            answerEntity.setAnswer(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)7), (String)"yyyy-MM-dd"));
                            answerEntity.setPaperId(paperEntity.getId());
                            answerEntity.setQuestionId(64);
                            answerEntityList.add(answerEntity);
                            this.paperAnswerService.savePaperAnswer(answerEntityList, userId);
                            continue;
                        }
                        this.logger.info("\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u5185\u5bb9\uff1a" + JsonUtils.toJson(m, (boolean)false));
                        continue;
                    }
                    this.logger.info("\u62a5\u544a\u4e0d\u5b58\u5728\uff0cperiod:" + ((PeriodEntity)baseJsonVo.getValue()).getId() + ",user:" + userId + ",class:" + this.classEnum.getQuestionClassId());
                    continue;
                }
                this.logger.info("\u671f\u6b21\u4e0d\u5b58\u5728\uff0cdate:" + date);
                continue;
            }
            this.logger.info("\u7528\u6237Id\u4e3a\u7a7a\uff1a" + JsonUtils.toJson(m, (boolean)false));
        }
        return BaseJsonVo.success((Object)"");
    }

    private List<PaperAnswerEntity> buildAnswer(Map<String, Object> map, Date date, String userId, String paperId, List<Map<String, Object>> fields) {
        PaperAnswerEntity answerEntity;
        ArrayList<PaperAnswerEntity> entitie = new ArrayList<PaperAnswerEntity>();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        StringBuilder sb3 = new StringBuilder();
        int i = 0;
        for (String k : map.keySet()) {
            if (!k.equals("shop") && !k.equals("p1") && !k.equals("p2") && !k.equals("p3") && !k.equals("g1") && !k.equals("g2") && !k.equals("g3") && !k.equals("g4") && !k.equals("g5") && !k.equals("g6") && !k.equals("n1") && !k.equals("n2") && !k.equals("n3") && !k.equals("n4")) continue;
            if (map.get(k) instanceof String) {
                List<Integer> q = this.getQuestion(k);
                if (q.size() <= 0) continue;
                PaperAnswerEntity answerEntity2 = new PaperAnswerEntity();
                answerEntity2.setCreateTime(date);
                answerEntity2.setUserId(userId);
                answerEntity2.setAnswer(map.get(k).toString());
                answerEntity2.setPaperId(paperId);
                answerEntity2.setQuestionId(q.get(0));
                entitie.add(answerEntity2);
            }
            if (!(map.get(k) instanceof ArrayList)) continue;
            ++i;
            Optional<Map> field = fields.stream().filter(c -> c.get("name").equals(k)).findFirst();
            if (field.isPresent()) {
                sb1.append(i + "." + field.get().get("label").toString() + "\u3010\u770b\u89c1\u3011\r\n");
                sb2.append(i + "." + field.get().get("label").toString() + "\u3010\u601d\u8003\u3011\r\n");
            }
            for (Map m : (List)map.get(k)) {
                sb1.append("    " + m.get(k + "_f1") == null ? "" : m.get(k + "_f1").toString() + "\r\n");
                sb2.append("    " + m.get(k + "_f2") == null ? "" : m.get(k + "_f2").toString() + "\r\n");
            }
        }
        if (sb1.length() > 0) {
            for (Integer q : this.getQuestion("f1")) {
                answerEntity = new PaperAnswerEntity();
                answerEntity.setCreateTime(date);
                answerEntity.setUserId(userId);
                answerEntity.setAnswer(sb1.toString());
                answerEntity.setPaperId(paperId);
                answerEntity.setQuestionId(q);
                entitie.add(answerEntity);
            }
        }
        if (sb2.length() > 0) {
            for (Integer q : this.getQuestion("f2")) {
                answerEntity = new PaperAnswerEntity();
                answerEntity.setCreateTime(date);
                answerEntity.setUserId(userId);
                answerEntity.setAnswer(sb2.toString());
                answerEntity.setPaperId(paperId);
                answerEntity.setQuestionId(q);
                entitie.add(answerEntity);
            }
        }
        if (sb3.length() > 0) {
            for (Integer q : this.getQuestion("f3")) {
                answerEntity = new PaperAnswerEntity();
                answerEntity.setCreateTime(date);
                answerEntity.setUserId(userId);
                answerEntity.setAnswer(sb3.toString());
                answerEntity.setPaperId(paperId);
                answerEntity.setQuestionId(q);
                entitie.add(answerEntity);
            }
        }
        return entitie;
    }

    private List<Integer> getQuestion(String name) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        if ("shop".equals(name)) {
            r.add(24);
        }
        if (name.contains("f1")) {
            r.add(25);
        }
        if (name.contains("f2")) {
            r.add(4);
            r.add(26);
            r.add(5);
            r.add(27);
        }
        if (name.contains("f3")) {
            r.add(5);
            r.add(27);
        }
        return r;
    }
}

