/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionClassVo;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.iservice.IOrgQuestionClassService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgQuestionClassService
extends BaseService
implements IOrgQuestionClassService {
    @Autowired
    private IOrgQuestionClassDomain orgQuestionClassDomain;

    @Override
    @ReadThroughSingleCache(namespace="OrgQuestionClassService.getQuestionClassList", expiration=300)
    public List<QuestionClassVo> getQuestionClassList(@ParameterValueKeyProvider Integer parentClassId) {
        try {
            List<QuestionClassEntity> classList = this.orgQuestionClassDomain.getQuestionClassEntityList(parentClassId);
            ArrayList<QuestionClassVo> list = new ArrayList<QuestionClassVo>();
            if (classList != null && classList.size() > 0) {
                classList.stream().filter(t -> t.getEnableVote() == 1).forEach(c -> {
                    QuestionClassVo questionClassVo = new QuestionClassVo();
                    BeanUtils.copyProperties((Object)c, (Object)questionClassVo);
                    list.add(questionClassVo);
                });
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u67e5\u627e\u95ee\u9898\u5206\u7c7b\u51fa\u9519,{}", (Object)parentClassId);
            return null;
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="OrgQuestionClassService.getQuestionClass", expiration=300)
    public QuestionClassEntity getQuestionClass(@ParameterValueKeyProvider Integer classId) {
        try {
            return this.orgQuestionClassDomain.getQuestionClassEntity(classId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u67e5\u627e\u95ee\u9898\u5206\u7c7b\u51fa\u9519,{}", (Object)classId);
            return null;
        }
    }
}

