/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCashticketMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.apiinvoke.mall.CashInvoke;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveCashticketService
extends BaseService
implements ActiveCashticketInterface {
    @Autowired
    private ActiveCashticketMapper activeCashticketMapper;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    CashInvoke cashInvoke;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=300)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType) {
        return this.activeCashticketMapper.getRedpackageConfigVoList(activeNo, activeType);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=300)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType, @ParameterValueKeyProvider(order=2) Integer shareCount) {
        List<RedpackageConfigDetailVo> list = this.getRedpackageConfigVoList(activeNo, activeType);
        if (list != null) {
            return list.stream().filter(c -> c.getUserType().intValue() == shareCount.intValue()).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getCashticketByBindCode")
    public List<ActiveCashticketVo> getSelectCashticketByBindCode(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getCashticketByBindCode(bindCode);
    }

    @Override
    public BaseJsonVo getCashticketListByBindCode(String bindCode) {
        return BaseJsonVo.success(this.activeCashticketMapper.getCashticketListByBindCode(bindCode));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getActiveCashticketList", expiration=300)
    public List<ActiveCashticketVo> getActiveCashticketList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer platFormId) {
        List<ActiveCashticketVo> list;
        Integer groupFormId = this.platFormService.getPlatFormGroupId(platFormId);
        if (StringUtils.isEmpty((String)bindCode) || "null".equals(bindCode)) {
            list = this.activeCashticketMapper.getActiveCashticketList4New(groupFormId);
        } else {
            list = this.activeCashticketMapper.getActiveCashticketList(bindCode, groupFormId);
            if (list.size() >= 1) {
                list.sort((v1, v2) -> {
                    if (v1.getCount() != null && v2.getCount() != null) {
                        return v2.getCount().compareTo(v1.getCount());
                    }
                    return 0;
                });
            }
        }
        return list;
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        return this.cashInvoke.sendCashticket(customerId, bindCode, 0.0, versionDetailId, platFormId, isSendMessage, isSendMessage);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog) {
        return this.cashInvoke.sendCashticket(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog, boolean checkActive) {
        return this.cashInvoke.sendCashticket(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog, checkActive);
    }

    @Override
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        this.cashInvoke.sendCashticketMq(customerId, bindCode, versionDetailId, platFormId, isSendMessage, isSendMessage);
    }

    @Override
    @Deprecated
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean checkActive) {
        ActiveCashticketMessageVo activeCashticketMessageVo = new ActiveCashticketMessageVo();
        activeCashticketMessageVo.setBindCode(bindCode);
        activeCashticketMessageVo.setOpenId("");
        activeCashticketMessageVo.setUserId(customerId);
        activeCashticketMessageVo.setVersionDetailId("");
        activeCashticketMessageVo.setSendMessage(isSendMessage);
        activeCashticketMessageVo.setPlatFormId(platFormId);
        activeCashticketMessageVo.setCheckActive(checkActive);
        this.logger.info("\u53d1\u9001\u5230\u6d88\u606f\u961f\u5217\uff0c" + JsonUtils.toJson((Object)activeCashticketMessageVo, (boolean)true));
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendActiveCashTicket, MessageParam.messageParam((String)customerId, (Object)activeCashticketMessageVo));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getBindCodeActiveCashticketList", expiration=300)
    public List<ActiveCashticketEntity> getBindCodeActiveCashticketList(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getBindCodeActiveCashticketList(bindCode);
    }

    @Override
    public BaseJsonVo deleteCouponConfig(Integer id) {
        ActiveCashticketEntity activeCashticketEntity = (ActiveCashticketEntity)this.activeCashticketMapper.selectByPrimaryKey(id);
        this.removeCache(activeCashticketEntity.getBindCode());
        int k = this.activeCashticketMapper.deleteByPrimaryKey(id);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveCoupon(String listCashticket, String bindCode) {
        try {
            String items = URLDecoder.decode(listCashticket, "UTF-8");
            if (!items.startsWith("[")) {
                items = "[" + items + "]";
            }
            List list = JsonUtils.getListByArray(ActiveCashticketEntity.class, (String)items);
            this.removeCache(bindCode);
            this.activeCashticketMapper.deleteCashticketByBindCode(bindCode);
            list.forEach(c -> {
                c.setBindCode(bindCode);
                c.setTackType(2);
                this.logger.info(c.toString());
            });
            this.activeCashticketMapper.insertActiveCashticketBatch(list);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.logger.error("\u4fdd\u5b58\u7ed1\u5b9a\u4f18\u60e0\u5238\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteCouponConfigByBindCode(String bindCode) {
        this.removeCache(bindCode);
        this.activeCashticketMapper.deleteCashticketByBindCode(bindCode);
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(String bindCode) {
        this.memcachedService.delete("ActiveCashticketService.getBindCodeActiveCashticketList", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketByBindCode", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketListByBindCode", bindCode);
    }

    @Override
    @Transactional
    public BaseJsonVo copyActiveCoupon(ActiveEntity sourceAct, String objBindCode) {
        ActiveCashticketEntity cashticketEntity = new ActiveCashticketEntity();
        cashticketEntity.setBindCode(sourceAct.getBindCode());
        List lst = this.activeCashticketMapper.getList(cashticketEntity);
        for (ActiveCashticketEntity p : lst) {
            p.setBindCode(objBindCode);
            p.setId(null);
            this.activeCashticketMapper.insertSelective(p);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo copyActiveQrCodeCoupon(String sourceBindCode, String objBindCode) {
        ActiveCashticketEntity cashticketEntity = new ActiveCashticketEntity();
        cashticketEntity.setBindCode(sourceBindCode);
        List lst = this.activeCashticketMapper.getList(cashticketEntity);
        for (ActiveCashticketEntity p : lst) {
            p.setBindCode(objBindCode);
            p.setId(null);
            this.activeCashticketMapper.insertSelective(p);
        }
        return BaseJsonVo.success((Object)"");
    }
}

