/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveItemMapper;
import cc.lechun.active.entity.active.ActiveItemEntity;
import cc.lechun.active.entity.active.ActiveItemPriceVo;
import cc.lechun.active.entity.active.ActiveItemResultVo;
import cc.lechun.active.iservice.active.ActiveItemInterface;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveItemService
extends BaseService<ActiveItemEntity, Integer>
implements ActiveItemInterface {
    @Resource
    private ActiveItemMapper activeItemMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;

    @Override
    public PageInfo getActiveItemList(ActiveItemEntity activeItemEntity, int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize).setOrderBy(" SEQUENCE ");
        List list = this.activeItemMapper.getList(activeItemEntity);
        PageInfo pg = page.toPageInfo();
        ArrayList result = new ArrayList();
        list.forEach(a -> {
            Serializable product;
            ActiveItemResultVo resultVo = new ActiveItemResultVo();
            BeanUtils.copyProperties((Object)a, (Object)resultVo);
            String itemName = "\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5";
            if (Integer.valueOf(4).equals(a.getItemType())) {
                resultVo.setItemTypeName("\u5355\u54c1");
                product = this.productInterface.getProduct(a.getItemId());
                if (product != null) {
                    itemName = ((MallProductEntity)product).getProName();
                }
            }
            if (Integer.valueOf(1).equals(a.getItemType())) {
                resultVo.setItemTypeName("\u4fc3\u9500");
                product = this.promotionInterface.getPromotion(a.getItemId());
                if (product != null) {
                    itemName = ((MallPromotionEntity)product).getPromotionName();
                }
            }
            resultVo.setItemName(itemName);
            resultVo.setStatusName(Integer.valueOf(1).equals(a.getStatus()) ? "\u6709\u6548" : "\u65e0\u6548");
            resultVo.setPriceTag(this.convertPriceList(a.getPriceList()));
            result.add(resultVo);
        });
        pg.setList(result);
        return pg;
    }

    private String convertPriceList(String priceList) {
        if (StringUtils.isEmpty((String)priceList)) {
            return "";
        }
        List priceVos = JsonUtils.getListByArray(ActiveItemPriceVo.class, (String)priceList);
        if (CollectionUtils.isNotEmpty((Collection)priceVos)) {
            StringBuilder sb = new StringBuilder();
            for (ActiveItemPriceVo v : priceVos) {
                sb.append("\u6570\u91cf" + v.getStart() + "~" + v.getEnd() + "\u552e\u4ef7" + v.getPrice() + ";");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public BaseJsonVo deleteActiveItem(ActiveItemEntity activeItemEntity) {
        int i;
        if (activeItemEntity != null && activeItemEntity.getId() != null && (i = this.deleteByPrimaryKey(activeItemEntity.getId())) > 0) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveItem(ActiveItemEntity activeItemEntity) {
        if (activeItemEntity != null) {
            if (StringUtils.isEmpty((String)activeItemEntity.getBindCode())) {
                return BaseJsonVo.error((String)"bindCodew\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)activeItemEntity.getItemId())) {
                return BaseJsonVo.error((String)"\u5546\u54c1Id\u4e3a\u7a7a");
            }
            if (activeItemEntity.getItemType() == null) {
                return BaseJsonVo.error((String)"\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (activeItemEntity.getOriginPrice() == null) {
                MallPromotionProductEntity promotion;
                MallProductEntity product;
                if (activeItemEntity.getItemType() == 4 && (product = this.productInterface.getProduct(activeItemEntity.getItemId())) != null) {
                    activeItemEntity.setOriginPrice(BigDecimal.valueOf(Double.valueOf(product.getProPrice())));
                }
                if (activeItemEntity.getItemType() == 1 && (promotion = this.promotionProductInterface.getPromotionProductEntity(activeItemEntity.getItemId())) != null) {
                    activeItemEntity.setOriginPrice(promotion.getPromotionPrice());
                }
            }
            if (activeItemEntity.getSalePrice() == null) {
                activeItemEntity.setSalePrice(activeItemEntity.getOriginPrice());
            }
            ActiveItemEntity search = new ActiveItemEntity();
            search.setBindCode(activeItemEntity.getBindCode());
            search.setItemType(activeItemEntity.getItemType());
            search.setItemId(activeItemEntity.getItemId());
            search = (ActiveItemEntity)this.activeItemMapper.getSingle(search);
            if (search != null) {
                activeItemEntity.setId(search.getId());
            }
            if (activeItemEntity.getId() == null) {
                this.insertSelective(activeItemEntity);
            } else {
                activeItemEntity.setPriceList(null);
                this.updateByPrimaryKeySelective(activeItemEntity);
            }
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveItemSalePriceList(Integer id, String priceList) {
        if (id == null) {
            return BaseJsonVo.error((String)"id\u4e3a\u7a7a");
        }
        List priceVos = JsonUtils.getListByArray(ActiveItemPriceVo.class, (String)priceList);
        if (CollectionUtils.isNotEmpty((Collection)priceVos)) {
            for (ActiveItemPriceVo s : priceVos) {
                if (s.getStart() == null || s.getEnd() == null) {
                    return BaseJsonVo.error((String)"\u8d77\u59cb\u6570\u91cf\u6216\u7ed3\u675f\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (s.getPrice() == null) {
                    return BaseJsonVo.error((String)"\u9636\u68af\u9500\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (s.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    return BaseJsonVo.error((String)"\u9636\u68af\u9500\u552e\u4ef7\u4e0d\u80fd\u4e3a0");
                }
                if (s.getStart() > s.getEnd()) {
                    return BaseJsonVo.error((String)"\u8d77\u59cb\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6570\u91cf");
                }
                if (priceVos.stream().filter(c -> !s.equals(c) && s.getStart().compareTo(c.getStart()) >= 0 && s.getStart().compareTo(c.getEnd()) <= 0).count() > 0L) {
                    return BaseJsonVo.error((String)"\u8d77\u59cb\u6570\u91cf\u91cd\u53e0");
                }
                if (priceVos.stream().filter(c -> !s.equals(c) && s.getEnd().compareTo(c.getStart()) >= 0 && s.getEnd().compareTo(c.getEnd()) <= 0).count() <= 0L) continue;
                return BaseJsonVo.error((String)"\u7ed3\u675f\u6570\u91cf\u91cd\u53e0");
            }
        }
        ActiveItemEntity itemEntity = new ActiveItemEntity();
        itemEntity.setId(id);
        itemEntity.setPriceList(priceList);
        this.updateByPrimaryKeySelective(itemEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo setActiveItemStatus(Integer id, Integer status) {
        if (id == null) {
            return BaseJsonVo.error((String)"id\u4e3a\u7a7a");
        }
        if (status == null) {
            return BaseJsonVo.error((String)"\u72b6\u6001\u4e3a\u7a7a");
        }
        ActiveItemEntity itemEntity = new ActiveItemEntity();
        itemEntity.setId(id);
        itemEntity.setStatus(status);
        this.updateByPrimaryKeySelective(itemEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }
}

