/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.dao.active.ActivePageMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.page.PageLinkEntity;
import cc.lechun.mall.iservice.page.PageLinkInterface;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivePageService
extends BaseService
implements ActivePageInterface {
    @Autowired
    private PageLinkInterface pageLinkInterface;
    @Autowired
    private ActiveMapper activeMapper;
    @Autowired
    private ActivePageMapper activePageMapper;

    @Override
    public BaseJsonVo<ActivePageEntity> getActivePageEntity(String activeNo) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        PageLinkEntity pageLinkEntity = new PageLinkEntity();
        pageLinkEntity.setActiveType(activeEntity.getActiveType());
        pageLinkEntity.setDefaultPage(1);
        PageLinkEntity query = (PageLinkEntity)this.pageLinkInterface.getSingle(pageLinkEntity, 0L);
        if (query.getLinkId() != null) {
            ActivePageEntity activePageEntity = new ActivePageEntity();
            activePageEntity.setActiveContent("");
            activePageEntity.setActiveUrl(query.getPageLink() + (StringUtils.isNotEmpty((String)query.getPageLinkPara()) ? "?" + this.getActiveLink(activeEntity, query.getPageLinkPara()) : ""));
            return BaseJsonVo.success((Object)activePageEntity);
        }
        return BaseJsonVo.error((String)"\u53c2\u6570\u6709\u8bef");
    }

    @Override
    public ActivePageEntity getActivePageEntityByActiveNo(String activeNo) {
        ActivePageEntity activePageEntity = new ActivePageEntity();
        activePageEntity.setActiveNo(activeNo);
        return (ActivePageEntity)this.activePageMapper.getSingle(activePageEntity);
    }

    @Override
    public BaseJsonVo saveActivePage(ActivePageEntity activePageEntity) {
        if (StringUtils.isEmpty((String)activePageEntity.getActivePageId())) {
            activePageEntity.setActivePageId(IDGenerate.getUniqueIdStr());
            return this.activePageMapper.insertSelective(activePageEntity) >= 1 ? BaseJsonVo.success((Object)activePageEntity) : BaseJsonVo.error((String)"");
        }
        return this.activePageMapper.updateByPrimaryKeySelective(activePageEntity) >= 1 ? BaseJsonVo.success((Object)activePageEntity) : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo saveActivePage(ActiveEntity activeEntity) {
        return this.saveActivePage(activeEntity, 0);
    }

    @Override
    public BaseJsonVo saveActivePage(ActiveEntity activeEntity, int updateStatus) {
        ActivePageEntity queryActivePage = new ActivePageEntity();
        queryActivePage.setActiveNo(activeEntity.getActiveNo());
        ActivePageEntity result = (ActivePageEntity)this.activePageMapper.getSingle(queryActivePage);
        if (result == null || StringUtils.isEmpty((String)result.getActiveUrl()) || updateStatus == 1) {
            PageLinkEntity pageLinkEntity = new PageLinkEntity();
            pageLinkEntity.setActiveType(activeEntity.getActiveType());
            PageLinkEntity query = (PageLinkEntity)this.pageLinkInterface.getSingle(pageLinkEntity, 0L);
            if (query != null && query.getLinkId() != null) {
                if (result == null || StringUtils.isEmpty((String)result.getActiveUrl())) {
                    ActivePageEntity activePageEntity = new ActivePageEntity();
                    activePageEntity.setActiveUrl(this.getActiveLink(activeEntity, query.getPageLinkPara()));
                    activePageEntity.setActiveUrl(query.getPageLink() + (StringUtils.isNotEmpty((String)query.getPageLinkPara()) ? "?" + this.getActiveLink(activeEntity, query.getPageLinkPara()) : ""));
                    activePageEntity.setActiveNo(activeEntity.getActiveNo());
                    activePageEntity.setColor1("");
                    activePageEntity.setIsvip(0);
                    activePageEntity.setVipRightType(activeEntity.getVipRightType());
                    return this.saveActivePage(activePageEntity);
                }
                if (updateStatus == 1) {
                    result.setActiveUrl(query.getPageLink() + (StringUtils.isNotEmpty((String)query.getPageLinkPara()) ? "?" + this.getActiveLink(activeEntity, query.getPageLinkPara()) : ""));
                    return this.saveActivePage(result);
                }
            }
            this.logger.error("\u6d3b\u52a8\u8fde\u63a5\u6ca1\u6709\u914d\u7f6e\uff01\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
            return BaseJsonVo.error((String)"\u627e\u4e0d\u5230\u6d3b\u52a8\u57fa\u7840\u8fde\u63a5,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo copyActivePage(ActiveEntity sourceAct, String objActiveNo, String objBindCode) {
        ActivePageEntity pageEntity = new ActivePageEntity();
        pageEntity.setActiveNo(sourceAct.getActiveNo());
        String url = "";
        List lst = this.activePageMapper.getList(pageEntity);
        for (ActivePageEntity p : lst) {
            p.setActiveNo(objActiveNo);
            p.setActivePageId(IDGenerate.getUniqueIdStr());
            if (StringUtils.isNotEmpty((String)p.getActiveUrl())) {
                p.setActiveUrl(p.getActiveUrl().replace(sourceAct.getBindCode(), objBindCode));
                url = p.getActiveUrl();
            }
            this.activePageMapper.insertSelective(p);
        }
        return BaseJsonVo.success((Object)url);
    }

    private String getActiveLink(ActiveEntity activeEntity, String url) {
        return this.getActiveLink(activeEntity.getBindCode(), activeEntity.getActiveNo(), url);
    }

    private String getActiveLink(String bindCode, String activeNo, String url) {
        return url.replace("{bindCode}", bindCode).replace("{activeNo}", activeNo);
    }
}

