/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActivePropertyQueryVo;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.service.property.ActivePropertyContext;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivePropertyService
extends BaseService<ActivePropertyEntity, Integer>
implements ActivePropertyInterface {
    @Resource
    private ActivePropertyMapper activePropertyMapper;
    @Autowired
    private ActivePropertyContext activePropertyContext;

    @Override
    public BaseJsonVo saveReunionActiveProperty(String itemList, Integer platformGroupId) throws UnsupportedEncodingException {
        List list;
        String items = URLDecoder.decode(itemList, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        boolean addFlag = ((ActivePropertyEntity)(list = JsonUtils.getListByArray(ActivePropertyEntity.class, (String)items)).get(0)).getPropertyId() == null || ((ActivePropertyEntity)list.get(0)).getPropertyId() == 0;
        for (ActivePropertyEntity activePropertyEntity : list) {
            activePropertyEntity.setStatus(1);
            activePropertyEntity.setPlatformGroupId(platformGroupId);
            this.logger.info("\u56fe\u7247\u5c5e\u6027:{}", (Object)JsonUtils.toJson((Object)activePropertyEntity, (boolean)false));
        }
        return (addFlag ? this.activePropertyMapper.batchInsert(list) > 0 : this.activePropertyMapper.batchUpdate(list) > 0) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\u8bf7\u7a0d\u5019\u91cd\u8bd5");
    }

    @Override
    public BaseJsonVo saveActiveProperty(ActivePropertyEntity activePropertyEntity) {
        this.logger.info(activePropertyEntity.toString());
        if (StringUtils.isEmpty((String)activePropertyEntity.getBindCode())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8bindCode\u4e3a\u7a7a");
        }
        ActivePropertyEntity search = new ActivePropertyEntity();
        search.setBindCode(activePropertyEntity.getBindCode());
        search.setPropertyKey(activePropertyEntity.getPropertyKey());
        search = (ActivePropertyEntity)this.activePropertyMapper.getSingle(search);
        if (search != null) {
            activePropertyEntity.setPropertyId(search.getPropertyId());
        }
        if (activePropertyEntity.getPropertyId() == null) {
            return this.insert(activePropertyEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return this.activePropertyMapper.updateByPrimaryKeySelective(activePropertyEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public BaseJsonVo deleteActiveProperty(ActivePropertyEntity activePropertyEntity) {
        if (activePropertyEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (activePropertyEntity.getPropertyId() == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e3b\u952e\u4e3a\u7a7a");
        }
        int i = this.deleteByPrimaryKey(activePropertyEntity.getPropertyId());
        if (i >= 1) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public BaseJsonVo getPicPropertyList(ActivePropertyQueryVo activePropertyQueryVo) {
        return this.activePropertyContext.getPicPropertyList(activePropertyQueryVo);
    }

    @Override
    public PageInfo<ActivePropertyEntity> getActivePropertyList(ActivePropertyQueryVo activePropertyQueryVo) {
        this.logger.info("\u6d3b\u52a8\u5c5e\u6027\u67e5\u8be2\u53c2\u6570:{}", (Object)activePropertyQueryVo.toString());
        ActivePropertyEntity query = new ActivePropertyEntity();
        BeanUtils.copyProperties((Object)activePropertyQueryVo, (Object)query);
        Page page = PageHelper.startPage((int)activePropertyQueryVo.getCurrentPage(), (int)activePropertyQueryVo.getPageSize());
        page.setOrderBy("PROPERTY_ID desc ");
        this.activePropertyMapper.getList(query);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo getActiveProperty(ActivePropertyQueryVo activePropertyQueryVo) {
        this.logger.info("\u6d3b\u52a8\u5c5e\u6027\u67e5\u8be2\u53c2\u6570:{}", (Object)activePropertyQueryVo.toString());
        ActivePropertyEntity query = new ActivePropertyEntity();
        BeanUtils.copyProperties((Object)activePropertyQueryVo, (Object)query);
        ActivePropertyEntity activePropertyEntity = (ActivePropertyEntity)this.activePropertyMapper.getSingle(query);
        return activePropertyEntity == null || activePropertyEntity.getPropertyId() == null ? BaseJsonVo.success((Object)"") : BaseJsonVo.success((Object)activePropertyEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo copyActiveProperty(ActiveEntity sourceAct, String objBindCode) {
        ActivePropertyEntity propertyEntity = new ActivePropertyEntity();
        propertyEntity.setBindCode(sourceAct.getBindCode());
        List lst = this.activePropertyMapper.getList(propertyEntity);
        for (ActivePropertyEntity p : lst) {
            p.setBindCode(objBindCode);
            p.setPropertyId(null);
            this.activePropertyMapper.insertSelective(p);
        }
        return BaseJsonVo.success((Object)"");
    }
}

