/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCashticketMapper;
import cc.lechun.active.dao.active.ActiveRuleMapper;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveRuleService
extends BaseService
implements ActiveRuleInterface {
    @Autowired
    private ActiveRuleMapper activeRuleMapper;
    @Autowired
    private ActiveCashticketMapper activeCashticketMapper;
    @Lazy
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo saveActiveRule(ActiveRuleEntity activeRuleEntity) {
        BaseJsonVo baseJsonVo = this.checkSaveActiveRule(activeRuleEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        activeRuleEntity.setBindCode(UUID.randomUUID().toString().replace("-", ""));
        activeRuleEntity.setCreateTime(DateUtils.now());
        this.removeCache(activeRuleEntity);
        return this.activeRuleMapper.insertSelective(activeRuleEntity) >= 1 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveRule(ActiveRuleEntity activeRuleEntity, List<ActiveCashticketEntity> activeCashTickets) {
        this.removeCache(activeRuleEntity);
        BaseJsonVo result = this.deleteActiveRule(activeRuleEntity, activeCashTickets);
        if (result.isSuccess()) {
            boolean temp;
            activeRuleEntity.setCreateTime(DateUtils.now());
            if (activeRuleEntity.getInviteQuantityMin() == null) {
                activeRuleEntity.setInviteQuantityMin(1);
            }
            if (activeRuleEntity.getInviteQuantityMax() == null) {
                activeRuleEntity.setInviteQuantityMax(100);
            }
            boolean bl = temp = this.activeRuleMapper.insert(activeRuleEntity) >= 1;
            if (!temp) {
                result.setError_msg("\u6d3b\u52a8\u89c4\u5219\u4fdd\u5b58\u5931\u8d25");
                return result;
            }
        } else {
            return result;
        }
        this.activeCashticketMapper.insertActiveCashticketBatch(activeCashTickets);
        return result;
    }

    @Override
    public BaseJsonVo saveActiveRuleByProId(ActiveRuleEntity activeRuleEntity, List<ActiveCashticketEntity> activeCashTickets) {
        BaseJsonVo result = this.deleteActiveRule(activeRuleEntity, activeCashTickets);
        if (result.isSuccess()) {
            boolean temp;
            activeRuleEntity.setCreateTime(DateUtils.now());
            boolean bl = temp = this.activeRuleMapper.insert(activeRuleEntity) >= 1;
            if (!temp) {
                return BaseJsonVo.error((String)"\u89c4\u5219\u4fdd\u5b58\u5931\u8d25");
            }
        } else {
            return result;
        }
        this.activeCashticketMapper.insertActiveCashticketBatch(activeCashTickets);
        return result;
    }

    private BaseJsonVo deleteActiveRule(ActiveRuleEntity activeRuleEntity, List<ActiveCashticketEntity> activeCashTickets) {
        BaseJsonVo result = this.checkSaveActiveRule(activeRuleEntity, activeCashTickets);
        if (result.isSuccess()) {
            ActiveRuleEntity temp;
            ActiveRuleEntity parameterActiveRule = new ActiveRuleEntity();
            parameterActiveRule.setActiveNo(activeRuleEntity.getActiveNo());
            if (activeRuleEntity.getInviteQuantityMin() != null) {
                parameterActiveRule.setInviteQuantityMin(activeRuleEntity.getInviteQuantityMin());
            }
            if (StringUtils.isNotEmpty((String)activeRuleEntity.getProId())) {
                parameterActiveRule.setProId(activeRuleEntity.getProId());
            }
            if ((temp = (ActiveRuleEntity)this.activeRuleMapper.getSingle(parameterActiveRule)) != null) {
                this.removeCache(activeRuleEntity);
                activeRuleEntity.setBindCode(temp.getBindCode());
                this.activeRuleMapper.deleteByPrimaryKey(temp.getActiveRuleId());
                this.activeCashticketMapper.deleteCashticketByBindCode(activeRuleEntity.getBindCode());
            } else if (StringUtils.isEmpty((String)activeRuleEntity.getBindCode())) {
                activeRuleEntity.setBindCode(IDGenerate.getUniqueIdStr());
            }
        }
        return result;
    }

    private void deleteActiveRule(String proId, List<ActiveCashticketEntity> activeCashTickets) {
        ActiveRuleEntity parameterActiveRule = new ActiveRuleEntity();
        parameterActiveRule.setProId(proId);
        ActiveRuleEntity temp = (ActiveRuleEntity)this.activeRuleMapper.getSingle(parameterActiveRule);
        if (temp != null) {
            this.activeRuleMapper.deleteByPrimaryKey(temp.getActiveRuleId());
        }
        this.activeCashticketMapper.deleteCashticketByBindCode(temp.getBindCode());
    }

    private BaseJsonVo checkSaveActiveRule(ActiveRuleEntity rule, List<ActiveCashticketEntity> activeCashTickets) {
        BaseJsonVo result = new BaseJsonVo();
        if (activeCashTickets != null) {
            if (rule == null) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u6b63\u786e");
            }
            if (activeCashTickets.size() == 0) {
                return BaseJsonVo.error((String)"\u5fc5\u987b\u9009\u62e9\u4f18\u60e0\u5238");
            }
            if (rule.getActiveNo().isEmpty()) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u6b63\u786e");
            }
        } else {
            return BaseJsonVo.error((String)"\u5fc5\u987b\u9009\u62e9\u4f18\u60e0\u5238");
        }
        return result;
    }

    private BaseJsonVo checkSaveActiveRule(ActiveRuleEntity rule) {
        if (rule == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u5151\u5956\u89c4\u5219");
        }
        if (rule.getInviteQuantityMin() == null || rule.getInviteQuantityMin() == 0) {
            return BaseJsonVo.error((String)"\u8d77\u59cb\u9080\u8bf7\u6570\u91cf\u6709\u8bef");
        }
        if (rule.getInviteQuantityMax() == null || rule.getInviteQuantityMax() == 0) {
            return BaseJsonVo.error((String)"\u622a\u6b62\u9080\u8bf7\u6570\u91cf\u6709\u8bef");
        }
        if (rule.getInviteQuantityMax() < rule.getInviteQuantityMin()) {
            return BaseJsonVo.error((String)"\u622a\u6b62\u9080\u8bf7\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u9080\u8bf7\u6570\u91cf");
        }
        if (StringUtils.isEmpty((String)rule.getActiveNo())) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public boolean deleteActiveRule(int id) {
        ActiveRuleEntity activeRuleEntity = (ActiveRuleEntity)this.activeRuleMapper.selectByPrimaryKey(Integer.valueOf(id));
        this.removeCache(activeRuleEntity);
        return this.activeRuleMapper.deleteByPrimaryKey(Integer.valueOf(id)) >= 1;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getRuleByQuantity", expiration=300)
    public ActiveRuleEntity getRuleByQuantity(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer count) {
        return this.activeRuleMapper.getRuleByQuantity(activeNo, count);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getRuleByQuantity")
    public ActiveRuleEntity getRuleByQuantity(@ParameterValueKeyProvider String activeNo) {
        ActiveRuleEntity activeRule = new ActiveRuleEntity();
        activeRule.setActiveNo(activeNo);
        List list = this.activeRuleMapper.getList(activeRule);
        if (list != null && list.size() >= 1) {
            return list.stream().sorted(Comparator.comparing(ActiveRuleEntity::getInviteQuantityMin)).findFirst().get();
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getRuleList")
    public List<ActiveRuleEntity> getRuleList(@ParameterValueKeyProvider String activeNo) {
        ActiveRuleEntity activeRule = new ActiveRuleEntity();
        activeRule.setActiveNo(activeNo);
        return this.activeRuleMapper.getList(activeRule);
    }

    @Override
    public List<ActiveRuleEntity> getRuleList(String activeNo, String proId) {
        ActiveRuleEntity activeRule = new ActiveRuleEntity();
        activeRule.setActiveNo(activeNo);
        activeRule.setProId(proId);
        return this.activeRuleMapper.getList(activeRule);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveRuleService.getTargetNum", expiration=300)
    public Integer getTargetNum(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer count) {
        Integer targeNum = 0;
        ActiveRuleEntity activeRuleEntity = this.getRuleByQuantity(activeNo, count);
        if (activeRuleEntity != null) {
            targeNum = activeRuleEntity.getInviteQuantityMax();
        } else {
            activeRuleEntity = this.getRuleByQuantity(activeNo);
            if (activeRuleEntity != null) {
                targeNum = activeRuleEntity.getInviteQuantityMin();
            } else {
                throw new RuntimeException("\u9636\u68af\u5151\u5956\u4eba\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u6d3b\u52a8\u53f7:" + activeNo + ",\u9080\u8bf7\u4eba\u6570=" + count);
            }
        }
        return targeNum;
    }

    private void removeCache(ActiveRuleEntity activeRuleEntity) {
        if (activeRuleEntity != null) {
            this.memcachedService.delete("ActiveRuleService.getRuleList", activeRuleEntity.getActiveNo());
            this.memcachedService.delete("ActiveRuleService.getRuleByQuantity", activeRuleEntity.getActiveNo());
        }
    }

    @Override
    @Transactional
    public BaseJsonVo copyActiveRule(ActiveEntity sourceAct, String objActiveNo) {
        ActiveRuleEntity ruleEntity = new ActiveRuleEntity();
        ruleEntity.setActiveNo(sourceAct.getActiveNo());
        List lst = this.activeRuleMapper.getList(ruleEntity);
        for (ActiveRuleEntity p : lst) {
            String sourceBindCode = p.getBindCode();
            p.setActiveNo(objActiveNo);
            p.setActiveRuleId(null);
            p.setBindCode(IDGenerate.getUniqueIdStr());
            this.activeRuleMapper.insertSelective(p);
            this.activeCashticketInterface.copyActiveQrCodeCoupon(sourceBindCode, p.getBindCode());
        }
        return BaseJsonVo.success((Object)"");
    }
}

