/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCheckinMapper;
import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveQueryVo;
import cc.lechun.active.entity.active.ActiveVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.sales.MallPromotionMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveService
extends BaseService
implements ActiveInterface {
    @Autowired
    private ActiveMapper activeMapper;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeInterface;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActivePageInterface activePageInterface;
    @Autowired
    private ActiveCheckinMapper checkinMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    protected ActivePropertyInterface activePropertyInterface;
    @Autowired
    protected ActiveRuleInterface activeRuleInterface;
    @Autowired
    private ActiveIndexInterface activeIndexInterface;
    @Autowired
    MallPromotionMapper promotionMapper;

    @Override
    public List<ActiveEntity> getEnableActiveList(Integer activeType) {
        return this.activeMapper.getEnableActiveList(activeType);
    }

    @Override
    public BaseJsonVo setOnline(ActiveEntity activeEntity) {
        ActiveEntity updateActive = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeEntity.getActiveNo()));
        this.removeCache(updateActive);
        this.activeMapper.updateByPrimaryKeySelective(activeEntity);
        if (updateActive.getActiveType() == 28 && activeEntity.getStatus() == 1) {
            ActiveIndexEntity activeIndexEntity = new ActiveIndexEntity();
            activeIndexEntity.setActiveIndexDesc(updateActive.getActiveName());
            activeIndexEntity.setActiveNo(updateActive.getActiveNo());
            ActivePageEntity activePageEntity = this.activePageInterface.getActivePageEntityByActiveNo(activeEntity.getActiveNo());
            if (activePageEntity != null) {
                activeIndexEntity.setActiveUrl(activePageEntity.getActiveUrl());
            }
            activeIndexEntity.setCreateTime(new Date());
            activeIndexEntity.setSort(1);
            this.activeIndexInterface.saveActiveIndex(activeIndexEntity);
        }
        return BaseJsonVo.success((Object)"\u5df2\u4e0a\u7ebf!");
    }

    @Override
    @Transactional
    public BaseJsonVo saveActive(ActiveEntity active, List<ActivePropertyEntity> activePropertyyList) {
        BaseJsonVo result = this.checkSaveActive(active);
        if (result.isSuccess()) {
            this.removeCache(active);
            if (StringUtils.isEmpty((String)active.getActiveNo())) {
                boolean temp;
                active.setActiveNo(IDGenerate.getUniqueIdStr());
                active.setCreateTime(DateUtils.now());
                if (active.getKeywordId() == null) {
                    active.setKeywordId(0);
                }
                if (active.getPayKeywordId() == null) {
                    active.setPayKeywordId(0);
                }
                if (active.getPayamount() == null) {
                    active.setPayamount(new BigDecimal(0));
                }
                if (StringUtils.isEmpty((String)active.getVipRightType())) {
                    active.setVipRightType("0");
                }
                if (StringUtils.isEmpty((String)active.getBindCode())) {
                    active.setBindCode(String.valueOf(RandomUtils.generateId()));
                }
                active.setPlatformGroupId(this.platFormService.getPlatFormGroupId(active.getPlatformId()));
                boolean bl = temp = this.activeMapper.insert(active) >= 1;
                if (!temp) {
                    result.setError_msg("\u6d3b\u52a8\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    return result;
                }
                result.setValue((Object)active);
                this.activePageInterface.saveActivePage(active);
                if (CollectionUtils.isNotEmpty(activePropertyyList)) {
                    for (ActivePropertyEntity activePropertyEntity : activePropertyyList) {
                        activePropertyEntity.setBindCode(active.getBindCode());
                    }
                    this.activePropertyInterface.batchInsertIgnore(activePropertyyList);
                }
            } else {
                this.activePageInterface.saveActivePage(active);
                active.setCreateUserid(active.getCreateUserid());
                if (CollectionUtils.isNotEmpty(activePropertyyList)) {
                    for (ActivePropertyEntity activePropertyEntity : activePropertyyList) {
                        activePropertyEntity.setBindCode(active.getBindCode());
                    }
                    this.activePropertyInterface.batchInsertIgnore(activePropertyyList);
                }
                return this.activeMapper.updateByPrimaryKeySelective(active) >= 1 ? BaseJsonVo.success((Object)active) : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return result;
    }

    private BaseJsonVo checkSaveActive(ActiveEntity active) {
        if (StringUtils.isEmpty((String)active.getActiveName())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u4e3a\u7a7a");
        }
        if (active.getBeginTime() == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (active.getEndTime() == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (active.getEndTime().before(active.getBeginTime())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        ActiveEntity tempActiveNo = new ActiveEntity();
        tempActiveNo.setActiveNo(active.getActiveNo());
        tempActiveNo.setActiveName(active.getActiveName());
        if (StringUtils.isEmpty((String)active.getActiveNo())) {
            if (this.activeMapper.existsActiveName(tempActiveNo) >= 1) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u5df2\u5b58\u5728");
            }
            if (active.getActiveType() == -1) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
            }
            if (active.getPlatformId() <= 0) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5e73\u53f0");
            }
        } else if (this.activeMapper.existsActiveNameByActiveNo(tempActiveNo) >= 1) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u5df2\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkActiveEnable(String activeNo) {
        ActiveEntity ActiveEntity2 = this.getActiveEntity(activeNo);
        return this.checkActiveEnable(ActiveEntity2);
    }

    @Override
    public BaseJsonVo checkActiveEnable(ActiveEntity activeEntity) {
        if (activeEntity == null) {
            this.logger.error("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return BaseJsonVo.error((String)"\u672a\u77e5\u6d3b\u52a8");
        }
        if (activeEntity.getBeginTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u672a\u5f00\u59cb."));
        }
        if (activeEntity.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u5df2\u7ed3\u675f."));
        }
        if (activeEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u672a\u542f\u7528"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public String getActiveNoByBindCode(String bindCode) {
        if (StringUtils.isNotEmpty((String)bindCode)) {
            ActiveEntity activeEntity = this.getActiveEntityByQrcode(bindCode);
            if (activeEntity == null) {
                this.logger.error("\u65e0\u5339\u914d\u8bb0\u5f55,bindcode={}", (Object)bindCode);
                return "";
            }
            return activeEntity.getActiveNo();
        }
        this.logger.info("\u53c2\u6570,bindcode\u4e3a\u7a7a");
        return "";
    }

    @Override
    public ActiveEntity getActiveEntityByQrcode(String bindCode) {
        if (StringUtils.isEmpty((String)bindCode)) {
            this.logger.info("\u67e5\u8be2bindcode\u4e3a\u7a7a");
            return null;
        }
        this.logger.info("bindCode={}", (Object)bindCode);
        if (bindCode.length() >= 32) {
            ActiveQrcodeEntity qrcode = this.activeQrcodeInterface.getActiveQrcode(bindCode);
            if (qrcode != null) {
                return (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)qrcode.getActiveNo()));
            }
            return null;
        }
        ActiveEntity activeEntity = new ActiveEntity();
        activeEntity.setBindCode(bindCode);
        return (ActiveEntity)this.activeMapper.getSingle(activeEntity);
    }

    @Override
    public String getActivePageUrl(String bindCode) {
        ActiveEntity activeEntity = this.getActiveEntityByQrcode(bindCode);
        BaseJsonVo<ActivePageEntity> baseJsonVo = this.activePageInterface.getActivePageEntity(activeEntity.getActiveNo());
        return baseJsonVo.isSuccess() ? ((ActivePageEntity)baseJsonVo.getValue()).getActiveUrl() : "";
    }

    @Override
    public ActiveVo getActiveEntityByActiveNo(String activeNo) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        if (activeEntity != null) {
            ActiveVo activeVo = new ActiveVo();
            ActivePropertyEntity query = new ActivePropertyEntity();
            query.setBindCode(activeEntity.getBindCode());
            List list = this.activePropertyInterface.getList(query, 0L);
            BeanUtils.copyProperties((Object)activeEntity, (Object)activeVo);
            activeVo.setPropertyList(list);
            return activeVo;
        }
        return null;
    }

    @Override
    public ActiveEntity getActiveEntity(String activeNo) {
        return (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
    }

    @Override
    public boolean deleteActive(String activeNo) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        this.removeCache(activeEntity);
        return this.activeMapper.deleteByPrimaryKey((Serializable)((Object)activeNo)) >= 1;
    }

    @Override
    public List<ActiveEntity> getEnableActiveForOption() {
        return this.getActiveForOptionByStatus(1, 1000);
    }

    @Override
    public List<ActiveEntity> getActiveForOptionByStatus(Integer status, Integer platformGroupId) {
        return this.activeMapper.getActiveForOptionByStatus(status, platformGroupId);
    }

    @Override
    public List<ActiveEntity> getActiveForOption(Integer platformGroupId) {
        return this.activeMapper.getActiveForOption(platformGroupId);
    }

    @Override
    public PageInfo getActiveList(ActiveQueryVo activeQueryVo) {
        ActiveQrcodeEntity activeQrcode;
        if (StringUtils.isEmpty((String)activeQueryVo.getActiveNo()) && StringUtils.isNotEmpty((String)activeQueryVo.getBindCode()) && (activeQrcode = this.activeQrcodeInterface.getQrcode(activeQueryVo.getBindCode())) != null) {
            activeQueryVo.setActiveNo(activeQrcode.getActiveNo());
            activeQrcode.setBindCode(null);
        }
        Page page = PageHelper.startPage((int)activeQueryVo.getCurrentPage(), (int)activeQueryVo.getPageSize()).setOrderBy(" CREATE_TIME DESC ");
        List<ActiveEntity> list = this.activeMapper.getActiveList(activeQueryVo);
        PageInfo pg = page.toPageInfo();
        ArrayList result = new ArrayList();
        list.forEach(a -> {
            ActiveVo activeEntityVo = new ActiveVo();
            BeanUtils.copyProperties((Object)a, (Object)activeEntityVo);
            List<MallPromotionEntity> promotionList = this.promotionMapper.getActivePromotionListByActive(a.getActiveNo());
            if (CollectionUtils.isNotEmpty(promotionList)) {
                activeEntityVo.setPromotionId(promotionList.size() == 1 ? promotionList.get(0).getPromotionId() : promotionList.stream().map(MallPromotionEntity::getPromotionId).collect(Collectors.joining(",")));
                activeEntityVo.setPromotionName(promotionList.size() == 1 ? promotionList.get(0).getPromotionName() : promotionList.stream().map(MallPromotionEntity::getPromotionName).collect(Collectors.joining(",")));
            }
            activeEntityVo.setUrl("");
            result.add(activeEntityVo);
        });
        pg.setList(result);
        return pg;
    }

    @Override
    public boolean updateActive(ActiveEntity update) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)update.getActiveNo()));
        this.removeCache(activeEntity);
        return this.activeMapper.updateByPrimaryKeySelective(update) >= 1;
    }

    @Override
    public List<MallSelectDataVo> getOptionActiveList(Integer platformGroupId) {
        return this.activeMapper.getOptionActiveList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionActiveList(Integer platformGroupId, Integer[] activeTypes) {
        return this.activeMapper.getOptionActiveListByActiveTypes(platformGroupId, activeTypes);
    }

    @Override
    public List<ActiveEntity> getActiveList4ActiveType(int platformGroupId, int activeType) {
        ActiveEntity activeEntity = new ActiveEntity();
        activeEntity.setPlatformGroupId(platformGroupId);
        activeEntity.setActiveType(activeType);
        return this.activeMapper.getList(activeEntity);
    }

    @Override
    public void checkinRemind() {
        List<Map<String, Object>> openIds = this.checkinMapper.findRemindUsers();
        ExecutorService pool = Executors.newCachedThreadPool();
        openIds.forEach(openId -> pool.execute(new Runnable((Map)openId){
            final /* synthetic */ Map val$openId;
            {
                this.val$openId = map;
            }

            @Override
            public void run() {
                if (((Integer)this.val$openId.get("MAX_COUNT")).compareTo((Integer)this.val$openId.get("SN")) > 0 && (this.val$openId.get("REMIND") == null || (Integer)this.val$openId.get("REMIND") != 0)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("text", (String)this.val$openId.get("REMIND_TEXT"));
                    BaseJsonVo result = ActiveService.this.messageService.sendWechatMessage("CHECKIN_TEXT_MESSAGE_NEW", (String)this.val$openId.get("CUSTOMER_ID"), param);
                    ActiveService.this.logger.info("\u65e0\u7cd6\u6253\u5361\u63d0\u9192\u7ed3\u679c[" + this.val$openId.get("CUSTOMER_ID") + "] : " + JsonUtils.toJson((Object)result, (boolean)true));
                }
            }
        }));
    }

    private void removeCache(ActiveEntity activeEntity) {
        if (activeEntity != null) {
            if (activeEntity.getKeywordId() != null && activeEntity.getKeywordId() > 0) {
                this.memcachedService.delete("ActiveService.getActiveCouponByKeyWordId", String.valueOf(activeEntity.getKeywordId()));
            }
            if (StringUtils.isNotEmpty((String)activeEntity.getActiveNo())) {
                this.memcachedService.delete("ActiveService.getActiveEntityByActiveNo", activeEntity.getActiveNo());
                this.memcachedService.delete("ActiveService.checkActiveEnable", activeEntity.getActiveNo());
                List<ActiveQrcodeEntity> list = this.activeQrcodeInterface.getQrcodeListByActiveNo(activeEntity.getActiveNo());
                if (list != null) {
                    list.forEach(q -> this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", q.getBindCode()));
                }
            }
            this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveService.getActiveNoByBindCode", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveQrcodeService.getQrcodeList", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveService.getActiveForOption", activeEntity.getPlatformGroupId() + "");
        }
    }

    @Override
    public List<ActiveEntity> getList(ActiveQueryVo queryVo) {
        return this.activeMapper.getActiveList(queryVo);
    }

    @Override
    public BaseJsonVo saveActiveCheckInConfig(String activeNo, String remindText, Integer maxCount) {
        this.activeMapper.updateCheckIn(activeNo, remindText, maxCount);
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getActiveCheckInConfig(String activeNo) {
        List<Map<String, Object>> list = this.activeMapper.getActiveCheckInConfig(activeNo);
        return BaseJsonVo.success(list);
    }

    @Override
    public List<ActiveEntity> getActiveForOptionListByType(Integer activeType) {
        ActiveEntity param = new ActiveEntity();
        param.setActiveType(activeType);
        List list = this.activeMapper.getList(param);
        return list;
    }

    @Override
    public BaseJsonVo autoGeneratePeriodActive() {
        ActiveEntity search = new ActiveEntity();
        search.setIsPeriod(1);
        search.setStatus(1);
        List activeEntities = this.activeMapper.getList(search);
        for (ActiveEntity act : activeEntities) {
            if (!DateUtils.getDateFromString((String)DateUtils.formatDate((Date)act.getEndTime(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd").equals(DateUtils.currentDate())) continue;
            BaseJsonVo js = ((ActiveService)SpringContextUtil.getBean(this.getClass())).copyActive(act.getActiveNo(), 0);
            this.logger.info("\u6d3b\u52a8{},\u590d\u5236\uff1a{},\u539f\u56e0:{}", new Object[]{act.getActiveNo(), js.isSuccess(), js.getMessage()});
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo copyActive(String activeNo, Integer isCopy) {
        ActiveEntity act = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        String activeName = "";
        String oldActiveName = "";
        if (act != null) {
            if (Integer.valueOf(0).equals(isCopy) && Integer.valueOf(2).equals(act.getIsPeriod())) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u751f\u6210\uff0c\u4e0d\u518d\u91cd\u590d\u751f\u6210");
            }
            activeName = act.getActiveName();
            this.removeCache(act);
            ActiveEntity update = new ActiveEntity();
            update.setIsPeriod(2);
            String date = "";
            if (Integer.valueOf(1).equals(isCopy)) {
                date = "(" + DateUtils.formatDate((Date)new Date(), (String)"MM.dd") + ")";
                activeName = act.getActiveName() + date;
                oldActiveName = act.getActiveName();
            } else {
                date = "(" + DateUtils.formatDate((Date)act.getBeginTime(), (String)"MM.dd") + "~" + DateUtils.formatDate((Date)act.getEndTime(), (String)"MM.dd") + ")";
                activeName = act.getActiveName();
                oldActiveName = act.getActiveName() + date;
            }
            update.setActiveName(oldActiveName);
            update.setActiveNo(act.getActiveNo());
            this.activeMapper.updateByPrimaryKeySelective(update);
            BeanUtils.copyProperties((Object)act, (Object)update);
            update.setActiveNo(IDGenerate.getUniqueIdStr());
            update.setBindCode(IDGenerate.getUniqueIdStr());
            update.setActiveName(activeName);
            update.setCreateTime(new Date());
            if (Integer.valueOf(0).equals(isCopy)) {
                update.setBeginTime(act.getEndTime());
                update.setEndTime(DateUtils.getAddDateByDay((Date)act.getEndTime(), (int)((int)DateUtils.getDateDiff((Date)act.getBeginTime(), (Date)act.getEndTime()))));
            }
            update.setRemark("Auto Generate,\u7531\u6d3b\u52a8NO." + activeNo + "\u751f\u6210");
            this.activeMapper.insertSelective(update);
            this.activePropertyInterface.copyActiveProperty(act, update.getBindCode());
            BaseJsonVo jsonPageVo = this.activePageInterface.copyActivePage(act, update.getActiveNo(), update.getBindCode());
            this.activeCashticketInterface.copyActiveCoupon(act, update.getBindCode());
            this.activeQrcodeInterface.copyActiveQrCode(act, update.getActiveNo());
            this.activeRuleInterface.copyActiveRule(act, update.getActiveNo());
            this.picInterface.copyProductPic(act.getActiveNo(), update.getActiveNo());
            ((ActiveService)SpringContextUtil.getBean(this.getClass())).copyActiveCheckInConfig(act.getActiveNo(), update.getActiveNo());
            if (update.getActiveType() == 28) {
                ActiveIndexEntity activeIndexEntity = new ActiveIndexEntity();
                activeIndexEntity.setActiveIndexDesc(update.getActiveName());
                activeIndexEntity.setActiveNo(update.getActiveNo());
                activeIndexEntity.setActiveUrl(jsonPageVo.isSuccess() ? jsonPageVo.getValue().toString() : "");
                activeIndexEntity.setCreateTime(new Date());
                activeIndexEntity.setSort(1);
                this.activeIndexInterface.saveActiveIndex(activeIndexEntity);
            }
        } else {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((String)("\u6210\u529f\u590d\u5236\uff0c\u65b0\u6d3b\u52a8\u540d\uff1a" + activeName), (Object)("\u8001\u6d3b\u52a8\u540d\uff1a" + oldActiveName));
    }

    @Override
    public BaseJsonVo copyActiveCheckInConfig(String sourceNo, String objNo) {
        this.activeMapper.copyActiveCheckInConfig(sourceNo, objNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendCaisiCardAndSms() {
        String smsTextModule = "- \u8521\u53f8 \u4eb2\u7231\u7684xxx\uff0c\u611f\u8c22\u60a8\u4e00\u76f4\u4ee5\u6765\u5bf9\u8521\u53f8\u7684\u652f\u6301\u3002\u6211\u4eec\u5c06\u4e3a\u60a8\u9001\u51fa\u300c\u8521\u53f8\u5458\u5de5\u5bb6\u5c5e\u7b54\u8c22\u793c-\u4e50\u7eaf\u5976\u5361\u300d\u3002\u8bf7\u51ed\u5361\u5bc6\u5373\u53ef\u5151\u6362\uff0c\u540c\u65f6\u4e13\u5c5e\u5de5\u4f5c\u4eba\u5458\u4f1a\u6dfb\u52a0\u60a8\u7684\u5fae\u4fe1\u8ddf\u8fdb\u540e\u7eed\u4f7f\u7528\uff0c\u8c22\u8c22\u4f60\u3002\u5151\u6362\u5361\u5bc6\uff1aPWD\uff1b\u5151\u6362\u94fe\u63a5\uff1ahttp://t.lechun.cc/5C5pss0\uff08\u4ee5\u4e0a\u4fe1\u606f\u5f88\u91cd\u8981\uff0c\u8bf7\u59a5\u5584\u7559\u5b58\uff09\uff0c\u70b9\u51fb\u94fe\u63a5\u4e4b\u540e\u8fdb\u5165\u201c\u5361\u5238\u5151\u6362\u201d\u8f93\u5165\u5361\u5bc6\u5373\u53ef\u3002\uff08\u6ce8\uff1a\u672c\u5238\u7801\u6709\u6548\u671f\u4e00\u5e74\uff09";
        List<Map<String, String>> list = this.activeMapper.getCaisiList();
        list.forEach(map -> {
            String smsText = smsTextModule.replaceAll("xxx", (String)map.get("name")).replaceAll("PWD", (String)map.get("pwd"));
            SmsUtil.sendSms((String)((String)map.get("mobile")), (String)smsText, (String)RandomUtils.generateStrId());
        });
        return BaseJsonVo.success((String)"\u53d1\u5b8c\u4e86", null);
    }
}

