/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.groupon;

import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.dao.groupon.GrouponConfigMapper;
import cc.lechun.active.dao.groupon.GrouponDetailMapper;
import cc.lechun.active.dao.groupon.GrouponMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.groupon.GroupStatusEnum;
import cc.lechun.active.entity.groupon.GroupTypeEnum;
import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.entity.groupon.GrouponDetailEntity;
import cc.lechun.active.entity.groupon.GrouponDetailExportVo;
import cc.lechun.active.entity.groupon.GrouponDetailVo;
import cc.lechun.active.entity.groupon.GrouponEntity;
import cc.lechun.active.entity.groupon.GrouponQueryVo;
import cc.lechun.active.entity.groupon.GrouponRefundOrderVo;
import cc.lechun.active.entity.groupon.GrouponVo;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorLinkVo;
import cc.lechun.mall.entity.distribution.DistributorVo;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductVo;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.service.user.SysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class GrouponService
extends BaseService
implements GrouponInterface {
    @Autowired
    private GrouponMapper grouponMapper;
    @Autowired
    private GrouponDetailMapper grouponDetailMapper;
    @Autowired
    private GrouponConfigMapper configMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Resource
    private ActiveMapper activeMapper;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private MallMessageConfigInterface messageConfigInterface;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    MallOrderGroupProductInterface orderGroupProductInterface;
    @Lazy
    @Autowired
    private MallTradeInterface tradeInterface;

    @Override
    public GrouponEntity getGrouponEntity(String inviteId) {
        return (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
    }

    @Override
    public PageInfo<DistributorLinkVo> getLink(String inviteId) {
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        String link = "active/pages/community_group/index.html?bindCode=" + grouponEntity.getBindCode() + "&inviteId=" + grouponEntity.getInviteId();
        DistributorEntity distributorEntity = new DistributorEntity();
        distributorEntity.setStatus(1);
        distributorEntity.setGroupId(5);
        PageInfo<DistributorVo> pageInfo = this.distributorInterface.getDistributorPageList(1, 150, distributorEntity);
        List result = pageInfo.getList().stream().map(distributorVo -> {
            DistributorLinkVo groupDistributorVo = new DistributorLinkVo();
            BeanUtils.copyProperties((Object)distributorVo, (Object)groupDistributorVo);
            groupDistributorVo.setLink(link + "&ncp_bat=" + distributorVo.getDistributorRelationCode());
            return groupDistributorVo;
        }).collect(Collectors.toList());
        PageInfo pageInfo2 = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)pageInfo2);
        pageInfo2.setList(result);
        return pageInfo2;
    }

    @Override
    public BaseJsonVo creatGroup(GrouponEntity grouponEntity) {
        if (StringUtils.isEmpty((String)grouponEntity.getInviteId())) {
            grouponEntity.setOrderMainNo("");
            grouponEntity.setCreateTime(DateUtils.now());
            grouponEntity.setGroupOrderAmout(BigDecimal.ZERO);
            grouponEntity.setInviteId(RandomUtils.generateId());
            grouponEntity.setJoinNum(0);
            grouponEntity.setIsPrize(0);
            grouponEntity.setInviteCount(0);
            if (StringUtils.isNotEmpty((String)grouponEntity.getBindCode())) {
                ActiveEntity activeQuery = new ActiveEntity();
                activeQuery.setBindCode(grouponEntity.getBindCode());
                ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.getSingle(activeQuery);
                grouponEntity.setActiveNo(activeEntity.getActiveNo());
            }
            return this.grouponMapper.insertOrUpdate(grouponEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
        }
        GrouponEntity update = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponEntity.getInviteId()));
        update.setGroupName(grouponEntity.getGroupName());
        update.setCustomerId(grouponEntity.getCustomerId());
        update.setLimitOrderAmout(grouponEntity.getLimitOrderAmout());
        update.setLimitSuccAmout(grouponEntity.getLimitSuccAmout());
        update.setAddress(grouponEntity.getAddress());
        update.setIsPrize(grouponEntity.getIsPrize());
        return this.grouponMapper.updateByPrimaryKeySelective(update) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
    }

    @Override
    public PageInfo<GrouponVo> getGrouponQueryVoList(GrouponQueryVo grouponQueryVo) {
        GrouponEntity grouponEntity = new GrouponEntity();
        BeanUtils.copyProperties((Object)grouponQueryVo, (Object)grouponEntity);
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getBindCode())) {
            grouponEntity.setBindCode(grouponQueryVo.getBindCode());
        } else {
            grouponEntity.setBindCode(null);
        }
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getCustomerId())) {
            grouponEntity.setCustomerId(grouponQueryVo.getCustomerId());
        } else {
            grouponEntity.setCustomerId(null);
        }
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getGroupName())) {
            grouponEntity.setGroupName(SqlUtils.sqlLike((String)grouponQueryVo.getGroupName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            grouponEntity.setGroupName(null);
        }
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getOrderMainNo())) {
            grouponEntity.setOrderMainNo(grouponQueryVo.getOrderMainNo());
        } else {
            grouponEntity.setOrderMainNo(null);
        }
        Page page = PageHelper.startPage((int)grouponQueryVo.getCurrentPage(), (int)grouponQueryVo.getPageSize());
        page.setOrderBy(" CREATE_TIME desc ");
        if (grouponQueryVo.getIsPrize() != null && grouponQueryVo.getIsPrize() == 4) {
            grouponEntity.setIsPrize(1);
        }
        List list = this.grouponMapper.getList(grouponEntity);
        if (grouponQueryVo.getIsPrize() != null && grouponQueryVo.getIsPrize() == 4) {
            list = list.stream().filter(g -> g.getPrizeTime() == null).collect(Collectors.toList());
        } else if (grouponQueryVo.getIsPrize() != null && grouponQueryVo.getIsPrize() == 1) {
            list = list.stream().filter(g -> g.getPrizeTime() != null).collect(Collectors.toList());
        }
        List<Object> grouponVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            grouponVoList = list.stream().map(group -> {
                GrouponVo grouponVo = new GrouponVo();
                BeanUtils.copyProperties((Object)group, (Object)grouponVo);
                ActiveEntity activeQuery = new ActiveEntity();
                activeQuery.setActiveNo(group.getActiveNo());
                ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.getSingle(activeQuery);
                grouponVo.setActiveName(activeEntity == null ? "" : activeEntity.getActiveName());
                if (Objects.equals(GroupTypeEnum.community_group.getValue(), group.getGroupType())) {
                    MallUserEntity userEntity = this.sysUserService.getMallUser(group.getCustomerId());
                    grouponVo.setCreator(userEntity == null ? "" : userEntity.getUserNick());
                } else {
                    CustomerEntity customerDetailVo = this.customerService.getCustomer(group.getCustomerId());
                    if (customerDetailVo != null) {
                        grouponVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
                        grouponVo.setNickName(customerDetailVo.getNickName());
                    }
                }
                grouponVo.setLink("active/pages/community_group/index?bindCode=" + group.getBindCode() + "&inviteId=" + group.getInviteId());
                grouponVo.setGroupTypeName(GroupTypeEnum.getName(group.getGroupType()));
                GrouponDetailEntity grouponDetailQuery = new GrouponDetailEntity();
                grouponDetailQuery.setInviteId(group.getInviteId());
                List grouponDetailEntityList = this.grouponDetailMapper.getList(grouponDetailQuery);
                grouponVo.setGroupOrderAmout(BigDecimal.ZERO);
                if (CollectionUtils.isNotEmpty((Collection)grouponDetailEntityList)) {
                    BigDecimal sumRefund = BigDecimal.ZERO;
                    int refundNum = 0;
                    int joinNum = 0;
                    int successNum = 0;
                    for (GrouponDetailEntity detailEntity : grouponDetailEntityList) {
                        MallOrderMainEntity orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(detailEntity.getOrderMainNo());
                        if (orderMainEntity.getStatus() == 2) {
                            ++joinNum;
                        } else if (orderMainEntity.getStatus() >= 20) {
                            ++refundNum;
                        } else {
                            if (orderMainEntity.getStatus() < 3 || orderMainEntity.getStatus() >= 20) continue;
                            ++successNum;
                        }
                        this.logger.info("\u56e2:{}\u8ba2\u5355:{},\u91d1\u989d:{}", new Object[]{grouponVo.getInviteId(), orderMainEntity.getOrderMainNo(), orderMainEntity.getTotalAmount()});
                        grouponVo.setGroupOrderAmout(PriceUtils.add((BigDecimal)grouponVo.getGroupOrderAmout(), (BigDecimal)orderMainEntity.getTotalAmount()));
                        List<MallOrderGroupProductEntity> mallOrderGroupProductEntityList = this.orderGroupProductInterface.getOrderGroupProductListByOrderMainNo(detailEntity.getOrderMainNo());
                        List result = mallOrderGroupProductEntityList.stream().map(c -> c.getRefundAmount()).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(result)) {
                            sumRefund = result.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                            this.logger.info("\u56e2:{}\u8ba2\u5355:{},\u5546\u54c1\u9000\u6b3e\u91d1\u989d:{}", new Object[]{grouponVo.getInviteId(), orderMainEntity.getOrderMainNo(), sumRefund});
                        }
                        grouponVo.setRefundAmout(PriceUtils.add((BigDecimal)grouponVo.getRefundAmout(), (BigDecimal)sumRefund));
                    }
                    grouponVo.setFailCount(refundNum);
                    grouponVo.setSuccessCount(successNum);
                    grouponVo.setJoiningCount(joinNum);
                    grouponVo.setRefundAmout(grouponVo.getRefundAmout().setScale(2, 4));
                }
                grouponVo.setGroupOrderAmout(grouponVo.getGroupOrderAmout().subtract(grouponVo.getRefundAmout()).setScale(2, 4));
                return grouponVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(grouponVoList);
        return pg;
    }

    @Override
    public PageInfo<GrouponDetailVo> getGrouponDtailList(GrouponQueryVo grouponQueryVo) {
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        BeanUtils.copyProperties((Object)grouponQueryVo, (Object)grouponDetailEntity);
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getBindCode())) {
            grouponDetailEntity.setBindCode(grouponQueryVo.getBindCode());
        } else {
            grouponDetailEntity.setBindCode(null);
        }
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponQueryVo.getInviteId()));
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getOrderMainNo())) {
            grouponDetailEntity.setOrderMainNo(grouponQueryVo.getOrderMainNo());
        } else {
            grouponDetailEntity.setOrderMainNo(null);
        }
        Page page = PageHelper.startPage((int)grouponQueryVo.getCurrentPage(), (int)grouponQueryVo.getPageSize());
        page.setOrderBy(" CREATE_TIME desc ");
        List list = this.grouponDetailMapper.getList(grouponDetailEntity);
        List<Object> grouponVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            grouponVoList = list.stream().map(group -> {
                MallOrderMainEntity orderMainEntity;
                GrouponDetailVo grouponVo = new GrouponDetailVo();
                BeanUtils.copyProperties((Object)group, (Object)grouponVo);
                CustomerEntity customerDetailVo = this.customerService.getCustomer(group.getAcceptCustomerId());
                if (customerDetailVo != null) {
                    grouponVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
                    grouponVo.setNickName(customerDetailVo.getNickName());
                }
                if ((orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(group.getOrderMainNo())).getStatus() > 20 || group.getStatus() == 2) {
                    group.setStatus(2);
                    grouponVo.setStatus(2);
                }
                grouponVo.setTotalAmount(orderMainEntity.getTotalAmount());
                grouponVo.setStatusName(GroupStatusEnum.getName(grouponVo.getStatus()));
                return grouponVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(grouponVoList);
        return pg;
    }

    @Override
    public List<GrouponDetailExportVo> getGrouponDetailExportVoList(GrouponQueryVo grouponQueryVo) {
        List<GrouponDetailExportVo> result = new ArrayList<GrouponDetailExportVo>();
        GrouponDetailEntity grouponDetailEntity = new GrouponDetailEntity();
        BeanUtils.copyProperties((Object)grouponQueryVo, (Object)grouponDetailEntity);
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getBindCode())) {
            grouponDetailEntity.setBindCode(grouponQueryVo.getBindCode());
        } else {
            grouponDetailEntity.setBindCode(null);
        }
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)grouponQueryVo.getInviteId()));
        if (StringUtils.isNotEmpty((String)grouponQueryVo.getOrderMainNo())) {
            grouponDetailEntity.setOrderMainNo(grouponQueryVo.getOrderMainNo());
        } else {
            grouponDetailEntity.setOrderMainNo(null);
        }
        Page page = PageHelper.startPage((int)grouponQueryVo.getCurrentPage(), (int)grouponQueryVo.getPageSize());
        page.setOrderBy(" CREATE_TIME desc ");
        List list = this.grouponDetailMapper.getList(grouponDetailEntity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = list.stream().filter(grouponDetailVo -> Objects.equals(grouponDetailVo.getStatus(), GroupStatusEnum.starting.getValue()) || Objects.equals(grouponDetailVo.getStatus(), GroupStatusEnum.success.getValue())).map(group -> {
                MallOrderMainEntity orderMainEntity;
                GrouponDetailExportVo grouponVo = new GrouponDetailExportVo();
                BeanUtils.copyProperties((Object)group, (Object)grouponVo);
                grouponVo.setGroupName(grouponEntity.getGroupName());
                grouponVo.setGroupStatusName(GroupStatusEnum.getName(grouponEntity.getIsPrize()));
                if (grouponEntity.getIsPrize().intValue() == GroupStatusEnum.success.getValue() && grouponEntity.getPrizeTime() == null) {
                    grouponVo.setGroupStatusName("\u5df2\u622a\u5355");
                }
                grouponVo.setAddress(grouponEntity.getAddress());
                CustomerEntity customerDetailVo = this.customerService.getCustomer(group.getAcceptCustomerId());
                if (customerDetailVo != null) {
                    grouponVo.setNickName(customerDetailVo.getNickName());
                }
                if ((orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(group.getOrderMainNo())).getStatus() > 20 || group.getStatus() < 2) {
                    group.setStatus(2);
                }
                grouponVo.setOrderStatusName(OrderStatusEnum.getName(orderMainEntity.getStatus()));
                OrderListVo orderListVo = this.tradeInterface.getOrderDetail(group.getOrderMainNo());
                grouponVo.setConsigneeAddr(orderListVo.getConsigneeProvincename() + orderListVo.getConsigneeCityname() + orderListVo.getConsigneeAreaname() + orderListVo.getConsigneeAddr());
                grouponVo.setConsigneeName(orderListVo.getConsigneeName());
                grouponVo.setConsigneePhone(orderListVo.getConsigneePhone());
                StringBuilder stringBuilder = new StringBuilder();
                for (MallOrderProductVo orderProductVo : orderListVo.getOrderProductVos()) {
                    stringBuilder.append(orderProductVo.getItemName());
                    stringBuilder.append("[");
                    stringBuilder.append(orderProductVo.getQuantity());
                    stringBuilder.append("],");
                }
                grouponVo.setProductInfo(stringBuilder.toString());
                return grouponVo;
            }).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo setPrize(String inviteId) {
        GrouponEntity grouponEntity = (GrouponEntity)this.grouponMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        grouponEntity.setIsPrize(1);
        grouponEntity.setEndTime(DateUtils.now());
        grouponEntity.setPrizeTime(DateUtils.now());
        int k = this.grouponMapper.updateByPrimaryKeySelective(grouponEntity);
        if (k <= 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        this.logger.info("\u8bbe\u7f6e\u672c\u6b21\u56e2:{}\u6210\u56e2\u6210\u529f", (Object)inviteId);
        String key = inviteId + ":Success";
        this.redisCacheUtil.set(key, (Object)1, Long.valueOf(120L));
        GrouponDetailEntity detailQuery = new GrouponDetailEntity();
        detailQuery.setInviteId(inviteId);
        detailQuery.setStatus(0);
        List detailEntityList = this.grouponDetailMapper.getList(detailQuery);
        String orderStatusName = grouponEntity.getGroupType() == null || grouponEntity.getGroupType() == 1 ? OrderStatusEnum.PAYCONFIRM.getName() : (grouponEntity.getGroupType() == 2 ? OrderStatusEnum.PAYCONFIRM.getName() : OrderStatusEnum.COMPLETION.getName());
        detailEntityList.forEach(detail -> {
            this.logger.info("\u66f4\u65b0\u4e3b\u8ba2\u5355\u72b6\u6001:{},\u72b6\u6001\u4e3a:{},\u8001\u72b6\u6001\u4e3a:{}", new Object[]{detail.getOrderMainNo(), orderStatusName, detail.getStatus()});
            boolean result = this.mallOrderMainService.updateOrderMainStatus(detail.getOrderMainNo(), orderStatusName, OrderStatusEnum.UNCONFIRM.getValue());
            if (result) {
                this.logger.info("\u8ba2\u5355:{}\u72b6\u6001\u4fee\u6539\u6210\u529f", (Object)detail.getOrderMainNo());
                detail.setStatus(1);
                detail.setPrizeTime(DateUtils.now());
                this.grouponDetailMapper.updateByPrimaryKeySelective(detail);
                this.pushSuccMessage((GrouponDetailEntity)detail, detailEntityList.size());
            } else {
                this.logger.info("\u8ba2\u5355:{}\u8bbe\u7f6e\u6210\u56e2\u5931\u8d25", (Object)detail.getOrderMainNo());
            }
        });
        return BaseJsonVo.success((Object)"");
    }

    void pushSuccMessage(GrouponDetailEntity detail, int num) {
        try {
            String productName = this.getProductName(detail.getOrderMainNo());
            if (productName.length() > 19) {
                productName = productName.substring(0, 16) + "...";
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("num", String.valueOf(num));
            map.put("productName", productName);
            map.put("time", DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd"));
            map.put("CUSTOMER_ID", detail.getAcceptCustomerId());
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            list.add(map);
            boolean result = this.messageConfigInterface.pushNoticeMQ("joinGroupNotice", list, Math.abs(detail.getAcceptCustomerId().hashCode()));
            this.logger.info("\u7528\u6237:{}\u62fc\u56e2\u6210\u529f\u6d88\u606f\u63a8\u9001:{}", (Object)detail.getAcceptCustomerId(), (Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u62fc\u56e2\u6d88\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    public String getProductName(String orderNo) {
        Map<String, Object> proMap = this.grouponMapper.getGroupInfoByOrderNo(orderNo);
        return (String)proMap.getOrDefault("PRODUCT_NAME", "");
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponHourByBindCode")
    public Integer getGrouponHourByBindCode(@ParameterValueKeyProvider String bindCode) {
        return 2;
    }

    @Override
    @ReadThroughSingleCache(namespace="GrouponService.getGrouponConfig")
    public GrouponConfigEntity getGrouponConfig(@ParameterValueKeyProvider String activeNo) {
        GrouponConfigEntity grouponConfigEntity = new GrouponConfigEntity();
        grouponConfigEntity.setActiveNo(activeNo);
        return (GrouponConfigEntity)this.configMapper.getSingle(grouponConfigEntity);
    }

    @Override
    public Integer saveGrouponConfig(GrouponConfigEntity grouponConfigEntity) {
        this.removeCache(grouponConfigEntity);
        if (grouponConfigEntity.getId() == null) {
            return this.configMapper.insertSelective(grouponConfigEntity);
        }
        return this.configMapper.updateByPrimaryKeySelective(grouponConfigEntity);
    }

    private List<GrouponRefundOrderVo> starerRefund(Date date) {
        List<GrouponEntity> list = this.grouponMapper.getUnrefundStartOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getIsPrize() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setGrouponRoleType(1);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private List<GrouponRefundOrderVo> joinRefund(Date date) {
        List<GrouponDetailEntity> list = this.grouponDetailMapper.getUnrefundJoinOrder(date);
        if (list != null && list.size() >= 1) {
            return list.stream().filter(g -> g.getStatus() == 0).map(c -> {
                GrouponRefundOrderVo grouponRefundOrderVo = new GrouponRefundOrderVo();
                BeanUtils.copyProperties((Object)c, (Object)grouponRefundOrderVo);
                grouponRefundOrderVo.setCustomerId(c.getAcceptCustomerId());
                grouponRefundOrderVo.setGrouponRoleType(2);
                return grouponRefundOrderVo;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private void removeCache(GrouponConfigEntity grouponConfigEntity) {
        if (grouponConfigEntity != null) {
            this.memcachedService.delete("GrouponService.getGrouponConfig", grouponConfigEntity.getActiveNo());
        }
    }

    @Override
    public void initShanghaiTuangouAiCallSql() {
        this.grouponMapper.initShanghaiTuangouAiCallSql();
    }
}

