/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.invite;

import cc.lechun.active.dao.invite.ActiveInviteDetailMapper;
import cc.lechun.active.dao.invite.ActiveInviteMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailVo;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.invite.ActiveInviteQueryDo;
import cc.lechun.active.entity.invite.ActiveInviteResultVo;
import cc.lechun.active.entity.invite.ActiveJoinRecord;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.entity.tempCode.FundVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveInviteService
extends BaseService
implements ActiveInviteInterface {
    @Autowired
    private ActiveInviteMapper activeInviteMapper;
    @Autowired
    private ActiveInviteDetailMapper activeInviteDetailMapper;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    @Lazy
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    @Lazy
    private ActiveInviteInterface ActiveInviteService;
    @Autowired
    @Lazy
    private ActiveInterface activeService;

    @Override
    public List<ActiveInviteResultVo> getCustomerInvietList(String inviteId) {
        List<ActiveInviteDetailEntity> list = this.getInviteDetailList(inviteId);
        ArrayList<ActiveInviteResultVo> resultVoList = new ArrayList<ActiveInviteResultVo>();
        if (list != null && list.size() > 0) {
            list.forEach(i -> {
                ActiveInviteResultVo activeJoinRecord = new ActiveInviteResultVo();
                BeanUtils.copyProperties((Object)i, (Object)activeJoinRecord);
                if (StringUtils.isNotEmpty((String)i.getBindCode())) {
                    ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(i.getBindCode());
                    activeJoinRecord.setActiveName(activeEntity == null ? "" : activeEntity.getActiveName());
                    CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(i.getAcceptCustomerId(), activeEntity == null ? 1 : activeEntity.getPlatformId());
                    activeJoinRecord.setCustomerId(i.getAcceptCustomerId());
                    activeJoinRecord.setHeadImageUrl(customerDetailVo == null ? "" : customerDetailVo.getHeadImageUrl());
                    activeJoinRecord.setNickName(customerDetailVo == null ? "" : customerDetailVo.getNickName());
                    activeJoinRecord.setSourceCustomerId(i.getCustomerId());
                }
                resultVoList.add(activeJoinRecord);
            });
        }
        return resultVoList;
    }

    @Override
    public PageInfo<ActiveInviteEntity> getJoinRcordList(ActiveInviteQueryDo activeInviteQueryDo) {
        if (activeInviteQueryDo != null) {
            if (StringUtils.isNotEmpty((String)activeInviteQueryDo.getOpenId())) {
                CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(activeInviteQueryDo.getOpenId());
                if (customerDetailVo == null) {
                    throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
                }
                activeInviteQueryDo.setCustomerId(customerDetailVo.getCustomerId());
            }
            if (StringUtils.isEmpty((String)activeInviteQueryDo.getOpenId()) && StringUtils.isEmpty((String)activeInviteQueryDo.getCustomerId()) && activeInviteQueryDo.getStart() == null) {
                activeInviteQueryDo.setStart(DateUtils.currentDate());
            }
        }
        Page page = PageHelper.startPage((int)activeInviteQueryDo.getCurrentPage(), (int)activeInviteQueryDo.getPageSize());
        page.setOrderBy("INVITE_ID desc");
        this.activeInviteMapper.getJoinRecordList(activeInviteQueryDo);
        PageInfo pageInfo = page.toPageInfo();
        return pageInfo;
    }

    @Override
    public PageInfo<ActiveJoinRecord> getJoinOrderRcordList(ActiveInviteQueryDo activeInviteQueryDo) {
        return this.ActiveInviteService.getJoinOrderRcordList(activeInviteQueryDo);
    }

    @Override
    public BaseJsonVo updateRechangeStatus(String customerId, String orderMainNo) {
        Integer tiketId = this.activeInviteDetailMapper.getInviteUserTicketId(orderMainNo);
        if (tiketId != null && tiketId > 0) {
            if (this.activeInviteDetailMapper.updateRechangeStatus(orderMainNo, customerId, tiketId) > 0) {
                ActiveInviteDetailEntity temp = new ActiveInviteDetailEntity();
                temp.setTicketId(tiketId);
                temp.setAcceptCustomerId(customerId);
                temp.setIsnew(2);
                ActiveInviteDetailEntity activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(temp);
                if (activeInviteDetailEntity != null) {
                    return BaseJsonVo.success((Object)activeInviteDetailEntity);
                }
            } else {
                this.logger.info("\u975e\u7ea2\u5305\u6d3b\u52a8\u9080\u8bf7\u65b0\u7528\u6237\u4f18\u60e0\u5238\u4e0b\u5355\u7684\u8ba2\u5355:{}", (Object)orderMainNo);
            }
        }
        this.logger.info("\u975e\u62a2\u7ea2\u5305\u65b0\u7528\u6237\u7528\u5238\u4e0b\u7684\u8ba2\u5355:{}", (Object)orderMainNo);
        return BaseJsonVo.error((String)"");
    }

    @Override
    public List<ActiveInviteDetailEntity> getInviteDetailList(String inviteId) {
        ActiveInviteDetailEntity temp = new ActiveInviteDetailEntity();
        temp.setInviteId(inviteId);
        return this.activeInviteDetailMapper.getList(temp);
    }

    @Override
    public boolean updateInviteNum(String inviteId, Integer num) {
        return this.activeInviteMapper.updateInviteNum(inviteId) >= 1;
    }

    @Override
    public FundVo getFund(String customerId, String bindCode) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setBindCode(bindCode);
        activeInviteEntity.setCustomerId(customerId);
        FundVo fundVo = new FundVo();
        List list = this.activeInviteMapper.getList(activeInviteEntity);
        if (list == null || list.size() == 0) {
            return fundVo;
        }
        list.forEach(c -> {
            fundVo.setLockAmount(c.getUnavailableCount() + fundVo.getLockAmount());
            fundVo.setAmount(c.getBalanceCount() + fundVo.getAmount());
            fundVo.setTakedAmount(c.getUsedCount() + fundVo.getTakedAmount());
        });
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setInviteId(((ActiveInviteEntity)list.get(0)).getInviteId());
        activeInviteDetailEntity.setCustomerId(customerId);
        List detailEntityList = this.activeInviteDetailMapper.getList(activeInviteDetailEntity);
        if (detailEntityList == null || detailEntityList.size() == 0) {
            return fundVo;
        }
        List<String> tempUnfinishList = detailEntityList.stream().filter(d -> d.getFundsStatus() == 0 && d.getStatus() == 1).map(ActiveInviteDetailEntity::getAcceptCustomerId).collect(Collectors.toList());
        fundVo.setUnfinishedUserUrl(new ArrayList<String>());
        if (tempUnfinishList != null && tempUnfinishList.size() >= 1) {
            List<CustomerEntity> unfinishCustomerList = this.customerInterface.getCustomerByCustomerIds(tempUnfinishList);
            ArrayList unfinishList = unfinishCustomerList.stream().filter(d -> d.getStatus() == 1).map(CustomerEntity::getHeadImageUrl).collect(Collectors.toList());
            fundVo.setUnfinishedUserUrl(unfinishList == null ? new ArrayList() : unfinishList);
        }
        fundVo.setFinishedUserUrl(new ArrayList<String>());
        List<String> tempfinishList = detailEntityList.stream().filter(d -> d.getFundsStatus() == 1).map(ActiveInviteDetailEntity::getAcceptCustomerId).collect(Collectors.toList());
        fundVo.setFinishedUserUrl(new ArrayList<String>());
        if (tempfinishList != null && tempfinishList.size() >= 1) {
            List<CustomerEntity> unfinishCustomerList = this.customerInterface.getCustomerByCustomerIds(tempfinishList);
            ArrayList finishList = unfinishCustomerList.stream().filter(d -> d.getStatus() == 1).map(CustomerEntity::getHeadImageUrl).collect(Collectors.toList());
            fundVo.setFinishedUserUrl(finishList == null ? new ArrayList() : finishList);
        }
        return fundVo;
    }

    @Override
    public ActiveInviteDetailEntity getActiveInviteDetailEntity(ActiveInviteDetailEntity queryActiveInviteDetailEntity) {
        return (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryActiveInviteDetailEntity);
    }

    @Override
    public BaseJsonVo getActiveInviteDetailEntity(String thirdTradNo, String orderNo, Date date) {
        ArrayList<ActiveInviteDetailVo> list = new ArrayList<ActiveInviteDetailVo>();
        ActiveInviteDetailVo activeInviteDetailVo = new ActiveInviteDetailVo();
        if (StringUtils.isEmpty((String)orderNo) && StringUtils.isNotEmpty((String)thirdTradNo)) {
            MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByThirdTradeNo(thirdTradNo, date);
            if (orderPayEntity != null) {
                orderNo = orderPayEntity == null ? "" : orderPayEntity.getOrderMainNo();
                this.logger.info("\u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u7684\u8ba2\u5355\u4e3a:{}", (Object)orderNo);
            } else {
                return BaseJsonVo.error((String)"\u672a\u77e5\u4ea4\u6613\u6d41\u6c34\u53f7\uff0c\u8bf7\u786e\u8ba4\u6d41\u6c34\u53f7\u662f\u6b63\u786e");
            }
        }
        if (StringUtils.isNotEmpty((String)orderNo)) {
            ActiveInviteDetailEntity detailEntity = this.activeInviteDetailMapper.getInviteDetailByOrderNo(orderNo, date);
            if (detailEntity == null) {
                return BaseJsonVo.error((String)"\u9080\u8bf7\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u8ba2\u5355\u53f7\u3001\u6d41\u6c34\u53f7\u662f\u5426\u4e3a\u6d3b\u52a8\u8ba2\u5355");
            }
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(detailEntity.getBindCode());
            if (activeEntity != null) {
                activeInviteDetailVo.setActiveEntity(activeEntity);
            }
            if (detailEntity.getCustomerId().equals(detailEntity.getAcceptCustomerId())) {
                activeInviteDetailVo.setSource(new CustomerDetailVo());
            } else {
                CustomerDetailVo source = this.customerInterface.getCustomerDetail(detailEntity.getCustomerId(), 1);
                if (source != null) {
                    source.setCustomerId("http://erpnew.lechun.cc/mall_customer_edit.html?customerid=" + detailEntity.getCustomerId());
                    activeInviteDetailVo.setSource(source);
                }
            }
            activeInviteDetailVo.setActiveInviteDetailEntity(detailEntity);
            list.add(activeInviteDetailVo);
            return BaseJsonVo.success(list);
        }
        return BaseJsonVo.error((String)"\u6d41\u6c34\u53f7\u3001\u8ba2\u5355\u53f7\u5176\u4e2d\u4e00\u9879\u5fc5\u987b\u8f93\u5165");
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(String inviteId) {
        return (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(ActiveInviteEntity queryActiveInviteEntity) {
        return (ActiveInviteEntity)this.activeInviteMapper.getSingle(queryActiveInviteEntity);
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            throw new RuntimeException(baseJsonVo.getMessage());
        }
        return this.getActiveInviteEntity(customerId, bindCode, activeEntity);
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(String customerId, String bindCode, ActiveEntity activeEntity) {
        ActiveInviteEntity queryActiveInvite = new ActiveInviteEntity();
        queryActiveInvite.setBindCode(bindCode);
        queryActiveInvite.setCustomerId(customerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(queryActiveInvite);
        if (activeInviteEntity == null) {
            activeInviteEntity = new ActiveInviteEntity();
            activeInviteEntity.setActiveNo(activeEntity.getActiveNo());
            activeInviteEntity.setActiveType(activeEntity.getActiveType());
            activeInviteEntity.setUnavailableCount(0);
            activeInviteEntity.setInviteCount(0);
            activeInviteEntity.setUsedCount(0);
            activeInviteEntity.setBalanceCount(0);
            activeInviteEntity.setCreateTime(DateUtils.now());
            activeInviteEntity.setIsPrize(0);
            activeInviteEntity.setActiveQrcodeId(0);
            activeInviteEntity.setInviteId(IDGenerate.getUniqueIdStr());
            boolean temp = this.activeInviteMapper.insertSelective(activeInviteEntity) >= 1;
            return temp ? activeInviteEntity : null;
        }
        return activeInviteEntity;
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveInviteEntity activeInviteEntity) {
        boolean temp = false;
        if (StringUtils.isEmpty((String)activeInviteEntity.getInviteId())) {
            activeInviteEntity.setInviteId(IDGenerate.getUniqueIdStr());
            temp = this.activeInviteMapper.insertSelective(activeInviteEntity) >= 1;
        } else {
            boolean bl = temp = this.activeInviteMapper.updateByPrimaryKeySelective(activeInviteEntity) >= 1;
        }
        if (!temp) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveActiveInvite(MallOrderMainEntity orderMain, ActiveEntity activeEntity, String source) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setBindCode(orderMain.getBindCode());
        singleActiveInviteEntity.setCustomerId(orderMain.getCustomerId());
        ActiveInviteEntity queryActiveInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (queryActiveInviteEntity != null) {
            activeInviteEntity = queryActiveInviteEntity;
            this.logger.info("\u5b58\u5728\u9080\u8bf7\u4eba\u8bb0\u5f55...{}", (Object)activeInviteEntity.toString());
        } else {
            activeInviteEntity.setUnavailableCount(0);
            activeInviteEntity.setBalanceCount(0);
            activeInviteEntity.setInviteCount(0);
            activeInviteEntity.setActiveQrcodeId(0);
            activeInviteEntity.setActiveNo(orderMain.getActiveNo());
            activeInviteEntity.setActiveType(activeEntity.getActiveType());
            activeInviteEntity.setBindCode(orderMain.getBindCode());
            activeInviteEntity.setIsPrize(0);
            activeInviteEntity.setCreateTime(DateUtils.now());
            activeInviteEntity.setUsedCount(0);
            activeInviteEntity.setSubBindCode("");
            activeInviteEntity.setReleaseSystemId("");
            activeInviteEntity.setCustomerId(orderMain.getCustomerId());
        }
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setCustomerId(source == null ? "" : source);
        activeInviteDetailEntity.setBalance(0);
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setIsnew(0);
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setVersionDetailId(orderMain.getVersionDetailId() == null ? orderMain.getVersionDetailId() : "");
        this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u540e\uff0c\u4fdd\u5b58\u6d3b\u52a8\u9080\u8bf7\u8bb0\u5f55{},{}", (Object)activeInviteEntity.toString(), (Object)activeInviteDetailEntity.toString());
        return this.saveActiveInvite(activeInviteEntity, activeInviteDetailEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo saveActiveInvite(ActiveEntity activeEntity, String sourceCustomerId, String bindCode, CustomerDetailVo customerDetailVo, Integer platformId) {
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setActiveNo(activeEntity.getActiveNo());
        singleActiveInviteEntity.setCustomerId(sourceCustomerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (activeInviteEntity == null) {
            this.logger.info("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId={}", (Object)sourceCustomerId);
            throw new RuntimeException("\u672a\u77e5\u9080\u8bf7\u7528\u6237");
        }
        this.activeInviteMapper.updateActiveInviteNum(activeInviteEntity.getInviteId());
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setAcceptCustomerId(customerDetailVo.getCustomerId());
        activeInviteDetailEntity.setCustomerId(sourceCustomerId);
        activeInviteDetailEntity.setOrderMainNo("");
        activeInviteDetailEntity.setBalance(0);
        activeInviteDetailEntity.setInviteId(activeInviteEntity.getInviteId());
        activeInviteDetailEntity.setBindCode(activeInviteEntity.getBindCode());
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setStatus(1);
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setVersionDetailId("");
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setIsnew(1);
        activeInviteDetailEntity.setCreateTime(DateUtils.now());
        return this.saveActiveInviteDetail(activeInviteDetailEntity);
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveEntity activeEntity, String bindCode, String customerId, Integer platformId) {
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setActiveNo(activeEntity.getActiveNo());
        singleActiveInviteEntity.setCustomerId(customerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (activeInviteEntity == null) {
            this.logger.info("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId={}", (Object)customerId);
            return this.saveActiveInvite(activeEntity, bindCode, customerId);
        }
        return BaseJsonVo.success((Object)activeInviteEntity);
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveEntity activeEntity, String bindCode, String customerId) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setInviteId(IDGenerate.getUniqueIdStr());
        activeInviteEntity.setActiveNo(activeEntity.getActiveNo());
        activeInviteEntity.setVersionDetailId("");
        activeInviteEntity.setActiveType(activeEntity.getActiveType());
        activeInviteEntity.setReleaseSystemId("");
        activeInviteEntity.setCustomerId(customerId);
        activeInviteEntity.setActiveType(activeEntity.getActiveType());
        activeInviteEntity.setSubBindCode("");
        activeInviteEntity.setCreateTime(DateUtils.now());
        activeInviteEntity.setIsPrize(0);
        activeInviteEntity.setBindCode(bindCode);
        activeInviteEntity.setBalanceCount(0);
        activeInviteEntity.setInviteCount(activeEntity.getInviteNum() == null ? 0 : activeEntity.getInviteNum());
        activeInviteEntity.setUnavailableCount(0);
        activeInviteEntity.setActiveQrcodeId(0);
        activeInviteEntity.setUsedCount(0);
        return this.activeInviteMapper.insertSelective(activeInviteEntity) >= 1 ? BaseJsonVo.success((Object)activeInviteEntity) : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveInviteByInviteId(MallOrderMainEntity orderMain, ActiveEntity activeEntity, String inviteId) {
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (activeInviteEntity == null) {
            this.logger.error("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,InviteId={}", (Object)inviteId);
            throw new RuntimeException("\u9080\u8bf7\u8bb0\u5f55\u6709\u8bef");
        }
        Integer amount = 10;
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setInviteId(inviteId);
        activeInviteDetailEntity.setCreateTime(DateUtils.now());
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setCustomerId(activeInviteEntity.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setIsnew(0);
        activeInviteDetailEntity.setBalance(amount);
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setVersionDetailId(orderMain.getVersionDetailId() == null ? orderMain.getVersionDetailId() : "");
        this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u540e\uff0c\u4fdd\u5b58\u6d3b\u52a8\u9080\u8bf7\u8bb0\u5f55{},{}", (Object)activeInviteEntity.toString(), (Object)activeInviteDetailEntity.toString());
        return this.activeInviteDetailMapper.insertSelective(activeInviteDetailEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveInviteEntity activeInviteEntity, ActiveInviteDetailEntity activeInviteDetailEntity) {
        try {
            if (StringUtils.isEmpty((String)activeInviteDetailEntity.getCustomerId())) {
                if (StringUtils.isEmpty((String)activeInviteEntity.getInviteId())) {
                    boolean temp;
                    activeInviteEntity.setInviteId(RandomUtils.generateStrId());
                    activeInviteEntity.setPrizeTime(DateUtils.now());
                    activeInviteEntity.setVersionDetailId("");
                    this.logger.info("\u5f00\u59cb\u5199\u5165\u9080\u8bf7\u4eba\u8bb0\u5f55...{}", (Object)activeInviteEntity.toString());
                    boolean bl = temp = this.activeInviteMapper.insert(activeInviteEntity) >= 1;
                    if (temp) {
                        this.logger.info("\u9080\u8bf7\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeInviteEntity.toString());
                    } else {
                        this.logger.info("\u9080\u8bf7\u8bb0\u5f55\u5199\u5165\u5931\u8d25 :{}", (Object)activeInviteEntity.toString());
                    }
                }
                activeInviteDetailEntity.setCustomerId(activeInviteEntity.getCustomerId());
            } else {
                this.logger.info("\u901a\u8fc7\u9080\u8bf7\u4eba\u4e0b\u5355...{}", (Object)activeInviteDetailEntity.toString());
                ActiveInviteEntity queryInvite = new ActiveInviteEntity();
                queryInvite.setCustomerId(activeInviteDetailEntity.getCustomerId());
                queryInvite.setBindCode(activeInviteEntity.getBindCode());
                ActiveInviteEntity temp = this.getActiveInviteEntity(queryInvite);
                if (temp == null) {
                    this.logger.error("\u67e5\u8be2\u9080\u8bf7\u4ebaid\u65f6\u51fa\u9519");
                    throw new RuntimeException("\u9080\u8bf7\u51fa\u9519");
                }
                activeInviteDetailEntity.setInviteId(temp.getInviteId());
                if (StringUtils.isEmpty((String)activeInviteEntity.getInviteId())) {
                    activeInviteEntity.setInviteId(RandomUtils.generateStrId());
                    int k = this.activeInviteMapper.insertSelective(activeInviteEntity);
                    if (k <= 0) {
                        throw new RuntimeException("\u9080\u8bf7\u8bb0\u5f55\u5199\u5165\u5931\u8d25");
                    }
                }
            }
            if (StringUtils.isEmpty((String)activeInviteDetailEntity.getInviteId())) {
                activeInviteDetailEntity.setInviteId(activeInviteEntity.getInviteId());
            }
            activeInviteDetailEntity.setCreateTime(DateUtils.now());
            activeInviteDetailEntity.setStatus(0);
            this.logger.info("\u5f00\u59cb\u5199\u5165\u9080\u8bf7\u8bb0\u5f55\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
            int k = this.activeInviteDetailMapper.insert(activeInviteDetailEntity);
            if (k <= 0) {
                throw new RuntimeException("\u9080\u8bf7\u8bb0\u5f55\u660e\u7ec6\u5199\u5165\u5931\u8d25");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveActiveInviteDetail(ActiveInviteDetailEntity activeInviteDetailEntity) {
        boolean temp = false;
        temp = activeInviteDetailEntity.getInviteDetailId() == null ? this.activeInviteDetailMapper.insertSelective(activeInviteDetailEntity) >= 1 : this.activeInviteDetailMapper.updateByPrimaryKeySelective(activeInviteDetailEntity) >= 1;
        return temp ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveInviteDetail(String inviteId, String customerId, String sourceCustomerId, int orderNum, RedpackageConfigDetailVo redpackageConfigVo) {
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setInviteId(inviteId);
        activeInviteDetailEntity.setAcceptCustomerId(customerId);
        activeInviteDetailEntity.setBalance(redpackageConfigVo.getBalance());
        activeInviteDetailEntity.setBindCode(redpackageConfigVo.getBindCode());
        activeInviteDetailEntity.setFundsStatus(redpackageConfigVo.getAmount());
        activeInviteDetailEntity.setCreateTime(DateUtils.now());
        activeInviteDetailEntity.setCustomerId(sourceCustomerId);
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setIsnew(orderNum == 0 ? 1 : 0);
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setVersionDetailId("");
        return this.saveActiveInviteDetail(activeInviteDetailEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo addActiveInviteNum(ActiveInviteDetailEntity activeInviteDetailEntity) {
        int num = this.activeInviteDetailMapper.updateActiveInviteDetailInfo(activeInviteDetailEntity);
        if (num == 0) {
            this.logger.error("\u66f4\u65b0\u9080\u8bf7\u660e\u7ec6\u65f6\u51fa\u9519,{}", (Object)activeInviteDetailEntity.toString());
            return BaseJsonVo.error((String)"\u66f4\u65b0\u9080\u8bf7\u4eba\u8bb0\u5f55\u51fa\u9519");
        }
        ActiveInviteDetailEntity queryInviteDetail = new ActiveInviteDetailEntity();
        queryInviteDetail.setAcceptCustomerId(activeInviteDetailEntity.getAcceptCustomerId());
        queryInviteDetail.setBindCode(activeInviteDetailEntity.getBindCode());
        queryInviteDetail.setOrderMainNo(activeInviteDetailEntity.getOrderMainNo());
        activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryInviteDetail);
        if (activeInviteDetailEntity != null) {
            this.logger.info("\u53c2\u4e0e\u4eba\u4fe1\u606f:{}", (Object)activeInviteDetailEntity.toString());
            if (StringUtils.isNotEmpty((String)activeInviteDetailEntity.getAcceptCustomerId()) && StringUtils.isNotEmpty((String)activeInviteDetailEntity.getCustomerId())) {
                if (!activeInviteDetailEntity.getAcceptCustomerId().equals(activeInviteDetailEntity.getCustomerId())) {
                    ActiveInviteEntity updateActiveInvite = (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)activeInviteDetailEntity.getInviteId()));
                    if (updateActiveInvite != null) {
                        num = this.activeInviteMapper.updateActiveInviteNum(updateActiveInvite.getInviteId());
                        if (num == 0) {
                            this.logger.error("\u9080\u8bf7\u4eba \u9080\u8bf7\u8bb0\u5f55\u4eba\u6570\u589e\u52a01 \u51fa\u9519:{}", (Object)activeInviteDetailEntity.toString());
                            return BaseJsonVo.error((String)"\u589e\u52a0\u9080\u8bf7\u6570\u51fa\u9519.");
                        }
                        return BaseJsonVo.success((Object)updateActiveInvite);
                    }
                    this.logger.error("\u67e5\u8be2\u9080\u8bf7\u4eba\u4fe1\u606f\u51fa\u9519:{}", (Object)activeInviteDetailEntity.toString());
                    return BaseJsonVo.error((String)"\u9080\u8bf7\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728.");
                }
                this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u4e2a\u7528\u6237\u4e0d\u5904\u74061,{}", (Object)activeInviteDetailEntity.toString());
            } else {
                this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u4e2a\u7528\u6237\u4e0d\u5904\u74062,{}", (Object)activeInviteDetailEntity.toString());
            }
        }
        return BaseJsonVo.error((String)"\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u4e2a\u7528\u6237");
    }

    @Override
    public BaseJsonVo setPrize(String customerId, Integer count, Integer activeType) {
        int k = this.activeInviteMapper.setPrize(DateUtils.now(), count, activeType, customerId);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo setPrize(String customerId, String bindCode) {
        int k = this.activeInviteMapper.setPrizeByBindCode(DateUtils.now(), bindCode, customerId);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public boolean existActiveInviteDetailEntity(ActiveInviteDetailEntity activeInviteDetailEntity) {
        return this.activeInviteDetailMapper.existsByEntity(activeInviteDetailEntity) >= 1;
    }

    @Override
    public BaseJsonVo updateUnTakedFund(MallOrderMainEntity orderMain) {
        boolean flag;
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        ActiveInviteDetailEntity result = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(activeInviteDetailEntity);
        if (result == null) {
            this.logger.error("\u4e0d\u662f\u6709\u6548\u7684\u6d3b\u52a8\u8ba2\u5355. orderNo={}", (Object)orderMain.getOrderMainNo());
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8\u8ba2\u5355");
        }
        boolean bl = flag = result.getAcceptCustomerId() == null || result.getCustomerId() == null || result.getCustomerId().equals(result.getAcceptCustomerId());
        if (flag) {
            this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u7528\u6237\u4e0d\u8ba1\u6570:{}", (Object)result.toString());
            return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u9080\u8bf7\u6761\u4ef6");
        }
        ActiveInviteDetailEntity updateInviteDetail = new ActiveInviteDetailEntity();
        updateInviteDetail.setStatus(1);
        updateInviteDetail.setFundsStatus(0);
        updateInviteDetail.setBalance(orderMain.getPayAmount().intValue());
        updateInviteDetail.setInviteDetailId(result.getInviteDetailId());
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(updateInviteDetail);
        BaseJsonVo baseJsonVo = this.activeInviteMapper.updateUnTakedFund(orderMain.getPayAmount().intValue(), result.getInviteId()) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
        this.logger.info("\u9080\u8bf7\u57fa\u91d1\u589e\u52a0{},orderNo={}", (Object)baseJsonVo.isSuccess(), (Object)orderMain.getOrderMainNo());
        if (baseJsonVo.isSuccess()) {
            baseJsonVo.setValue((Object)result);
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo updateTakedFund(MallOrderMainEntity orderMain) {
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(1);
        activeInviteDetailEntity.setCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        ActiveInviteDetailEntity result = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(activeInviteDetailEntity);
        if (result == null) {
            this.logger.error("\u4e0d\u662f\u6709\u6548\u7684\u6d3b\u52a8\u8ba2\u5355. orderNo={}", (Object)orderMain.getOrderMainNo());
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8\u8ba2\u5355");
        }
        ActiveInviteDetailEntity updateInviteDetail = new ActiveInviteDetailEntity();
        updateInviteDetail.setFundsStatus(1);
        updateInviteDetail.setInviteDetailId(result.getInviteDetailId());
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(updateInviteDetail);
        BaseJsonVo baseJsonVo = this.activeInviteMapper.updateTakedFund(result.getBalance(), result.getInviteId()) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
        this.logger.info("\u53ef\u53d6\u57fa\u91d1\u589e\u52a0{},orderNo={}", (Object)baseJsonVo.isSuccess(), (Object)orderMain.getOrderMainNo());
        return baseJsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo updatePrizeFund(String customerId, String bindCode) {
        boolean temp;
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(customerId, bindCode);
        if (activeInviteEntity.getBalanceCount() < 0) {
            this.logger.info("\u67e5\u8be2\u5230\u65e0\u53ef\u53d6\u57fa\u91d1..customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
            return BaseJsonVo.error((String)"\u65e0\u53ef\u53d6\u57fa\u91d1");
        }
        boolean bl = temp = this.activeInviteMapper.updatePrizeFund(activeInviteEntity.getInviteId(), activeInviteEntity.getBalanceCount()) >= 1;
        if (!temp) {
            this.logger.info("\u57fa\u91d1\u5df2\u63d0\u8d77..customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
            return BaseJsonVo.error((String)"\u57fa\u91d1\u5df2\u63d0\u8d77,\u65e0\u53ef\u53d6\u57fa\u91d1");
        }
        boolean bl2 = temp = this.activeInviteDetailMapper.updateTakedFundStatus(activeInviteEntity.getInviteId()) >= 1;
        if (!temp) {
            this.logger.info("\u8bbe\u7f6e\u9080\u8bf7\u57fa\u91d1\u72b6\u6001\u4e3a\u5df2\u63d0\u8d77\u5931\u8d25..customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
            return BaseJsonVo.error((String)"\u57fa\u91d1\u5df2\u63d0\u8d77,\u65e0\u53ef\u53d6\u57fa\u91d1");
        }
        return BaseJsonVo.success((Object)activeInviteEntity.getBalanceCount());
    }

    @Override
    @Transactional
    public void updateInviteNum(ActiveInviteDetailEntity activeInviteDetailEntity, Integer amount) {
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)activeInviteDetailEntity.getInviteId()));
        ActiveInviteEntity updatActiveInviteEntity = new ActiveInviteEntity();
        updatActiveInviteEntity.setInviteId(activeInviteDetailEntity.getInviteId());
        updatActiveInviteEntity.setBalanceCount(activeInviteEntity.getBalanceCount() + amount);
        updatActiveInviteEntity.setUnavailableCount(activeInviteEntity.getUnavailableCount() - amount);
        this.activeInviteMapper.updateByPrimaryKeySelective(updatActiveInviteEntity);
        ActiveInviteDetailEntity updatActiveInviteDetailEntity = new ActiveInviteDetailEntity();
        updatActiveInviteDetailEntity.setInviteDetailId(activeInviteDetailEntity.getInviteDetailId());
        updatActiveInviteDetailEntity.setFundsStatus(1);
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(updatActiveInviteDetailEntity);
    }

    @Override
    public Integer getInviteNum(String customerId, Integer activeType) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setCustomerId(customerId);
        activeInviteEntity.setIsPrize(0);
        activeInviteEntity.setActiveType(activeType);
        List list = this.activeInviteMapper.getList(activeInviteEntity);
        int num = 0;
        if (list != null && list.size() >= 1) {
            for (ActiveInviteEntity ai : list) {
                if (ai.getInviteCount() == null) continue;
                num += ai.getInviteCount().intValue();
            }
        }
        return num;
    }

    @Override
    public Integer getInviteNum(String customerId, String bindCode) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setCustomerId(customerId);
        activeInviteEntity.setIsPrize(0);
        activeInviteEntity.setBindCode(bindCode);
        List list = this.activeInviteMapper.getList(activeInviteEntity);
        int num = 0;
        if (list != null && list.size() >= 1) {
            for (ActiveInviteEntity ai : list) {
                if (ai.getInviteCount() == null) continue;
                num += ai.getInviteCount().intValue();
            }
        }
        return num;
    }
}

