/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.luckydraw;

import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawPrizeMapper;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawPrizeEntity;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawPrizeInterface;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.util.StringUtil;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ActiveLuckyDrawPrizeService
extends BaseService<ActiveLuckyDrawPrizeEntity, String>
implements ActiveLuckyDrawPrizeInterface {
    @Resource
    private ActiveLuckyDrawPrizeMapper prizeMapper;
    @Autowired
    private ActiveLuckyDrawInterface drawInterface;

    @Override
    public List<ActiveLuckyDrawPrizeEntity> luckyDrawPrizeList(String luckyDrawId) {
        ActiveLuckyDrawPrizeEntity entity = new ActiveLuckyDrawPrizeEntity();
        entity.setLuckyDrawId(luckyDrawId);
        return this.prizeMapper.getList(entity);
    }

    @Override
    public BaseJsonVo getLuckyDrawPrize(String luckyDrawPrizeId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        ActiveLuckyDrawPrizeEntity prizeEntity = (ActiveLuckyDrawPrizeEntity)this.prizeMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawPrizeId));
        if (prizeEntity != null) {
            BaseJsonVo2.setValue((Object)prizeEntity);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo addLuckyDrawPrize(ActiveLuckyDrawPrizeEntity entity) {
        BaseJsonVo baseJsonVo = this.drawInterface.updatePrizeCheck(entity.getLuckyDrawId());
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        Integer result = 0;
        ActiveLuckyDrawPrizeEntity search = new ActiveLuckyDrawPrizeEntity();
        search.setLevel(entity.getLevel());
        search.setLuckyDrawId(entity.getLuckyDrawId());
        search = (ActiveLuckyDrawPrizeEntity)this.getSingle(search);
        if (Integer.valueOf(1).equals(entity.getPrizeType()) && StringUtils.isEmpty((String)entity.getPrizeData())) {
            return BaseJsonVo.error((String)"\u5956\u9879\u7c7b\u578b\u4e3a\u4f18\u60e0\u5238\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u5956\u9879\u4f18\u60e0\u5238");
        }
        if (StringUtils.isEmpty((String)entity.getId())) {
            if (search != null) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u5b58\u5728\u8be5\u7b49\u7ea7\u5956\u9879\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e");
            }
            entity.setId(RandomUtils.generateStrId());
            entity.setCreateTime(new Date());
            result = this.prizeMapper.insertSelective(entity);
        } else {
            if (search != null && !search.getId().equals(entity.getId())) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u5b58\u5728\u8be5\u7b49\u7ea7\u5956\u9879\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e");
            }
            result = this.prizeMapper.updateByPrimaryKeySelective(entity);
        }
        if (result == 1) {
            baseJsonVo.setValue((Object)entity);
        } else {
            baseJsonVo.setError("\u4fee\u6539\u5931\u8d25");
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo deleteLuckyDrawPrize(String luckyDrawPrizeId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        ActiveLuckyDrawPrizeEntity prizeEntity = (ActiveLuckyDrawPrizeEntity)this.prizeMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawPrizeId));
        if (prizeEntity == null) {
            BaseJsonVo2.setError("\u5220\u9664\u5931\u8d25");
            return BaseJsonVo2;
        }
        BaseJsonVo2 = this.drawInterface.updatePrizeCheck(prizeEntity.getLuckyDrawId());
        if (!BaseJsonVo2.isSuccess()) {
            return BaseJsonVo2;
        }
        Integer result = this.prizeMapper.deleteByPrimaryKey((Serializable)((Object)luckyDrawPrizeId));
        if (result != 1) {
            BaseJsonVo2.setError("\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo2;
    }

    @Override
    public String getPrizeLevelName(Integer level) {
        String name = "";
        if (level == null) {
            return name;
        }
        switch (level) {
            case 1: {
                name = "\u4e00\u7b49\u5956";
                break;
            }
            case 2: {
                name = "\u4e8c\u7b49\u5956";
                break;
            }
            case 3: {
                name = "\u4e09\u7b49\u5956";
                break;
            }
            case 4: {
                name = "\u56db\u7b49\u5956";
                break;
            }
            case 5: {
                name = "\u4e94\u7b49\u5956";
                break;
            }
            case 6: {
                name = "\u516d\u7b49\u5956";
            }
        }
        return name;
    }

    @Override
    @Transactional
    public BaseJsonVo setFixUser(String luckyDrawId, String customerId, Integer level, Integer status) {
        ActiveLuckyDrawPrizeEntity prizeEntity = new ActiveLuckyDrawPrizeEntity();
        prizeEntity.setLuckyDrawId(luckyDrawId);
        prizeEntity.setLevel(level);
        prizeEntity = (ActiveLuckyDrawPrizeEntity)this.prizeMapper.getSingle(prizeEntity);
        if (prizeEntity != null) {
            List<String> list = new ArrayList<String>();
            if (StringUtil.isNotEmpty((String)prizeEntity.getPrizeUser())) {
                list = Arrays.asList(prizeEntity.getPrizeUser().split(","));
            }
            if (status == 1) {
                list.add(customerId);
            } else {
                list.remove(customerId);
            }
            prizeEntity.setPrizeUser(Joiner.on((String)",").join(list));
            this.prizeMapper.updateByPrimaryKeySelective(prizeEntity);
            return BaseJsonVo.success((Object)"\u8bbe\u7f6e\u6210\u529f");
        }
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return BaseJsonVo.error((String)"\u5956\u9879\u4e0d\u5b58\u5728");
    }

    @Override
    @Transactional
    public BaseJsonVo buildNextPrize(String drawId, String nextDrawId) {
        ActiveLuckyDrawPrizeEntity search = new ActiveLuckyDrawPrizeEntity();
        search.setLuckyDrawId(drawId);
        List lst = this.getList(search);
        for (ActiveLuckyDrawPrizeEntity p : lst) {
            p.setId(null);
            p.setLuckyDrawId(nextDrawId);
            p.setCreateTime(new Date());
            p.setPrizeUser("");
            this.addLuckyDrawPrize(p);
        }
        return BaseJsonVo.success((Object)"");
    }
}

