/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.luckydraw;

import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawPrizeEntity;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawPrizeInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveLuckyDrawService
extends BaseService<ActiveLuckyDrawEntity, String>
implements ActiveLuckyDrawInterface {
    @Autowired
    ActiveLuckyDrawMapper luckyDrawMapper;
    @Autowired
    ActiveLuckyDrawPrizeInterface prizeInterface;
    @Autowired
    private ActiveMapper activeMapper;

    @Override
    public BaseJsonVo luckyDrawListByBindCode(String bindCode, Integer pageSize, Integer pageNum) {
        String[] bindCodes = new String[]{bindCode};
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List<ActiveLuckyDrawEntity> lst = this.luckyDrawMapper.selectByBindCodes(bindCodes);
        return BaseJsonVo.success((Object)page.toPageInfo());
    }

    @Override
    public BaseJsonVo getLuckyDraw(String luckyDrawId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        ActiveLuckyDrawEntity entity = (ActiveLuckyDrawEntity)this.luckyDrawMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawId));
        if (entity != null) {
            BaseJsonVo2.setValue((Object)entity);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo<ActiveLuckyDrawEntity> addLuckyDraw(ActiveLuckyDrawEntity entity) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        Integer result = 0;
        if (entity.getBeginTime() == null || entity.getEndTime() == null) {
            return BaseJsonVo.error((String)"\u62bd\u5956\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)entity.getId())) {
            if (this.luckyDrawMapper.isExistsRepDate(entity.getBeginTime(), entity.getEndTime(), entity.getId(), entity.getBindCode()) > 0) {
                this.logger.error("bindCode={},\u4fdd\u5b58\u5931\u8d25", (Object)entity.getBindCode());
                return BaseJsonVo.error((String)"\u62bd\u5956\u6d3b\u52a8\u5b58\u5728\u65e5\u671f\u91cd\u53e0\uff0c\u4fdd\u5b58\u5931\u8d25");
            }
            entity.setId(RandomUtils.generateStrId());
            result = this.luckyDrawMapper.insertSelective(entity);
        } else {
            baseJsonVo = this.updateDrawCheck(entity.getId(), 1);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            result = this.luckyDrawMapper.updateByPrimaryKeySelective(entity);
        }
        if (result == 1) {
            baseJsonVo.setValue((Object)entity);
        } else {
            baseJsonVo.setError("\u4fee\u6539\u5931\u8d25");
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo deleteLuckyDraw(String luckyDrawId) {
        BaseJsonVo jsonVo = this.updateDrawCheck(luckyDrawId, 0);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        Integer result = this.luckyDrawMapper.deleteByPrimaryKey((Serializable)((Object)luckyDrawId));
        if (result != 1) {
            return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public ActiveLuckyDrawEntity getOpenLuckyDraw() {
        return this.luckyDrawMapper.getOpenLuckyDraw();
    }

    @Override
    public BaseJsonVo updateDrawCheck(String luckyDrawId, Integer update) {
        ActiveLuckyDrawEntity drawEntity = (ActiveLuckyDrawEntity)this.luckyDrawMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawId));
        if (drawEntity != null) {
            if (drawEntity.getBeginTime() != null && drawEntity.getBeginTime().before(new Date()) && update == 0) {
                return BaseJsonVo.error((String)"\u62bd\u5956\u5df2\u7ecf\u5f00\u59cb\u9884\u7ea6\uff0c\u4e0d\u80fd\u4fee\u6539/\u5220\u9664");
            }
            if (drawEntity.getStatus() != 0) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u62bd\u5956\uff0c\u4e0d\u80fd\u4fee\u6539/\u5220\u9664");
            }
            if (update == 0) {
                ActiveLuckyDrawPrizeEntity prizeEntity = new ActiveLuckyDrawPrizeEntity();
                prizeEntity.setLuckyDrawId(luckyDrawId);
                if (this.prizeInterface.existsByEntity(prizeEntity) >= 1) {
                    return BaseJsonVo.error((String)"\u8bf7\u5148\u5220\u9664\u5956\u54c1\u518d\u5220\u9664\u62bd\u5956\u6d3b\u52a8");
                }
            }
        } else {
            return BaseJsonVo.error((String)"\u62bd\u5956\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updatePrizeCheck(String luckyDrawId) {
        ActiveLuckyDrawEntity drawEntity = (ActiveLuckyDrawEntity)this.luckyDrawMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawId));
        if (drawEntity != null) {
            if (drawEntity.getOpenTime().before(new Date())) {
                return BaseJsonVo.error((String)"\u62bd\u5956\u5df2\u7ecf\u5f00\u59cb\uff0c\u4e0d\u80fd\u4fee\u6539/\u5220\u9664");
            }
            if (drawEntity.getStatus() != 0) {
                return BaseJsonVo.error((String)"\u5df2\u7ecf\u62bd\u5956\uff0c\u4e0d\u80fd\u4fee\u6539/\u5220\u96641");
            }
        } else {
            return BaseJsonVo.error((String)"\u62bd\u5956\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo buildNextPeriod(String bindCode) {
        ActiveEntity query = new ActiveEntity();
        query.setBindCode(bindCode);
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.getSingle(query);
        if (activeEntity.getEndTime().before(new Date()) || !Objects.equals(activeEntity.getStatus(), 1)) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        ActiveLuckyDrawEntity search = new ActiveLuckyDrawEntity();
        search.setBindCode(bindCode);
        List lst = this.getList(search);
        Optional<ActiveLuckyDrawEntity> optional = lst.stream().filter(c -> c.getStatus() != 3).sorted((c, d) -> d.getCreateTime().compareTo(c.getCreateTime())).findFirst();
        if (optional.isPresent()) {
            ActiveLuckyDrawEntity entity = optional.get();
            String lastDrawId = entity.getId();
            entity.setId(null);
            entity.setStatus(0);
            entity.setBindCode(bindCode);
            entity.setPeriod(entity.getPeriod() + 1);
            entity.setCreateTime(new Date());
            Long diff = DateUtils.getDateDiffSecond((Date)entity.getBeginTime(), (Date)entity.getEndTime());
            Long diffOpen = DateUtils.getDateDiffSecond((Date)entity.getEndTime(), (Date)entity.getOpenTime());
            entity.setBeginTime(DateUtils.getAddDateBySecond((Date)entity.getEndTime(), (int)1));
            entity.setEndTime(DateUtils.getAddDateBySecond((Date)entity.getBeginTime(), (int)diff.intValue()));
            entity.setOpenTime(DateUtils.getAddDateBySecond((Date)entity.getEndTime(), (int)diffOpen.intValue()));
            BaseJsonVo<ActiveLuckyDrawEntity> jsonVo = this.addLuckyDraw(entity);
            if (jsonVo.isSuccess()) {
                ActiveLuckyDrawEntity result = (ActiveLuckyDrawEntity)jsonVo.getValue();
                this.prizeInterface.buildNextPrize(lastDrawId, result.getId());
                this.logger.info("\u4e0b\u671f\u6784\u5efa\u6210\u529f");
                return BaseJsonVo.success((Object)"\u4e0b\u671f\u6784\u5efa\u6210\u529f");
            }
        }
        return BaseJsonVo.error((String)"\u5931\u8d25");
    }
}

