/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.luckydraw;

import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawUserMapper;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawConditionEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawPrizeEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawUserEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawUserMessageVo;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawUserVo;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawConditionInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawPrizeInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawUserInterface;
import cc.lechun.active.service.message.MarketMessage;
import cc.lechun.common.Lottry.LotteryUtil;
import cc.lechun.common.Lottry.LotteryVo;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ActiveLuckyDrawUserService
extends BaseService<ActiveLuckyDrawUserEntity, Integer>
implements ActiveLuckyDrawUserInterface {
    @Resource
    private ActiveLuckyDrawUserMapper activeLuckyDrawUserMapper;
    @Autowired
    private ActiveLuckyDrawInterface drawInterface;
    @Autowired
    private ActiveLuckyDrawPrizeInterface prizeInterface;
    @Autowired
    private ActiveLuckyDrawUserInterface drawUserInterface;
    @Autowired
    private ActiveLuckyDrawConditionInterface conditionInterface;
    @Autowired
    MarketMessage marketMessage;

    @Override
    public List<ActiveLuckyDrawUserEntity> getDrawUserList(String luckDrawId) {
        ActiveLuckyDrawUserEntity userEntity = new ActiveLuckyDrawUserEntity();
        userEntity.setLuckyDrawId(luckDrawId);
        List lst = this.activeLuckyDrawUserMapper.getList(userEntity);
        return lst;
    }

    @Override
    @Transactional
    public BaseJsonVo updateDrawUser(String customerId, ActiveLuckyDrawPrizeEntity prizeEntity) {
        if (prizeEntity == null) {
            return BaseJsonVo.error((String)"\u4e2d\u5956\u5956\u9879\u4e3a\u7a7a");
        }
        ActiveLuckyDrawUserEntity userEntity = new ActiveLuckyDrawUserEntity();
        userEntity.setLuckyDrawId(prizeEntity.getLuckyDrawId());
        userEntity.setCustomerId(customerId);
        userEntity = (ActiveLuckyDrawUserEntity)this.activeLuckyDrawUserMapper.getSingle(userEntity);
        if (userEntity != null) {
            userEntity.setPrizeId(prizeEntity.getId());
            userEntity.setLevel(prizeEntity.getLevel());
            userEntity.setIsUsed(1);
            int i = this.activeLuckyDrawUserMapper.updateByPrimaryKeySelective(userEntity);
            if (i >= 1) {
                return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
            }
        }
        return BaseJsonVo.error((String)"\u4e2d\u5956\u66f4\u65b0\u5f02\u5e38");
    }

    @Override
    @Transactional
    public BaseJsonVo openLuckyDraw(String luckyDrawId) {
        ActiveLuckyDrawEntity drawEntity = StringUtil.isNotEmpty((String)luckyDrawId) ? (ActiveLuckyDrawEntity)this.drawInterface.selectByPrimaryKey((Serializable)((Object)luckyDrawId)) : this.drawInterface.getOpenLuckyDraw();
        if (drawEntity != null) {
            luckyDrawId = drawEntity.getId();
            if (!Integer.valueOf(0).equals(drawEntity.getStatus())) {
                return BaseJsonVo.error((String)"\u8be5\u62bd\u5956\u6d3b\u52a8\u5df2\u7ecf\u5f00\u5956\u6216\u72b6\u6001\u65e0\u6548");
            }
            if (drawEntity.getEndTime().after(new Date())) {
                return BaseJsonVo.error((String)"\u9884\u7ea6\u672a\u7ed3\u675f\uff0c\u4e0d\u80fd\u5f00\u5956\uff0c\u8bf7\u8bbe\u7f6e\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4");
            }
            drawEntity.setStatus(1);
            this.drawInterface.updateByPrimaryKeySelective(drawEntity);
            List<ActiveLuckyDrawPrizeEntity> prizeEntities = this.prizeInterface.luckyDrawPrizeList(drawEntity.getId());
            if (prizeEntities.size() == 0) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u6ca1\u6709\u8bbe\u7f6e\u5956\u54c1");
            }
            List<ActiveLuckyDrawUserEntity> drawUserEntities = this.drawUserInterface.getDrawUserList(drawEntity.getId());
            if (prizeEntities.stream().filter(c -> Integer.valueOf(3).equals(c.getPrizeMode())).count() > 1L) {
                return BaseJsonVo.error((String)"\u8bbe\u7f6e\u4e3a\u5168\u4e2d\u7684\u5956\u9879\u53ea\u80fd\u662f\u672b\u7b49\u5956");
            }
            for (ActiveLuckyDrawPrizeEntity p : prizeEntities) {
                if ((Integer.valueOf(2).equals(p.getPrizeType()) || Integer.valueOf(1).equals(p.getLevel())) && Integer.valueOf(3).equals(p.getPrizeMode())) {
                    return BaseJsonVo.error((String)"\u4e00\u7b49\u5956\u6216\u624b\u5de5\u53d1\u653e\u7684\u4e0d\u751f\u8bbe\u7f6e\u4e3a\u5168\u4e2d");
                }
                BaseJsonVo<List<ActiveLuckyDrawUserEntity>> baseJsonVo = this.drawUserInterface.generateDrawUsers(drawEntity, p, drawUserEntities);
                if (baseJsonVo.isSuccess()) {
                    List prizeJackpot = (List)baseJsonVo.getValue();
                    for (ActiveLuckyDrawUserEntity j : prizeJackpot) {
                        int n = this.drawUserInterface.updateByPrimaryKeySelective(j);
                    }
                    continue;
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return baseJsonVo;
            }
        } else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u62bd\u5956\u5bf9\u8c61\u4e3a\u7a7a");
        }
        drawEntity.setStatus(2);
        drawEntity.setOpenTime(new Date());
        this.drawInterface.updateByPrimaryKeySelective(drawEntity);
        try {
            this.drawInterface.buildNextPeriod(drawEntity.getBindCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.marketMessage.sendLuckyDrawMessage(luckyDrawId, drawEntity.getBindCode(), "lucky");
        return BaseJsonVo.success((Object)"\u62bd\u5956\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo buildNextPeriod(String luckyDrawId) {
        ActiveLuckyDrawEntity drawEntity = StringUtil.isNotEmpty((String)luckyDrawId) ? (ActiveLuckyDrawEntity)this.drawInterface.selectByPrimaryKey((Serializable)((Object)luckyDrawId)) : this.drawInterface.getOpenLuckyDraw();
        return this.drawInterface.buildNextPeriod(drawEntity.getBindCode());
    }

    @Override
    @Transactional
    public BaseJsonVo<List<ActiveLuckyDrawUserEntity>> generateDrawUsers(ActiveLuckyDrawEntity luckyDraw, ActiveLuckyDrawPrizeEntity prize, List<ActiveLuckyDrawUserEntity> drawUserEntities) {
        ActiveLuckyDrawConditionEntity conditionEntity;
        ArrayList<ActiveLuckyDrawUserEntity> resultList = new ArrayList<ActiveLuckyDrawUserEntity>();
        if (StringUtils.isNotEmpty((String)prize.getPrizeUser())) {
            List<ActiveLuckyDrawUserEntity> speList = drawUserEntities.stream().filter(c -> Integer.valueOf(0).equals(c.getIsUsed())).collect(Collectors.toList());
            resultList.addAll(this.processFixUser(prize.getPrizeUser().split(","), luckyDraw, prize, speList));
        }
        if (prize.getPrizeConditionId() != null && (conditionEntity = (ActiveLuckyDrawConditionEntity)this.conditionInterface.selectByPrimaryKey(prize.getPrizeConditionId())) != null && Integer.valueOf(1).equals(conditionEntity.getPrizeConditionClass())) {
            List<ActiveLuckyDrawUserEntity> speList = drawUserEntities.stream().filter(c -> Integer.valueOf(0).equals(c.getIsUsed()) && c.getSubscribeTotalCount() >= conditionEntity.getNum1() && c.getSubscribeTotalCount() <= conditionEntity.getNum2()).collect(Collectors.toList());
            int prizeCount = prize.getPrizeCount() - resultList.size();
            if ((double)speList.size() * conditionEntity.getProbability().doubleValue() > (double)prizeCount) {
                speList = this.randomLottery(speList, prizeCount);
            }
            resultList.addAll(this.buildDrawJackposts(luckyDraw, prize, speList, 0));
        }
        if (Integer.valueOf(1).equals(prize.getPrizeMode())) {
            List<ActiveLuckyDrawUserEntity> randsList = drawUserEntities.stream().filter(c -> Integer.valueOf(0).equals(c.getIsUsed())).collect(Collectors.toList());
            int count = randsList.size();
            if (count > prize.getPrizeCount() - resultList.size()) {
                randsList = this.randomLottery(randsList, prize.getPrizeCount() - resultList.size());
            }
            resultList.addAll(this.buildDrawJackposts(luckyDraw, prize, randsList, 0));
        }
        return BaseJsonVo.success(resultList);
    }

    private List<ActiveLuckyDrawUserEntity> randomLottery(List<ActiveLuckyDrawUserEntity> list, Integer prizeCount) {
        ArrayList<LotteryVo> lotteryVos = new ArrayList<LotteryVo>();
        if (prizeCount <= 0) {
            return new ArrayList<ActiveLuckyDrawUserEntity>();
        }
        Double sumWeight = list.stream().mapToDouble(c -> c.getSubscribeTotalCount().intValue()).sum();
        double d1 = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            d1 = i == 0 ? 0.0 : (d1 += list.get(i - 1).getSubscribeTotalCount().doubleValue() / sumWeight);
            lotteryVos.add(new LotteryVo(list.get(i).getCustomerId(), d1, d2 += list.get(i).getSubscribeTotalCount().doubleValue() / sumWeight));
        }
        Set<String> set = LotteryUtil.lottery(lotteryVos, prizeCount.intValue());
        ArrayList<ActiveLuckyDrawUserEntity> result = new ArrayList<ActiveLuckyDrawUserEntity>();
        for (String str : set) {
            Optional<ActiveLuckyDrawUserEntity> op = list.stream().filter(c -> str.equals(c.getCustomerId())).findFirst();
            if (!op.isPresent()) continue;
            result.add(op.get());
        }
        return result;
    }

    private List<ActiveLuckyDrawUserEntity> processFixUser(String[] users, ActiveLuckyDrawEntity luckyDraw, ActiveLuckyDrawPrizeEntity prize, List<ActiveLuckyDrawUserEntity> drawUserEntities) {
        ArrayList<ActiveLuckyDrawUserEntity> resultList = new ArrayList<ActiveLuckyDrawUserEntity>();
        Integer i = prize.getPrizeCount() >= users.length ? users.length : prize.getPrizeCount();
        for (int j = 0; j < i; ++j) {
            int k = j;
            Optional<ActiveLuckyDrawUserEntity> optional = drawUserEntities.stream().filter(c -> c.getCustomerId().equals(users[k])).findFirst();
            if (!optional.isPresent()) continue;
            resultList.add(this.buildDrawJackpost(luckyDraw, prize, optional.get(), 1));
        }
        return resultList;
    }

    private List<ActiveLuckyDrawUserEntity> buildDrawJackposts(ActiveLuckyDrawEntity luckyDraw, ActiveLuckyDrawPrizeEntity prize, List<ActiveLuckyDrawUserEntity> drawUsers, Integer isFix) {
        ArrayList<ActiveLuckyDrawUserEntity> resultList = new ArrayList<ActiveLuckyDrawUserEntity>();
        for (ActiveLuckyDrawUserEntity du : drawUsers) {
            resultList.add(this.buildDrawJackpost(luckyDraw, prize, du, isFix));
        }
        return resultList;
    }

    private ActiveLuckyDrawUserEntity buildDrawJackpost(ActiveLuckyDrawEntity luckyDraw, ActiveLuckyDrawPrizeEntity prize, ActiveLuckyDrawUserEntity drawUser, Integer isFix) {
        drawUser.setPrizeId(prize.getId());
        drawUser.setLevel(prize.getLevel());
        drawUser.setIsUsed(1);
        drawUser.setUsedTime(new Date());
        drawUser.setIsFixPrize(isFix);
        drawUser.setPeriod(luckyDraw.getPeriod());
        return drawUser;
    }

    @Override
    public PageInfo getDrawUserList(String luckyDrawId, Integer pageNum, Integer pageSize) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        ActiveLuckyDrawUserEntity search = new ActiveLuckyDrawUserEntity();
        search.setLuckyDrawId(luckyDrawId);
        List<ActiveLuckyDrawUserVo> lst = this.activeLuckyDrawUserMapper.getDrawUserList(search);
        for (ActiveLuckyDrawUserVo v : lst) {
            v.setLevelName(this.prizeInterface.getPrizeLevelName(v.getLevel()));
        }
        return page.toPageInfo();
    }

    @Override
    @Transactional
    public BaseJsonVo setFixUser(Integer id) {
        ActiveLuckyDrawUserEntity drawUserEntity = (ActiveLuckyDrawUserEntity)this.selectByPrimaryKey(id);
        if (drawUserEntity == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u8be5\u7528\u6237\u6ca1\u6709\u9884\u7ea6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5185\u7f6e");
        }
        ActiveLuckyDrawEntity drawEntity = (ActiveLuckyDrawEntity)this.drawInterface.selectByPrimaryKey((Serializable)((Object)drawUserEntity.getLuckyDrawId()));
        if (drawEntity != null && !Integer.valueOf(0).equals(drawEntity.getStatus())) {
            return BaseJsonVo.error((String)"\u5df2\u7ecf\u62bd\u5956\u5b8c\u6210\uff0c\u4e0d\u80fd\u8bbe\u7f6e");
        }
        Integer status = Integer.valueOf(1).equals(drawUserEntity.getIsFixPrize()) ? 0 : 1;
        drawUserEntity.setIsFixPrize(status);
        this.activeLuckyDrawUserMapper.updateByPrimaryKeySelective(drawUserEntity);
        return this.prizeInterface.setFixUser(drawUserEntity.getLuckyDrawId(), drawUserEntity.getCustomerId(), 1, status);
    }

    @Override
    @Transactional
    public BaseJsonVo setFixUser(String luckyDrawId, String prizeId, String customerId) {
        ActiveLuckyDrawUserEntity drawUserEntity = new ActiveLuckyDrawUserEntity();
        drawUserEntity.setLuckyDrawId(luckyDrawId);
        drawUserEntity.setCustomerId(customerId);
        drawUserEntity = (ActiveLuckyDrawUserEntity)this.getSingle(drawUserEntity, 0L);
        if (drawUserEntity == null) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)("\u8be5\u7528\u6237[" + customerId + "]\u6ca1\u6709\u9884\u7ea6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5185\u7f6e"));
        }
        drawUserEntity.setIsFixPrize(1);
        this.updateByPrimaryKeySelective(drawUserEntity);
        return BaseJsonVo.success((Object)"\u8bbe\u7f6e\u6210\u529f");
    }

    @Override
    public List<ActiveLuckyDrawUserMessageVo> getLuckyUserMessage(String luckyDrawId) {
        return this.activeLuckyDrawUserMapper.getLuckyUserMessage(luckyDrawId);
    }

    @Override
    public BaseJsonVo setLineOffTakeDrawSuccess(Integer id, String userName) {
        ActiveLuckyDrawUserEntity drawUserEntity;
        if (id != null && (drawUserEntity = (ActiveLuckyDrawUserEntity)this.selectByPrimaryKey(id)) != null && drawUserEntity.getLevel() == 1) {
            drawUserEntity.setIsTake(1);
            drawUserEntity.setTakeTime(new Date());
            drawUserEntity.setTakeType("\u7ebf\u4e0b\u5ba2\u670d\u9886\u53d6\uff1a" + userName);
            int i = this.activeLuckyDrawUserMapper.updateByPrimaryKeySelective(drawUserEntity);
            if (i == 0) {
                return BaseJsonVo.success((Object)"\u9886\u53d6\u6210\u529f");
            }
        }
        return BaseJsonVo.success((Object)"\u9886\u53d6\u5931\u8d25");
    }
}

