/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.message;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveReserveEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawUserMessageVo;
import cc.lechun.active.entity.message.TaskSmsMessageEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawPrizeInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawUserInterface;
import cc.lechun.active.iservice.message.TaskSmsMessageInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.apiinvoke.mall.MallTempMsgInvoke;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.entity.weixin.TemplateExecOrderEnum;
import cc.lechun.mall.entity.weixin.TemplateExecTypeEnum;
import cc.lechun.mall.entity.weixin.WeekEnum;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MarketMessage {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Lazy
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    RedisCacheUtil redisCacheUtil;
    @Autowired
    @Lazy
    private MallMessageConfigInterface messageConfigInterface;
    @Autowired
    @Lazy
    private CustomerInterface customerInterface;
    @Autowired
    ReserveInterface reserveInterface;
    @Autowired
    @Lazy
    protected ActiveInterface activeService;
    @Autowired
    private MallTempMsgInvoke mallTempMsgInvoke;
    @Autowired
    TaskSmsMessageInterface taskSmsMessageInterface;
    @Lazy
    @Autowired
    ActiveLuckyDrawUserInterface drawUserInterface;
    @Lazy
    @Autowired
    ActiveLuckyDrawPrizeInterface prizeInterface;
    @Lazy
    @Autowired
    MiniSchemeInterface miniSchemeInterface;
    private final Map<Integer, String> activeTypeMap = new HashMap<Integer, String>(){
        {
            this.put(28, "\u9884\u7ea6\u63d0\u9192\u6a21\u677f");
            this.put(31, "auto_send_customer_message");
            this.put(32, "dailySms");
        }
    };

    public BaseJsonVo sendMessage(Date date, Integer activeType) {
        List<ActiveEntity> activeEntityList = this.activeService.getEnableActiveList(activeType);
        if (CollectionUtils.isNotEmpty(activeEntityList)) {
            String actionId = this.activeTypeMap.get(activeType);
            activeEntityList.stream().filter(item -> this.getActivePushRule(item.getBindCode()) != null).forEach(item -> {
                ActivePropertyEntity activePropertyEntity = this.getActivePushRule(item.getBindCode());
                this.setPushOrderCache(item.getBindCode(), activePropertyEntity, actionId);
                switch (activeType) {
                    case 28: {
                        this.sendReserveMessage(item.getBindCode(), actionId);
                        break;
                    }
                    case 31: {
                        this.messageConfigInterface.pushNoticeMQ(actionId);
                        break;
                    }
                    case 32: {
                        this.sendSMSMessage(item.getBindCode(), actionId);
                        break;
                    }
                }
            });
        }
        return BaseJsonVo.success((Object)"\u6267\u884c\u6210\u529f!");
    }

    public BaseJsonVo sendReserveMessage(String bindCode, String type, String actionId) {
        this.logger.info("\u6d3b\u52a8{}\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u5468\u671f\u63a8\u9001", (Object)bindCode);
        List<MallMessageConfigEntity> messageConfigEntityList = this.messageConfigInterface.getMessageConfigEntityList(1000, actionId);
        if (CollectionUtils.isNotEmpty(messageConfigEntityList)) {
            messageConfigEntityList.stream().forEach(messageConfigEntity -> {
                String propertyMessageKey = messageConfigEntity.getMessageId() + ":" + (3 == messageConfigEntity.getMessageType() ? MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() : messageConfigEntity.getMessageType().intValue()) + ":MessageProperty";
                this.redisCacheUtil.remove(propertyMessageKey);
                this.logger.info("\u79fb\u9664\u7f13\u5b58:{}\u6210\u529f", (Object)propertyMessageKey);
            });
            if (Integer.valueOf(type).intValue() == SalesTypeEnum.SALES_ACTIVE.getValue()) {
                ActivePropertyEntity activePropertyEntity = this.getActivePushRule(bindCode);
                if (activePropertyEntity != null) {
                    this.setPushOrderCache(bindCode, activePropertyEntity, actionId);
                }
                return this.sendReserveMessage(bindCode, actionId);
            }
            if (Integer.valueOf(type).intValue() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                return this.sendReserveMessage(bindCode, actionId);
            }
            if (Integer.valueOf(type).intValue() == SalesTypeEnum.SALES_GROUP.getValue()) {
                return this.sendReserveMessage(bindCode, actionId);
            }
            if (Integer.valueOf(type).intValue() == SalesTypeEnum.SALES_PRODUCT.getValue() || Integer.valueOf(type).intValue() == SalesTypeEnum.SALES_OFF_PRODUCT.getValue()) {
                return this.sendReserveMessage(bindCode, actionId);
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo sendNewUserGiftSMSMessage(String operationId) {
        String path = "account/pages/pic_for/index?bindCode=1592776238752993281&type=2";
        BaseJsonVo<MiniSchemeEntity> baseJsonVo = this.miniSchemeInterface.getMiniSchemeSystemByPara(path);
        PageInfo<TaskSmsMessageEntity> pageInfo = this.taskSmsMessageInterface.getMobileList(100, 1, DateUtils.currentDate(), 0, 2);
        int pages = pageInfo.getPages();
        for (int i = 0; i < pages; ++i) {
            ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
            try {
                pageInfo = this.taskSmsMessageInterface.getMobileList(100, i, DateUtils.currentDate(), 0, 2);
                this.logger.info("\u8981\u53d1\u9001\u77ed\u4fe1\u4e86 : \u4e00\u6b21\u8981\u63a8\u9001\u8bb0\u5f55\u6570:{}", (Object)pageInfo.getList().size());
                String msgId = RandomUtils.generateId();
                if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
                for (TaskSmsMessageEntity taskSmsMessageEntity : pageInfo.getList()) {
                    if (taskSmsMessageEntity.getMobile().contains("*")) {
                        this.logger.info("\u7528\u6237\u624b\u673a\u53f7:{} \u5305\u542b\u52a0\u5bc6\u4fe1\u606f,\u4e0d\u53d1\u9001", (Object)taskSmsMessageEntity.getMobile());
                        this.taskSmsMessageInterface.deleteByPrimaryKey(taskSmsMessageEntity.getId());
                        continue;
                    }
                    JSONObject jsonObj = JSON.parseObject((String)taskSmsMessageEntity.getParaInfo());
                    if (baseJsonVo.isSuccess()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("proName", "\u77ed\u4fe1");
                        map.put("shortUrl", ((MiniSchemeEntity)baseJsonVo.getValue()).getShortLink());
                        map.put("CUSTOMER_ID", taskSmsMessageEntity.getMobile());
                        mapList.add(map);
                        String key = jsonObj.getString("orderMainNo") + ":NewUserGiftFlag";
                        this.logger.info("\u8bbe\u7f6e\u8ba2\u5355:{}\u6709\u8d60\u54c1\u6807\u8bc6:{}", (Object)jsonObj.getString("orderMainNo"), (Object)key);
                        this.redisCacheUtil.set(key, (Object)1, Long.valueOf(604800L));
                        continue;
                    }
                    this.logger.error("\u8ba2\u5355:{}\u751f\u6210\u77ed\u8fde\u63a5\u51fa\u9519", (Object)jsonObj.getString("orderMainNo"));
                }
                if (mapList.size() == 1) {
                    ((Map)mapList.get(0)).put("custid", msgId);
                }
                boolean result = this.messageConfigInterface.pushNoticeMQ(operationId, msgId, mapList, i);
                this.logger.info("\u8981\u53d1\u9001\u7684\u77ed\u4fe1\u624b\u673a\u53f7\u5df2\u53d1\u9001\u5230\u6d88\u606f\u961f\u5217\u4e2d:{}", (Object)result);
                pageInfo.getList().forEach(smsMessageEntity -> {
                    this.logger.info("\u8bbe\u7f6e\u624b\u673a\u53f7\uff1a{},\u4e3a\u5df2\u63a8\u9001", (Object)smsMessageEntity.getMobile());
                    smsMessageEntity.setStatus(1);
                    smsMessageEntity.setSendTime(DateUtils.now());
                    smsMessageEntity.setMsgId(msgId);
                    this.taskSmsMessageInterface.updateByPrimaryKeySelective(smsMessageEntity);
                });
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo sendSMSMessage(String bindCode, String operationId) {
        int pageSize = 100;
        PageInfo<TaskSmsMessageEntity> pageInfo = this.taskSmsMessageInterface.getMobileList(pageSize, 1, DateUtils.currentDate(), 0, 1);
        int pages = pageInfo.getPages();
        for (int i = 0; i < pages; ++i) {
            ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
            try {
                pageInfo = this.taskSmsMessageInterface.getMobileList(pageSize, i, DateUtils.currentDate(), 0, 1);
                this.logger.info("\u8981\u53d1\u9001\u77ed\u4fe1\u4e86 : \u4e00\u6b21\u8981\u63a8\u9001\u8bb0\u5f55\u6570:{}", (Object)pageInfo.getList().size());
                String msgId = RandomUtils.generateId();
                if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
                for (TaskSmsMessageEntity taskSmsMessageEntity : pageInfo.getList()) {
                    if (taskSmsMessageEntity.getMobile().contains("*") || taskSmsMessageEntity.getMobile().contains("-")) {
                        this.logger.info("\u7528\u6237\u624b\u673a\u53f7:{} \u5305\u542b\u52a0\u5bc6\u4fe1\u606f,\u4e0d\u53d1\u9001", (Object)taskSmsMessageEntity.getMobile());
                        this.taskSmsMessageInterface.deleteByPrimaryKey(taskSmsMessageEntity.getId());
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("proName", "\u77ed\u4fe1");
                    map.put("CUSTOMER_ID", taskSmsMessageEntity.getMobile());
                    mapList.add(map);
                }
                if (mapList.size() == 1) {
                    ((Map)mapList.get(0)).put("custid", msgId);
                }
                boolean result = this.messageConfigInterface.pushNoticeMQ(operationId, msgId, mapList, i);
                this.logger.info("\u8981\u53d1\u9001\u7684\u77ed\u4fe1\u624b\u673a\u53f7\u5df2\u53d1\u9001\u5230\u6d88\u606f\u961f\u5217\u4e2d:{}", (Object)result);
                pageInfo.getList().forEach(smsMessageEntity -> {
                    this.logger.info("\u8bbe\u7f6e\u624b\u673a\u53f7\uff1a{},\u4e3a\u5df2\u63a8\u9001", (Object)smsMessageEntity.getMobile());
                    smsMessageEntity.setStatus(1);
                    smsMessageEntity.setSendTime(DateUtils.now());
                    smsMessageEntity.setMsgId(msgId);
                    this.taskSmsMessageInterface.updateByPrimaryKeySelective(smsMessageEntity);
                });
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u53d1\u9001\u77ed\u4fe1\u51fa\u9519,\u9519\u8bef\u6d88\u606f" + e);
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo sendReserveMessage(String bindCode, String operationId) {
        List<Map<String, Object>> customers = this.reserveInterface.findUnsend(bindCode);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        Integer activeType = 0;
        if (activeEntity != null) {
            activeType = activeEntity.getActiveType();
        }
        HashSet<Map<String, Object>> customersSet = new HashSet<Map<String, Object>>(customers);
        this.logger.info("\u8981\u53d1\u9001\u9884\u7ea6\u63d0\u9192\u4e86 : \u8981\u63a8\u9001\u8bb0\u5f55\u6570:{}", (Object)customers.size());
        int k = 0;
        for (Map<String, Object> customer : customers) {
            try {
                ++k;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("CUSTOMER_ID", customer.get("CUSTOMER_ID").toString());
                map.put("proName", (String)customer.get("PRO_NAME"));
                CustomerEntity customerEntity = this.customerInterface.getCustomer(customer.get("CUSTOMER_ID").toString());
                map.put("nickName", StringUtils.isNotEmpty((String)customerEntity.getNickName()) ? customerEntity.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                map.put("date", DateUtils.date());
                map.put("createTime", customer.get("CREATE_TIME") == null ? DateUtils.date() : DateUtils.formatDate((Date)((Date)customer.get("CREATE_TIME")), (String)"yyyy-MM-dd"));
                if (Integer.valueOf(39).equals(activeType)) {
                    // empty if block
                }
                ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                list.add(map);
                boolean result = this.messageConfigInterface.pushNoticeMQ(operationId, list, k);
                ActiveReserveEntity activeReserveEntity = new ActiveReserveEntity();
                activeReserveEntity.setId(Integer.valueOf(customer.get("ID").toString()));
                activeReserveEntity.setIsSend(result ? "1" : "2");
                activeReserveEntity.setSendTime(DateUtils.now());
                this.reserveInterface.setReserveStatus(activeReserveEntity);
                this.logger.info("\u63a8\u9001\u9884\u7ea6\u63d0\u9192,\u7528\u6237:[{}],\u63a8\u9001\u7ed3\u679c:[{}]", (Object)customer.get("CUSTOMER_ID").toString(), (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private ActivePropertyEntity getActivePushRule(String bindCode) {
        ActivePropertyEntity query = new ActivePropertyEntity();
        query.setBindCode(bindCode);
        List activePropertyList = this.activePropertyInterface.getList(query, 0L);
        if (CollectionUtils.isNotEmpty((Collection)activePropertyList)) {
            List<WeekEnum> weekEnumList = WeekEnum.getList();
            Optional<ActivePropertyEntity> propertyEntityOptional = activePropertyList.stream().filter(property -> {
                String week = ((WeekEnum)((Object)((Object)weekEnumList.get(this.getLocalDate(DateUtils.now()).getDayOfWeek().getValue() - 1)))).getName();
                this.logger.info("\u5f53\u5929\u662f{},\u6d3b\u52a8:{},\u914d\u7f6e\u6267\u884c\u7684\u65f6\u95f4\u662f:{}", new Object[]{week, bindCode, property.getPropertyValue()});
                return Objects.equals(property.getPropertyKey(), String.valueOf(TemplateExecTypeEnum.ByWeek.getValue())) && (Objects.equals(property.getPropertyValue(), week) || Objects.equals(property.getPropertyValue(), "\u6bcf\u5929"));
            }).findFirst();
            if (propertyEntityOptional.isPresent()) {
                return propertyEntityOptional.get();
            }
        }
        return null;
    }

    private void setPushOrderCache(String bindCode, ActivePropertyEntity activePropertyEntity, String operationId) {
        if (activePropertyEntity != null) {
            List<MallMessageConfigEntity> messageConfigEntityList;
            if (Integer.valueOf(activePropertyEntity.getPropertyRemark()).intValue() == TemplateExecOrderEnum.Sort.getValue()) {
                String orderKey = bindCode + ":MarketMessage:order";
                Integer order = 1;
                if (this.redisCacheUtil.get(orderKey) == null) {
                    order = 1;
                } else {
                    Integer n = order = (Integer)this.redisCacheUtil.get(orderKey);
                    Integer n2 = order = Integer.valueOf(order + 1);
                    if (order >= 100) {
                        order = 1;
                    }
                }
                this.redisCacheUtil.set(orderKey, (Object)order);
                this.logger.info("\u672c\u6b21\u6d3b\u52a8:{},\u9884\u7ea6\u63a8\u9001\u6267\u884c\u987a\u5e8f:{}", (Object)bindCode, (Object)order);
            }
            if (CollectionUtils.isNotEmpty(messageConfigEntityList = this.messageConfigInterface.getMessageConfigEntityList(1000, operationId))) {
                messageConfigEntityList.forEach(message -> {
                    String propertyMessageKey = message.getMessageId() + ":" + (3 == message.getMessageType() ? MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() : message.getMessageType().intValue()) + ":MessageProperty";
                    this.redisCacheUtil.set(propertyMessageKey, (Object)activePropertyEntity, Long.valueOf(3600L));
                });
            }
        }
    }

    public BaseJsonVo sendPreview(String openId, Integer platformGroupId, String actionId) {
        String customerId = "";
        HashMap<String, String> map = new HashMap<String, String>();
        List<MallMessageConfigEntity> messageConfigEntityList = this.messageConfigInterface.getMessageConfigEntityList(actionId);
        if (CollectionUtils.isEmpty(messageConfigEntityList)) {
            return BaseJsonVo.error((String)"\u6d88\u606f\u914d\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5");
        }
        for (MallMessageConfigEntity messageConfigEntity : messageConfigEntityList) {
            String propertyMessageKey = messageConfigEntity.getMessageId() + ":" + (3 == messageConfigEntity.getMessageType() ? MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() : messageConfigEntity.getMessageType().intValue()) + ":MessageProperty";
            this.redisCacheUtil.remove(propertyMessageKey);
            this.logger.info("\u79fb\u9664\u7f13\u5b58:{}\u6210\u529f", (Object)propertyMessageKey);
        }
        MallMessageConfigEntity messageConfigEntity = messageConfigEntityList.get(0);
        if (MessageTypeEnum.MP_SUBSCRIBE_MESSAGE.getValue() == messageConfigEntity.getMessageType().intValue() || MessageTypeEnum.TEMPLATE_MESSAGE.getValue() == messageConfigEntity.getMessageType().intValue() || MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() == messageConfigEntity.getMessageType().intValue()) {
            if (openId.startsWith("1") && openId.length() == 11) {
                CustomerEntity customerEntity = this.customerInterface.getCustomerByMobile(openId, platformGroupId);
                if (customerEntity == null) {
                    return BaseJsonVo.error((String)"\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u6216\u8005\u624b\u673a\u53f7\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5");
                }
                map.put("nickName", customerEntity.getNickName());
                map.put("date", DateUtils.date());
                customerId = customerEntity.getCustomerId();
            } else {
                CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(openId);
                if (customerDetailVo == null) {
                    return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5");
                }
                customerId = customerDetailVo.getCustomerId();
                map.put("nickName", customerDetailVo.getNickName());
                map.put("date", DateUtils.date());
            }
            BaseJsonVo baseJsonVo = this.mallTempMsgInvoke.sendTempMsg(StringUtils.isNotEmpty((String)actionId) ? actionId : "\u9884\u7ea6\u63d0\u9192\u6a21\u677f", customerId, JSONObject.toJSONString(map));
            this.logger.info("\u53d1\u9001\u72b6\u6001:{},{}", (Object)baseJsonVo.isSuccess(), (Object)baseJsonVo.getMessage());
            return baseJsonVo;
        }
        if (MessageTypeEnum.SMS_MESSAGE.getValue() == messageConfigEntity.getMessageType().intValue()) {
            map.put("proName", "\u77ed\u4fe1");
            map.put("custid", RandomUtils.generateId());
            BaseJsonVo result = this.mallTempMsgInvoke.sendTempMsg(actionId, openId, JSONObject.toJSONString(map));
            this.logger.info("\u77ed\u4fe1\u63a8\u9001\u624b\u673a\u53f7:{},\u63a8\u9001\u7ed3\u679c:{}", (Object)openId, (Object)result.isSuccess());
            return result;
        }
        return BaseJsonVo.success((Object)"");
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    public BaseJsonVo sendLuckyDrawMessage(String luckyDrawId, String bindCode, String actionId) {
        this.logger.info("\u6d3b\u52a8{}\u6ca1\u6709\u8bbe\u7f6e\u4e3a\u5468\u671f\u63a8\u9001", (Object)bindCode);
        List<MallMessageConfigEntity> messageConfigEntityList = this.messageConfigInterface.getMessageConfigEntityList(1000, actionId);
        for (MallMessageConfigEntity messageConfigEntity : messageConfigEntityList) {
            String propertyMessageKey = messageConfigEntity.getMessageId() + ":" + (3 == messageConfigEntity.getMessageType() ? MessageTypeEnum.CUSTOMZICE_MESSAGE.getValue() : messageConfigEntity.getMessageType().intValue()) + ":MessageProperty";
            this.redisCacheUtil.remove(propertyMessageKey);
            this.logger.info("\u79fb\u9664\u7f13\u5b58:{}\u6210\u529f", (Object)propertyMessageKey);
        }
        List<ActiveLuckyDrawUserMessageVo> customers = this.drawUserInterface.getLuckyUserMessage(luckyDrawId);
        this.logger.info("\u8981\u53d1\u9001\u9884\u7ea6\u63d0\u9192\u4e86 : \u8981\u63a8\u9001\u8bb0\u5f55\u6570:{}", (Object)customers.size());
        int k = 0;
        for (ActiveLuckyDrawUserMessageVo customer : customers) {
            try {
                customer.setLevelName(this.prizeInterface.getPrizeLevelName(customer.getLevel()));
                ++k;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("CUSTOMER_ID", customer.getCustomerId());
                map.put("nickName", StringUtils.isNotEmpty((String)customer.getNickName()) ? customer.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                map.put("luckyDrawId", customer.getLuckyDrawId());
                map.put("bindCode", customer.getBindCode());
                map.put("luckyDrawName", customer.getLuckyDrawName());
                String prizeName = customer.getIsUsed() == 1 ? customer.getLevelName() + "\uff1a" + customer.getPrizeName() : "\u6682\u672a\u83b7\u5956";
                String header = "";
                String footer = "";
                if (customer.getIsUsed() == 1) {
                    header = "\u4e2d\u5956\u5566\uff01\u606d\u559c\u4f60\u9526\u9ca4\u9644\u8eab\uff0c\u62b1\u8d70" + prizeName;
                    footer = "\u5feb\u6765\u8054\u7cfb\u5c0f\u5c9b\u4f53\u9a8c\u5b98\u9886\u8d70\u4f60\u7684\u5956\u54c1\u5427\uff5e";
                } else {
                    header = "\u5f88\u9057\u61be,\u60a8\u672c\u6b21\u672a\u4e2d\u5956\uff0c\u518d\u63a5\u518d\u5389\uff0c\u4e2d\u5956\u6982\u7387\u4e0e\u9884\u7ea6\u6b21\u6570\u6210\u6b63\u6bd4";
                    footer = "\u522b\u7070\u5fc3\uff0c\u62bd\u5956\u6b21\u6570\u8d8a\u591a\uff0c\u8d62\u53d6\u5927\u5956\u7684\u51e0\u7387\u8d8a\u5927\u54e6\uff5e";
                }
                map.put("prizeName", prizeName);
                map.put("openTime", DateUtils.formatDate((Date)customer.getOpenTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                map.put("headImageUrl", customer.getHeadImageUrl());
                map.put("subscribeTotalCount", customer.getSubscribeTotalCount().toString());
                map.put("header", "@" + (String)map.get("nickName") + header);
                map.put("footer", footer);
                ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                list.add(map);
                boolean result = this.messageConfigInterface.pushNoticeMQ(actionId, list, k);
                ActiveReserveEntity activeReserveEntity = new ActiveReserveEntity();
                activeReserveEntity.setProId(bindCode);
                activeReserveEntity.setCustomerId(customer.getCustomerId());
                activeReserveEntity.setIsSend(result ? "1" : "2");
                activeReserveEntity.setSendTime(DateUtils.now());
                this.reserveInterface.setReserveStatus(activeReserveEntity);
                this.logger.info("\u63a8\u9001\u9884\u7ea6\u63d0\u9192,\u7528\u6237:[{}],\u63a8\u9001\u7ed3\u679c:[{}]", (Object)customer.getCustomerId(), (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return BaseJsonVo.success((Object)"");
    }
}

