/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.property;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActivePropertyQueryVo;
import cc.lechun.active.entity.active.PicLinkVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ActivePropertyBase {
    @Resource
    private ActivePropertyMapper activePropertyMapper;
    @Autowired
    MallProductPicInterface picService;
    @Lazy
    @Autowired
    private ActiveInterface activeInterface;

    public BaseJsonVo getPicPropertyList(ActivePropertyQueryVo activePropertyQueryVo) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(activePropertyQueryVo.getBindCode());
        ArrayList picLinkVoList = new ArrayList();
        List<MallProductPicEntity> list = this.picService.getProductPics(activeEntity.getActiveNo(), ProductPicTypeEnum.getValue(activePropertyQueryVo.getPropertyName()));
        ActivePropertyEntity activePropertyEntity = new ActivePropertyEntity();
        activePropertyEntity.setBindCode(activePropertyQueryVo.getBindCode());
        activePropertyEntity.setPropertyName(activePropertyQueryVo.getPropertyName());
        List propertyList = this.activePropertyMapper.getList(activePropertyEntity);
        if (list.size() > 0) {
            list.forEach(item -> {
                Optional<ActivePropertyEntity> picUrlOption;
                PicLinkVo picLinkVo = new PicLinkVo();
                picLinkVo.setPicUrl(item.getFullRelativeUrl());
                picLinkVo.setPicName(item.getPicName());
                if (propertyList.size() > 0 && (picUrlOption = propertyList.stream().filter(p -> {
                    String temp = item.getFullRelativeUrl().replace("https://", "").replace("http://", "");
                    return temp.substring(temp.indexOf("/") + 1).equals(p.getPropertyKey());
                }).findFirst()).isPresent()) {
                    picLinkVo.setLinkUrl(picUrlOption.get().getPropertyValue());
                    picLinkVo.setPropertyId(picUrlOption.get().getPropertyId());
                }
                picLinkVoList.add(picLinkVo);
            });
        }
        return BaseJsonVo.success(picLinkVoList);
    }
}

