/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.reserve;

import cc.lechun.active.dao.active.ActiveReserveMapper;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveReserveEntity;
import cc.lechun.active.entity.active.ActiveReserveQueryVo;
import cc.lechun.active.entity.active.ActiveVo;
import cc.lechun.active.entity.active.ReserveCustomerDo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ReserveService
extends BaseService
implements ReserveInterface {
    @Autowired
    private ActiveReserveMapper reserveMapper;
    @Lazy
    @Autowired
    private ActiveCashticketInterface activeCashticketServcie;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Lazy
    @Autowired
    private ActiveInterface activeService;

    @Override
    public List<ReserveCustomerDo> exportCustomer(String proId, Integer status, String type) {
        ActiveReserveEntity activeReserveEntity = new ActiveReserveEntity();
        activeReserveEntity.setProType(type);
        activeReserveEntity.setProId(proId);
        List list = this.reserveMapper.getList(activeReserveEntity);
        ArrayList result = new ArrayList();
        if (list.size() > 0) {
            list.forEach(t -> {
                ReserveCustomerDo reserveCustomerDo = new ReserveCustomerDo();
                BeanUtils.copyProperties((Object)t, (Object)reserveCustomerDo);
                result.add(reserveCustomerDo);
            });
        }
        HashSet set = new HashSet(result);
        return set.stream().collect(Collectors.toList());
    }

    @Override
    public BaseJsonVo sendReserveCoupon(String bindCode) {
        return this.sendReserveCoupon(bindCode, "5", bindCode);
    }

    @Override
    public BaseJsonVo sendReserveCoupon(String bindCode, String type, String proId) {
        ActiveReserveEntity activeReserveEntity = new ActiveReserveEntity();
        activeReserveEntity.setProType(type);
        activeReserveEntity.setProId(proId);
        List list = this.reserveMapper.getList(activeReserveEntity);
        if (list == null || list.size() == 0) {
            return BaseJsonVo.error((String)"\u65e0\u9884\u7ea6\u7528\u6237");
        }
        for (ActiveReserveEntity r : list) {
            this.logger.info("\u9884\u7ea6\u7528\u6237:{}", (Object)r.toString());
            this.activeCashticketServcie.sendTicket4BaseAsynchronous(r.getCustomerId(), bindCode, "", r.getPlatformId(), true, false);
        }
        return BaseJsonVo.success((Object)"\u4f18\u60e0\u5238\u53d1\u9001\u4e2d...\u8bf7\u7a0d\u540e");
    }

    @Override
    public List<Map<String, Object>> findUnsend(String bindCode) {
        return this.reserveMapper.findUnsend(bindCode);
    }

    @Override
    public PageInfo reserveList(ActiveReserveQueryVo activeReserveQueryVo) {
        Page page = PageHelper.startPage((int)activeReserveQueryVo.getCurrentPage(), (int)activeReserveQueryVo.getPageSize());
        List<Object> list = new ArrayList();
        if (Integer.valueOf(activeReserveQueryVo.getProType()).intValue() == SalesTypeEnum.SALES_ACTIVE.getValue()) {
            if (StringUtils.isNotEmpty((String)activeReserveQueryVo.getProId()) && "5".equals(activeReserveQueryVo.getProType())) {
                ActiveVo activeEntity = this.activeService.getActiveEntityByActiveNo(activeReserveQueryVo.getProId());
                activeReserveQueryVo.setProId(activeEntity != null ? activeEntity.getBindCode() : "");
            }
            list = this.reserveMapper.getActiveReserveList(activeReserveQueryVo.getProId(), activeReserveQueryVo.getProType());
        } else if (Integer.valueOf(activeReserveQueryVo.getProType()).intValue() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
            list = this.reserveMapper.getPromotionReserveList(activeReserveQueryVo.getProId(), activeReserveQueryVo.getProType());
        } else if (Integer.valueOf(activeReserveQueryVo.getProType()).intValue() == SalesTypeEnum.SALES_GROUP.getValue()) {
            list = this.reserveMapper.getGroupReserveList(activeReserveQueryVo.getProId(), activeReserveQueryVo.getProType());
        } else if (Integer.valueOf(activeReserveQueryVo.getProType()).intValue() == SalesTypeEnum.SALES_PRODUCT.getValue() || Integer.valueOf(activeReserveQueryVo.getProType()).intValue() == SalesTypeEnum.SALES_OFF_PRODUCT.getValue()) {
            list = this.reserveMapper.getProductReserveList(activeReserveQueryVo.getProId(), activeReserveQueryVo.getProType());
        }
        for (Map map : list) {
            map.put("AUTO_SEND", 0);
            map.put("PRO_TYPE2", map.get("PRO_ID") != null ? this.getProType(map.get("PRO_TYPE").toString()) : "");
            if (Integer.valueOf(activeReserveQueryVo.getProType()).intValue() != SalesTypeEnum.SALES_ACTIVE.getValue()) continue;
            ActivePropertyEntity query = new ActivePropertyEntity();
            query.setBindCode(map.get("PRO_ID").toString());
            query.setPropertyName("\u6d3b\u52a8\u6267\u884c\u65f6\u95f4");
            ActivePropertyEntity activePropertyEntity = (ActivePropertyEntity)this.activePropertyInterface.getSingle(query, 0L);
            if (activePropertyEntity == null || activePropertyEntity.getPropertyId() == null) continue;
            map.put("AUTO_SEND", 1);
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    private String getProType(String proType) {
        if (proType.equals("\u6d3b\u52a8")) {
            return "5";
        }
        if (proType.equals("\u5355\u54c1")) {
            return "4";
        }
        if (proType.equals("\u5957\u88c5")) {
            return "2";
        }
        if (proType.equals("\u4fc3\u9500")) {
            return "1";
        }
        if (proType.equals("\u4e0b\u67b6\u5355\u54c1")) {
            return "6";
        }
        return "\u7c7b\u578b\u9519\u8bef";
    }

    @Override
    public void setReserveStatus(ActiveReserveEntity activeReserveEntity) {
        if (activeReserveEntity.getId() == null && StringUtils.isNotEmpty((String)activeReserveEntity.getCustomerId()) && StringUtils.isNotEmpty((String)activeReserveEntity.getProId())) {
            ActiveReserveEntity search = new ActiveReserveEntity();
            search.setProId(activeReserveEntity.getProId());
            search.setCustomerId(activeReserveEntity.getCustomerId());
            activeReserveEntity = (ActiveReserveEntity)this.reserveMapper.getSingle(search);
        }
        if (activeReserveEntity != null) {
            int i = this.reserveMapper.updateByPrimaryKeySelective(activeReserveEntity);
            this.logger.info("\u66f4\u65b0\u53d1\u9001\u72b6\u6001:{}", (Object)i);
        }
    }
}

