/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.api;

import cc.lechun.active.entity.active.QyInviteEntity;
import cc.lechun.active.iservice.active.QyInviteInterface;
import cc.lechun.cms.api.CustomerInfoApi;
import cc.lechun.cms.dto.CustomerDetailDTO;
import cc.lechun.cms.dto.CustomerInfoDTO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CustomerInfoApiImpl
implements CustomerInfoApi {
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private QyInviteInterface qyInviteInterface;
    @Autowired
    private DistributorQiyeweixinExternalContactInterface distributorQiyeweixinExternalContactInterface;

    public BaseJsonVo<CustomerInfoDTO> getCustomerInfo(String customerId, Integer platformId) {
        CustomerInfoDTO customerInfoDTO = new CustomerInfoDTO();
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(customerId, platformId);
        if (customerDetailVo != null) {
            CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
            customerInfoDTO.setIsNew(customerEntity.getIsNew());
            BeanUtils.copyProperties((Object)customerDetailVo, (Object)customerInfoDTO);
        }
        return BaseJsonVo.success((Object)customerInfoDTO);
    }

    public BaseJsonVo<CustomerDetailDTO> getCustomer(String customerId, Integer platformId) {
        CustomerDetailDTO customerDetailDTO = new CustomerDetailDTO();
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(customerId, platformId);
        if (customerDetailVo != null) {
            BeanUtils.copyProperties((Object)customerDetailVo, (Object)customerDetailDTO);
        }
        return BaseJsonVo.success((Object)customerDetailDTO);
    }

    public BaseJsonVo<CustomerDetailDTO> getCustomerByOpenId(String openId) {
        CustomerDetailDTO customerDetailDTO = new CustomerDetailDTO();
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(openId);
        if (customerDetailVo != null) {
            BeanUtils.copyProperties((Object)customerDetailVo, (Object)customerDetailDTO);
        }
        return BaseJsonVo.success((Object)customerDetailDTO);
    }

    public BaseJsonVo getCustomerInfoByOpenId(String openId) {
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(openId);
        return BaseJsonVo.success((Object)ObjectConvert.beanToMap((Object)customerDetailVo));
    }

    public BaseJsonVo addMamaInvite(String customerId, String bindcode) {
        QyInviteEntity param = new QyInviteEntity();
        param.setCustomerId(customerId);
        param.setBindCode(bindcode);
        List list = this.qyInviteInterface.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.error((String)"\u8be5\u7528\u6237\u5df2\u7ecf\u6dfb\u52a0\u5230\u4e86\u5206\u4eab\u4eba");
        }
        DistributorQiyeweixinExternalContactEntity param2 = new DistributorQiyeweixinExternalContactEntity();
        param2.setCustomerId(customerId);
        List list2 = this.distributorQiyeweixinExternalContactInterface.getList(param2);
        if (list2 == null || list2.size() == 0) {
            return BaseJsonVo.error((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4f01\u4e1a\u5fae\u4fe1\u8054\u7cfb\u4eba\u7684\u8bb0\u5f55");
        }
        DistributorQiyeweixinExternalContactEntity entity = (DistributorQiyeweixinExternalContactEntity)list2.get(0);
        QyInviteEntity inviteEntity = new QyInviteEntity();
        inviteEntity.setCustomerId(customerId);
        inviteEntity.setCustomerOpenId(entity.getExternalUserid());
        inviteEntity.setQyWeixinUserid(entity.getQyWeixinUserid());
        inviteEntity.setBindCode(bindcode);
        inviteEntity.setInviteCount(3);
        inviteEntity.setSendResult(null);
        inviteEntity.setCreateTime(DateUtils.now());
        this.qyInviteInterface.insert(inviteEntity);
        return BaseJsonVo.success(null);
    }

    public BaseJsonVo removeCustomerCache(String customerId) {
        this.customerInterface.removeCache(customerId);
        return BaseJsonVo.success(null);
    }
}

