/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.api;

import cc.lechun.cms.api.ShortLinkApi;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.minischeme.SchemeExprieTypeEnum;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.shortlink.ShortLinkInterface;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ShortLinkApiImpl
implements ShortLinkApi {
    private static final Logger logger = LoggerFactory.getLogger(ShortLinkApiImpl.class);
    @Autowired
    ShortLinkInterface shortLinkService;
    @Autowired
    MiniSchemeInterface miniSchemeInterface;

    public BaseJsonVo getShortLink(String link, String urlKey, String urlName) {
        if (StringUtils.isEmpty((String)link)) {
            logger.error("getShortLink-error:\u957f\u94fe\u63a5\u4e3a\u7a7a");
            return BaseJsonVo.error((String)"\u957f\u94fe\u63a5\u4e3a\u7a7a");
        }
        if (link.startsWith("http:") || link.startsWith("https:")) {
            String result = this.shortLinkService.getShorterUrl(link, urlKey, urlName);
            return StringUtils.isNotEmpty((String)result) ? BaseJsonVo.success((Object)result) : BaseJsonVo.error((String)"url\u91cd\u590d\uff0c\u8bf7\u6362\u4e00\u4e2a\u518d\u8bd5");
        }
        MiniSchemeEntity miniSchemeEntity = new MiniSchemeEntity();
        miniSchemeEntity.setPlatformId(PlatFormEnum.LECHUN_MINI.getValue());
        String[] page = link.split("\\?");
        miniSchemeEntity.setMiniPath(page[0]);
        miniSchemeEntity.setQueryPara(page.length > 1 ? page[1] : "");
        MiniSchemeEntity search = (MiniSchemeEntity)this.miniSchemeInterface.getSingle(miniSchemeEntity);
        if (search != null && search.getExpiredTime().after(new Date())) {
            return BaseJsonVo.success((Object)search.getShortLink());
        }
        miniSchemeEntity.setExpireType(SchemeExprieTypeEnum.temp.getValue());
        miniSchemeEntity.setCreateTime(new Date());
        miniSchemeEntity.setSchemeName(urlName + UUID.randomUUID());
        miniSchemeEntity.setSchemeType(0);
        BaseJsonVo jsonVo = this.miniSchemeInterface.saveMiniScheme(miniSchemeEntity);
        logger.info("getShortLink-error:jsonVo:{}", (Object)JsonUtils.toJson((Object)jsonVo, (boolean)false));
        if (jsonVo.isSuccess()) {
            return BaseJsonVo.success((Object)((MiniSchemeEntity)jsonVo.getValue()).getShortLink());
        }
        return BaseJsonVo.error((String)"\u751f\u6210\u77ed\u8fde\u63a5\u9519\u8bef");
    }
}

