/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.Lottry;

import cc.lechun.common.Lottry.LotteryVo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LotteryUtil {
    private static String lottery(List<LotteryVo> prizes) {
        String random = "";
        try {
            double randomNumber = Math.random();
            Optional<LotteryVo> optional = prizes.stream().filter(c -> c.getBeginCount() <= randomNumber && c.getEndCount() >= randomNumber).findFirst();
            if (optional.isPresent()) {
                random = optional.get().getKey();
            }
        }
        catch (Exception e) {
            System.out.println("\u751f\u6210\u62bd\u5956\u968f\u673a\u6570\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
        }
        return random;
    }

    public static Set<String> lottery(List<LotteryVo> prizes, long drawCount) {
        boolean b;
        long s = System.currentTimeMillis();
        HashSet<String> set = new HashSet<String>();
        if ((long)prizes.size() <= drawCount) {
            return prizes.stream().map(c -> c.getKey()).collect(Collectors.toSet());
        }
        boolean bl = b = drawCount > 0L;
        while (b) {
            set.add(LotteryUtil.lottery(prizes));
            if ((long)set.size() < drawCount) continue;
            b = false;
        }
        System.out.println("\u968f\u673a\u7528\u65f6\uff1a" + (System.currentTimeMillis() - s));
        return set;
    }

    public static void main(String[] args) {
        ArrayList<LotteryVo> l = new ArrayList<LotteryVo>();
        Double sumWeight = 0.0;
        for (int i = 0; i < 100; ++i) {
            double d = Math.random() * 100.0;
            sumWeight = sumWeight + d;
            l.add(new LotteryVo(String.valueOf(i), d, 0.0));
        }
        double d1 = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < l.size(); ++i) {
            d1 = i == 0 ? 0.0 : (d1 += ((LotteryVo)l.get(i - 1)).getBeginCount() / sumWeight);
            ((LotteryVo)l.get(i)).setBeginCount(d1);
            ((LotteryVo)l.get(i)).setEndCount(d2 += ((LotteryVo)l.get(i)).getBeginCount() / sumWeight);
        }
        Set<String> s = LotteryUtil.lottery(l, 1000L);
        System.out.println(s);
    }
}

