/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.login;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerLoginService {
    private static final Logger log = LoggerFactory.getLogger(CustomerLoginService.class);
    @Autowired
    CustomerInterface customerService;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Value(value="${shiro.cookie.name}")
    private String cookie_name;
    @Value(value="${topdomain:lechun.cc}")
    private String topdomain;

    public void login(HttpServletResponse response, HttpServletRequest request, String sign) {
        CookieUtils.addCookie((HttpServletResponse)response, (String)this.topdomain, (String)this.cookie_name, (String)sign, (int)86400);
    }

    public int getPlatFormId() {
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String value = request.getParameter("platformIdKey");
        if (StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)(value = request.getParameter("userTerminal"))) && StringUtils.isEmpty((String)(value = request.getParameter("platFormId")))) {
            return PlatFormEnum.YUANQI_WECHAT_MALL.getValue();
        }
        return Integer.parseInt(value);
    }

    public PlatFormAndGroupVo getPlatFormAndGroup() {
        return this.platFormInterface.getPlatFormAndGroup(this.getPlatFormId());
    }

    private Cookie getCookie(HttpServletRequest request) {
        return CookieUtils.getCookie((HttpServletRequest)request, (String)this.cookie_name);
    }
}

