/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.weixin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MessageUtil {
    public static Map<String, Object> parseXml(String msg) {
        return MessageUtil.parseXml(msg, new ArrayList<String>());
    }

    public static Map<String, Object> parseXmlOfWxContact(String msg) {
        ArrayList<String> nodeList = new ArrayList<String>();
        nodeList.add("extattr");
        nodeList.add("externalattr");
        nodeList.add("external_attr");
        return MessageUtil.parseXml(msg, new ArrayList<String>());
    }

    public static Map<String, Object> parseXml(String msg, List<String> nodeList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8.name()));){
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)inputStream);
            Element root = document.getRootElement();
            MessageUtil.parseElement(root, map, nodeList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static void parseElement(Element e, Map<String, Object> map, List<String> nodeList) {
        if (e.elements().size() > 0) {
            List elements = e.elements();
            if (MessageUtil.isList(elements, nodeList)) {
                ArrayList childList = new ArrayList();
                map.put(e.getName().toLowerCase(), childList);
                elements.forEach(element -> {
                    HashMap<String, Object> childMap = new HashMap<String, Object>();
                    childList.add(childMap);
                    MessageUtil.parseElement(element, childMap, nodeList);
                });
            } else {
                HashMap childMap = new HashMap();
                map.put(e.getName().toLowerCase(), childMap);
                elements.forEach(element -> MessageUtil.parseElement(element, childMap, nodeList));
            }
        } else {
            map.put(e.getName().toLowerCase(), e.getTextTrim());
        }
    }

    private static boolean isList(List<Element> elements, List<String> nodeList) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            String name = element.getName().toLowerCase();
            if (nodeList.contains(name)) {
                return true;
            }
            if (names.contains(name)) {
                return true;
            }
            names.add(name);
        }
        return false;
    }
}

