/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.enums.cashticket.CashComposeUseEnum;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.cashticket.ProductCashRuleTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleDetailMapper;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleDetailEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchVo;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.form.cashticket.CashUseRuleForm;
import cc.lechun.mall.form.cashticket.CashUseRuleItem;
import cc.lechun.mall.form.cashticket.ProductCashQueryVo;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import cc.lechun.mall.service.user.SysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketBatchNewRuleService
extends BaseService
implements CashticketBatchNewRuleInterface {
    @Autowired
    private CashticketBatchNewRuleDetailMapper cashticketBatchNewRuleDetailMapper;
    @Autowired
    private CashticketBatchNewRuleMapper cashticketBatchNewRuleMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    MallProductInterface productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private MallProductCategoryInterface productCategoryService;
    @Lazy
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private SysUserService sysUserService;

    @Override
    public List<CashticketBatchNewRuleVo> getCashRule(String ticketBatchId) {
        return this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
    }

    @Override
    public List<CashticketBatchNewRuleVo> getCashRule(String ticketBatchId, Integer ruleType, Integer platformGroupId) {
        List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        if (list != null) {
            return list.stream().filter(cashticketBatchNewRuleVo -> {
                boolean flag = false;
                if (cashticketBatchNewRuleVo.getRuleType().equals(ruleType)) {
                    flag = true;
                    cashticketBatchNewRuleVo.setDetailIdNames(this.getName(cashticketBatchNewRuleVo.getRuleType(), cashticketBatchNewRuleVo.getDetailIds(), platformGroupId));
                }
                return flag;
            }).collect(Collectors.toList());
        }
        return new ArrayList<CashticketBatchNewRuleVo>();
    }

    @Override
    public List<MallSelectDataVo> getCashRule(String ticketBatchId, Integer ruleType) {
        List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        CashticketBatchNewRuleVo cashticketBatchNewRuleVo = list.stream().filter(ruleVo -> Objects.equals(ruleVo.getRuleType(), ruleType)).findFirst().orElse(null);
        if (cashticketBatchNewRuleVo != null) {
            ArrayList<MallSelectDataVo> resultList = new ArrayList<MallSelectDataVo>();
            CashticketBatchNewRuleDetailEntity cashticketBatchNewRuleDetailEntity = new CashticketBatchNewRuleDetailEntity();
            cashticketBatchNewRuleDetailEntity.setRuleId(cashticketBatchNewRuleVo.getRuleId());
            List tempList = this.cashticketBatchNewRuleDetailMapper.getList(cashticketBatchNewRuleDetailEntity);
            for (CashticketBatchNewRuleDetailEntity item : tempList) {
                MallSelectDataVo mallSelectDataVo = new MallSelectDataVo();
                mallSelectDataVo.setName(this.getName(ruleType, item.getDetailId()));
                mallSelectDataVo.setId(item.getDetailId());
                mallSelectDataVo.setRuleDetailId(item.getId());
                resultList.add(mallSelectDataVo);
            }
            return resultList;
        }
        return new ArrayList<MallSelectDataVo>();
    }

    @Override
    public PageInfo getCashticketBatchUseRuleList(PageForm pageForm, String ticketBatchId, Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(cashticketBatchNewRuleVo -> {
                cashticketBatchNewRuleVo.setRuleTypeName(CashRuleTypeEnum.getName(cashticketBatchNewRuleVo.getRuleType()));
                cashticketBatchNewRuleVo.setDetailIdNames(this.getName(cashticketBatchNewRuleVo.getRuleType(), cashticketBatchNewRuleVo.getDetailIds(), platformGroupId));
            });
        }
        return pg;
    }

    private String getName(Integer ruleType, String detailIds, Integer platformGroupId) {
        String detailIdNames;
        block8: {
            String[] detailIdss;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                if (StringUtils.isEmpty((String)detailIds)) {
                                    return "";
                                }
                                detailIdss = detailIds.split(",");
                                detailIdNames = "";
                                if (ruleType.intValue() != CashRuleTypeEnum.danpin.getValue()) break block7;
                                MallProductEntity detail = null;
                                for (String str : detailIdss) {
                                    detail = this.productService.getProduct(str);
                                    if (detail == null) continue;
                                    detailIdNames = detailIdNames + detail.getProName() + ",";
                                }
                                break block8;
                            }
                            if (ruleType.intValue() != CashRuleTypeEnum.cuxiao.getValue()) break block9;
                            MallPromotionEntity detail = null;
                            for (String str : detailIdss) {
                                detail = this.mallPromotionService.getPromotion(str);
                                if (detail == null) continue;
                                detailIdNames = detailIdNames + detail.getPromotionName() + ",";
                            }
                            break block8;
                        }
                        if (ruleType.intValue() != CashRuleTypeEnum.taozhuang.getValue()) break block10;
                        MallProductGroupEntity detail = null;
                        for (String str : detailIdss) {
                            detail = this.mallGroupService.getGroup(str);
                            if (detail == null) continue;
                            detailIdNames = detailIdNames + detail.getGroupName() + ",";
                        }
                        break block8;
                    }
                    if (ruleType.intValue() != CashRuleTypeEnum.pingtai.getValue()) break block11;
                    PlatFormEntity detail = null;
                    for (String str : detailIdss) {
                        detail = this.platFormService.getPlatForm(Integer.parseInt(str));
                        if (detail == null) continue;
                        detailIdNames = detailIdNames + detail.getPlatformName() + ",";
                    }
                    break block8;
                }
                if (ruleType.intValue() != CashRuleTypeEnum.transport.getValue()) break block12;
                String detail = null;
                for (String str : detailIdss) {
                    detail = TransportTypeEnum.getName(Integer.parseInt(str));
                    if (detail == null) continue;
                    detailIdNames = detailIdNames + detail + ",";
                }
                break block8;
            }
            if (ruleType.intValue() != CashRuleTypeEnum.product_class.getValue()) break block8;
            MallProductCategoryEntity detail = null;
            for (String str : detailIdss) {
                detail = this.productCategoryService.getMallProductCategoryEntityById(str);
                if (detail == null) continue;
                detailIdNames = detailIdNames + detail.getCategoryName() + ",";
            }
        }
        return detailIdNames;
    }

    private String getName(Integer ruleType, String ruleDetailId) {
        String name = "";
        if (ruleType.intValue() == CashRuleTypeEnum.danpin.getValue()) {
            MallProductEntity detail = null;
            detail = this.productService.getProduct(ruleDetailId);
            if (detail != null) {
                name = detail.getProName();
            }
        } else if (ruleType.intValue() == CashRuleTypeEnum.cuxiao.getValue()) {
            MallPromotionEntity detail = null;
            detail = this.mallPromotionService.getPromotion(ruleDetailId);
            if (detail != null) {
                name = detail.getPromotionName();
            }
        } else if (ruleType.intValue() == CashRuleTypeEnum.taozhuang.getValue()) {
            MallProductGroupEntity detail = null;
            detail = this.mallGroupService.getGroup(ruleDetailId);
            if (detail != null) {
                name = detail.getGroupName();
            }
        } else if (ruleType.intValue() == CashRuleTypeEnum.pingtai.getValue()) {
            PlatFormEntity detail = null;
            detail = this.platFormService.getPlatForm(Integer.parseInt(ruleDetailId));
            if (detail != null) {
                name = detail.getPlatformName();
            }
        } else if (ruleType.intValue() == CashRuleTypeEnum.transport.getValue()) {
            name = TransportTypeEnum.getName(Integer.parseInt(ruleDetailId));
        } else if (ruleType.intValue() == CashRuleTypeEnum.product_class.getValue()) {
            MallProductCategoryEntity detail = null;
            detail = this.productCategoryService.getMallProductCategoryEntityById(ruleDetailId);
            if (detail != null) {
                name = detail.getCategoryName();
            }
        }
        return name;
    }

    @Override
    @Transactional
    public BaseJsonVo saveCashRule(CashUseRuleForm cashUseRuleForm) {
        this.removeCache(cashUseRuleForm.getTicketBatchId());
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(cashUseRuleForm.getTicketBatchId());
        qpq.setRuleType(cashUseRuleForm.getRuleType());
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        if (ls1 != null && ls1.size() > 0) {
            ls1.forEach(cashticketBatchNewRuleEntity -> this.deleteCashRule(cashticketBatchNewRuleEntity.getRuleId()));
        }
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity2 = new CashticketBatchNewRuleEntity();
        cashticketBatchNewRuleEntity2.setCreateTime(DateUtils.now());
        cashticketBatchNewRuleEntity2.setRuleType(cashUseRuleForm.getRuleType());
        cashticketBatchNewRuleEntity2.setStats(cashUseRuleForm.getStats());
        cashticketBatchNewRuleEntity2.setItemType(cashUseRuleForm.getItemType());
        cashticketBatchNewRuleEntity2.setTicketBatchId(cashUseRuleForm.getTicketBatchId());
        this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity2);
        if (cashUseRuleForm.getDetailIds() != null && cashUseRuleForm.getDetailIds().size() > 0) {
            cashUseRuleForm.getDetailIds().forEach(s -> {
                CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
                m.setCreateTime(DateUtils.now());
                m.setRuleId(cashticketBatchNewRuleEntity2.getRuleId());
                m.setDetailId((String)s);
                this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo saveCashRule(CashUseRuleItem cashUseRuleItem) {
        this.removeCache(cashUseRuleItem.getTicketBatchId());
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(cashUseRuleItem.getTicketBatchId());
        qpq.setRuleType(cashUseRuleItem.getRuleType());
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = new CashticketBatchNewRuleEntity();
        if (ls1 != null && ls1.size() > 0) {
            cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)ls1.get(0);
        } else {
            cashticketBatchNewRuleEntity.setCreateTime(DateUtils.now());
            cashticketBatchNewRuleEntity.setRuleType(cashUseRuleItem.getRuleType());
            cashticketBatchNewRuleEntity.setStats(cashUseRuleItem.getStats());
            cashticketBatchNewRuleEntity.setTicketBatchId(cashUseRuleItem.getTicketBatchId());
            this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity);
        }
        Long ruleId = cashticketBatchNewRuleEntity.getRuleId();
        if (cashUseRuleItem.getDetailIds() != null && cashUseRuleItem.getDetailIds().size() > 0) {
            cashUseRuleItem.getDetailIds().forEach(s -> {
                CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
                m.setCreateTime(DateUtils.now());
                m.setRuleId(ruleId);
                m.setDetailId((String)s);
                this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveCashRule(String ticketBatchId, Integer ruleType, String ruleDetailsId) {
        this.removeCache(ticketBatchId);
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(ticketBatchId);
        qpq.setRuleType(ruleType);
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = new CashticketBatchNewRuleEntity();
        if (CollectionUtils.isNotEmpty((Collection)ls1)) {
            cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)ls1.get(0);
        } else {
            cashticketBatchNewRuleEntity.setCreateTime(DateUtils.now());
            cashticketBatchNewRuleEntity.setRuleType(ruleType);
            cashticketBatchNewRuleEntity.setStats(3);
            cashticketBatchNewRuleEntity.setTicketBatchId(ticketBatchId);
            this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity);
        }
        Long ruleId = cashticketBatchNewRuleEntity.getRuleId();
        CashticketBatchNewRuleDetailEntity query = new CashticketBatchNewRuleDetailEntity();
        query.setRuleId(ruleId);
        query.setDetailId(ruleDetailsId);
        CashticketBatchNewRuleDetailEntity detailEntity = (CashticketBatchNewRuleDetailEntity)this.cashticketBatchNewRuleDetailMapper.getSingle(query);
        if (detailEntity != null && detailEntity.getId() != null) {
            return BaseJsonVo.error((String)"\u89c4\u5219\u5df2\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4fdd\u5b58");
        }
        CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
        m.setCreateTime(DateUtils.now());
        m.setRuleId(ruleId);
        m.setDetailId(ruleDetailsId);
        this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo saveCashRule(String ticketBatchId, Integer ruleType, Integer itemType, String ruleDetailsId) {
        this.removeCache(ticketBatchId);
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(ticketBatchId);
        qpq.setRuleType(ruleType);
        qpq.setItemType(itemType);
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = new CashticketBatchNewRuleEntity();
        if (CollectionUtils.isNotEmpty((Collection)ls1)) {
            cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)ls1.get(0);
        } else {
            cashticketBatchNewRuleEntity.setCreateTime(DateUtils.now());
            cashticketBatchNewRuleEntity.setRuleType(ruleType);
            cashticketBatchNewRuleEntity.setStats(3);
            cashticketBatchNewRuleEntity.setItemType(itemType);
            cashticketBatchNewRuleEntity.setTicketBatchId(ticketBatchId);
            this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity);
        }
        Long ruleId = cashticketBatchNewRuleEntity.getRuleId();
        CashticketBatchNewRuleDetailEntity query = new CashticketBatchNewRuleDetailEntity();
        query.setRuleId(ruleId);
        query.setDetailId(ruleDetailsId);
        CashticketBatchNewRuleDetailEntity detailEntity = (CashticketBatchNewRuleDetailEntity)this.cashticketBatchNewRuleDetailMapper.getSingle(query);
        if (detailEntity != null && detailEntity.getId() != null) {
            return BaseJsonVo.error((String)"\u89c4\u5219\u5df2\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u4fdd\u5b58");
        }
        CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
        m.setCreateTime(DateUtils.now());
        m.setRuleId(ruleId);
        m.setDetailId(ruleDetailsId);
        this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
        if (Objects.equals(itemType, ProductCashRuleTypeEnum.cash.getValue())) {
            this.saveBatchUseType(ticketBatchId, ruleType);
        } else if (Objects.equals(itemType, ProductCashRuleTypeEnum.cuxiao.getValue()) || Objects.equals(itemType, ProductCashRuleTypeEnum.danpin.getValue())) {
            int tempType = ProductCashRuleTypeEnum.danpin.getValue();
            if (Objects.equals(itemType, ProductCashRuleTypeEnum.cuxiao.getValue())) {
                tempType = CashRuleTypeEnum.cuxiao.getValue();
            }
            if (Objects.equals(itemType, ProductCashRuleTypeEnum.danpin.getValue())) {
                tempType = CashRuleTypeEnum.danpin.getValue();
            }
            this.saveCashRule(ruleDetailsId, tempType, ProductCashRuleTypeEnum.cash.getValue(), ticketBatchId);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void saveBatchUseType(String ticketBatchId, Integer ruleType) {
        if (ruleType.intValue() == CashRuleTypeEnum.danpin.getValue() || ruleType.intValue() == CashRuleTypeEnum.transport.getValue() || ruleType.intValue() == CashRuleTypeEnum.taozhuang.getValue() || ruleType.intValue() == CashRuleTypeEnum.cuxiao.getValue() || ruleType.intValue() == CashRuleTypeEnum.product_class.getValue()) {
            CashticketBatchEntity updateBatch = new CashticketBatchEntity();
            updateBatch.setUseType(2);
            updateBatch.setTicketBatchId(ticketBatchId);
            this.cashticketBatchInterface.saveCashticketBatch(updateBatch);
        }
    }

    @Override
    public List<CashticketBatchVo> getProductCashList(ProductCashQueryVo productCashQueryVo) {
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(productCashQueryVo.getItemId());
        qpq.setItemType(productCashQueryVo.getItemType());
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        if (CollectionUtils.isNotEmpty((Collection)ls1)) {
            Page page = PageHelper.startPage((int)productCashQueryVo.getCurrentPage(), (int)productCashQueryVo.getPageSize());
            page.setOrderBy("ID desc");
            CashticketBatchNewRuleDetailEntity cashticketBatchNewRuleDetailEntity = new CashticketBatchNewRuleDetailEntity();
            cashticketBatchNewRuleDetailEntity.setRuleId(((CashticketBatchNewRuleEntity)ls1.get(0)).getRuleId());
            this.cashticketBatchNewRuleDetailMapper.getList(cashticketBatchNewRuleDetailEntity);
            PageInfo pg = page.toPageInfo();
            if (pg.getList() != null && pg.getList().size() > 0) {
                return pg.getList().stream().map(o -> {
                    CashticketBatchVo cashticketBatchVo = new CashticketBatchVo();
                    CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(o.getDetailId());
                    BeanUtils.copyProperties((Object)cashticketBatchEntity, (Object)cashticketBatchVo);
                    cashticketBatchVo.setCreateTypeName(CashCreateTypeEnum.getName(cashticketBatchEntity.getCreateType().shortValue()));
                    cashticketBatchVo.setCashComposeUseName(CashComposeUseEnum.getName(cashticketBatchEntity.getComposeUse()));
                    cashticketBatchVo.setDiscountModeName(CashDiscountModeEnum.getName(cashticketBatchEntity.getDiscountMode().shortValue()));
                    cashticketBatchVo.setDiscountOrAmount(cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() ? cashticketBatchEntity.getAmount() + "" : cashticketBatchEntity.getDiscountAmount() + "");
                    cashticketBatchVo.setUserName(this.sysUserService.getMallUserNickName(cashticketBatchVo.getCreateUserid()));
                    return cashticketBatchVo;
                }).collect(Collectors.toList());
            }
        }
        return new ArrayList<CashticketBatchVo>();
    }

    @Override
    @Transactional
    public BaseJsonVo deleteCashRule(Long ruleId) {
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)this.cashticketBatchNewRuleMapper.selectByPrimaryKey(ruleId);
        if (cashticketBatchNewRuleEntity != null) {
            this.logger.info("\u5220\u9664\u5238\u6279\u6b21id:{}\u4f7f\u7528\u89c4\u5219", (Object)cashticketBatchNewRuleEntity.getTicketBatchId());
            this.removeCache(cashticketBatchNewRuleEntity.getTicketBatchId());
            this.cashticketBatchNewRuleMapper.deleteByPrimaryKey(ruleId);
            CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
            qpq.setTicketBatchId(cashticketBatchNewRuleEntity.getTicketBatchId());
            List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
            boolean productType = false;
            if (ls1 != null && ls1.size() > 0) {
                productType = ls1.stream().anyMatch(rule -> {
                    Integer ruleTypeId = rule.getRuleType();
                    return ruleTypeId.intValue() == CashRuleTypeEnum.transport.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.taozhuang.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.cuxiao.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.product_class.getValue();
                });
            }
            if (!productType) {
                CashticketBatchEntity updateBatch = new CashticketBatchEntity();
                updateBatch.setUseType(1);
                updateBatch.setTicketBatchId(cashticketBatchNewRuleEntity.getTicketBatchId());
                this.cashticketBatchInterface.saveCashticketBatch(updateBatch);
            }
            CashticketBatchNewRuleDetailEntity qpc = new CashticketBatchNewRuleDetailEntity();
            qpc.setRuleId(cashticketBatchNewRuleEntity.getRuleId());
            List ls = this.cashticketBatchNewRuleDetailMapper.getList(qpc);
            if (ls != null && ls.size() > 0) {
                ls.forEach(cashticketBatchNewRuleDetailEntity -> this.cashticketBatchNewRuleDetailMapper.deleteByPrimaryKey(cashticketBatchNewRuleDetailEntity.getId()));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo deleteCashRuleDetail(Long ruleDetailId, String ticketBatchId, Integer ruleType) {
        List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        if (CollectionUtils.isNotEmpty(list) && list.size() == 1) {
            CashticketBatchNewRuleDetailEntity query = new CashticketBatchNewRuleDetailEntity();
            query.setRuleId(list.get(0).getRuleId());
            List tempList = this.cashticketBatchNewRuleDetailMapper.getList(query);
            if (CollectionUtils.isNotEmpty((Collection)tempList) && tempList.size() == 1) {
                CashticketBatchEntity updateBatch = new CashticketBatchEntity();
                updateBatch.setUseType(1);
                updateBatch.setTicketBatchId(ticketBatchId);
                this.cashticketBatchInterface.saveCashticketBatch(updateBatch);
            }
        }
        CashticketBatchNewRuleVo cashticketBatchNewRuleVo = list.stream().filter(ruleVo -> Objects.equals(ruleVo.getRuleType(), ruleType)).findFirst().get();
        CashticketBatchNewRuleDetailEntity query = new CashticketBatchNewRuleDetailEntity();
        query.setRuleId(cashticketBatchNewRuleVo.getRuleId());
        List tempList = this.cashticketBatchNewRuleDetailMapper.getList(query);
        if (CollectionUtils.isNotEmpty((Collection)tempList) && tempList.size() == 1) {
            this.cashticketBatchNewRuleMapper.deleteByPrimaryKey(cashticketBatchNewRuleVo.getRuleId());
        }
        this.cashticketBatchNewRuleDetailMapper.deleteByPrimaryKey(ruleDetailId);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo deleteProductCashRule(String itemId, Integer itemType, Integer ruleType, String ticketBatchId) {
        List<MallSelectDataVo> list;
        List temp;
        CashticketBatchNewRuleEntity query = new CashticketBatchNewRuleEntity();
        query.setItemType(itemType);
        query.setTicketBatchId(itemId);
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)this.cashticketBatchNewRuleMapper.getSingle(query);
        if (cashticketBatchNewRuleEntity != null) {
            CashticketBatchNewRuleDetailEntity detailQuery = new CashticketBatchNewRuleDetailEntity();
            detailQuery.setRuleId(cashticketBatchNewRuleEntity.getRuleId());
            List tempList = this.cashticketBatchNewRuleDetailMapper.getList(detailQuery);
            if (CollectionUtils.isNotEmpty((Collection)tempList)) {
                for (CashticketBatchNewRuleDetailEntity detailEntity : tempList) {
                    this.cashticketBatchNewRuleDetailMapper.deleteByPrimaryKey(detailEntity.getId());
                }
            }
            this.cashticketBatchNewRuleMapper.deleteByPrimaryKey(cashticketBatchNewRuleEntity.getRuleId());
        }
        if (CollectionUtils.isNotEmpty(temp = (list = ((CashticketBatchNewRuleService)SpringContextUtil.getBean(this.getClass())).getCashRule(ticketBatchId, SalesTypeEnum.SALES_PROMOTION.getValue())).stream().filter(ruleVo -> Objects.equals(itemId, ruleVo.getId())).collect(Collectors.toList()))) {
            list.forEach(ruleVo -> ((CashticketBatchNewRuleService)SpringContextUtil.getBean(this.getClass())).deleteCashRule(ruleVo.getRuleDetailId()));
        }
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashRule", ticketBatchId);
        this.memcachedService.delete("CashticketBatchNewRuleService.getCashRule", new String[]{ticketBatchId, "0"});
    }
}

