/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.form.cash.CashticketBatchQuaryForm;
import cc.lechun.apiinvoke.mall.YouShuCashInvoke;
import cc.lechun.apiinvoke.message.GroupRuleInvoke;
import cc.lechun.common.enums.cashticket.CashBathStatusEnum;
import cc.lechun.common.enums.cashticket.CashComposeUseEnum;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashPeriodTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketUserInfoEntity;
import cc.lechun.mall.entity.cashticket.EnableCashticketVo;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.service.cashticket.CashticketClassService;
import cc.lechun.mall.service.cashticket.CashticketService;
import cc.lechun.mall.service.cashticket.CashticketUserInfoService;
import cc.lechun.mall.service.user.SysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketBatchService
extends BaseService
implements CashticketBatchInterface {
    @Autowired
    private CashticketBatchMapper cashticketBatchMapper;
    @Autowired
    private CashticketUserInfoService cashticketUserInfoService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CashticketClassService cashticketClassService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private GroupRuleInvoke groupRuleInvoke;
    @Autowired
    YouShuCashInvoke youShuCashInvoke;

    @Override
    public BaseJsonVo setTakedNum(String ticketBatchId, Integer num) {
        return this.cashticketBatchMapper.setTakedNum(ticketBatchId, num) > 0 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public CashticketBatchEntity getCashticketBatchByTicketNo(String ticketNo) {
        CashticketBatchEntity temp = new CashticketBatchEntity();
        temp.setTicketNo(ticketNo);
        return (CashticketBatchEntity)this.cashticketBatchMapper.getSingle(temp);
    }

    @Override
    public CashticketBatchEntity getCashticketBatch(@ParameterValueKeyProvider String ticketBatchId) {
        return (CashticketBatchEntity)this.cashticketBatchMapper.selectByPrimaryKey((Serializable)((Object)ticketBatchId));
    }

    @Override
    @Transactional
    public BaseJsonVo addCashticketBatch(CashticketBatchEntity cashticketBatchEntity) {
        BaseJsonVo vo = this.validateCash(cashticketBatchEntity);
        if (!vo.isSuccess()) {
            return vo;
        }
        cashticketBatchEntity.setTicketBatchId(IDGenerate.getUniqueID() + "");
        cashticketBatchEntity.setCreateTime(DateUtils.now());
        this.cashticketBatchMapper.insertSelective(cashticketBatchEntity);
        if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
            this.cashticketService.addCashTicketNos(cashticketBatchEntity.getTicketBatchId());
        }
        BaseJsonVo baseJsonVo = this.youShuCashInvoke.addCoupon(cashticketBatchEntity.getTicketBatchId());
        this.logger.info("\u6709\u6570\u5361\u5238\u6279\u6b21:{}\u4e0a\u62a5:{}", (Object)cashticketBatchEntity.getTicketBatchName(), (Object)baseJsonVo.getMessage());
        return BaseJsonVo.success((Object)cashticketBatchEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo updateCashticketBatch(CashticketBatchEntity cashticketBatchEntity, String userId) {
        String tempUserId = cashticketBatchEntity.getCreateUserid();
        cashticketBatchEntity.setCreateUserid(userId);
        BaseJsonVo vo = this.validateCash(cashticketBatchEntity);
        if (!vo.isSuccess()) {
            return vo;
        }
        cashticketBatchEntity.setCreateUserid(tempUserId);
        this.removeCache(cashticketBatchEntity.getTicketBatchId());
        this.cashticketBatchMapper.updateByPrimaryKeySelective(cashticketBatchEntity);
        if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
            this.cashticketService.addCashTicketNos(cashticketBatchEntity.getTicketBatchId());
        }
        BaseJsonVo baseJsonVo = this.youShuCashInvoke.addCoupon(cashticketBatchEntity.getTicketBatchId());
        this.logger.info("\u6709\u6570\u5361\u5238\u6279\u6b21:{}\u4e0a\u62a5:{}", (Object)cashticketBatchEntity.getTicketBatchName(), (Object)baseJsonVo.getMessage());
        return BaseJsonVo.success((Object)cashticketBatchEntity);
    }

    @Override
    public BaseJsonVo saveCashticketBatch(CashticketBatchEntity cashticketBatchEntity) {
        this.removeCache(cashticketBatchEntity.getTicketBatchId());
        this.cashticketBatchMapper.updateByPrimaryKeySelective(cashticketBatchEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteCashticketBatch(String ticketBatchId) {
        CashticketBatchEntity cashticketBatchEntity = this.getCashticketBatch(ticketBatchId);
        if (cashticketBatchEntity == null) {
            BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21");
        }
        cashticketBatchEntity.setStatus(CashBathStatusEnum.jinyong.getValue());
        this.cashticketBatchMapper.updateByPrimaryKeySelective(cashticketBatchEntity);
        this.removeCache(ticketBatchId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo importCoupon(Integer platformGroupId) {
        return this.youShuCashInvoke.importCoupon(platformGroupId);
    }

    @Override
    public BaseJsonVo importCustomerCoupon() {
        return this.youShuCashInvoke.importCustomerCoupon();
    }

    @Override
    public PageInfo getCashticketBatchList(PageForm pageForm, CashticketBatchQuaryForm cashticketBatchQuaryForm, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("CREATE_TIME desc");
        this.cashticketBatchMapper.getCashticketBatchList(cashticketBatchQuaryForm, platformGroupId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                o.setCreateTypeName(CashCreateTypeEnum.getName(o.getCreateType().shortValue()));
                o.setCashComposeUseName(CashComposeUseEnum.getName(o.getComposeUse()));
                o.setDiscountModeName(CashDiscountModeEnum.getName(o.getDiscountMode().shortValue()));
                o.setTicetClassName(o.getTicetClass() == null ? "" : this.cashticketClassService.getCashticketClassName(o.getPlatformGroupId(), o.getTicetClass()));
                o.setDiscountOrAmount(o.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() ? o.getAmount() + "" : o.getDiscountAmount() + "");
                o.setUserName(this.sysUserService.getMallUserNickName(o.getCreateUserid()));
            });
        }
        return pg;
    }

    private BaseJsonVo validateCash(CashticketBatchEntity cashticketBatchEntity) {
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u53c2\u6570");
        }
        if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketBatchName())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u4f18\u60e0\u52b5\u540d\u79f0");
        }
        CashticketUserInfoEntity cashticketUserInfo = this.cashticketUserInfoService.getCashticketUserInfo(cashticketBatchEntity.getCreateUserid());
        if (cashticketUserInfo == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6743\u9650\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (cashticketUserInfo.getMaxValue() > 0 && cashticketBatchEntity.getAmount().intValue() > cashticketUserInfo.getMaxValue()) {
            return BaseJsonVo.paramError((String)"\u8d85\u8fc7\u6700\u5927\u521b\u5efa\u91d1\u989d");
        }
        int count = cashticketBatchEntity.getQuantity();
        if (cashticketBatchEntity.getCreateType().shortValue() == CashCreateTypeEnum.ma.getValue()) {
            count = cashticketBatchEntity.getQuantity() * cashticketBatchEntity.getTicketNoNum();
        }
        this.logger.info("userId={}, count\u662f:{}\uff0cMaxNum\u662f", new Object[]{cashticketBatchEntity.getCreateUserid(), count, cashticketUserInfo.getMaxNum()});
        if (cashticketUserInfo.getMaxNum() > 0 && count > cashticketUserInfo.getMaxNum()) {
            return BaseJsonVo.paramError((String)"\u8d85\u8fc7\u6700\u5927\u521b\u5efa\u6570\u91cf");
        }
        if (cashticketBatchEntity.getTicetClass() == null || cashticketBatchEntity.getTicetClass() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7c7b");
        }
        if (cashticketBatchEntity.getPeriodType().intValue() == CashPeriodTypeEnum.riqi.getValue()) {
            if (cashticketBatchEntity.getBeginTime() == null || cashticketBatchEntity.getEndTime() == null) {
                return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u65e5\u671f");
            }
            cashticketBatchEntity.setEndTime(DateUtils.StrToDate((String)(DateUtils.formatDate((Date)cashticketBatchEntity.getEndTime(), (String)"yyyy-MM-dd") + " 23:59:59"), (String)""));
        }
        if (cashticketBatchEntity.getCreateType().shortValue() == CashCreateTypeEnum.ma.getValue()) {
            CashticketBatchEntity temp;
            if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketNo())) {
                return BaseJsonVo.paramError((String)"\u9519\u8bef\u7684\u4f18\u60e0\u7801");
            }
            if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketBatchId()) ? (temp = this.getCashticketBatchByTicketNo(cashticketBatchEntity.getTicketNo())) != null : (temp = this.getCashticketBatchByTicketNo(cashticketBatchEntity.getTicketNo())) != null && !temp.getTicketBatchId().equals(cashticketBatchEntity.getTicketBatchId())) {
                return BaseJsonVo.paramError((String)"\u4f18\u60e0\u7801\u91cd\u590d");
            }
        }
        return BaseJsonVo.success(null);
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashticketBatch", ticketBatchId);
    }

    @Override
    public List<CashticketBatchEntity> getCashticketBatchForOption() {
        CashticketBatchEntity entity = new CashticketBatchEntity();
        entity.setStatus(1);
        List cashticketBatchEntities = this.cashticketBatchMapper.getList(entity);
        cashticketBatchEntities.sort((c1, c2) -> c1.getTicketBatchName().compareTo(c2.getTicketBatchName()));
        return cashticketBatchEntities;
    }

    @Override
    public PageInfo getCashticketBatchForOption(PageForm pageForm, Integer platFormGroupId, String ticketBatchName) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("CREATE_TIME desc");
        this.cashticketBatchMapper.getEnableCashticketList(platFormGroupId, ticketBatchName);
        PageInfo pg = page.toPageInfo();
        PageInfo pageInfo = new PageInfo();
        if (pg != null) {
            List list = pg.getList();
            ArrayList enableCashticketVoList = new ArrayList();
            if (list != null && list.size() >= 1) {
                list.forEach(c -> {
                    EnableCashticketVo vo = new EnableCashticketVo();
                    BeanUtils.copyProperties((Object)c, (Object)vo);
                    vo.setAmount(c.getDiscountMode().intValue() == CashDiscountModeEnum.manjian.getValue() ? c.getAmount() + "\u5143" : (c.getDiscountMode().intValue() == CashDiscountModeEnum.zhekou.getValue() ? c.getDiscountAmount() + "\u6298" : ""));
                    vo.setUserName(this.sysUserService.getMallUserNickName(c.getCreateUserid()));
                    enableCashticketVoList.add(vo);
                });
            }
            pageInfo.setList(enableCashticketVoList);
            pageInfo.setTotal(pg.getTotal());
        }
        return pageInfo;
    }
}

