/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.dto.CashQueryDTO;
import cc.lechun.cms.dto.CashticketRemarkVo;
import cc.lechun.cms.dto.GroupUserlDTO;
import cc.lechun.common.enums.cashticket.CashBathStatusEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashRuleStatusEnum;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.cashticket.CashticketCustomerRecordVo;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.cashticket.CashticketSimpleVo;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchNewRuleService;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import cc.lechun.mall.service.cashticket.CashticketService;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketCustomerService
extends BaseService
implements CashticketCustomerInterface {
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;
    @Autowired
    private CashticketBatchNewRuleService cashticketBatchNewRuleService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private ActiveInterface activeService;

    @Override
    public List<GroupUserlDTO> getCashCustomerList(CashQueryDTO cashQueryDTO) {
        List<CashticketSimpleVo> list = this.cashticketCustomerMapper.getCashCustomerList(cashQueryDTO);
        List<Object> result = new ArrayList<GroupUserlDTO>();
        if (list.size() > 0) {
            result = list.stream().map(cashticketSimpleVo -> {
                GroupUserlDTO groupUserlDTO = new GroupUserlDTO();
                groupUserlDTO.setCustomerId(cashticketSimpleVo.getCustomerId());
                groupUserlDTO.setOpenId("");
                groupUserlDTO.setMobile("");
                CashticketRemarkVo cashticketRemarkVo = new CashticketRemarkVo();
                cashticketRemarkVo.setAmount(cashticketSimpleVo.getAmount());
                cashticketRemarkVo.setTicketBatchName(cashticketSimpleVo.getTicketBatchName());
                cashticketRemarkVo.setEndTime(cashticketSimpleVo.getEndTime());
                cashticketRemarkVo.setAmount(cashticketSimpleVo.getAmount());
                cashticketRemarkVo.setDiscountAmount(cashticketSimpleVo.getDiscountAmount());
                cashticketRemarkVo.setDiscountMode(cashticketSimpleVo.getDiscountMode());
                cashticketRemarkVo.setMinUseamount(cashticketSimpleVo.getMinUseamount());
                String strJson = JSONObject.toJSONString((Object)cashticketRemarkVo);
                this.logger.info("{}", (Object)strJson);
                groupUserlDTO.setRemark(strJson);
                return groupUserlDTO;
            }).collect(Collectors.toList());
            HashSet<GroupUserlDTO> set = new HashSet<GroupUserlDTO>(result);
            result.clear();
            result.addAll(set);
        }
        return result;
    }

    @Override
    public PageInfo<CashticketCustomerRecordVo> getCustomerCashticketList(String ticketBatchId, String start, String end, String customerId, Integer status, Integer pageSize, Integer pageCount) {
        Page page = PageHelper.startPage((int)pageCount, (int)pageSize);
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        List<CashticketCustomerEntity> tempList = this.cashticketCustomerMapper.getCustomerCashList(customerId, start, end, ticketBatchId, status);
        PageInfo pg = page.toPageInfo();
        ArrayList list = new ArrayList();
        tempList.forEach(o -> {
            if (StringUtils.isEmpty((String)o.getTicketBatchId())) {
                return;
            }
            CashticketCustomerRecordVo c = new CashticketCustomerRecordVo();
            BeanUtils.copyProperties((Object)o, (Object)c);
            CashticketEntity cashticketEntity = this.cashticketService.getCashticket(o.getTicketId());
            if (cashticketEntity != null) {
                BeanUtils.copyProperties((Object)cashticketEntity, (Object)c);
            }
            if (o.getEndTime() != null && o.getEndTime().before(DateUtils.now()) && o.getStatus() == 1) {
                c.setStatus(3);
            }
            c.setCashStatusName(CashStatusEnum.getName(c.getStatus()));
            c.setEndTime(o.getEndTime());
            c.setBeginTime(o.getBeginTime());
            this.logger.info("{},{}", (Object)cashticketEntity, (Object)c);
            CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(o.getTicketBatchId());
            if (cashticketBatchEntity != null) {
                c.setAmountMin(cashticketBatchEntity.getMinUseamount());
                c.setUsedRule(StringUtils.isNotEmpty((String)cashticketBatchEntity.getRemark()) ? cashticketBatchEntity.getRemark() : "");
                if (cashticketBatchEntity.getStatus().intValue() == CashStatusEnum.jinyong.getValue() && c.getStatus().intValue() == CashStatusEnum.yijihuo.getValue()) {
                    c.setStatus(CashStatusEnum.jinyong.getValue());
                }
            }
            if (StringUtils.isNotEmpty((String)o.getBindCode())) {
                ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(o.getBindCode());
                c.setSourceActiveNo(activeEntity == null ? "" : activeEntity.getActiveName());
            }
            list.add(c);
        });
        pg.setList(list);
        return pg;
    }

    @Override
    public int getCashticketTicketId(String bindCode, String customerId) {
        return this.cashticketCustomerMapper.getCashticketTicketId(customerId, bindCode);
    }

    public CashticketCustomerEntity getCashticketCustomer(int ticketCustomerId) {
        return (CashticketCustomerEntity)this.cashticketCustomerMapper.selectByPrimaryKey(Integer.valueOf(ticketCustomerId));
    }

    @Override
    @Transactional
    public BaseJsonVo useCashTicketCustomer(String customerId, int ticketCustomerId, String orderMainNo, BigDecimal realyDeduction) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        if (!cashticketCustomerEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u4f18\u60e0\u52b5");
        }
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketCustomerEntity.getTicketBatchId());
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(cashticketBatchEntity.getPlatformGroupId(), customerId, ticketCustomerId, 1);
        if (ls == null || ls.size() == 0) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u5df2\u5931\u6548");
        }
        if (this.cashticketCustomerMapper.updateCustomerCashStasusUse(customerId, orderMainNo, realyDeduction, ticketCustomerId) <= 0) {
            return BaseJsonVo.paramError((String)"\u4f18\u60e0\u52b5\u65e0\u6cd5\u4f7f\u7528");
        }
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yishiyong);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo returnCashTicketCustomer(int ticketCustomerId, String orderMainNo) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            CashticketCustomerEntity query = new CashticketCustomerEntity();
            query.setTicketId(ticketCustomerId);
            query.setOrderMainNo(orderMainNo);
            query.setStatus(CashStatusEnum.yishiyong.getValue());
            cashticketCustomerEntity = (CashticketCustomerEntity)CollectionUtils.listToEntiy((List)this.cashticketCustomerMapper.getList(query));
        }
        cashticketCustomerEntity.setOrderMainNo("");
        cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity);
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yijihuo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getCashticketGetList(PageForm pageForm, String ticketBatchId, String ticketNo, Integer status) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketCustomerMapper.getCashticketGetList(ticketBatchId, ticketNo, status);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                o.setCodeStatusName(CashStatusEnum.getName(o.getCodeStatus()));
                o.setCashStatusName(CashStatusEnum.getName(o.getCashStatus()));
            });
        }
        return pg;
    }

    private CashticketVo getCashticketVo(CashticketSimpleVo simpleVo, boolean status, BigDecimal enableCashticketAmount) {
        CashticketVo vo = new CashticketVo();
        vo.setTicketCustomerId(simpleVo.getTicketCustomerId());
        vo.setTicketBatchName(simpleVo.getTicketBatchName());
        vo.setTimes(DateUtils.formatDate((Date)simpleVo.getBeginTime(), (String)"yyyy.MM.dd") + "-" + DateUtils.formatDate((Date)simpleVo.getEndTime(), (String)"yyyy.MM.dd"));
        vo.setEnable(this.getCashStatus(simpleVo, status));
        vo.setTicketAmount(simpleVo.getAmount());
        vo.setDiscountMode(simpleVo.getDiscountMode().shortValue());
        vo.setDiscountAmount(MathUtils.divBigDecimal((Number)simpleVo.getDiscountAmount(), (Number)10, (Integer)2));
        vo.setRemark(simpleVo.getRemark());
        vo.setEnableCashticketAmount(enableCashticketAmount);
        if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            vo.setTicketAmount(enableCashticketAmount);
        }
        return vo;
    }

    private int getCashStatus(CashticketSimpleVo simpleVo, boolean status) {
        if (status) {
            return CashStatusEnum.yijihuo.getValue();
        }
        if (simpleVo.getBatchStatus().intValue() == CashBathStatusEnum.jinyong.getValue()) {
            return CashStatusEnum.jinyong.getValue();
        }
        if (simpleVo.getTicketStatus().intValue() == CashStatusEnum.yishiyong.getValue()) {
            return CashStatusEnum.yishiyong.getValue();
        }
        return CashStatusEnum.guoqi.getValue();
    }

    private boolean getCashUseStatus(Map<Integer, CashticketBatchNewRuleVo> rule_map, String detail_id, int cash_rule_type, int platFormId, String bindCode) {
        if (rule_map != null && rule_map.size() > 0) {
            CashticketBatchNewRuleVo rule_vo;
            boolean flag = false;
            CashticketBatchNewRuleVo rule_plat_vo = rule_map.get(CashRuleTypeEnum.pingtai.getValue());
            if (rule_plat_vo != null) {
                if (rule_map.keySet().size() == 1) {
                    flag = true;
                }
                if (rule_plat_vo.getStats().intValue() != CashRuleStatusEnum.quanbu.getValue()) {
                    if (StringUtils.isEmpty((String)rule_plat_vo.getDetailIds())) {
                        return false;
                    }
                    List<String> rule_detail_list = Arrays.asList(rule_plat_vo.getDetailIds().split(","));
                    if (!rule_detail_list.contains(platFormId + "")) {
                        return false;
                    }
                }
            }
            if ((rule_vo = rule_map.get(cash_rule_type)) == null) {
                return flag;
            }
            if (rule_vo.getStats().intValue() != CashRuleStatusEnum.quanbu.getValue()) {
                if (StringUtils.isEmpty((String)rule_vo.getDetailIds())) {
                    return false;
                }
                List<String> rule_detail_list = Arrays.asList(rule_vo.getDetailIds().split(","));
                if (!rule_detail_list.contains(detail_id)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Integer getCashticketCount(String customerId, Integer enable) {
        return this.cashticketCustomerMapper.getCashticketCount(customerId, enable);
    }
}

