/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.thread.ThreadPool;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchMapper;
import cc.lechun.mall.dao.cashticket.CashticketMapper;
import cc.lechun.mall.entity.cashticket.CashticketActivTionVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketService
extends BaseService
implements CashticketInterface {
    @Autowired
    private CashticketMapper cashticketMapper;
    @Autowired
    private CashticketBatchMapper cashticketBatchService;
    @Autowired
    private CashticketCustomerService cashticketCustomerService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo setCashCache() {
        ThreadPool.services.execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 96; ++i) {
                    Page page = PageHelper.startPage((int)i, (int)10000);
                    CashticketService.this.cashticketMapper.getCashticketListByOld();
                    PageInfo pageInfo = page.toPageInfo();
                    if (pageInfo == null || pageInfo.getList() == null || pageInfo.getList().size() <= 0) continue;
                    pageInfo.getList().forEach(c -> {
                        if (c != null && StringUtils.isNotEmpty((String)c.toString())) {
                            boolean temp = CashticketService.this.redisService.sadd("ticketNo", c);
                            CashticketService.this.logger.info("\u4f18\u60e0\u5238\u7801:{}\uff0c\u6dfb\u52a0\u5230redis:{}", c, (Object)temp);
                        }
                    });
                }
            }
        });
        return BaseJsonVo.success((Object)"\u7a0b\u5e8f\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u5019....");
    }

    @Override
    public CashticketEntity getCashticket(int ticketId) {
        return (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId));
    }

    @Override
    public CashticketEntity getCashticket4No(String ticketNo) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketNo(ticketNo);
        List ls = this.cashticketMapper.getList(cashticketEntity);
        if (ls != null && ls.size() > 0) {
            return (CashticketEntity)ls.get(0);
        }
        return null;
    }

    @Override
    public List<CashticketEntity> getCashticketList(String ticketBatchId, CashStatusEnum status) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        if (status != null) {
            cashticketEntity.setStatus(status.getValue());
        }
        cashticketEntity.setTicketBatchId(ticketBatchId);
        return this.cashticketMapper.getList(cashticketEntity);
    }

    @Override
    public CashticketActivTionVo getWaitActivtionCashticketList(String ticketBatchId) {
        return this.cashticketMapper.getWaitActivtionCashticketList(ticketBatchId);
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = new CashticketEntity()) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                cashticketEntity.setLaststatus(CashStatusEnum.yijihuo.getValue());
            }
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum, CashticketBatchEntity cashticketBatchEntity) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId))) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(cashticketEntity.getActivtionCount() + 1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            }
            if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                if (this.cashticketMapper.updateStatusByPrimaryKeySelective(cashticketEntity) == 1) {
                    return true;
                }
            } else {
                this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketAmount(int ticketId, double amount) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId))) != null) {
            cashticketEntity.setTicketAmount(new BigDecimal(amount));
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            return this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity) == 1;
        }
        return false;
    }

    @Override
    @Transactional
    public BaseJsonVo addCashTicketNos(String ticketBatchId) {
        final CashticketBatchEntity cashticketBatchEntity = (CashticketBatchEntity)this.cashticketBatchService.selectByPrimaryKey((Serializable)((Object)ticketBatchId));
        if (cashticketBatchEntity == null) {
            BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21");
        }
        int ticketNoNum = 0;
        ticketNoNum = cashticketBatchEntity.getCreateType().shortValue() == CashCreateTypeEnum.ma.getValue() ? cashticketBatchEntity.getTicketNoNum().intValue() : cashticketBatchEntity.getQuantity().intValue();
        int count = this.cashticketMapper.getCashTicketCount(cashticketBatchEntity.getTicketBatchId());
        if ((ticketNoNum -= count) > 0) {
            int size_count = 100;
            int size = ticketNoNum / size_count + 1;
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) {
                    size_count = (ticketNoNum + size_count) % size_count;
                }
                final int param = size_count;
                ThreadPool.services.execute(new Runnable(){

                    @Override
                    public void run() {
                        CashticketService.this.addCashTicketNos(cashticketBatchEntity, param);
                    }
                });
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private void addCashTicketNos(CashticketBatchEntity cashticketBatchEntity, int ticketNoNum) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        cashticketEntity.setTicketName(cashticketBatchEntity.getTicketBatchName());
        cashticketEntity.setTicketAmount(cashticketBatchEntity.getAmount());
        cashticketEntity.setStatus(CashStatusEnum.weijihuo.getValue());
        cashticketEntity.setActivtionCount(0);
        int k = 0;
        long new_ticketNoNum = MathUtils.mulBigDecimal((Number)ticketNoNum, (Number)3).longValue();
        int i = 0;
        while ((long)i < new_ticketNoNum && k < ticketNoNum) {
            cashticketEntity.setCreateTime(DateUtils.now());
            if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                cashticketEntity.setTicketNo(this.getTicketNo(cashticketBatchEntity.getTicketPosition()));
            } else {
                cashticketEntity.setTicketNo(this.getTicketNo());
            }
            try {
                int l = this.cashticketMapper.insertSelective(cashticketEntity);
                if (l > 0 && cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                    this.redisService.sadd("ticketNo", cashticketEntity.getTicketNo());
                    ++k;
                }
            }
            catch (Exception e) {
                this.logger.error("\u5151\u6362\u7801\u91cd\u590d \u4e0d\u9700\u8981\u5904\u7406", (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public CashticketEntity addCashTicketNos(CashticketBatchEntity cashticketBatchEntity) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        cashticketEntity.setTicketName(cashticketBatchEntity.getTicketBatchName());
        cashticketEntity.setTicketAmount(cashticketBatchEntity.getAmount());
        cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        cashticketEntity.setActivtionCount(1);
        int k = 0;
        cashticketEntity.setCreateTime(DateUtils.now());
        cashticketEntity.setTicketNo(this.getTicketNo());
        cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        try {
            int l = this.cashticketMapper.insertSelective(cashticketEntity);
            if (l > 0) {
                return cashticketEntity;
            }
            if (++k < 10) {
                return this.addCashTicketNos(cashticketBatchEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketEntity.toString());
        }
        return null;
    }

    private String getTicketNo(int ticketPosition) {
        String randNo = RandomUtils.generateString((int)ticketPosition);
        if (this.redisService.sIsMember("ticketNo", randNo = randNo.toUpperCase())) {
            return this.getTicketNo(ticketPosition);
        }
        return randNo;
    }

    private String getTicketNo() {
        String randNo = IDGenerate.getUniqueIdStr();
        if (!this.redisService.sadd("ticketNo", randNo)) {
            return this.getTicketNo();
        }
        return randNo;
    }
}

