/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket.cashRule;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.cashticket.CashRuleSearchVo;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.service.cashticket.cashRule.CashRuleBase;
import cc.lechun.mall.service.cashticket.cashRule.CashRuleHandle;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cashRuleType_8")
public class ProductClassCashRule
extends CashRuleBase
implements CashRuleHandle {
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;
    @Autowired
    private MallProductCategoryInterface productCategoryService;

    @Override
    public PageInfo getCashRuleItemList(CashRuleSearchVo cashRuleSearchVo) {
        MallProductCategoryEntity productEntity = new MallProductCategoryEntity();
        productEntity.setPlatformGroupId(cashRuleSearchVo.getPlatformGroupId());
        productEntity.setCategoryName(SqlUtils.sqlLike((String)cashRuleSearchVo.getName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        PageInfo pageInfo = this.productCategoryService.getCategoryList(cashRuleSearchVo.getCurrentPage(), 1000, productEntity);
        List tempList = pageInfo.getList();
        ArrayList list = new ArrayList();
        List<Object> firstCategoryList = new ArrayList();
        firstCategoryList = tempList.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getParentId(), "0")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(firstCategoryList)) {
            firstCategoryList.forEach(p -> {
                this.addChildrenCategoryList(cashRuleSearchVo, list, (MallProductCategoryEntity)p);
                List<MallProductCategoryEntity> secondCategoryList = tempList.stream().filter(pp -> Objects.equals(pp.getParentId(), p.getCategoryId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(secondCategoryList)) {
                    secondCategoryList.forEach(second -> this.addChildrenCategoryList(cashRuleSearchVo, list, (MallProductCategoryEntity)second));
                }
            });
        }
        pageInfo.setList(list);
        return pageInfo;
    }

    private void addChildrenCategoryList(CashRuleSearchVo cashRuleSearchVo, List<MallSelectDataVo> list, MallProductCategoryEntity p) {
        if (StringUtils.isNotEmpty((String)cashRuleSearchVo.getName())) {
            if (p.getCategoryName().contains(cashRuleSearchVo.getName())) {
                MallSelectDataVo selectDataVo = new MallSelectDataVo();
                selectDataVo.setId(String.valueOf(p.getCategoryId()));
                selectDataVo.setName(p.getCategoryName());
                list.add(selectDataVo);
            }
        } else {
            MallSelectDataVo selectDataVo = new MallSelectDataVo();
            selectDataVo.setId(String.valueOf(p.getCategoryId()));
            selectDataVo.setName(p.getCategoryName());
            list.add(selectDataVo);
        }
    }
}

