/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket.cashRule;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashRuleProductItem;
import cc.lechun.mall.entity.cashticket.CashRuleSearchVo;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.service.cashticket.cashRule.CashRuleBase;
import cc.lechun.mall.service.cashticket.cashRule.CashRuleHandle;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cashRuleType_3")
public class PromotionCashRule
extends CashRuleBase
implements CashRuleHandle {
    @Autowired
    private MallPromotionInterface mallPromotionInterface;
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;

    @Override
    public PageInfo getCashRuleItemList(CashRuleSearchVo cashRuleSearchVo) {
        MallPromotionEntity promotion = new MallPromotionEntity();
        promotion.setPlatformGroupId(cashRuleSearchVo.getPlatformGroupId());
        promotion.setPromotionName(cashRuleSearchVo.getName());
        promotion.setBeginTime(DateUtils.now());
        promotion.setEndTime(DateUtils.now());
        promotion.setStatus(1);
        PageInfo pageInfo = this.mallPromotionInterface.getPromotionList(cashRuleSearchVo.getCurrentPage(), cashRuleSearchVo.getPageSize(), promotion);
        List tempList = pageInfo.getList();
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)tempList)) {
            tempList.forEach(p -> {
                BaseJsonVo sr;
                CashRuleProductItem selectDataVo = new CashRuleProductItem();
                selectDataVo.setId(p.getPromotionId());
                selectDataVo.setName(p.getPromotionName());
                selectDataVo.setCreateTime(p.getCreateTime());
                MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(p.getPromotionId());
                if (promotionProduct != null) {
                    selectDataVo.setSalePrice(promotionProduct.getPromotionPrice());
                }
                if ((sr = this.mallPromotionInterface.buildPromotionVO(p.getPromotionId(), 1, true)).isSuccess() && ((MallPromotionVO)sr.getValue()).getValid().booleanValue()) {
                    list.add(selectDataVo);
                }
            });
        }
        pageInfo.setList(list);
        return pageInfo;
    }
}

