/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerFreeMapper;
import cc.lechun.mall.entity.customer.CustomerFreeEntity;
import cc.lechun.mall.entity.customer.CustomerFreeEntityVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeRecordInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.vip.MallVipConditionInterface;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerFreeService
extends BaseService<CustomerFreeEntity, Integer>
implements CustomerFreeInterface {
    @Resource
    private CustomerFreeMapper customerFreeMapper;
    @Autowired
    private MallFreeInterface freeInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private CustomerFreeRecordInterface customerFreeRecordInterface;
    @Autowired
    private MallVipConditionInterface vipConditionInterface;

    @Override
    public List<CustomerFreeEntityVo> getCustomerFreePool(String customerId) {
        CustomerFreeEntity search = new CustomerFreeEntity();
        search.setCustomerId(customerId);
        List lst = this.getList(search, 0L);
        lst = lst.stream().sorted(Comparator.comparing(CustomerFreeEntity::getCardId).thenComparing(CustomerFreeEntity::getId)).collect(Collectors.toList());
        ArrayList<CustomerFreeEntityVo> result = new ArrayList<CustomerFreeEntityVo>();
        for (CustomerFreeEntity cf : lst) {
            CustomerFreeEntityVo cfVo = new CustomerFreeEntityVo();
            try {
                MallFreeEntity freeEntity;
                ObjectConvert.fatherConvertToChild((Object)cf, (Object)cfVo);
                if (StringUtil.isNotEmpty((String)cf.getFreeId()) && (freeEntity = this.freeInterface.selectByPrimaryKey(cf.getFreeId())) != null) {
                    cfVo.setFreeName(freeEntity.getFreeName());
                    String date = DateUtils.formatDate((Date)freeEntity.getBeginTime(), (String)"yyyy/MM/dd") + "~" + DateUtils.formatDate((Date)freeEntity.getEndTime(), (String)"yyyy/MM/dd");
                    cfVo.setEnableDate(date);
                    if (freeEntity.getBeginTime().after(new Date()) || freeEntity.getEndTime().before(new Date())) {
                        cfVo.setStatus(3);
                    }
                }
                if (Integer.valueOf(1).equals(cf.getSource())) {
                    PrepayCardBatchEntity batchEntity;
                    cfVo.setSourceName("\u5976\u5361");
                    if (cf.getCardBatchId() != null && (batchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(cf.getCardBatchId())) != null) {
                        cfVo.setCardBatchName(batchEntity.getBatchName());
                    }
                }
                if (Integer.valueOf(2).equals(cf.getSource())) {
                    MallVipConditionEntity vipConditionEntity;
                    cfVo.setSourceName("\u4f1a\u5458");
                    if (cf.getCardBatchId() != null && (vipConditionEntity = this.vipConditionInterface.getVipConditionByLevel(cf.getCardBatchId())) != null) {
                        cfVo.setCardBatchName(vipConditionEntity.getLevelName());
                    }
                }
                if (cfVo.getQuantity() == null) {
                    cfVo.setQuantity(0);
                }
                if (cfVo.getUseQuantity() == null) {
                    cfVo.setUseQuantity(0);
                }
                cfVo.setEnableQuantity(cfVo.getQuantity() - cfVo.getUseQuantity());
                if (cfVo.getEnableQuantity() < 0) {
                    cfVo.setEnableQuantity(0);
                }
                result.add(cfVo);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public BaseJsonVo disabledFreePoolProduct(Integer id) {
        if (id == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7981\u7528\u7684\u8d60\u54c1");
        }
        CustomerFreeEntity freeEntity = new CustomerFreeEntity();
        freeEntity.setId(id);
        freeEntity.setStatus(0);
        int i = this.updateByPrimaryKeySelective(freeEntity);
        if (i == 1) {
            return BaseJsonVo.success((Object)"\u8bbe\u7f6e\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u8bbe\u7f6e\u5931\u8d25");
    }

    @Override
    public BaseJsonVo cleanFreePoolProduct(Integer id) {
        if (id == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u7f6e\u7684\u8d60\u54c1");
        }
        CustomerFreeEntity freeEntity = (CustomerFreeEntity)this.selectByPrimaryKey(id, 0L);
        if (freeEntity == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u4e0d\u5b58\u5728");
        }
        if (!Integer.valueOf(1).equals(freeEntity.getStatus())) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u72b6\u6001\u4e0d\u5141\u8bb8\u91cd\u7f6e");
        }
        if (!Integer.valueOf(0).equals(freeEntity.getUseQuantity())) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u91cd\u7f6e");
        }
        int i = this.deleteByPrimaryKey(id);
        if (i == 1) {
            this.customerFreeRecordInterface.updateRecordUnUsed(freeEntity.getCustomerId(), freeEntity.getCardBatchId());
            return BaseJsonVo.success((Object)"\u91cd\u7f6e\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u91cd\u7f6e\u5931\u8d25");
    }
}

