/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.customer.MobileValidateTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerMobileMapper;
import cc.lechun.mall.entity.customer.CustomerMobileEntity;
import cc.lechun.mall.entity.customer.SmsHistoryEntity;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerMobileService
extends BaseService
implements CustomerMobileInterface {
    @Autowired
    private CustomerMobileMapper customerMobileMapper;
    @Autowired
    private RedisService redisService;
    public static int bindMobileReward = 200;
    public static final int code_exp = 1800;

    @Override
    @Transactional
    public void sendValidateCode(String validateCodeType, String mobile, String customerId) {
        String validateCode = RandomUtils.generateNumString((int)4);
        String msg = "\u9a8c\u8bc1\u7801: " + validateCode;
        if (this.redisService.save(validateCodeType + "_" + mobile, validateCode, 1800L)) {
            String sendStatus = this.sendSmsSaveLog(mobile, msg);
            CustomerMobileEntity customerMobileEntity = new CustomerMobileEntity();
            customerMobileEntity.setCustomerId(customerId);
            customerMobileEntity.setMobile(mobile);
            customerMobileEntity.setReward(validateCodeType.equals(MobileValidateTypeEnum.bindMobile.name()) ? bindMobileReward : 0);
            customerMobileEntity.setVersionDetailId("");
            customerMobileEntity.setBindCode(validateCode);
            customerMobileEntity.setCreateTime(DateUtils.now());
            customerMobileEntity.setSendStatus(sendStatus);
            customerMobileEntity.setType(validateCodeType);
            this.customerMobileMapper.insertSelective(customerMobileEntity);
        }
    }

    @Override
    @Transactional
    public String sendSmsSaveLog(String mobile, String msg) {
        String msg_id = IDGenerate.getUniqueIdStr();
        String result = SmsUtil.sendSms((String)mobile, (String)msg, (String)msg_id);
        int commit_success = 0;
        if (result != null && !"".equals(result) && result.length() > 10) {
            commit_success = 1;
        }
        int send_status = 0;
        send_status = commit_success == 1 ? 2 : -1;
        SmsHistoryEntity smsHistoryEntity = new SmsHistoryEntity();
        smsHistoryEntity.setVid("10000");
        smsHistoryEntity.setUid(RandomUtils.generateId() + "");
        smsHistoryEntity.setMsisdn(mobile);
        smsHistoryEntity.setMsg(msg);
        smsHistoryEntity.setCreateTime(DateUtils.now());
        smsHistoryEntity.setMsgStatus(send_status);
        smsHistoryEntity.setStatusDesc(commit_success + "");
        smsHistoryEntity.setLastTime(DateUtils.now());
        smsHistoryEntity.setMsgId(msg_id);
        smsHistoryEntity.setSmsId(msg_id);
        smsHistoryEntity.setFlagStr("bindcode_" + mobile + "_" + msg + "_" + DateUtils.date());
        smsHistoryEntity.setTempleteId("");
        this.customerMobileMapper.saveSmsHistory(smsHistoryEntity);
        return commit_success + "";
    }

    @Override
    public boolean validateCode(String validateCodeType, String mobile, String validateCode) {
        String key = validateCodeType + "_" + mobile;
        Object code = this.redisService.get(key);
        if (code != null && !StringUtils.isEmpty((String)code.toString())) {
            return validateCode.trim().equals(code.toString());
        }
        return false;
    }

    @Override
    public List<CustomerMobileEntity> findMobile(String mobile) {
        CustomerMobileEntity customerMobileEntity = new CustomerMobileEntity();
        customerMobileEntity.setMobile(mobile);
        return this.customerMobileMapper.getList(customerMobileEntity);
    }
}

