/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.apiinvoke.sales.ClueCleanInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.customer.PasswordTypeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.ids.UuidUtil;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.customer.CustomerMapper;
import cc.lechun.mall.dao.customer.CustomerOpenidMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerListVo;
import cc.lechun.mall.entity.customer.CustomerOnlineEntity;
import cc.lechun.mall.entity.customer.CustomerOpenidEntity;
import cc.lechun.mall.entity.customer.CustomerQueryVo;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import cc.lechun.mall.iservice.customer.CustomerOnlineInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.scrm.entity.AppEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.user.FollowResult;
import weixin.popular.bean.user.User;
import weixin.popular.bean.user.UserInfoList;

@Service
public class CustomerService
extends BaseService
implements CustomerInterface {
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private CustomerOpenidMapper customerOpenidMapper;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private WeiXinBaseAccessToken weiWinBaseService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private CustomerMobileInterface customerMobileService;
    @Autowired
    private MallRedisLock redisLock;
    @Autowired
    private CustomerOnlineInterface customerOnlineService;
    @Autowired
    DistributorQiyeweixinExternalContactInterface customerQwInterface;
    @Autowired
    ClueCleanInvoke clueCleanInvoke;
    @Autowired
    private DistributorInterface distributorService;

    @Override
    public void getWeixinFollowerCount() {
        Integer platFormId = 1;
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platFormId);
        FollowResult followResult = UserAPI.userGet((String)accessToken, (String)"");
        Integer total = followResult.getTotal();
        this.customerMapper.updateFollowerCount(platFormId, total, DateUtils.now());
    }

    @Override
    public PageInfo<CustomerListVo> getCustomerList(CustomerQueryVo customerQueryVo) {
        this.logger.info("\u641c\u7d22\u6761\u4ef6:{}", (Object)customerQueryVo.toString());
        ArrayList resultList = new ArrayList();
        if (customerQueryVo.getIsOnLine()) {
            PageInfo<CustomerOnlineEntity> cusertomerOnline = this.customerOnlineService.getCustomerList(customerQueryVo);
            if (cusertomerOnline == null) {
                return null;
            }
            cusertomerOnline.getList().forEach(c -> {
                CustomerEntity customerEntity = this.getCustomer(c.getCustomerId());
                CustomerListVo customerListVo = new CustomerListVo();
                BeanUtils.copyProperties((Object)customerEntity, (Object)customerListVo);
                customerListVo.setOnLine(customerQueryVo.getIsOnLine());
                customerListVo.setConsultTime(c.getCreateTime());
                customerListVo.setOpenId(customerEntity.getChannelCustomerId());
                resultList.add(customerListVo);
            });
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(resultList);
            pageInfo.setTotal(cusertomerOnline.getTotal());
            return pageInfo;
        }
        CustomerEntity customerEntity = new CustomerEntity();
        if (StringUtils.isNotEmpty((String)customerQueryVo.getMobile())) {
            customerEntity.setMobile(customerQueryVo.getMobile());
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getOpenId())) {
            CustomerOpenidEntity query = new CustomerOpenidEntity();
            query.setOpenId(customerQueryVo.getOpenId());
            CustomerOpenidEntity customerOpenidEntity = (CustomerOpenidEntity)this.customerOpenidMapper.getSingle(query);
            if (customerOpenidEntity != null) {
                customerEntity.setCustomerId(customerOpenidEntity.getCustomerId());
            } else {
                customerEntity.setChannelCustomerId(customerQueryVo.getOpenId());
            }
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getCustomerId())) {
            customerEntity.setCustomerId(customerQueryVo.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getNickName())) {
            customerEntity.setNickName(customerQueryVo.getNickName());
        }
        customerEntity.setStatus(1);
        Page page = PageHelper.startPage((int)customerQueryVo.getCurrentPage(), (int)customerQueryVo.getPageSize());
        page.setOrderBy("CUSTOMER_ID desc");
        this.customerMapper.getCustomerList(customerEntity);
        List list = page.toPageInfo().getList();
        list.forEach(c -> {
            CustomerListVo customerListVo = new CustomerListVo();
            BeanUtils.copyProperties((Object)c, (Object)customerListVo);
            customerListVo.setOnLine(customerQueryVo.getIsOnLine());
            customerListVo.setOpenId(c.getChannelCustomerId());
            customerListVo.setNickName(c.getNickName());
            resultList.add(customerListVo);
        });
        PageInfo pg = page.toPageInfo();
        PageInfo pg2 = new PageInfo();
        pg2.setList(resultList);
        pg2.setTotal(pg.getTotal());
        return pg2;
    }

    @Override
    public PageInfo<Map<String, String>> getAllNickNameAndOpenId(int page) {
        Page list = PageHelper.startPage((int)page, (int)10000);
        this.customerMapper.getAllNickNameAndOpenId();
        return list.toPageInfo();
    }

    @Override
    public CustomerEntity getCustomer(String customerId) {
        return (CustomerEntity)this.customerMapper.selectByPrimaryKey((Serializable)((Object)customerId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerBySign", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerBySign(@ParameterValueKeyProvider String sign) {
        return this.listToEntiy(this.customerMapper.getCustomerBySign(sign));
    }

    public CustomerOpenidEntity getCustomerOpenid(String customerOpenId) {
        return (CustomerOpenidEntity)this.customerOpenidMapper.selectByPrimaryKey((Serializable)((Object)customerOpenId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerByMobile", expiration=7200)
    @ReadDataSource
    public CustomerEntity getCustomerByMobile(@ParameterValueKeyProvider(order=0) String mobile, @ParameterValueKeyProvider(order=1) int platformGroupId) {
        return this.listToEntiy(this.customerMapper.getCustomerByMobile(mobile, platformGroupId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetail", expiration=7200)
    @ReadDataSource
    public CustomerDetailVo getCustomerDetail(@ParameterValueKeyProvider(order=0) String customerId, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetail(customerId, platformId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetailByOpenid")
    @ReadDataSource
    public CustomerDetailVo getCustomerDetailByOpenid(@ParameterValueKeyProvider(order=0) String openId, @ParameterValueKeyProvider(order=1) int platformId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openId, platformId));
    }

    @Override
    @ReadThroughSingleCache(namespace="getCustomerDetailByOpenid")
    public CustomerDetailVo getCustomerDetailByOpenid(@ParameterValueKeyProvider String openId) {
        return this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid2(openId));
    }

    @Override
    @ReadDataSource
    public List<CustomerOpenidEntity> getCustomerOpenidList(String customerId) {
        CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
        customerOpenid.setCustomerId(customerId);
        return this.customerOpenidMapper.getList(customerOpenid);
    }

    @Override
    @ReadDataSource
    public List<CustomerOpenidEntity> getCustomerOpenidList(String customerId, Integer platformId) {
        CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
        customerOpenid.setCustomerId(customerId);
        customerOpenid.setPlatformId(platformId);
        return this.customerOpenidMapper.getList(customerOpenid);
    }

    @Override
    @Transactional
    public BaseJsonVo addCustomer4Wechat(int platformId, String openID, String unionid, String userName, String fxId, User user, String bindCode, String versionDetailId) throws IOException {
        boolean lock = this.redisLock.tryLock(openID + ":customer", 10000L);
        if (lock) {
            Boolean collectionFlag = false;
            PlatFormAndGroupVo platFormAndGroup = this.platFormService.getPlatFormAndGroup(platformId);
            if (platFormAndGroup == null) {
                return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5e73\u53f0");
            }
            if (user != null) {
                if (StringUtils.isEmpty((String)openID)) {
                    openID = user.getOpenid();
                }
                if (StringUtils.isEmpty((String)unionid) && !StringUtils.isEmpty((String)user.getUnionid())) {
                    unionid = user.getUnionid();
                }
                if (StringUtils.isEmpty((String)userName)) {
                    userName = user.getNickname() == null ? "" : user.getNickname();
                }
            }
            CustomerEntity customerEntity = null;
            CustomerOpenidEntity customerOpenid = null;
            CustomerDetailVo customerDeatail = this.listToEntiy(this.customerMapper.getCustomerDetailByOpenid(openID, platFormAndGroup.getPlatformId()));
            if (customerDeatail != null) {
                customerEntity = this.getCustomer(customerDeatail.getCustomerId());
                customerOpenid = this.getCustomerOpenid(customerDeatail.getCustomerOpenId());
            } else if (!StringUtils.isEmpty((String)unionid)) {
                customerEntity = this.listToEntiy(this.customerMapper.getCustomerByUnionid(unionid, platFormAndGroup.getPlatformGroupId()));
            }
            if (customerEntity != null) {
                this.removeCache(customerEntity);
                if (customerEntity.getSign() == null || customerEntity.getSign().length() < 60) {
                    customerEntity.setSign(this.getNewCustomerSign());
                }
                if (!StringUtils.isEmpty((String)unionid)) {
                    customerEntity.setUnionid(unionid);
                }
                if (!StringUtils.isEmpty((String)userName)) {
                    customerEntity.setNickName(userName);
                }
                if (!StringUtils.isEmpty((String)fxId)) {
                    customerEntity.setFxId(fxId);
                }
                if (user != null) {
                    this.userToCustomer(user, customerEntity);
                }
                this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            } else {
                customerEntity = new CustomerEntity();
                customerEntity.setIsNew(1);
                customerEntity.setSign(this.getNewCustomerSign());
                customerEntity.setCustomerId(this.getCustomerId(platFormAndGroup));
                customerEntity.setCreateTime(DateUtils.now());
                customerEntity.setVemail(this.getVemail());
                customerEntity.setPlatformGroupId(platFormAndGroup.getPlatformGroupId());
                customerEntity.setUnionid(unionid);
                customerEntity.setNickName(userName);
                customerEntity.setFxId(fxId);
                customerEntity.setChannelCustomerId(openID);
                if (user != null) {
                    this.userToCustomer(user, customerEntity);
                }
                customerEntity.setLoginName(customerEntity.getCustomerId());
                this.customerMapper.insertSelective(customerEntity);
                collectionFlag = true;
            }
            if (customerOpenid != null) {
                if (!StringUtils.isEmpty((String)bindCode)) {
                    customerOpenid.setBindCode(bindCode);
                }
                if (!StringUtils.isEmpty((String)versionDetailId)) {
                    customerOpenid.setVersionDetailId(versionDetailId);
                }
                if (!StringUtils.isEmpty((String)unionid)) {
                    customerOpenid.setUnionId(unionid);
                }
                if (user != null) {
                    this.userToCustomerOpenId(user, customerOpenid);
                }
                this.customerOpenidMapper.updateByPrimaryKeySelective(customerOpenid);
            } else {
                customerOpenid = new CustomerOpenidEntity();
                customerOpenid.setCustomerOpenId(this.getCustomerOpenID(platFormAndGroup));
                customerOpenid.setOpenId(openID);
                customerOpenid.setUnionId(unionid);
                customerOpenid.setPlatformId(platformId);
                customerOpenid.setCustomerId(customerEntity.getCustomerId());
                customerOpenid.setCreateTime(DateUtils.now());
                customerOpenid.setBindCode(bindCode);
                customerOpenid.setVersionDetailId(versionDetailId);
                customerOpenid.setSource(platformId == 4 ? 2 : platformId);
                if (user != null) {
                    this.userToCustomerOpenId(user, customerOpenid);
                }
                this.customerOpenidMapper.insertSelective(customerOpenid);
            }
            if (collectionFlag.booleanValue()) {
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)"", (Object)customerEntity.getCustomerId()));
            }
            return BaseJsonVo.success((Object)customerEntity);
        }
        return BaseJsonVo.error((String)"\u91cd\u590d\u6dfb\u52a0\u7528\u6237");
    }

    @Override
    public BaseJsonVo saveMobile(String mobile, String customerId) {
        CustomerEntity customerNew = this.getCustomer(customerId);
        if (customerNew == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7528\u6237");
        }
        String old_mobile = customerNew.getMobile();
        List<CustomerEntity> customer4Mobiles = this.customerMapper.getCustomerByMobile(mobile, customerNew.getPlatformGroupId());
        if (customer4Mobiles != null && customer4Mobiles.size() > 0) {
            return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\uff0c\u8bf7\u66f4\u6362\u4e3a\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        CustomerEntity customer = new CustomerEntity();
        customer.setCustomerId(customerId);
        customer.setMobile(mobile);
        this.removeCache(customerNew);
        int k = this.customerMapper.updateByPrimaryKeySelective(customer);
        if (k >= 1) {
            return BaseJsonVo.success((Object)"\u624b\u673a\u53f7\u4fee\u6539\u6210\u529f");
        }
        return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public void test() {
        this.logger.info("spring \u5b9a\u65f6\u4efb\u52a1\u6d4b\u8bd5");
    }

    private String getCountLimitKey(String customerId, PasswordTypeEnum passwordTypeEnum) {
        String key = customerId + "_validatepassword_count_" + passwordTypeEnum.getValue();
        return key;
    }

    private void userToCustomer(User user, CustomerEntity customerEntity) {
        customerEntity.setGender(user.getSex());
        customerEntity.setLanguage(user.getLanguage());
        customerEntity.setCity(user.getCity() == null ? "" : user.getCity());
        customerEntity.setProvince(user.getProvince() == null ? "" : user.getProvince());
        customerEntity.setCountry(user.getCountry() == null ? "" : user.getCountry());
        customerEntity.setHeadImageUrl(user.getHeadimgurl());
    }

    private void userToCustomerOpenId(User user, CustomerOpenidEntity customerOpenid) {
        customerOpenid.setSubscribe(user.getSubscribe() == null ? 0 : user.getSubscribe());
        if (user.getSubscribe_time() != null && user.getSubscribe_time() != 0) {
            customerOpenid.setSubscribeTime(new Date(MathUtils.mulBigDecimal((Number)user.getSubscribe_time(), (Number)1000).longValue()));
        }
    }

    private String getCustomerId(PlatFormAndGroupVo platFormAndGroup) {
        return platFormAndGroup.getPlatformGroupId() + RandomUtils.generateStrId();
    }

    private String getCustomerOpenID(PlatFormAndGroupVo platFormAndGroup) {
        return platFormAndGroup.getPlatformGroupId() + platFormAndGroup.getPlatformId() + RandomUtils.generateStrId();
    }

    private String getNewCustomerSign() {
        String sign = UuidUtil.get32UUID() + UuidUtil.get32UUID();
        return sign;
    }

    private String getVemail() {
        return "v" + RandomUtils.generateStrId() + "@lechun.cc";
    }

    private <T> T listToEntiy(List<T> ls) {
        if (ls != null && ls.size() > 0) {
            return ls.get(0);
        }
        return null;
    }

    @Override
    public void removeCache(String customerId) {
        this.removeCache(this.getCustomer(customerId));
    }

    @Override
    public void removeCache(CustomerEntity customer) {
        if (customer != null) {
            this.memcachedService.delete("getCustomer", customer.getCustomerId());
            this.memcachedService.delete("getCustomerBySign", customer.getSign());
            this.memcachedService.delete("getCustomerByMobile", new String[]{StringUtils.isEmpty((String)customer.getMobile()) ? "" : customer.getMobile(), "" + customer.getPlatformGroupId()});
            List<CustomerOpenidEntity> ls = this.getCustomerOpenidList(customer.getCustomerId());
            if (ls != null && ls.size() > 0) {
                ls.forEach(customerOpenidEntity -> {
                    this.memcachedService.delete("getCustomerOpenid", customerOpenidEntity.getCustomerOpenId());
                    this.memcachedService.delete("getCustomerDetail", new String[]{customer.getCustomerId(), customerOpenidEntity.getPlatformId() + ""});
                    this.memcachedService.delete("getCustomerDetailBySignActive", new String[]{customer.getSign(), customerOpenidEntity.getPlatformId() + ""});
                    this.memcachedService.delete("getCustomerDetailByOpenid", new String[]{customerOpenidEntity.getOpenId(), customerOpenidEntity.getPlatformId() + ""});
                });
            }
        }
    }

    @Override
    public void updateCustomerEntitySelective(CustomerEntity customerEntity) {
        if (customerEntity != null && StringUtils.isNotEmpty((String)customerEntity.getCustomerId())) {
            this.removeCache(customerEntity);
            this.customerMapper.updateByPrimaryKeySelective(customerEntity);
            if (customerEntity.getIsNew() != null) {
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)customerEntity.getCustomerId(), (Object)customerEntity.getCustomerId()));
            }
        }
    }

    @Override
    public List<CustomerEntity> getCustomerByCustomerIds(List<String> ids) {
        return this.customerMapper.getCustomerByCustomerIds(ids);
    }

    @Override
    public List<CustomerEntity> getCustomerBySignIds(List<String> ids) {
        return this.customerMapper.getCustomerBySignIds(ids);
    }

    @Override
    public List<CustomerDetailVo> getCustomerDetailByOpenIds(List<String> ids) {
        return this.customerMapper.getCustomerDetailByOpenIds(ids);
    }

    @Override
    public BaseJsonVo batchGetUsers(int platFormId, String nextOpenId) {
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platFormId);
        do {
            try {
                FollowResult result = UserAPI.userGet((String)accessToken, (String)nextOpenId);
                if (result.isSuccess()) {
                    FollowResult.Data data = result.getData();
                    if (data == null) {
                        nextOpenId = "";
                        continue;
                    }
                    nextOpenId = result.getNext_openid();
                    List<List<String>> lists = CustomerService.splitAry(data.getOpenid(), 100);
                    for (List<String> lst : lists) {
                        UserInfoList userInfoList = UserAPI.userInfoBatchget((String)accessToken, (String)"zh_CN", lst);
                        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.batchGetUser, MessageParam.messageParam((String)(platFormId + "|" + UUID.randomUUID()), (Object)userInfoList.getUser_info_list()));
                    }
                    continue;
                }
                nextOpenId = "";
            }
            catch (Exception e) {
                this.logger.error("\u62c9\u53d6\u7528\u6237\u5931\u8d25\uff1a" + nextOpenId + "," + e.getMessage());
            }
        } while (StringUtils.isNotEmpty((String)nextOpenId));
        return BaseJsonVo.success((Object)"\u540c\u6b65\u5b8c\u6210");
    }

    private static List<List<String>> splitAry(String[] ary, int subSize) {
        ArrayList numList = Lists.newArrayList((Object[])ary);
        return Lists.partition((List)numList, (int)subSize);
    }

    @Override
    public BaseJsonVo getCustomerInfoWithQw(CustomerQueryVo customerQueryVo) {
        if (StringUtils.isEmpty((String)customerQueryVo.getOpenId())) {
            customerQueryVo.setOpenId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getCustomerId())) {
            customerQueryVo.setCustomerId(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getMobile())) {
            customerQueryVo.setMobile(null);
        }
        if (StringUtils.isEmpty((String)customerQueryVo.getNickName())) {
            customerQueryVo.setNickName(null);
        }
        String customerId = customerQueryVo.getCustomerId();
        Integer appType = AppEnum.SCRM.getValue();
        if (customerQueryVo.getAppType() == null) {
            DistributorEntity distributorEntity;
            if (StringUtils.isNotEmpty((String)customerQueryVo.getQyuserId()) && (distributorEntity = this.distributorService.getDistributorEntity(customerQueryVo.getQyuserId())) != null) {
                appType = distributorEntity.getAppId();
            }
        } else {
            appType = customerQueryVo.getAppType();
        }
        if (StringUtils.isEmpty((String)customerId) && StringUtils.isNotEmpty((String)customerQueryVo.getOpenId())) {
            customerId = this.getOpenCustomerId(customerQueryVo.getOpenId());
        }
        HashedMap map = new HashedMap();
        if (StringUtils.isEmpty((String)customerId)) {
            map.put("customerId", "");
            map.put("mobile", "");
            map.put("openId", customerQueryVo.getOpenId());
            map.put("nickName", "");
            map.put("vipLevel", "");
            map.put("customerTypeName", "C\u7aef\u79c1\u57df\u7528\u6237");
            map.put("customerType", appType);
            return BaseJsonVo.success((Object)map);
        }
        CustomerEntity customerEntity = this.getCustomer(customerId);
        if (customerEntity == null) {
            map.put("customerId", "");
            map.put("mobile", "");
            map.put("openId", customerQueryVo.getOpenId());
            map.put("nickName", "");
            map.put("vipLevel", "");
            map.put("customerType", appType);
            map.put("customerTypeName", "C\u7aef\u79c1\u57df\u7528\u6237");
            return BaseJsonVo.success((Object)map);
        }
        map.put("customerId", customerEntity.getCustomerId());
        map.put("mobile", customerEntity.getMobile());
        map.put("openId", customerQueryVo.getOpenId());
        map.put("nickName", customerEntity.getNickName());
        map.put("isLogin", 0);
        map.put("isDelMe", 1);
        MallVipEntity mallVipEntity = this.vipService.getUserVipInfo(customerId);
        map.put("vipLevel", mallVipEntity != null ? (mallVipEntity.getLevel() > 0 ? "V" + mallVipEntity.getLevel() : "-") : "-");
        DistributorQiyeweixinExternalContactEntity param = new DistributorQiyeweixinExternalContactEntity();
        param.setCustomerId(customerId);
        List contacts = this.customerQwInterface.getList(param, 0L);
        if (contacts.size() > 0) {
            if (StringUtils.isNotEmpty((String)customerQueryVo.getQyuserId())) {
                map.put("isLogin", 1);
                List qwEntities = contacts.stream().filter(c -> customerQueryVo.getQyuserId().equals(c.getQyWeixinUserid())).collect(Collectors.toList());
                if (qwEntities.size() > 0) {
                    map.put("defineName", ((DistributorQiyeweixinExternalContactEntity)qwEntities.get(0)).getDefineName());
                    if (Integer.valueOf(2).equals(((DistributorQiyeweixinExternalContactEntity)qwEntities.get(0)).getSaveSucc())) {
                        map.put("isDelMe", 2);
                    } else if (Integer.valueOf(10).equals(((DistributorQiyeweixinExternalContactEntity)qwEntities.get(0)).getDefineStatus()) || Integer.valueOf(2).equals(((DistributorQiyeweixinExternalContactEntity)qwEntities.get(0)).getDefineStatus()) || Integer.valueOf(20).equals(((DistributorQiyeweixinExternalContactEntity)qwEntities.get(0)).getDefineStatus())) {
                        map.put("isDelMe", ((DistributorQiyeweixinExternalContactEntity)qwEntities.get(0)).getDefineStatus());
                    }
                } else {
                    map.put("defineName", "");
                }
            } else {
                map.put("defineName", "");
            }
        } else {
            map.put("defineName", "");
        }
        if (StringUtils.isNotEmpty((String)customerQueryVo.getQyuserId())) {
            map.put("customerType", appType);
            map.put("customerTypeName", AppEnum.getName(appType));
        }
        return BaseJsonVo.success((Object)map);
    }

    public String getOpenCustomerId(String openId) {
        CustomerOpenidEntity customerOpenid = new CustomerOpenidEntity();
        customerOpenid.setOpenId(openId);
        List lst = this.customerOpenidMapper.getList(customerOpenid);
        if (lst.size() > 0) {
            return ((CustomerOpenidEntity)lst.get(0)).getCustomerId();
        }
        return "";
    }

    @Override
    public BaseJsonVo closeAccount(String customerId, String userName) {
        int flag = this.customerMapper.closeAccount(customerId, userName);
        return BaseJsonVo.success(null);
    }
}

