/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerUserMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerUserEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerUserInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerUserService
extends BaseService<CustomerUserEntity, Integer>
implements CustomerUserInterface {
    @Resource
    private CustomerUserMapper customerUserMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private SysUserInterface userInterface;

    @Override
    public BaseJsonVo saveCusertomerUserService(String openId, String email, Date startTime, String userId, String cid) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(openId);
        if (customerDetailVo == null) {
            this.logger.error("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,openId={}", (Object)openId);
            return BaseJsonVo.success((Object)"");
        }
        if (StringUtils.isEmpty((String)userId)) {
            MallUserEntity userEntity = this.userInterface.getSysUser4name(email);
            if (userEntity == null) {
                this.logger.error("\u5ba2\u670d\u90ae\u7bb1\u548c\u7528\u6237\u540d\u4e0d\u5bf9\u5e94,\u5ba2\u670d\u90ae\u7bb1:{}", (Object)email);
                userId = "";
            } else {
                userId = userEntity.getUserId();
            }
        }
        if (StringUtils.isNotEmpty((String)cid)) {
            CustomerUserEntity param = new CustomerUserEntity();
            param.setCid(cid);
            CustomerUserEntity result = (CustomerUserEntity)this.getSingle(param);
            if (result != null) {
                this.logger.error("\u4f1a\u8bdd\u8bb0\u5f55:{}\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u4fdd\u5b58", (Object)cid);
                return BaseJsonVo.success((Object)"");
            }
        }
        CustomerUserEntity customerUserEntity = new CustomerUserEntity();
        customerUserEntity.setCustomerId(customerDetailVo.getCustomerId());
        customerUserEntity.setUserId(userId);
        customerUserEntity.setUserName(email);
        customerUserEntity.setCreateTime(startTime);
        customerUserEntity.setCid(cid);
        return this.insert(customerUserEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

