/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallAreaMapper;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MallAreaService
extends BaseService
implements MallAreaInterface {
    @Autowired
    private MallAreaMapper areaMapper;
    @Value(value="${erp.getArea.url}")
    private String getAreaUrl;

    private List<MallAreaEntity> getAreaErp(String cityId, String areaId, String areaName) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("cityId", cityId);
        mapParam.put("areaId", areaId);
        mapParam.put("areaName", areaName);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.getAreaUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        this.logger.info("*************************getAreaErp********************\u8c03\u7528ERP3.0\u83b7\u53d6areaList\u4f20\u9012\u548c\u8fd4\u56de\u7684\u53c2\u6570*************mapParam={},result", (Object)JSON.toJSONString(mapParam), (Object)result);
        if (StringUtils.isNotEmpty((String)result)) {
            JSONObject jsonObject = JSON.parseObject((String)result);
            int status = (Integer)jsonObject.get((Object)"status");
            if (status == 200) {
                boolean success = (Boolean)jsonObject.get((Object)"success");
                if (success) {
                    ArrayList<MallAreaEntity> mallAreaEntityArrayList = new ArrayList<MallAreaEntity>();
                    JSONArray jsonArrayCity = (JSONArray)jsonObject.get((Object)"result");
                    for (JSONObject ob : jsonArrayCity) {
                        String code = (String)ob.get((Object)"code");
                        String name = (String)ob.get((Object)"name");
                        String parentcode = (String)ob.get((Object)"parentcode");
                        Integer nomalstatus = ob.getInteger("nomalstatus");
                        Integer coldstatus = ob.getInteger("coldstatus");
                        Integer freshstatus = ob.getInteger("freshstatus");
                        MallAreaEntity mallAreaEntity = new MallAreaEntity();
                        mallAreaEntity.setAreaId(Integer.valueOf(code));
                        mallAreaEntity.setAreaName(name);
                        mallAreaEntity.setCityId(Integer.valueOf(parentcode));
                        mallAreaEntity.setStatus((int)coldstatus);
                        mallAreaEntity.setOrdinaryStatus((int)nomalstatus);
                        mallAreaEntityArrayList.add(mallAreaEntity);
                    }
                    return mallAreaEntityArrayList;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="getAreaIsOpen", expiration=300)
    public BaseJsonVo getAreaIsOpen(@ParameterValueKeyProvider Integer areaId) {
        if (areaId == null) {
            return BaseJsonVo.paramError((String)"\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5730\u5740");
        }
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(null, String.valueOf(areaId), null);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            int areaIsOpen = 1;
            MallAreaEntity mallAreaEntity = mallAreaEntityArrayList.get(0);
            Integer status = mallAreaEntity.getStatus();
            Integer ordinaryStatus = mallAreaEntity.getOrdinaryStatus();
            areaIsOpen = status == 1 ? 1 : (ordinaryStatus == 1 ? 2 : 3);
            return BaseJsonVo.success((Object)areaIsOpen);
        }
        return BaseJsonVo.paramError((String)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
    }

    @Override
    @ReadThroughSingleCache(namespace="getArea", expiration=300)
    public MallAreaEntity getArea(@ParameterValueKeyProvider Integer areaId) {
        if (areaId == null) {
            return null;
        }
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(null, String.valueOf(areaId), null);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            return mallAreaEntityArrayList.get(0);
        }
        return null;
    }

    @Override
    public List<MallAreaEntity> getAreaList(Integer cityId) {
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(String.valueOf(cityId), null, null);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            return mallAreaEntityArrayList;
        }
        return null;
    }

    @Override
    public MallAreaEntity getAreaByName(String areaName) {
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(null, null, areaName);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            return mallAreaEntityArrayList.get(0);
        }
        return null;
    }

    @Override
    public BaseJsonVo syncArea() {
        return this.areaMapper.sycnArea();
    }
}

