/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.apiinvoke.mall.OrderDeliverdInvoke;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallOrderDeliverRecordMapper;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import cc.lechun.mall.iservice.deliver.MallOrderDeliverRecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.util.JsonUtil;

@Service
public class MallOrderDeliverRecordService
extends BaseService
implements MallOrderDeliverRecordInterface {
    @Autowired
    private MallOrderDeliverRecordMapper orderDeliverRecordMapper;
    @Autowired
    private DeliverRouteInterface deliverRouteInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private OrderDeliverdInvoke orderDeliverdInvoke;

    @Override
    @ReadThroughSingleCache(namespace="MallOrderDeliverRecordService.getDeliverRecordList", expiration=60)
    public List<OrderDeliverRecordVo> getDeliverRecordList(@ParameterValueKeyProvider String orderNo) {
        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
        if (orderEntity == null) {
            new ArrayList();
        }
        if (orderEntity.getPickupTime().before(DateUtils.getDateFromString((String)"2019-03-11"))) {
            List<OrderDeliverRecordVo> orderDeliverRecordVos = this.orderDeliverRecordMapper.getDeliverRecordList(orderNo);
            if (orderDeliverRecordVos != null) {
                orderDeliverRecordVos.sort(Comparator.comparing(OrderDeliverRecordVo::getPushTime).reversed().thenComparing(OrderDeliverRecordVo::getOrderdeliverRecordId).reversed());
            }
            return orderDeliverRecordVos;
        }
        return (List)this.orderDeliverdInvoke.getRouteInfo(orderNo).getValue();
    }

    @Override
    public BaseJsonVo pullOrderRouteInfo() {
        List<MallOrderEntity> orderEntities = this.orderInterface.getDeliveringOrder();
        for (MallOrderEntity o : orderEntities) {
            this.logger.info("\u5f00\u59cb\u6279\u91cf\u62c9\u53d6\u8ba2\u5355\u8def\u7531\u4fe1\u606f\uff0c\u8ba2\u5355\u53f7\uff1a" + o.getOrderNo() + ",\u7269\u6d41\u5355\u53f7\uff1a" + o.getWaybillNo());
            BaseJsonVo js = this.orderDeliverdInvoke.getRouteInfo(o.getOrderNo());
            this.logger.info("\u7ed3\u675f\u6279\u91cf\u62c9\u53d6\u8ba2\u5355\u8def\u7531\u4fe1\u606f\uff0c\u8ba2\u5355\u53f7\uff1a" + o.getOrderNo() + ",\u7269\u6d41\u5355\u53f7\uff1a" + o.getWaybillNo() + ",Result:" + JsonUtil.toJSONString((Object)js));
        }
        return BaseJsonVo.success((Object)"");
    }
}

