/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.dictionary;

import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.dictionary.DictionaryMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.platform.PlatFormGroupService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryService
implements DictionaryInterface {
    private static final Logger log = LoggerFactory.getLogger(DictionaryService.class);
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private PlatFormGroupService platFormGroupService;
    @Autowired
    private RedisService redisService;

    @Override
    public DictionaryEntity saveDictionary(int platformGroupId, int dictionaryTypeId, String dictionaryKey, String dictionaryName, int sort, String remark, int status) {
        DictionaryEntity dictionaryEntity = new DictionaryEntity();
        dictionaryEntity.setPlatformGroupId(platformGroupId);
        dictionaryEntity.setDictionaryKey(dictionaryKey);
        dictionaryEntity.setDictionaryName(dictionaryName);
        dictionaryEntity.setDictionaryTypeId(dictionaryTypeId);
        dictionaryEntity.setStatus((short)status);
        dictionaryEntity.setSort((short)sort);
        dictionaryEntity.setRemark(remark);
        this.dictionaryMapper.saveDictionary(dictionaryEntity);
        this.removeCache(platformGroupId, dictionaryEntity.getDictionaryId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey());
        return dictionaryEntity;
    }

    @Override
    public DictionaryEntity updateDictionary(int dictionaryId, String dictionaryKey, String dictionaryName, int sort, String remark, int status) {
        DictionaryEntity dictionaryEntity = this.getDictionary(dictionaryId);
        this.removeCache(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey());
        dictionaryEntity.setDictionaryKey(dictionaryKey);
        dictionaryEntity.setDictionaryName(dictionaryName);
        dictionaryEntity.setSort((short)sort);
        dictionaryEntity.setRemark(remark);
        dictionaryEntity.setStatus((short)status);
        this.dictionaryMapper.updateByPrimaryKeySelective(dictionaryEntity);
        return dictionaryEntity;
    }

    @Override
    public BaseJsonVo deleteDictionary(int dictionaryId, int userPlatformGroupId) {
        DictionaryEntity dictionaryEntity = this.getDictionary(dictionaryId);
        if (dictionaryEntity == null) {
            return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        this.removeCache(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey());
        this.dictionaryMapper.deleteByPrimaryKey(Integer.valueOf(dictionaryId));
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public DictionaryEntity getDictionary(int dictionaryId) {
        return (DictionaryEntity)this.dictionaryMapper.selectByPrimaryKey(Integer.valueOf(dictionaryId));
    }

    @Override
    public DictionaryEntity getDictionary(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        List<DictionaryEntity> ls = this.dictionaryMapper.getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (ls != null && ls.size() > 0) {
            return ls.get(0);
        }
        return null;
    }

    @Override
    public String getDictionaryToString(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        return dictionaryEntity == null ? "" : (dictionaryEntity.getDictionaryName() == null ? "" : dictionaryEntity.getDictionaryName());
    }

    @Override
    public Integer getDictionaryToInteger(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        Integer value = null;
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (dictionaryEntity != null && !StringUtil.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            try {
                value = Integer.valueOf(dictionaryEntity.getDictionaryName());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public int getDictionaryToInt(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        int value = 0;
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (dictionaryEntity != null && !StringUtil.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            try {
                value = Integer.parseInt(dictionaryEntity.getDictionaryName());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public double getDictionaryToDouble(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        double value = 0.0;
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (dictionaryEntity != null && !StringUtil.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            try {
                value = Double.parseDouble(dictionaryEntity.getDictionaryName());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public List<DictionaryEntity> getValidDictionaryList(Integer platformGroupId, Integer dictionaryTypeId) {
        return this.dictionaryMapper.getValidDictionaryList(platformGroupId, dictionaryTypeId);
    }

    @Override
    public PageInfo getDictionaryList(int pageNum, int pageSize, int platformGroupId, int dictionaryTypeId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.dictionaryMapper.getDictionaryList(platformGroupId, dictionaryTypeId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private void removeCache(Integer platformGroupId, Integer dictionaryId, Integer dictionaryTypeId, String dictionaryKey) {
        this.redisService.delete("LOGIN_WHITE_IP_LIST_35");
        this.memcachedService.delete("dictionary", dictionaryId + "");
        List<PlatFormGroupEntity> ls = this.platFormGroupService.getPlatFormGroupList();
        if (ls != null && ls.size() > 0) {
            ls.forEach(platFormGroupEntity -> {
                this.memcachedService.delete("dictionary_key", new String[]{platFormGroupEntity.getPlatformGroupId() + "", dictionaryTypeId + "", dictionaryKey});
                this.memcachedService.delete("ValidDictionaryListNew", new String[]{platFormGroupEntity.getPlatformGroupId() + "", dictionaryTypeId + ""});
            });
        }
        this.memcachedService.delete("dictionary_key", new String[]{"0", dictionaryTypeId + "", dictionaryKey});
        this.memcachedService.delete("ValidDictionaryListNew", new String[]{"0", dictionaryTypeId + ""});
    }

    @Override
    public DictionaryEntity getSingle(DictionaryEntity searchDic) {
        return (DictionaryEntity)this.dictionaryMapper.getSingle(searchDic);
    }
}

