/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionInviteMapper;
import cc.lechun.mall.entity.distribution.DistributionInviteEntity;
import cc.lechun.mall.entity.distribution.DistributionInviteVo;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionInviteService
extends BaseService<DistributionInviteEntity, String>
implements DistributionInviteInterface {
    @Resource
    private DistributionInviteMapper distributionInviteMapper;
    @Autowired
    private DistributorRelationInterface relationInterface;

    @Override
    public PageInfo<DistributionInviteVo> getListVo(Integer pageNum, Integer pageSize, Integer distributorId, Date sdate, Date edate, String mobile, String nickName, Integer appId) {
        mobile = StringUtils.isEmpty((String)mobile) ? null : SqlUtils.sqlLike((String)mobile, (SqlLikeEnum)SqlLikeEnum.sqlLike_All);
        nickName = StringUtils.isEmpty((String)nickName) ? null : SqlUtils.sqlLike((String)nickName, (SqlLikeEnum)SqlLikeEnum.sqlLike_All);
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.distributionInviteMapper.getListVo(distributorId, sdate, edate, mobile, nickName, appId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo insertQiyeweixinUserInvite(DistributorEntity distributorEntity, Date creatTime, String customerId) {
        DistributionInviteEntity e = new DistributionInviteEntity();
        DistributorRelationEntity relationEntity = this.relationInterface.getDistributorRelationByRelationUserId(distributorEntity.getQyWeixinUserid(), 1);
        if (relationEntity != null) {
            e.setDistributorId(distributorEntity.getId());
            e.setDistributorRelationId(relationEntity.getId());
            e.setDistributorRelationUserId(distributorEntity.getQyWeixinUserid());
            e.setInviteSource("\u4f01\u4e1a\u5fae\u4fe1\u76f4\u8fbe");
            e.setInviteTime(creatTime);
            e.setId(IDGenerate.getUniqueIdStr());
            e.setInviteLogId(0);
            e.setInvalidTime(DateUtils.getAddDateByDay((Date)creatTime, (int)100000));
            e.setInvitedCustomerId(customerId);
            e.setInviteType(3);
            e.setPlatformId(4);
            e.setUpdateTime(new Date());
            this.distributionInviteMapper.insertSelective(e);
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

