/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.distribution.BatchMediaStaffDo;
import cc.lechun.mall.entity.distribution.DistributionMediaEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaQueryVo;
import cc.lechun.mall.entity.distribution.DistributionMediaStaffEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaStaffVo;
import cc.lechun.mall.entity.distribution.DistributionMediaVo;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorLinkVo;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.distribution.DistributionMediaBaseInterface;
import cc.lechun.mall.iservice.distribution.DistributionMediaInterface;
import cc.lechun.mall.iservice.distribution.DistributionMediaStaffInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributionMediaBaseService
extends BaseService
implements DistributionMediaBaseInterface {
    @Resource
    private DistributionMediaInterface distributionMediaInterface;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DistributionMediaStaffInterface distributionMediaStaffInterface;
    @Autowired
    private DistributorRelationInterface distributorRelationInterface;
    @Autowired
    DistributorInterface distributorInterface;
    @Autowired
    OssService ossService;
    private String inviteLink = "ncp_bat=${code}";

    @Override
    public PageInfo<DistributorLinkVo> getDistributorLinkVoList(String miniPath) {
        return this.distributionMediaStaffInterface.getDistributorLinkVoList(miniPath);
    }

    @Override
    @Transactional
    public BaseJsonVo deleteMedia(Integer mediaId) {
        this.distributionMediaInterface.deleteByPrimaryKey(mediaId);
        DistributionMediaStaffEntity distributionMediaStaffEntity = new DistributionMediaStaffEntity();
        distributionMediaStaffEntity.setMediaId(mediaId);
        List staffList = this.distributionMediaStaffInterface.getList(distributionMediaStaffEntity, 0L);
        if (CollectionUtils.isNotEmpty((Collection)staffList)) {
            staffList.forEach(staffEntity -> this.distributionMediaStaffInterface.deleteByPrimaryKey(staffEntity.getMediaStaffId()));
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteMediaStaff(Integer mediaStaffId) {
        this.distributionMediaStaffInterface.deleteByPrimaryKey(mediaStaffId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public BaseJsonVo saveBatchMediaStaff(BatchMediaStaffDo batchMediaStaffDo) {
        DistributionMediaEntity distributionMediaEntity = this.getDistributionMedia(batchMediaStaffDo.getMediaId());
        if (distributionMediaEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u7d20\u6750");
        }
        this.logger.info("\u7d20\u6750:{}", (Object)JsonUtils.toJson((Object)distributionMediaEntity, (boolean)false));
        DistributorEntity distributorEntity = new DistributorEntity();
        distributorEntity.setGroupId(batchMediaStaffDo.getGroupId());
        distributorEntity.setStatus(1);
        List staffList = this.distributorInterface.getList(distributorEntity, 0L);
        if (CollectionUtils.isNotEmpty((Collection)staffList)) {
            staffList.forEach(distributor -> {
                DistributorRelationEntity query = new DistributorRelationEntity();
                query.setDistributorId(distributor.getId());
                DistributorRelationEntity distributorRelationEntity = (DistributorRelationEntity)this.distributorRelationInterface.getSingle(query, 0L);
                if (distributorRelationEntity != null) {
                    DistributionMediaStaffEntity distributionMediaStaffEntity = new DistributionMediaStaffEntity();
                    BeanUtils.copyProperties((Object)distributionMediaEntity, (Object)distributionMediaStaffEntity);
                    distributionMediaStaffEntity.setMediaTitle(distributor.getDistributorName() + distributionMediaEntity.getMediaTitle());
                    distributionMediaStaffEntity.setDistributorRelationId(distributorRelationEntity.getId());
                    this.distributionMediaStaffInterface.save(distributionMediaStaffEntity);
                }
            });
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u7ec4\u5458\u6216\u8005\u65e0\u6548\u7684\u7ec4");
    }

    @Override
    public DistributionMediaEntity getDistributionMedia(Integer mediaId) {
        return (DistributionMediaEntity)this.distributionMediaInterface.selectByPrimaryKey(mediaId);
    }

    @Override
    public PageInfo<DistributionMediaVo> getDistributionMediaList(DistributionMediaQueryVo distributionMediaQueryVo) {
        return this.distributionMediaInterface.getDistributionMediaList(distributionMediaQueryVo);
    }

    @Override
    public List<DistributionMediaStaffVo> getDistributionMediaStaffList(DistributionMediaStaffEntity distributionMediaStaffEntity) {
        return this.distributionMediaStaffInterface.getDistributionMediaStaffList(distributionMediaStaffEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo save(final DistributionMediaEntity distributionMediaEntity) {
        if (distributionMediaEntity.getMediaId() == null) {
            distributionMediaEntity.setCreateTime(DateUtils.now());
            this.distributionMediaInterface.save(distributionMediaEntity);
        } else {
            DistributionMediaStaffEntity mediaStaffEntity = new DistributionMediaStaffEntity();
            mediaStaffEntity.setMediaId(distributionMediaEntity.getMediaId());
            distributionMediaEntity.setPicUrl(this.ossService.removeUrlDomain(distributionMediaEntity.getPicUrl()));
            this.distributionMediaInterface.save(distributionMediaEntity);
            DistributionMediaStaffEntity distributionMediaStaffEntity = new DistributionMediaStaffEntity();
            distributionMediaStaffEntity.setMediaId(distributionMediaEntity.getMediaId());
            final List staffList = this.distributionMediaStaffInterface.getList(distributionMediaStaffEntity, 0L);
            if (CollectionUtils.isNotEmpty((Collection)staffList)) {
                if (staffList.size() > 5) {
                    try {
                        ExecutorService pool = Executors.newFixedThreadPool(1);
                        pool.execute(new Runnable(){

                            @Override
                            public void run() {
                                staffList.forEach(staffEntity -> {
                                    BeanUtils.copyProperties((Object)distributionMediaEntity, (Object)staffEntity);
                                    DistributionMediaBaseService.this.distributionMediaStaffInterface.save((DistributionMediaStaffEntity)staffEntity);
                                });
                            }
                        });
                        pool.shutdown();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    return BaseJsonVo.success((Object)"\u5206\u9500\u5458\u7d20\u6750\u6279\u91cf\u751f\u6210\u4e2d...\u8bf7\u57282\u5206\u949f\u540e\u7a0d\u5019\u5237\u65b0\u9875\u9762\u67e5\u770b");
                }
                staffList.forEach(staffEntity -> {
                    BeanUtils.copyProperties((Object)distributionMediaEntity, (Object)staffEntity);
                    this.distributionMediaStaffInterface.save((DistributionMediaStaffEntity)staffEntity);
                });
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void save(DistributionMediaEntity distributionMediaEntity, DistributionMediaStaffEntity mediaStaffEntity) {
        List<DistributionMediaStaffVo> list = this.getDistributionMediaStaffList(mediaStaffEntity);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(distributionMediaStaffVo -> {
                DistributionMediaStaffEntity distributionMediaStaffEntity = new DistributionMediaStaffEntity();
                BeanUtils.copyProperties((Object)distributionMediaStaffVo, (Object)distributionMediaStaffEntity);
                DistributorRelationEntity distributorRelationEntity = (DistributorRelationEntity)this.distributorRelationInterface.selectByPrimaryKey(distributionMediaStaffVo.getDistributorRelationId());
                distributionMediaStaffEntity.setBasePath((distributionMediaStaffEntity.getBasePath().contains("?") ? "&" : "?") + this.inviteLink.replace("${code}", distributorRelationEntity.getDistributorRelationCode()));
                this.distributionMediaStaffInterface.save(distributionMediaStaffEntity);
                this.logger.info("\u5bf9\u8c61:{}\u8fde\u63a5\u66f4\u65b0\u6210\u529f", (Object)distributionMediaEntity.toString());
            });
        }
    }

    @Override
    public BaseJsonVo save(DistributionMediaStaffVo distributionMediaStaffVo) {
        DistributionMediaStaffEntity distributionMediaStaffEntity = new DistributionMediaStaffEntity();
        BeanUtils.copyProperties((Object)distributionMediaStaffVo, (Object)distributionMediaStaffEntity);
        this.distributionMediaStaffInterface.save(distributionMediaStaffEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo save(DistributionMediaStaffEntity distributionMediaStaffEntity) {
        this.distributionMediaStaffInterface.save(distributionMediaStaffEntity);
        return BaseJsonVo.success((Object)"");
    }
}

