/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionMediaMapper;
import cc.lechun.mall.entity.distribution.DistributionMediaEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaQueryVo;
import cc.lechun.mall.entity.distribution.DistributionMediaVo;
import cc.lechun.mall.entity.distribution.MediaPathTypeEnum;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.distribution.DistributionMediaInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionMediaService
extends BaseService<DistributionMediaEntity, Integer>
implements DistributionMediaInterface {
    @Resource
    private DistributionMediaMapper distributionMediaMapper;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    OssService ossService;

    @Override
    public PageInfo<DistributionMediaVo> getDistributionMediaList(DistributionMediaQueryVo distributionMediaQueryVo) {
        Page page = PageHelper.startPage((int)distributionMediaQueryVo.getCurrentPage(), (int)distributionMediaQueryVo.getPageSize());
        page.setOrderBy("CREATE_TIME DESC");
        List<DistributionMediaEntity> list = this.distributionMediaMapper.getDistributionMediaList(distributionMediaQueryVo);
        List<Object> result = new ArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            result = list.stream().map(distributionMediaEntity -> {
                DistributionMediaVo distributionMediaVo = new DistributionMediaVo();
                BeanUtils.copyProperties((Object)distributionMediaEntity, (Object)distributionMediaVo);
                distributionMediaVo.setPicUrl(this.ossService.getImageResoure(distributionMediaEntity.getPicUrl()));
                distributionMediaVo.setPathTypeName(MediaPathTypeEnum.getName(distributionMediaEntity.getPathType()));
                String itemDesc = "";
                if (MediaPathTypeEnum.ACTIVE_DETAIL.getValue() == distributionMediaEntity.getPathType().intValue()) {
                    ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(distributionMediaEntity.getItemId());
                    itemDesc = activeEntity != null ? activeEntity.getActiveName() : "";
                    distributionMediaVo.setActiveNo(activeEntity != null ? activeEntity.getActiveNo() : "");
                } else if (MediaPathTypeEnum.PRODUCT_DETAIL.getValue() == distributionMediaEntity.getPathType().intValue()) {
                    MallProductEntity product = this.productInterface.getProduct(distributionMediaEntity.getItemId());
                    itemDesc = product != null ? product.getProName() : "";
                } else if (MediaPathTypeEnum.PROMOTION_DETAIL.getValue() == distributionMediaEntity.getPathType().intValue()) {
                    MallPromotionEntity promotion = this.promotionInterface.getPromotion(distributionMediaEntity.getItemId());
                    itemDesc = promotion != null ? promotion.getPromotionName() : "";
                } else if (MediaPathTypeEnum.GROUP_DETAIL.getValue() == distributionMediaEntity.getPathType().intValue()) {
                    MallProductGroupEntity group = this.groupInterface.getGroup(distributionMediaEntity.getItemId());
                    itemDesc = itemDesc + (group != null ? group.getGroupName() : "");
                } else {
                    itemDesc = MediaPathTypeEnum.getName(distributionMediaEntity.getPathType());
                }
                distributionMediaVo.setItemDesc(itemDesc);
                return distributionMediaVo;
            }).collect(Collectors.toList());
        }
        PageInfo pg2 = new PageInfo();
        pg2.setList(result);
        pg2.setTotal(page.getTotal());
        return pg2;
    }

    @Override
    public BaseJsonVo save(DistributionMediaEntity distributionMediaEntity) {
        if (distributionMediaEntity.getMediaId() == null) {
            distributionMediaEntity.setCreateTime(DateUtils.now());
        }
        distributionMediaEntity.setPicUrl(this.ossService.removeUrlDomain(distributionMediaEntity.getPicUrl()));
        int k = this.distributionMediaMapper.insertOrUpdate(distributionMediaEntity);
        return k >= 1 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

