/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.file.FileUtils;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionMediaStaffMapper;
import cc.lechun.mall.entity.distribution.DistributionMediaEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaStaffEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaStaffVo;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorLinkVo;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.distribution.DistributorVo;
import cc.lechun.mall.entity.distribution.MediaPathTypeEnum;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.distribution.DistributionMediaInterface;
import cc.lechun.mall.iservice.distribution.DistributionMediaStaffInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.qy.UploadMediaAPI;
import weixin.popular.bean.media.Media;

@Service
public class DistributionMediaStaffService
extends BaseService<DistributionMediaStaffEntity, Integer>
implements DistributionMediaStaffInterface {
    @Resource
    private DistributionMediaStaffMapper distributionMediaStaffMapper;
    @Autowired
    DistributionMediaInterface distributionMediaInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;
    @Autowired
    DistributorInterface distributorInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    OssService ossService;
    @Autowired
    private MiniSchemeInterface miniSchemeInterface;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseInterface;
    @Resource
    private ActivePropertyMapper activePropertyMapper;

    @Override
    public List<DistributionMediaStaffVo> getDistributionMediaStaffList(DistributionMediaStaffEntity distributionMediaStaffEntity) {
        this.logger.info("\u67e5\u8be2\u53c2\u6570:{}", (Object)distributionMediaStaffEntity.toString());
        DistributionMediaEntity distributionMediaEntity = (DistributionMediaEntity)this.distributionMediaInterface.selectByPrimaryKey(distributionMediaStaffEntity.getMediaId());
        if (distributionMediaEntity == null) {
            return new ArrayList<DistributionMediaStaffVo>();
        }
        if ("".equals(distributionMediaEntity.getMediaTitle())) {
            distributionMediaStaffEntity.setMediaTitle(null);
        }
        List mediaStaffEntityList = this.distributionMediaStaffMapper.getList(distributionMediaStaffEntity);
        ArrayList<DistributionMediaStaffVo> result = new ArrayList();
        result = mediaStaffEntityList.stream().map(mediaStaff -> {
            DistributionMediaStaffVo distributionMediaStaffVo = new DistributionMediaStaffVo();
            BeanUtils.copyProperties((Object)mediaStaff, (Object)distributionMediaStaffVo);
            distributionMediaStaffVo.setPicUrl(this.ossService.getImageResoure(mediaStaff.getPicUrl()));
            distributionMediaStaffVo.setPathTypeName(MediaPathTypeEnum.getName(distributionMediaEntity.getPathType()));
            if (mediaStaff.getDistributorRelationId() != null) {
                DistributorRelationEntity distributorRelationEntity = (DistributorRelationEntity)this.distributorRelationInterface.selectByPrimaryKey(mediaStaff.getDistributorRelationId());
                if (distributorRelationEntity != null) {
                    distributionMediaStaffVo.setDistributorRelationCode(distributorRelationEntity.getDistributorRelationCode());
                    DistributorEntity distribution = (DistributorEntity)this.distributorInterface.selectByPrimaryKey(distributorRelationEntity.getDistributorId());
                    distributionMediaStaffVo.setStaffName(distribution == null ? "" : distribution.getDistributorName());
                    distributionMediaStaffVo.setDistributorRelationId(mediaStaff.getDistributorRelationId());
                    distributionMediaStaffVo.setDistributorPhone(StringUtils.isNotEmpty((String)distribution.getDistributorPhone()) ? distribution.getDistributorPhone() : "");
                    distributionMediaStaffVo.setStatus(distributorRelationEntity.getStatus());
                    distributionMediaStaffVo.setStatusName(distributorRelationEntity.getStatus() == 1 ? "\u53ef\u7528" : "\u7981\u7528");
                } else {
                    distributionMediaStaffVo.setStaffName("\u672a\u77e5");
                }
            }
            String itemDesc = "";
            if (MediaPathTypeEnum.ACTIVE_DETAIL.getValue() == distributionMediaEntity.getPathType().intValue()) {
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(mediaStaff.getItemId());
                itemDesc = itemDesc + (activeEntity != null ? activeEntity.getActiveName() : "");
                distributionMediaStaffVo.setActiveNo(activeEntity != null ? activeEntity.getActiveNo() : "");
            } else if (MediaPathTypeEnum.PRODUCT_DETAIL.getValue() == mediaStaff.getPathType().intValue()) {
                MallProductEntity product = this.productInterface.getProduct(mediaStaff.getItemId());
                itemDesc = itemDesc + product != null ? product.getProName() : "";
            } else if (MediaPathTypeEnum.PROMOTION_DETAIL.getValue() == mediaStaff.getPathType().intValue()) {
                MallPromotionEntity promotion = this.promotionInterface.getPromotion(mediaStaff.getItemId());
                itemDesc = itemDesc + (promotion != null ? promotion.getPromotionName() : "");
            } else if (MediaPathTypeEnum.GROUP_DETAIL.getValue() == mediaStaff.getPathType().intValue()) {
                MallProductGroupEntity group = this.groupInterface.getGroup(mediaStaff.getItemId());
                itemDesc = itemDesc + (group != null ? group.getGroupName() : "");
            } else {
                itemDesc = MediaPathTypeEnum.getName(distributionMediaEntity.getPathType());
            }
            distributionMediaStaffVo.setRemark(itemDesc);
            return distributionMediaStaffVo;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public BaseJsonVo save(DistributionMediaStaffEntity distributionMediaStaffEntity) {
        DistributorRelationEntity distributorRelationEntity;
        this.logger.info("\u4fdd\u5b58\u670d\u52a1\u4eba\u5458\u7d20\u6750:{}", (Object)JsonUtils.toJson((Object)distributionMediaStaffEntity, (boolean)false));
        String picUrl = distributionMediaStaffEntity.getPicUrl();
        try {
            File file = FileUtils.getFile(picUrl);
            Media image = UploadMediaAPI.uploadTempFile((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(7), (File)file, (String)"image");
            distributionMediaStaffEntity.setPicQyMediaId(image.getMedia_id());
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u5ba2\u670d\u7d20\u6750\u5931\u8d25", (Throwable)e);
        }
        distributionMediaStaffEntity.setPicUrl(this.ossService.removeUrlDomain(distributionMediaStaffEntity.getPicUrl()));
        String inviteCode = "";
        if (distributionMediaStaffEntity.getDistributorRelationId() != null && (distributorRelationEntity = (DistributorRelationEntity)this.distributorRelationInterface.selectByPrimaryKey(distributionMediaStaffEntity.getDistributorRelationId())) != null) {
            inviteCode = distributorRelationEntity.getDistributorRelationCode();
        }
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        int activeType = -1;
        int linkType = 1;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (MediaPathTypeEnum.ACTIVE_DETAIL.getValue() == distributionMediaStaffEntity.getPathType().intValue()) {
            ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(distributionMediaStaffEntity.getItemId());
            map.put("activeNo", activeEntity.getActiveNo());
            map.put("bindCode", activeEntity.getBindCode());
            map.put("ncp_bat", inviteCode);
            activeType = -1;
            linkType = 1;
        } else if (MediaPathTypeEnum.PRODUCT_DETAIL.getValue() == distributionMediaStaffEntity.getPathType().intValue() || MediaPathTypeEnum.PROMOTION_DETAIL.getValue() == distributionMediaStaffEntity.getPathType().intValue() || MediaPathTypeEnum.GROUP_DETAIL.getValue() == distributionMediaStaffEntity.getPathType().intValue()) {
            linkType = distributionMediaStaffEntity.getPathType();
            activeType = -1;
            map.put("productId", distributionMediaStaffEntity.getItemId());
            map.put("productType", distributionMediaStaffEntity.getPathType());
            map.put("ncp_bat", inviteCode);
        } else {
            linkType = distributionMediaStaffEntity.getPathType();
            activeType = -1;
            map.put("ncp_bat", inviteCode);
        }
        baseJsonVo = this.miniSchemeInterface.getMiniSchemeSystem(linkType, activeType, map);
        if (baseJsonVo.isSuccess()) {
            MiniSchemeEntity schemeEntity = (MiniSchemeEntity)baseJsonVo.getValue();
            distributionMediaStaffEntity.setBasePath(schemeEntity.getMiniPath() + "?" + schemeEntity.getQueryPara());
            distributionMediaStaffEntity.setOpenLink(schemeEntity.getOpenLink());
            distributionMediaStaffEntity.setShortLink(schemeEntity.getShortLink());
            String urlPathName = schemeEntity.getMiniPath().replace("active/", "").replace("active1/", "").replace("/index", "");
            urlPathName = urlPathName.replace("pages", "");
            String urlLink = StringUtils.isNotEmpty((String)schemeEntity.getQueryPara()) ? "http://lechun.cc" + urlPathName + "?" + schemeEntity.getQueryPara() : "http://lechun.cc" + urlPathName;
            try {
                String encodeUrl = schemeEntity.getMiniPath() + ".html?type=open&targeturl=" + URLEncoder.encode(urlLink, "utf-8");
                this.logger.info("\u63a8\u6587\u8fde\u63a5:{}", (Object)encodeUrl);
                distributionMediaStaffEntity.setEncodeLink(encodeUrl);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        DistributionMediaStaffEntity query = new DistributionMediaStaffEntity();
        query.setDistributorRelationId(distributionMediaStaffEntity.getDistributorRelationId());
        query.setMediaId(distributionMediaStaffEntity.getMediaId());
        DistributionMediaStaffEntity temp = (DistributionMediaStaffEntity)this.getSingle(query, 0L);
        if (temp != null && temp.getMediaStaffId() != null) {
            distributionMediaStaffEntity.setMediaStaffId(temp.getMediaStaffId());
        }
        if (distributionMediaStaffEntity.getMediaStaffId() == null) {
            distributionMediaStaffEntity.setCreateTime(DateUtils.now());
            this.distributionMediaStaffMapper.insertSelective(distributionMediaStaffEntity);
        } else {
            this.distributionMediaStaffMapper.updateByPrimaryKeySelective(distributionMediaStaffEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public PageInfo<DistributorLinkVo> getDistributorLinkVoList(String miniPath) {
        this.logger.info("\u8fde\u63a5\u53c2\u6570:{}", (Object)miniPath);
        DistributorEntity distributorEntity = new DistributorEntity();
        distributorEntity.setStatus(1);
        distributorEntity.setGroupId(5);
        PageInfo<DistributorVo> pageInfo = this.distributorInterface.getDistributorPageList(1, 150, distributorEntity);
        List result = pageInfo.getList().stream().map(distributorVo -> {
            DistributorLinkVo groupDistributorVo = new DistributorLinkVo();
            BeanUtils.copyProperties((Object)distributorVo, (Object)groupDistributorVo);
            String regex = "\\?";
            String[] path = miniPath.split(regex);
            String code = "ncp_bat=" + distributorVo.getDistributorRelationCode();
            if (path.length > 1) {
                if (!path[1].contains("code") && path[1].contains("bindCode")) {
                    for (String item : path[1].split("&")) {
                        String[] itemArr;
                        if (!item.contains("bindCode") || (itemArr = item.split("=")).length <= 1 || !this.canGetCode(itemArr[1])) continue;
                        String takeCode = RandomUtils.generateString((int)8);
                        takeCode = this.encrypt16(takeCode);
                        code = code + "&code=" + takeCode;
                    }
                }
                groupDistributorVo.setLink(miniPath + "&" + code);
            } else {
                groupDistributorVo.setLink(miniPath + "?" + code);
            }
            BaseJsonVo<MiniSchemeEntity> miniSchemeEntityBaseJsonVo = this.miniSchemeInterface.getMiniSchemeSystemByPara(miniPath);
            if (miniSchemeEntityBaseJsonVo.isSuccess()) {
                groupDistributorVo.setShortLinkUrl(((MiniSchemeEntity)miniSchemeEntityBaseJsonVo.getValue()).getShortLink());
            }
            return groupDistributorVo;
        }).collect(Collectors.toList());
        PageInfo pageInfo2 = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)pageInfo2);
        pageInfo2.setList(result);
        return pageInfo2;
    }

    private boolean canGetCode(String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (Objects.equals(activeEntity.getActiveType(), 15)) {
            ActivePropertyEntity query = new ActivePropertyEntity();
            query.setBindCode(activeEntity.getBindCode());
            List propertyEntities = this.activePropertyMapper.getList(query);
            if (CollectionUtils.isNotEmpty((Collection)propertyEntities)) {
                return propertyEntities.stream().anyMatch(p -> Objects.equals(p.getPropertyKey(), "cashTakeType") && Objects.equals(p.getPropertyValue(), "\u4ec5\u4e00\u6b21"));
            }
        }
        return false;
    }

    public String encrypt32(String encryptStr) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md5Bytes = md5.digest(encryptStr.getBytes());
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            encryptStr = hexValue.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encryptStr;
    }

    public String encrypt16(String encryptStr) {
        return this.encrypt32(encryptStr).substring(8, 24);
    }
}

