/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionOrderMapper;
import cc.lechun.mall.entity.distribution.DistributionOrderEntity;
import cc.lechun.mall.entity.distribution.DistributionOrderEntityEx;
import cc.lechun.mall.entity.distribution.DistributionOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionOrderService
extends BaseService<DistributionOrderEntity, Integer>
implements DistributionOrderInterface {
    @Resource
    private DistributionOrderMapper distributionOrderMapper;
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    MallOrderPayInterface payInterface;
    @Autowired
    DistributionInviteLogInterface inviteLogInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;

    @Override
    public void finishDistributionOrders() {
        try {
            String confirmDays = this.dictionaryInterface.getDictionary(1000, 206, "CONFIRM_DAYS_BEFORE").getDictionaryName();
            this.logger.info("\u5c06\u786e\u8ba4\u6536\u83b7" + confirmDays + "\u5929");
            List<DistributionOrderEntityEx> orders = this.distributionOrderMapper.getFinishedDistributionOrders();
            this.logger.info("\u5c06\u786e\u8ba4\u6536\u83b7" + confirmDays + "\u5929,\u8ba2\u5355\u6570\uff1a" + orders.size());
            for (DistributionOrderEntityEx order : orders) {
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + JsonUtils.toJson((Object)order, (boolean)true));
                Map<String, BigDecimal> finalOrderAmount = this.orderInterface.getFinalOrderAmount(order.getOrderNo());
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",refundAmout:" + finalOrderAmount.get("refundAmount") + ",orderAmount:" + finalOrderAmount.get("orderAmount"));
                BigDecimal refundAmount = finalOrderAmount.get("refundAmount");
                order.setSaleAmount(finalOrderAmount.get("orderAmount").subtract(refundAmount));
                BigDecimal rate = finalOrderAmount.get("orderAmount").doubleValue() == 0.0 ? BigDecimal.ZERO : PriceUtils.divide((BigDecimal)order.getExpectOrderAmount(), (BigDecimal)finalOrderAmount.get("orderAmount"));
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u6bd4\u4f8b\uff1a" + rate);
                refundAmount = PriceUtils.multiply((BigDecimal)refundAmount, (BigDecimal)rate);
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u9000\u6b3e\u91d1\u989d0\uff1a" + refundAmount);
                order.setRefundAmount(refundAmount);
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u9000\u6b3e\u91d1\u989d\uff1a" + refundAmount);
                order.setFinalOrderAmount(order.getExpectOrderAmount().subtract(refundAmount));
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u6700\u7ec8\u8ba2\u5355\u91d1\u989d\uff1a" + order.getFinalOrderAmount());
                if (order.getFinalOrderAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    order.setFinalOrderAmount(BigDecimal.ZERO);
                }
                if (refundAmount.compareTo(BigDecimal.ZERO) == 1) {
                    order.setDiffReason("\u9000\u6b3e" + refundAmount + "\u5143");
                }
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u5f00\u59cb\u5224\u65ad\u65f6\u95f4");
                Date finishOrderTimeEnd = DateUtils.getAddDateByDay((Date)(order.getPickupDate() == null ? order.getCreateTime() : order.getPickupDate()), (int)Integer.valueOf(confirmDays));
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u5f00\u59cb\u5224\u65ad\u65f6\u95f4" + finishOrderTimeEnd);
                finishOrderTimeEnd = DateUtils.getDateFromString((String)DateUtils.formatDate((Date)finishOrderTimeEnd, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u683c\u5f0f\u5316\u5f00\u59cb\u5224\u65ad\u65f6\u95f4" + finishOrderTimeEnd);
                if (DateUtils.currentDate().after(finishOrderTimeEnd)) {
                    order.setHasSettled(1);
                }
                this.logger.info("\u5faa\u73af\u8ba2\u5355\u53f7:" + order.getOrderNo() + ",\u7ed3\u7b97\uff1a" + order.getHasSettled());
                BigDecimal perRefundAmount = order.getExpectOrderAmount().doubleValue() == 0.0 ? BigDecimal.ZERO : order.getExpectPercentageAmount().divide(order.getExpectOrderAmount(), 6).multiply(refundAmount);
                order.setFinalPercentageAmount(order.getExpectPercentageAmount().subtract(perRefundAmount));
                if (order.getFinalPercentageAmount().doubleValue() < 0.0) {
                    order.setFinalPercentageAmount(BigDecimal.ZERO);
                }
                order.setUpdateTime(DateUtils.now());
                this.logger.info("\u66f4\u65b0\u5206\u9500\uff1a");
                this.distributionOrderMapper.updateByPrimaryKeySelective(order);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public PageInfo<DistributionOrderVo> getListVo(Integer pageNum, Integer pageSize, DistributionOrderVo vo) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        if (StringUtils.isEmpty((String)vo.getMobile())) {
            vo.setMobile(null);
        } else {
            vo.setMobile(SqlUtils.sqlLike((String)vo.getMobile(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)vo.getNickName())) {
            vo.setNickName(null);
        } else {
            vo.setNickName(SqlUtils.sqlLike((String)vo.getNickName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        if (StringUtils.isEmpty((String)vo.getOrderNo())) {
            vo.setOrderNo(null);
        } else {
            vo.setOrderNo(SqlUtils.sqlLike((String)vo.getOrderNo(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        }
        page.setOrderBy("t1.CREATE_TIME DESC");
        this.distributionOrderMapper.getListVo(vo);
        PageInfo pg = page.toPageInfo();
        return pg;
    }
}

