/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorQiyeweixinExternalContactMapper;
import cc.lechun.mall.entity.distribution.DefineStatusEnum;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactBase;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactVo;
import cc.lechun.mall.entity.distribution.SaveSuccEnum;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.distribution.DistributorQiyeweixinExternalContactInterface;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.qiyeweixin.entity.tag.TagGroupUserQueryVo;
import cc.lechun.scrm.entity.route.RouteCustomerQwCountVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ReadThroughAssignCache;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributorQiyeweixinExternalContactService
extends BaseService<DistributorQiyeweixinExternalContactEntity, Integer>
implements DistributorQiyeweixinExternalContactInterface {
    @Resource
    private DistributorQiyeweixinExternalContactMapper distributorQiyeweixinExternalContactMapper;
    @Autowired
    private MallUserInterface mallUserInterface;

    @Override
    public PageInfo<DistributorQiyeweixinExternalContactEntity> getDistributorQiyeweixinExternalContactEntityList(PageForm pageForm, String customerId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy(" customer_id ");
        DistributorQiyeweixinExternalContactEntity query = new DistributorQiyeweixinExternalContactEntity();
        if (StringUtils.isNotEmpty((String)customerId)) {
            query.setCustomerId(customerId);
        }
        query.setSaveSucc(1);
        query.setType(1);
        this.distributorQiyeweixinExternalContactMapper.getList(query);
        return page.toPageInfo();
    }

    @Override
    public PageInfo<DistributorQiyeweixinExternalContactBase> getDistributorQiyeweixinExternalContactList(PageForm pageForm, String customerId, List<String> qyWeixinUseridList, String start, String end) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy(" ID DESC ");
        String[] arr = null;
        if (CollectionUtils.isNotEmpty(qyWeixinUseridList)) {
            arr = qyWeixinUseridList.toArray(new String[qyWeixinUseridList.size()]);
        }
        List<DistributorQiyeweixinExternalContactEntity> list = this.distributorQiyeweixinExternalContactMapper.getDistributorQiyeweixinExternalContactList(customerId, arr, start, end);
        List result = list.stream().map(item -> {
            DistributorQiyeweixinExternalContactBase base = new DistributorQiyeweixinExternalContactBase();
            BeanUtils.copyProperties((Object)item, (Object)base);
            base.setDefineStatusName(DefineStatusEnum.getName(item.getDefineStatus()));
            base.setSaveSuccName(SaveSuccEnum.getName(item.getSaveSucc()));
            return base;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(result);
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    @Override
    public List<DistributorQiyeweixinExternalContactEntity> getDistributorQiyeweixinExternalContactEntityList(String[] customerIds) {
        return this.distributorQiyeweixinExternalContactMapper.getDistributorQiyeweixinExternalContactEntityListByCustomerIds(customerIds);
    }

    @Override
    public PageInfo<DistributorQiyeweixinExternalContactVo> getUserContactTagList(TagGroupUserQueryVo tagGroupUserQueryVo) {
        tagGroupUserQueryVo.setCustomerId(null);
        Page page = PageHelper.startPage((int)tagGroupUserQueryVo.getCurrentPage(), (int)tagGroupUserQueryVo.getPageSize());
        page.setOrderBy(" ID desc ");
        String[] tempArr = new String[]{tagGroupUserQueryVo.getQyWeixinUserid()};
        this.distributorQiyeweixinExternalContactMapper.getUserContactTagList2(tempArr, tagGroupUserQueryVo.getExternalUserid(), tagGroupUserQueryVo.getCustomerId(), CollectionUtils.isNotEmpty(tagGroupUserQueryVo.getTagList()) ? tagGroupUserQueryVo.getTagList().toArray(new String[tagGroupUserQueryVo.getTagList().size()]) : null);
        return page.toPageInfo();
    }

    @Override
    public BaseJsonVo saveDefineName(String userId, String customerId, String defineName) {
        if (StringUtils.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237Id\u672a\u7a7a");
        }
        if (StringUtils.isEmpty((String)defineName)) {
            return BaseJsonVo.error((String)"\u81ea\u5b9a\u4e49\u6635\u79f0\u672a\u7a7a");
        }
        DistributorQiyeweixinExternalContactEntity entity = new DistributorQiyeweixinExternalContactEntity();
        MallUserEntity userEntity = null;
        if (userId != null) {
            userEntity = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)userId));
        }
        if (userEntity != null) {
            entity.setQyWeixinUserid(userEntity.getQyWeixinUserid());
        }
        entity.setCustomerId(customerId);
        entity = (DistributorQiyeweixinExternalContactEntity)this.getSingle(entity, 0L);
        if (entity != null) {
            entity.setDefineName(defineName);
            this.updateByPrimaryKeySelective(entity);
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
    }

    @Override
    public BaseJsonVo saveSuccStatus(String userId, String customerId, Integer isDelMe) {
        if (StringUtils.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237Id\u4e3a\u7a7a");
        }
        if (isDelMe == null) {
            isDelMe = 1;
        }
        DistributorQiyeweixinExternalContactEntity entity = new DistributorQiyeweixinExternalContactEntity();
        MallUserEntity userEntity = null;
        if (userId == null) {
            return BaseJsonVo.error((String)"UserId\u4e3a\u7a7a");
        }
        userEntity = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)userId));
        if (userEntity != null) {
            entity.setQyWeixinUserid(userEntity.getQyWeixinUserid());
        }
        entity.setCustomerId(customerId);
        entity = (DistributorQiyeweixinExternalContactEntity)this.getSingle(entity);
        if (entity != null) {
            if (isDelMe == 1 || isDelMe == 2) {
                entity.setSaveSucc(isDelMe);
            }
            entity.setDefineStatus(isDelMe);
            this.updateByPrimaryKeySelective(entity);
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
    }

    @Override
    public List<Map<String, Object>> getContactCount() {
        return this.distributorQiyeweixinExternalContactMapper.getContactCount();
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="getQiWeixinUseridList", expiration=86400)
    public List<RouteCustomerQwCountVo> getQiWeixinUseridList() {
        return this.distributorQiyeweixinExternalContactMapper.getQiWeixinUseridList();
    }
}

