/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorRelationMapper;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DistributorRelationService
extends BaseService<DistributorRelationEntity, Integer>
implements DistributorRelationInterface {
    @Resource
    private DistributorRelationMapper distributorRelationMapper;

    @Override
    public List<DistributorRelationEntity> getDistributorRelation(Integer distributorId) {
        DistributorRelationEntity param = new DistributorRelationEntity();
        param.setDistributorId(distributorId);
        return this.getList(param);
    }

    @Override
    public BaseJsonVo saveDistributorRelation(DistributorRelationEntity relationEntity) {
        BaseJsonVo jsonVo;
        this.logger.info("\u4fdd\u5b58\u4e1a\u52a1\u5458:{}", (Object)relationEntity.toString());
        DistributorRelationEntity param = new DistributorRelationEntity();
        param.setDistributorId(relationEntity.getDistributorId());
        relationEntity.setRelationType(1);
        param = (DistributorRelationEntity)this.getSingle(param);
        if (param != null) {
            relationEntity.setId(param.getId());
        }
        if (!(jsonVo = this.validateRepeat(relationEntity, "relationUserId", "\u8d26\u53f7")).isSuccess()) {
            return jsonVo;
        }
        if (relationEntity.getId() == null) {
            Boolean inviteNoExists = true;
            while (inviteNoExists.booleanValue()) {
                String inviteCode = RandomUtils.generateString((int)8);
                relationEntity.setDistributorRelationCode(inviteCode);
                if (!this.validateRepeat(relationEntity, "distributorRelationCode", "\u9080\u8bf7\u7801").isSuccess()) continue;
                inviteNoExists = false;
            }
        }
        if (this.insertOrUpdate(relationEntity) > 0) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public DistributorRelationEntity getDistributorRelationByRelationUserId(String customerId, Integer relationType) {
        DistributorRelationEntity param = new DistributorRelationEntity();
        param.setRelationUserId(customerId);
        param.setRelationType(relationType);
        List list = this.distributorRelationMapper.getList(param);
        if (list != null && list.size() > 0) {
            return (DistributorRelationEntity)list.get(0);
        }
        return null;
    }
}

