/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.active.entity.active.QyInviteEntity;
import cc.lechun.active.iservice.active.QyInviteInterface;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.distribution.DistributorMapper;
import cc.lechun.mall.dao.distribution.DistributorQiyeweixinExternalContactMapper;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.DistribuorClassEnum;
import cc.lechun.mall.entity.distribution.DistributionMediaEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaStaffEntity;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorGroupEntity;
import cc.lechun.mall.entity.distribution.DistributorQiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.distribution.DistributorVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributionMediaInterface;
import cc.lechun.mall.iservice.distribution.DistributionMediaStaffInterface;
import cc.lechun.mall.iservice.distribution.DistributorGroupInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import cc.lechun.qiyeweixin.iservice.QiYeWeiXinContactInterface;
import cc.lechun.qiyeweixin.iservice.needaddphone.NeedAddPhoneInterface;
import cc.lechun.scrm.entity.AppEnum;
import cc.lechun.utils.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import weixin.popular.api.qy.FollowUserAPI;
import weixin.popular.api.qy.SendMsgAPI;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.qy.ExternalContact;
import weixin.popular.bean.qy.FollowUser;
import weixin.popular.bean.qy.FollowUserContactResult;
import weixin.popular.bean.qy.FollowUserInfo;
import weixin.popular.bean.qy.FollowUserResult;
import weixin.popular.bean.qy.QySendMsg;
import weixin.popular.bean.qy.QySendMsgAttachmentsMini;
import weixin.popular.bean.qy.QySendMsgAttachmentsMiniBody;
import weixin.popular.bean.qy.SendMsgResult;
import weixin.popular.bean.qy.UserResult;

@Service
public class DistributorService
extends BaseService<DistributorEntity, Integer>
implements DistributorInterface {
    @Resource
    private DistributorMapper distributorMapper;
    @Autowired
    private DistributorQiyeweixinExternalContactMapper distributorQiyeweixinExternalContactMapper;
    @Autowired
    private DistributorGroupInterface distributorGroupInterface;
    @Autowired
    private DistributorRelationInterface distributorRelationInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private WeiXinBaseAccessToken weiXinBaseInterface;
    @Autowired
    private DistributionInviteInterface inviteInterface;
    @Autowired
    private QyInviteInterface qyInviteInterface;
    @Autowired
    private DistributionMediaStaffInterface distributionMediaStaffInterface;
    @Autowired
    private DistributionMediaInterface distributionMediaInterface;
    @Autowired
    private NeedAddPhoneInterface needAddPhoneInterface;
    @Autowired
    QiYeWeiXinContactInterface qiYeWeiXinContactInterface;
    @Autowired
    RedisCacheUtil redisCacheUtil;
    @Autowired
    private SysUserInterface sysUserInterface;

    @Override
    public List<Map<String, Object>> getDistributorList(Integer appId, Integer distributorType) {
        DistributorEntity query = new DistributorEntity();
        query.setAppId(appId);
        if (distributorType != null && !Objects.equals(distributorType, -1)) {
            query.setDistributorType(distributorType);
        }
        query.setStatus(1);
        List list = this.distributorMapper.getList(query);
        List<MallUserEntity> lst = this.sysUserInterface.getUserList(new MallUserEntity());
        lst = lst.stream().filter(c -> StringUtils.isNotEmpty((String)c.getQyWeixinUserid())).collect(Collectors.toList());
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (DistributorEntity item : list) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Optional<MallUserEntity> userEntityOptional = lst.stream().filter(u -> Objects.equals(item.getQyWeixinUserid(), u.getQyWeixinUserid())).findFirst();
            if (!userEntityOptional.isPresent()) continue;
            map.put("id", item.getId());
            map.put("name", item.getDistributorName());
            map.put("type", item.getDistributorType());
            map.put("limitNum", item.getLimitNum());
            map.put("qyWeixinUserid", item.getQyWeixinUserid());
            maps.add(map);
        }
        return maps;
    }

    @Override
    public BaseJsonVo<JSONObject> getDistributor(Integer appId, String userId) {
        MallUserEntity mallUserEntity = this.sysUserInterface.getMallUser(userId);
        if (StringUtils.isEmpty((String)mallUserEntity.getQyWeixinUserid())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u662f\u5206\u9500\u5458");
        }
        DistributorEntity distributorEntity = new DistributorEntity();
        distributorEntity.setQyWeixinUserid(mallUserEntity.getQyWeixinUserid());
        distributorEntity.setAppId(appId);
        DistributorEntity result = (DistributorEntity)this.getSingle(distributorEntity, 0L);
        if (result != null) {
            Map map = ObjectConvert.beanToMap((Object)result);
            JSONObject jsonObject = new JSONObject(map);
            jsonObject.put("distributorId", (Object)result.getId());
            jsonObject.put("dingdingId", (Object)mallUserEntity.getDingdingId());
            jsonObject.put("qyWeixinUserid", (Object)mallUserEntity.getQyWeixinUserid());
            return BaseJsonVo.success((Object)jsonObject);
        }
        return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u662f\u5206\u9500\u5458");
    }

    public BaseJsonVo getDistributorById(Integer distributorId) {
        DistributorEntity distributorEntity = (DistributorEntity)this.selectByPrimaryKey(distributorId);
        Map map = BeanUtils.beanToMap((Object)distributorEntity);
        map.put("userId", "");
        MallUserEntity query = new MallUserEntity();
        if (StringUtils.isNotEmpty((String)distributorEntity.getQyWeixinUserid())) {
            query.setQyWeixinUserid(distributorEntity.getQyWeixinUserid());
            MallUserEntity userEntity = this.sysUserInterface.getSingle(query);
            if (userEntity != null) {
                map.put("userId", userEntity.getUserId());
            }
            map.put("dingdingId", userEntity.getDingdingId());
        }
        return BaseJsonVo.success((Object)map);
    }

    @Override
    public PageInfo<DistributorVo> getDistributorPageList(int pageNum, int pageSize, DistributorEntity distributorEntity) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize, (String)"ID DESC");
        if (StringUtils.isNotEmpty((String)distributorEntity.getDistributorPhone())) {
            distributorEntity.setDistributorPhone(SqlUtils.sqlLike((String)distributorEntity.getDistributorPhone(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            distributorEntity.setDistributorPhone(null);
        }
        if (StringUtils.isNotEmpty((String)distributorEntity.getDistributorName())) {
            distributorEntity.setDistributorName(SqlUtils.sqlLike((String)distributorEntity.getDistributorName(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        } else {
            distributorEntity.setDistributorName(null);
        }
        this.distributorMapper.getListVo(distributorEntity);
        PageInfo pg = page.toPageInfo();
        pg.getList().forEach(item -> item.setDistributorClassName(DistribuorClassEnum.getName(item.getDistributorClass())));
        return pg;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveDistributor(DistributorVo distributorVo) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        this.logger.info("\u4fdd\u5b58\u4e1a\u52a1\u5458:{}", (Object)distributorVo.toString());
        try {
            if (distributorVo.getStatus() == 1) {
                if (distributorVo.getGroupId() == null) {
                    return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
                }
                DistributorGroupEntity groupEntity = (DistributorGroupEntity)this.distributorGroupInterface.selectByPrimaryKey(distributorVo.getGroupId());
                if (groupEntity == null) {
                    return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
                }
                if (!StringUtils.checkPhone((String)distributorVo.getDistributorPhone()).booleanValue()) {
                    return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
                }
                if (StringUtils.isEmpty((String)distributorVo.getDistributorName()) && StringUtils.isEmpty((String)distributorVo.getRelationUserId())) {
                    return BaseJsonVo.error((String)"\u59d3\u540d\u5fc5\u586b");
                }
                if (Objects.equals(AppEnum.SCRM.getValue(), distributorVo.getAppId()) && this.customerInterface.getCustomer(distributorVo.getRelationUserId()) == null) {
                    return BaseJsonVo.error((String)"\u5173\u8054\u7528\u6237\u65e0\u6548");
                }
                distributorVo.setGroupName(groupEntity.getGroupName());
                jsonVo = this.validateRepeat(distributorVo, "distributorPhone", "\u624b\u673a\u53f7");
                if (!jsonVo.isSuccess()) {
                    return jsonVo;
                }
            }
            DistributorEntity distributorEntity = new DistributorEntity();
            if (Objects.equals(distributorVo.getAppId(), AppEnum.SALES.getValue())) {
                MallUserEntity userEntity = this.sysUserInterface.getMallUser(distributorVo.getRelationUserId());
                if (userEntity == null) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isEmpty((String)distributorVo.getRelationNickName())) {
                    distributorVo.setDistributorName(userEntity.getUserNick());
                }
                userEntity.setQyWeixinUserid(distributorVo.getDistributorPhone());
                try {
                    this.sysUserInterface.updateMallUser(userEntity);
                }
                catch (Exception e) {
                    this.logger.error("\u66f4\u65b0\u7528\u6237\u5931\u8d25", (Throwable)e);
                }
                distributorEntity.setQyWeixinUserid(distributorVo.getDistributorPhone());
                this.logger.info("distributorVo.getDistributorPhone:{}", (Object)distributorEntity.getQyWeixinUserid());
                distributorEntity.setBelongQyWeixinUserid(distributorVo.getDistributorPhone());
            }
            BeanUtils.beanCopy((Object)distributorVo, (Object)distributorEntity);
            if (Integer.valueOf(0).equals(distributorEntity.getStatus()) && distributorEntity.getEndTime() == null) {
                distributorEntity.setEndTime(new Date());
            }
            this.logger.info("distributorVo.getDistributorPhone:{}", (Object)distributorEntity.getQyWeixinUserid());
            this.logger.info("\u4e1a\u52a1\u5458\u4fdd\u5b58:{}", (Object)distributorEntity.toString());
            if (distributorEntity.getId() == null || distributorEntity.getId() == 0) {
                distributorEntity.setId(null);
                if (Objects.equals(distributorVo.getAppId(), AppEnum.SALES.getValue())) {
                    distributorEntity.setQyWeixinUserid(distributorVo.getDistributorPhone());
                    distributorEntity.setBelongQyWeixinUserid(distributorVo.getDistributorPhone());
                }
                this.insert(distributorEntity);
            } else {
                this.updateByPrimaryKey(distributorEntity);
            }
            DistributorRelationEntity relationEntity = new DistributorRelationEntity();
            BeanUtils.beanCopy((Object)distributorVo, (Object)relationEntity);
            relationEntity.setDistributorId(distributorEntity.getId());
            jsonVo = this.distributorRelationInterface.saveDistributorRelation(relationEntity);
            if (jsonVo.isSuccess()) {
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
            }
            this.logger.error("\u4e1a\u52a1\u5458\u4fdd\u5b58:{},{}", (Object)jsonVo.isSuccess(), (Object)jsonVo.getMessage());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return jsonVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Override
    @Transactional
    public BaseJsonVo getQiyeWeixinFollowUsers(Integer appId) {
        FollowUserResult followUserList = FollowUserAPI.getFollowUserList((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(7));
        try {
            if (followUserList.isSuccess()) {
                String[] follow_user = followUserList.getFollow_user();
                if (follow_user == null || follow_user.length == 0) {
                    return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1\u63a8\u5e7f\u7528\u6237");
                }
                ArrayList<String> syncQiyeweixinUserid = new ArrayList<String>();
                this.logger.info("follow_user:{}", (Object)JsonUtils.toJson((Object)follow_user, (boolean)false));
                for (String userId : follow_user) {
                    syncQiyeweixinUserid.add(userId);
                    DistributorEntity distributorEntity2 = new DistributorEntity();
                    distributorEntity2.setQyWeixinUserid(userId);
                    List list = this.distributorMapper.getList(distributorEntity2);
                    if (list != null && list.size() > 0) {
                        this.logger.error("\u8be5\u7528\u6237\u5df2\u5b58\u5728:{}", (Object)JsonUtils.toJson((Object)list, (boolean)false));
                        list.forEach(distributorEntity1 -> {
                            this.logger.error("1\u8be5\u7528\u6237\u72b6\u6001\u4e3a:{}\uff0c\u5224\u65ad\u662f\u5426\u76f8\u7b49[distributorEntity1.getStatus() == 0]\uff1a{}", (Object)distributorEntity1.getStatus(), (Object)(distributorEntity1.getStatus() == 0 ? 1 : 0));
                            this.logger.error("2\u8be5\u7528\u6237\u72b6\u6001\u4e3a:{}\uff0c\u5224\u65ad\u662f\u5426\u76f8\u7b49[distributorEntity1.getStatus() == 0]\uff1a{}", (Object)distributorEntity1.getStatus(), (Object)(distributorEntity1.getStatus() == 0 ? 1 : 0));
                            if (distributorEntity1.getStatus() == 0) {
                                // empty if block
                            }
                        });
                        continue;
                    }
                    UserResult user = FollowUserAPI.getUser((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(8), (String)userId);
                    if (!user.isSuccess()) {
                        this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8be5\u7528\u6237\u901a\u8baf\u5f55\u4fe1\u606f:{}", (Object)userId);
                        continue;
                    }
                    DistributorVo distributorVo = new DistributorVo();
                    distributorVo.setRelationUserId(userId);
                    distributorVo.setRelationType(1);
                    distributorVo.setRelationNickName(user.getName());
                    distributorVo.setEffectiveDays(365);
                    distributorVo.setRobbedable(1);
                    distributorVo.setRenewable(1);
                    distributorVo.setSelfable(1);
                    distributorVo.setDistributorable(1);
                    distributorVo.setPercentage(new BigDecimal("0.15"));
                    distributorVo.setDistributorPhone(user.getMobile());
                    distributorVo.setDistributorName(user.getName());
                    distributorVo.setGroupId(5);
                    distributorVo.setGroupName("\u4f01\u4e1a\u5fae\u4fe1");
                    distributorVo.setStatus(1);
                    distributorVo.setCreateTime(DateUtils.now());
                    distributorVo.setPlatformId(4);
                    BeanUtils.beanCopy((Object)distributorVo, (Object)distributorEntity2);
                    distributorEntity2.setQyWeixinUserid(userId);
                    distributorEntity2.setAppId(appId);
                    this.insert(distributorEntity2);
                    DistributorRelationEntity relationEntity = new DistributorRelationEntity();
                    BeanUtils.beanCopy((Object)distributorVo, (Object)relationEntity);
                    relationEntity.setDistributorId(distributorEntity2.getId());
                    BaseJsonVo jsonVo = this.distributorRelationInterface.saveDistributorRelation(relationEntity);
                    this.logger.info("\u4fdd\u5b58\u63a8\u5e7f\u5458\u7ed3\u679c{}\uff1a{}", (Object)jsonVo.isSuccess(), (Object)JsonUtils.toJson((Object)distributorVo, (boolean)false));
                }
                this.logger.info("syncQiyeweixinUserid:{}", (Object)JsonUtils.toJson(syncQiyeweixinUserid, (boolean)false));
                if (syncQiyeweixinUserid.size() > 0) {
                    List<DistributorEntity> hasnot = this.distributorMapper.getHasnotByList(syncQiyeweixinUserid);
                    this.logger.info("\u8fd9\u4e9b\u4f01\u4e1a\u5ba2\u670d\u5df2\u79bb\u804c\uff0c\u5c06\u7f6e\u4e3a\u5220\u9664\u72b6\u6001\uff1a{}", (Object)JsonUtils.toJson(hasnot, (boolean)false));
                    hasnot.forEach(distributorEntity -> {
                        if (distributorEntity.getEndTime() == null) {
                            distributorEntity.setEndTime(DateUtils.now());
                        }
                        distributorEntity.setStatus(0);
                        this.distributorMapper.updateByPrimaryKeySelective(distributorEntity);
                    });
                }
                return BaseJsonVo.success((Object)"\u540c\u6b65\u6210\u529f");
            }
        }
        catch (Exception e) {
            this.logger.error("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u5e7f\u7528\u6237\u5931\u8d25\u5f02\u5e38", (Throwable)e);
        }
        return BaseJsonVo.error((String)("\u4f01\u4e1a\u5fae\u4fe1\u63a8\u5e7f\u7528\u6237\u5931\u8d25" + followUserList.getErrmsg()));
    }

    @Override
    public BaseJsonVo getQiyeWeixinFollowUserContactResult(String userId, String externalId) {
        return BaseJsonVo.success((Object)FollowUserAPI.getFollowUserInfo((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(7), (String)externalId));
    }

    @Override
    public BaseJsonVo<String> getQiyeWeixinShareCode(String qyWeixinUserid) {
        List<DistributorRelationEntity> list;
        List<DistributorRelationEntity> relationEntityList;
        DistributorEntity query = new DistributorEntity();
        query.setQyWeixinUserid(qyWeixinUserid);
        query.setGroupId(5);
        DistributorEntity distributorEntity = (DistributorEntity)this.getSingle(query);
        if (distributorEntity != null && (relationEntityList = this.distributorRelationInterface.getDistributorRelation(distributorEntity.getId())).size() > 0 && CollectionUtils.isNotEmpty(list = this.distributorRelationInterface.getDistributorRelation(distributorEntity.getId()))) {
            return BaseJsonVo.success((Object)list.get(0).getDistributorRelationCode());
        }
        return BaseJsonVo.error((String)"\u672a\u627e\u5230\u5206\u9500\u7801");
    }

    @Override
    public DistributorEntity getDistributorEntity(String qyWeixinUserid) {
        DistributorEntity query = new DistributorEntity();
        query.setQyWeixinUserid(qyWeixinUserid);
        return (DistributorEntity)this.distributorMapper.getSingle(query);
    }

    @Override
    @Transactional
    public BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> addOrUpdateExternalContact(Integer appId, String userId, String externalUserID) {
        return ((DistributorService)SpringContextUtil.getBean(this.getClass())).addOrUpdateExternalContact(appId, userId, externalUserID, (Boolean)false);
    }

    @Override
    @Transactional
    public BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> addOrUpdateExternalContact(Integer appId, String userId, String externalUserID, Boolean addByTransfer) {
        FollowUserContactResult followUserInfoResult = FollowUserAPI.getFollowUserInfo((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(7), (String)externalUserID);
        if (!followUserInfoResult.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5916\u90e8\u8054\u7cfb\u4eba\u5931\u8d25\uff1a{}", (Object)JsonUtils.toJson((Object)followUserInfoResult, (boolean)false));
            return BaseJsonVo.error((String)("\u83b7\u53d6\u5916\u90e8\u8054\u7cfb\u4eba\u5931\u8d25\uff1a" + followUserInfoResult.getErrmsg()));
        }
        ExternalContact external_contact = followUserInfoResult.getExternal_contact();
        List follow_info_list = followUserInfoResult.getFollow_user();
        if (StringUtils.isNotEmpty((String)userId)) {
            List<FollowUser> collect = follow_info_list.stream().filter(followUser -> userId.equals(followUser.getUserid())).collect(Collectors.toList());
            return this.addOrUpdateExternalContact(appId, collect, external_contact, addByTransfer);
        }
        return this.addOrUpdateExternalContact(appId, follow_info_list, external_contact, addByTransfer);
    }

    @Override
    @Transactional
    public BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> addOrUpdateExternalContact(Integer appId, List<FollowUser> followUserList, ExternalContact externalContact) {
        return ((DistributorService)SpringContextUtil.getBean(this.getClass())).addOrUpdateExternalContact(appId, followUserList, externalContact, (Boolean)false);
    }

    @Override
    public BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> addOrUpdateExternalContact(Integer appId, List<FollowUser> followUserList, ExternalContact externalContact, Boolean addByTransfer) {
        if (externalContact == null || followUserList == null || followUserList.size() == 0) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        ArrayList rtnList = new ArrayList();
        followUserList.forEach(followUser -> {
            BaseJsonVo inviteRst;
            String mobile;
            DistributorEntity distributorEntity = new DistributorEntity();
            distributorEntity.setQyWeixinUserid(followUser.getUserid());
            List list = this.distributorMapper.getList(distributorEntity);
            if (list == null || list.size() == 0) {
                this.getQiyeWeixinFollowUsers(appId);
                list = this.distributorMapper.getList(distributorEntity);
            }
            distributorEntity = (DistributorEntity)list.get(0);
            DistributorQiyeweixinExternalContactEntity entity = this.buildContactEntity((FollowUser)followUser, externalContact, addByTransfer);
            Boolean isAdd = false;
            if (entity.getId() != null) {
                this.distributorQiyeweixinExternalContactMapper.updateByPrimaryKey(entity);
            } else {
                this.distributorQiyeweixinExternalContactMapper.insert(entity);
                isAdd = true;
            }
            BaseJsonVo saveCustomerRst = null;
            if (StringUtils.isEmpty((String)entity.getCustomerId()) && entity.getType() == 1) {
                try {
                    saveCustomerRst = this.customerInterface.addCustomer4Wechat(7, entity.getExternalUserid(), entity.getUnionid(), entity.getName(), "", null, "", "");
                }
                catch (IOException e) {
                    this.logger.error("\u4f01\u5fae\u5ba2\u6237\u4fdd\u5b58\u5230customer\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                if (saveCustomerRst != null && saveCustomerRst.isSuccess()) {
                    entity.setCustomerId(((CustomerEntity)saveCustomerRst.getValue()).getCustomerId());
                } else {
                    this.logger.info("\u4f01\u5fae\u5ba2\u6237\u4fdd\u5b58\u5230customer\u5931\u8d25\uff1a{}", (Object)JsonUtils.toJson((Object)saveCustomerRst, (boolean)false));
                }
                this.distributorQiyeweixinExternalContactMapper.updateByPrimaryKey(entity);
            }
            if (StringUtils.isNotEmpty((String)entity.getRemarkMobiles()) && StringUtils.isNotEmpty((String)(mobile = entity.getRemarkMobiles().split(",")[0])) && mobile.length() == 11) {
                BaseJsonVo saveMobileRst = this.customerInterface.saveMobile(mobile, entity.getCustomerId());
                this.logger.info("\u540c\u6b65\u4f01\u5fae\u7528\u6237[{}]\u4fdd\u5b58\u624b\u673a\u53f7\u7ed3\u679c[{}]:{}", new Object[]{entity.getExternalUserid(), saveMobileRst.isSuccess(), JsonUtils.toJson((Object)saveMobileRst, (boolean)false)});
                this.needAddPhoneInterface.addNeedAddPhoneSuccess(mobile, entity.getExternalUserid());
            }
            if (StringUtils.isNotEmpty((String)entity.getCustomerId()) && isAdd.booleanValue() && !(inviteRst = this.inviteInterface.insertQiyeweixinUserInvite(distributorEntity, entity.getCreateTime(), entity.getCustomerId())).isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u4f01\u5fae\u5ba2\u6237\u5904\u7406invite\u5931\u8d25\uff1a{}", (Object)JsonUtils.toJson((Object)inviteRst, (boolean)false));
            }
            rtnList.add(entity);
        });
        return BaseJsonVo.success(rtnList);
    }

    public DistributorQiyeweixinExternalContactEntity buildContactEntity(FollowUser followUser, ExternalContact externalContact, Boolean addByTransfer) {
        DistributorQiyeweixinExternalContactEntity entity = new DistributorQiyeweixinExternalContactEntity();
        entity.setExternalUserid(externalContact.getExternal_userid());
        entity.setQyWeixinUserid(followUser.getUserid());
        List list = this.distributorQiyeweixinExternalContactMapper.getList(entity);
        if (list != null && list.size() > 0) {
            if (list.size() > 1) {
                this.logger.error("\u8b66\u544a\uff0ct_mall_distributor_qiyeweixin_external_contact\u8868\u6709\u91cd\u590d\u8bb0\u5f55[external_userid={}][qy_weixin_userid={}]", (Object)entity.getExternalUserid(), (Object)entity.getQyWeixinUserid());
            }
            entity.setId(((DistributorQiyeweixinExternalContactEntity)list.get(0)).getId());
            entity.setCustomerId(((DistributorQiyeweixinExternalContactEntity)list.get(0)).getCustomerId());
            entity.setSaveSucc(1);
            entity.setDefineName(((DistributorQiyeweixinExternalContactEntity)list.get(0)).getDefineName());
            entity.setDefineStatus(((DistributorQiyeweixinExternalContactEntity)list.get(0)).getDefineStatus());
        }
        entity.setDeleteTime(null);
        entity.setSaveSucc(1);
        entity.setName(externalContact.getName());
        entity.setAvatar(externalContact.getAvatar());
        entity.setType(externalContact.getType());
        entity.setGender(externalContact.getGender());
        entity.setUnionid(externalContact.getUnionid());
        entity.setPosition(externalContact.getPosition());
        entity.setCorpName(externalContact.getCorp_name());
        entity.setCorpFullName(externalContact.getCorp_full_name());
        entity.setExternalProfile(externalContact.getExternal_profile() == null ? "" : externalContact.getExternal_profile().toString());
        entity.setCreateTime(new Date(followUser.getCreatetime() * 1000L));
        entity.setAddWay(String.valueOf(followUser.getAdd_way()));
        entity.setState(followUser.getState());
        Boolean b = this.qiYeWeiXinContactInterface.isTransferTakeOverRelation(entity.getExternalUserid(), entity.getQyWeixinUserid());
        entity.setAddByTransfer(addByTransfer != false || b != false ? 1 : 0);
        if (followUser.getAdd_way() != null && (followUser.getAdd_way() == 201 || followUser.getAdd_way() == 202)) {
            entity.setAddByTransfer(1);
        }
        entity.setRemarkCorpName(followUser.getRemark_corp_name());
        entity.setRemark(followUser.getRemark());
        entity.setDescription(followUser.getDescription());
        if (followUser.getRemark_mobiles() != null && followUser.getRemark_mobiles().size() > 0) {
            StringBuilder mobiles = new StringBuilder();
            for (String remark_mobile : followUser.getRemark_mobiles()) {
                mobiles.append(remark_mobile).append(",");
            }
            entity.setRemarkMobiles(mobiles.deleteCharAt(mobiles.length() - 1).toString());
        }
        return entity;
    }

    @Override
    public BaseJsonVo deleteExternalContact(String userId, String externalUserID, Integer status, Boolean deleteByTransfer) {
        DistributorQiyeweixinExternalContactEntity entity = new DistributorQiyeweixinExternalContactEntity();
        entity.setExternalUserid(externalUserID);
        entity.setQyWeixinUserid(userId);
        List list = this.distributorQiyeweixinExternalContactMapper.getList(entity);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(d -> {
                if (deleteByTransfer.booleanValue()) {
                    d.setDeleteByTransfer(1);
                }
                d.setSaveSucc(status);
                d.setDeleteTime(DateUtils.now());
                this.distributorQiyeweixinExternalContactMapper.updateByPrimaryKeySelective(d);
            });
        }
        if (Integer.valueOf(2).equals(status) && list.size() > 0) {
            try {
                WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getAccessTokenByPlatformId(7);
                if (weiXinBaseEntity != null && DateUtil.getCurrentHour() < 22 && DateUtil.getCurrentHour() >= 8) {
                    String text = "\u5ba2\u6237\u3010" + ((DistributorQiyeweixinExternalContactEntity)list.get(0)).getName() + "\u3011\u628a\u60a8\u4ece\u597d\u53cb\u5217\u8868\u4e2d\u5220\u9664\u4e86\uff0c<a href='https://csms.lechun.cc/userInfoQw?partnerId=" + externalUserID + "'>\u70b9\u51fb\u67e5\u770b</a>";
                    WxApiUtils.sendAppTextMessage((String)weiXinBaseEntity.getAccessToken(), (Integer)Integer.valueOf(weiXinBaseEntity.getMchId()), (String)userId, (String)text);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<DistributorQiyeweixinExternalContactEntity> getDistributorContactByPhone(String phone) {
        return this.distributorQiyeweixinExternalContactMapper.getDistributorContactByPhone(phone);
    }

    @Override
    public BaseJsonVo sendInvitePageMsg(String bindcode) {
        QyInviteEntity param = new QyInviteEntity();
        param.setBindCode(bindcode);
        List list = this.qyInviteInterface.getList(param);
        this.logger.info("send-list:{}", (Object)JsonUtils.toJson((Object)list, (boolean)false));
        HashMap map = new HashMap();
        list.forEach(qyInviteEntity -> {
            String qyWeixinUserid = qyInviteEntity.getQyWeixinUserid();
            if (map.containsKey(qyWeixinUserid)) {
                String[] external_userid = ((QySendMsg)map.get(qyWeixinUserid)).getExternal_userid();
                String[] new_external_userid = new String[external_userid.length + 1];
                System.arraycopy(external_userid, 0, new_external_userid, 0, external_userid.length);
                new_external_userid[new_external_userid.length - 1] = qyInviteEntity.getCustomerOpenId();
                ((QySendMsg)map.get(qyWeixinUserid)).setExternal_userid(new_external_userid);
                this.logger.info("put-add-new:{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
            } else {
                QySendMsg qySendMsg = new QySendMsg();
                qySendMsg.setChat_type("single");
                QySendMsgAttachmentsMini qySendMsgAttachmentsMini = new QySendMsgAttachmentsMini();
                QySendMsgAttachmentsMiniBody qySendMsgAttachmentsMiniBody = new QySendMsgAttachmentsMiniBody();
                DistributorEntity distributorEntityParam = new DistributorEntity();
                distributorEntityParam.setQyWeixinUserid(qyWeixinUserid);
                List list1 = this.distributorMapper.getList(distributorEntityParam);
                this.logger.info("new-list1:{}", (Object)JsonUtils.toJson((Object)list1, (boolean)false));
                if (list1 == null || list1.size() == 0) {
                    return;
                }
                DistributorRelationEntity distributorRelationEntityParam = new DistributorRelationEntity();
                distributorRelationEntityParam.setDistributorId(((DistributorEntity)list1.get(0)).getId());
                List list2 = this.distributorRelationInterface.getList(distributorRelationEntityParam);
                this.logger.info("new-list2:{}", (Object)JsonUtils.toJson((Object)list2, (boolean)false));
                if (list2 == null || list2.size() == 0) {
                    return;
                }
                DistributionMediaEntity mediaEntityParam = new DistributionMediaEntity();
                mediaEntityParam.setItemId(bindcode);
                List list4 = this.distributionMediaInterface.getList(mediaEntityParam);
                if (list4 == null || list4.size() == 0) {
                    return;
                }
                DistributionMediaStaffEntity mediaParam = new DistributionMediaStaffEntity();
                mediaParam.setDistributorRelationId(((DistributorRelationEntity)list2.get(0)).getId());
                mediaParam.setMediaId(((DistributionMediaEntity)list4.get(0)).getMediaId());
                List list3 = this.distributionMediaStaffInterface.getList(mediaParam);
                this.logger.info("new-list3:{}", (Object)JsonUtils.toJson((Object)list3, (boolean)false));
                if (list3 == null || list3.size() == 0) {
                    return;
                }
                DistributionMediaStaffEntity distributionMediaStaffEntity = (DistributionMediaStaffEntity)list3.get(0);
                qySendMsgAttachmentsMiniBody.setTitle(distributionMediaStaffEntity.getMediaTitle());
                qySendMsgAttachmentsMiniBody.setPic_media_id(distributionMediaStaffEntity.getPicQyMediaId());
                qySendMsgAttachmentsMiniBody.setAppid(distributionMediaStaffEntity.getAppId());
                qySendMsgAttachmentsMiniBody.setPage(distributionMediaStaffEntity.getBasePath());
                qySendMsgAttachmentsMini.setMiniprogram(qySendMsgAttachmentsMiniBody);
                ArrayList<QySendMsgAttachmentsMini> listA = new ArrayList<QySendMsgAttachmentsMini>();
                listA.add(qySendMsgAttachmentsMini);
                qySendMsg.setAttachments(listA);
                String[] externalUserId = new String[]{qyInviteEntity.getCustomerOpenId()};
                qySendMsg.setExternal_userid(externalUserId);
                map.put(qyWeixinUserid, qySendMsg);
                this.logger.info("putnew:{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
            }
        });
        this.logger.info("map:{}", (Object)JsonUtils.toJson(map, (boolean)false));
        Boolean[] b = new Boolean[]{true};
        StringBuilder sb = new StringBuilder();
        map.keySet().forEach(qyWeixinUserid -> {
            SendMsgResult sendMsgResult = SendMsgAPI.sendQyMsg((String)this.weiXinBaseInterface.getAccessTokenValueByPlatformId(7), (QySendMsg)((QySendMsg)map.get(qyWeixinUserid)));
            if (!sendMsgResult.isSuccess()) {
                sb.append(sendMsgResult.getErrmsg());
            }
            if (sendMsgResult.getFail_list() != null && sendMsgResult.getFail_list().length > 0) {
                this.qyInviteInterface.recordFail(bindcode, sendMsgResult.getFail_list());
                b[0] = false;
            }
        });
        if (sb.length() > 0) {
            return BaseJsonVo.error((String)sb.toString());
        }
        return b[0] != false ? BaseJsonVo.success((String)"\u53d1\u9001\u6210\u529f", null) : BaseJsonVo.error((String)"\u90e8\u5206\u5931\u8d25");
    }

    @Override
    public BaseJsonVo syncContactBatchWithoutTag(Integer appId) {
        return BaseJsonVo.error((String)"\u6b64\u65b9\u6cd5\u4e0d\u53ef\u7528\uff0c\u4f1a\u5bfc\u81f4\u7528\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
    }

    @Override
    public BaseJsonVo afterSyncContactBatchDoDeleteContact() {
        return BaseJsonVo.error((String)"\u6b64\u65b9\u6cd5\u4e0d\u53ef\u7528\uff0c\u4f1a\u5bfc\u81f4\u7528\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
    }

    @Override
    @ReadThroughSingleCache(namespace="DistributorService.getUserIdByDistributor", expiration=1000)
    public List<String> getUserIdByDistributor(@ParameterValueKeyProvider List<String> distributorIds) {
        if (distributorIds == null || distributorIds.size() == 0) {
            return new ArrayList<String>();
        }
        return this.distributorMapper.getUserIdByDistributor(distributorIds);
    }

    @Override
    @ReadThroughSingleCache(namespace="DistributorService.getUserIdByDistributor", expiration=1000)
    public Map<String, String> getUserIdByDistributor(@ParameterValueKeyProvider Integer distributorId) {
        if (distributorId == null) {
            return new HashMap<String, String>();
        }
        return this.distributorMapper.getUserIdAndQwIdByDistributor(distributorId);
    }

    private /* synthetic */ void lambda$syncContactBatchWithoutTag$10(Integer appId, final FollowUserInfo followContact) {
        BaseJsonVo<List<DistributorQiyeweixinExternalContactEntity>> saveContactRst = ((DistributorService)SpringContextUtil.getBean(this.getClass())).addOrUpdateExternalContact(appId, (List<FollowUser>)new ArrayList<FollowUser>(){
            {
                this.add(followContact.getFollow_info());
            }
        }, followContact.getExternal_contact());
        if (!saveContactRst.isSuccess()) {
            this.logger.error("\u6279\u91cf\u540c\u6b65\u4f01\u5fae\u7528\u6237[followUserId={}][externalUserId={}]\u5931\u8d25:{}", new Object[]{followContact.getFollow_info().getUserid(), followContact.getExternal_contact().getExternal_userid(), JsonUtils.toJson(saveContactRst, (boolean)false)});
        }
        this.distributorQiyeweixinExternalContactMapper.insertImport(followContact.getExternal_contact().getExternal_userid(), followContact.getFollow_info().getUserid());
    }
}

