/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.distribution.QwConfigInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseAccessToken;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class QwConfigService
extends BaseService
implements QwConfigInterface {
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    WeiXinBaseAccessToken weiXinBaseAccessToken;
    @Autowired
    RedissonClient redissonClient;
    private String secretId;
    private String corpId;
    private String agentId;
    private static Map<String, Ticket> ticketMap = new HashMap<String, Ticket>();

    @Override
    public BaseJsonVo getWeiXinPermissionsValidationConfig(String url, String type, long timestamp, String nonceStr) {
        if (StringUtils.isEmpty((String)url)) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u975e\u6cd5");
        }
        try {
            url = URLDecoder.decode(url, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        WeiXinBaseEntity baseEntity = this.weiXinBaseInterface.getWeiXinBase(10);
        if (baseEntity == null) {
            return BaseJsonVo.error((String)"App\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.corpId = baseEntity.getAppid();
        this.secretId = baseEntity.getAppscret();
        this.agentId = baseEntity.getMchId();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String ticket = "";
        try {
            if (ObjectUtils.isEmpty((Object)type)) {
                ticket = this.getJsApiTicket(0, baseEntity.getPlatformId(), null);
                data.put("appId", this.corpId);
                this.logger.info("get company temp ticket is \uff1a{}", (Object)ticket);
            } else {
                ticket = this.getJsApiTicket(0, baseEntity.getPlatformId(), type);
                data.put("agentid", this.agentId);
                data.put("corpid", this.corpId);
                this.logger.info("get app temp ticket is \uff1a{}", (Object)ticket);
            }
        }
        catch (InterruptedException e) {
            this.logger.error("\u83b7\u53d6ticket\u5931\u8d25", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)ticket)) {
            return BaseJsonVo.error((String)"\u83b7\u53d6\u4e34\u65f6\u7968\u636e\u5931\u8d25!");
        }
        String signature = this.getSignature(ticket, nonceStr, timestamp, url);
        data.put("timestamp", timestamp);
        data.put("nonceStr", nonceStr);
        data.put("signature", signature);
        return BaseJsonVo.success(data);
    }

    private String getSignature(String ticket, String nonceStr, long timestamp, String url) {
        try {
            String unEncryptStr = "jsapi_ticket=" + ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
            this.logger.info("unEncryptStr:" + unEncryptStr);
            MessageDigest sha = MessageDigest.getInstance("SHA");
            byte[] cipherBytes = sha.digest(unEncryptStr.getBytes());
            String encryptStr = Hex.encodeHexString((byte[])cipherBytes);
            return encryptStr;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsApiTicket(int num, Integer platformId, String type) throws InterruptedException {
        block10: {
            String accessToken = this.weiXinBaseAccessToken.getQiYeAccessTokenValueByPlatformId(platformId);
            if (StringUtils.isEmpty((String)accessToken)) {
                if (++num < 5) {
                    return this.getJsApiTicket(num, platformId, type);
                }
            } else {
                String key = MD5.sign((String)(accessToken + (StringUtils.isNotEmpty((String)type) ? type : "")));
                Object cache = this.redisCacheUtil.get(key);
                if (cache != null) {
                    return cache.toString();
                }
                WeiXinBaseEntity baseEntity = this.weiXinBaseInterface.getWeiXinBase(10);
                if (baseEntity.getJsapiTicketExpired() != null && baseEntity.getJsapiTicketExpired().after(DateUtils.now())) {
                    return baseEntity.getJsapiTicket();
                }
                RLock lock = this.redissonClient.getLock("JsApiTicket" + platformId + (StringUtils.isNotEmpty((String)type) ? type : ""));
                boolean res = lock.tryLock(100L, 10L, TimeUnit.SECONDS);
                if (res) {
                    try {
                        Ticket ticket = this.getJsApiTicketFromWeChatPlatform(key, accessToken, type);
                        if (ticket != null) {
                            baseEntity.setJsapiTicketExpired(new Date(ticket.getValid()));
                            baseEntity.setJsapiTicket(ticket.getTicket());
                            this.weiXinBaseInterface.saveWeiXinBase(baseEntity);
                            String string = ticket.getTicket();
                            return string;
                        }
                        break block10;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                this.logger.error("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u653e\u5f03\u6267\u884c...");
            }
        }
        return null;
    }

    public Ticket getJsApiTicketFromWeChatPlatform(String key, String accessToken, String type) {
        String body;
        String url = Objects.equals("agent_config", type) ? "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=" + accessToken + "&type=" + type : "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=" + accessToken;
        if (StringUtils.isNotEmpty((String)accessToken) && StringUtils.isNotEmpty((String)(body = this.doGet(url)))) {
            this.logger.info("ticket:{}", (Object)body);
            JSONObject object = JSON.parseObject((String)body);
            if (object.getIntValue("errcode") == 0) {
                Ticket ticket = new Ticket();
                ticket.setTicket(object.getString("ticket"));
                ticket.setValid(System.currentTimeMillis() + object.getLong("expires_in") * 1000L);
                Boolean setCache = this.redisCacheUtil.set(key, (Object)object.getString("ticket"), object.getLong("expires_in"));
                this.logger.info("ticket key={},ticket={}\u8bbe\u7f6e\u7f13\u5b58:{},\u6709\u6548\u671f:{}", new Object[]{key, ticket.getTicket(), setCache, object.getLong("expires_in")});
                return ticket;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGet(String url) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String body = "";
        try {
            httpClient = HttpClients.createDefault();
            URL newUrl = new URL(url);
            HttpGet httpGet = new HttpGet(String.valueOf(newUrl));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return body;
    }

    private static class Ticket {
        private String ticket;
        private Long valid;

        private Ticket() {
        }

        public String getTicket() {
            return this.ticket;
        }

        public void setTicket(String ticket) {
            this.ticket = ticket;
        }

        public Long getValid() {
            return this.valid;
        }

        public void setValid(Long valid) {
            this.valid = valid;
        }

        public String toString() {
            return "Ticket{ticket='" + this.ticket + '\'' + ", valid=" + this.valid + '}';
        }
    }
}

