/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.common.file.OssService;
import cc.lechun.common.tree.TreeBuilder;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.item.BuildPageMapper;
import cc.lechun.mall.entity.common.MallTreeVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.BuildPageVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallBuildPageService
extends BaseService
implements MallBuildPageInterface {
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private BuildPageMapper buildPageMapper;
    @Autowired
    private OssService ossInterface;
    @Autowired
    private PlatFormGroupInterface platFormGroupInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="BuildPagetree", expiration=300)
    public List<MallTreeVo> getBuildPageTree(@ParameterValueKeyProvider int platformGroupId) {
        List<PlatFormEntity> platFormEntities;
        List<Object> platFormGroupEntities = new ArrayList<PlatFormGroupEntity>();
        ArrayList<MallTreeVo> mallTreeVos = new ArrayList<MallTreeVo>();
        if (platformGroupId == 0) {
            platFormGroupEntities = this.platFormGroupInterface.getValidPlatFormGroupList();
            platFormEntities = this.platFormInterface.getValidPlatFormList4All();
        } else {
            platFormGroupEntities.add(this.platFormGroupInterface.getPlatFormGroup(platformGroupId));
            platFormEntities = this.platFormInterface.getValidPlatFormList(platformGroupId);
        }
        if (platFormGroupEntities != null && platFormGroupEntities.size() > 0 && platFormEntities != null && platFormEntities.size() > 0) {
            for (PlatFormGroupEntity platFormGroupEntity : platFormGroupEntities) {
                List<DictionaryEntity> dictionaryEntities = this.dictionaryInterface.getValidDictionaryList(platFormGroupEntity.getPlatformGroupId(), 24);
                if (dictionaryEntities == null || dictionaryEntities.size() <= 0) continue;
                MallTreeVo treeVo = new MallTreeVo();
                treeVo.setId(String.valueOf(platFormGroupEntity.getPlatformGroupId()));
                treeVo.setName(platFormGroupEntity.getPlatformGroupName());
                treeVo.setRemark(platFormGroupEntity.getPlatformGroupDesc());
                treeVo.setpId("");
                mallTreeVos.add(treeVo);
                for (PlatFormEntity p : platFormEntities) {
                    if (p.getPlatformGroupId().intValue() != platFormGroupEntity.getPlatformGroupId().intValue()) continue;
                    treeVo = new MallTreeVo();
                    treeVo.setId(String.valueOf(p.getPlatformId()));
                    treeVo.setName(p.getPlatformName());
                    treeVo.setRemark(p.getPlatformDesc());
                    treeVo.setpId(String.valueOf(platFormGroupEntity.getPlatformGroupId()));
                    mallTreeVos.add(treeVo);
                    for (DictionaryEntity d : dictionaryEntities) {
                        treeVo = new MallTreeVo();
                        treeVo.setId(platFormGroupEntity.getPlatformGroupId() + "_" + p.getPlatformId() + "_" + d.getDictionaryKey());
                        treeVo.setName(d.getDictionaryName());
                        treeVo.setRemark(d.getRemark());
                        treeVo.setpId(String.valueOf(p.getPlatformId()));
                        treeVo.setLeaf(1);
                        mallTreeVos.add(treeVo);
                    }
                }
            }
        }
        return TreeBuilder.builder(mallTreeVos);
    }

    @Override
    public List<BuildPageVo> getBuildPageEntityList(int platformId, short navType) {
        ArrayList<BuildPageVo> buildPageVos = new ArrayList<BuildPageVo>();
        BuildPageEntity buildPageEntity = new BuildPageEntity();
        buildPageEntity.setPlatformId(platformId);
        buildPageEntity.setNavType(navType);
        List buildPageEntities = this.buildPageMapper.getList(buildPageEntity);
        if (buildPageEntities != null) {
            PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(platformId);
            try {
                for (BuildPageEntity p : buildPageEntities) {
                    DictionaryEntity dictionaryEntity;
                    BuildPageVo buildPageVo = new BuildPageVo();
                    ObjectConvert.fatherConvertToChild((Object)p, (Object)buildPageVo);
                    if (platFormEntity != null && (dictionaryEntity = this.dictionaryInterface.getDictionary(platFormEntity.getPlatformGroupId(), 24, String.valueOf(navType))) != null) {
                        buildPageVo.setNavTypeName(dictionaryEntity.getDictionaryName());
                    }
                    buildPageVo.setImageUrl(this.ossInterface.getImageResoure() + buildPageVo.getImageUrl());
                    buildPageVos.add(buildPageVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.getMessage());
            }
        }
        return buildPageVos;
    }

    @Override
    public boolean deleteBuildPage(int buildPageId) {
        boolean b;
        BuildPageEntity buildPageEntity = this.getBuildPage(buildPageId);
        boolean bl = b = this.buildPageMapper.deleteByPrimaryKey(Integer.valueOf(buildPageId)) == 1;
        if (buildPageEntity != null) {
            this.removeCache(buildPageId, buildPageEntity.getPlatformId(), buildPageEntity.getNavType());
        }
        return b;
    }

    @Override
    @ReadThroughSingleCache(namespace="BuildPageEntity", expiration=3600)
    public BuildPageEntity getBuildPage(@ParameterValueKeyProvider int buildPageId) {
        return (BuildPageEntity)this.buildPageMapper.selectByPrimaryKey(Integer.valueOf(buildPageId));
    }

    @Override
    @ReadThroughSingleCache(namespace="BuildPageEntity", expiration=3600)
    public List<BuildPageEntity> getBuildPageByNavType(@ParameterValueKeyProvider(order=0) int platformId, @ParameterValueKeyProvider(order=1) short navType) {
        BuildPageEntity buildPageEntity = new BuildPageEntity();
        buildPageEntity.setNavType(navType);
        buildPageEntity.setPlatformId(platformId);
        return this.buildPageMapper.getList(buildPageEntity);
    }

    @Override
    public BaseJsonVo saveBuildPage(BuildPageEntity buildPageEntity) {
        boolean isNew = false;
        int platformGroupId = 0;
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(buildPageEntity.getPlatformId());
        if (platFormEntity != null) {
            platformGroupId = platFormEntity.getPlatformGroupId();
        }
        if (buildPageEntity.getBuildPageId() == null || buildPageEntity.getBuildPageId() == 0) {
            isNew = true;
        }
        if (isNew) {
            BuildPageEntity pageEntity1 = new BuildPageEntity();
            pageEntity1.setPageName(buildPageEntity.getPageName());
            pageEntity1.setPlatformId(buildPageEntity.getPlatformId());
            if (this.buildPageMapper.existsByEntity(pageEntity1) > 0) {
                return BaseJsonVo.error((String)"\u9875\u9762\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u4fdd\u5b58");
            }
            buildPageEntity.setPageCode(IDGenerate.getUniqueIdStr());
            buildPageEntity.setCreateTime(DateUtils.now());
        }
        String content = "";
        content = buildPageEntity.getPageContent();
        if (buildPageEntity.getSaveType() == 1) {
            buildPageEntity.setPath("");
            String u = this.ossInterface.uploadFile(AliyunOSSDir.HTML_MODULE, buildPageEntity.getPageCode() + ".html", content);
            if (!u.isEmpty()) {
                buildPageEntity.setUrl(u);
            } else {
                return BaseJsonVo.error((String)"\u4e0a\u4f20\u5230oss\u5931\u8d25");
            }
        }
        if (buildPageEntity.getSaveType() == 2) {
            // empty if block
        }
        int count = 0;
        count = isNew ? this.buildPageMapper.insertSelective(buildPageEntity) : this.buildPageMapper.updateByPrimaryKeySelective(buildPageEntity);
        if (count == 0) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        this.removeCache(buildPageEntity.getBuildPageId(), buildPageEntity.getPlatformId(), buildPageEntity.getNavType());
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public BaseJsonVo saveBuildPage(BuildPageEntity buildPageEntity, int platformGroupId) {
        boolean isNew = false;
        if (buildPageEntity.getBuildPageId() == null || buildPageEntity.getBuildPageId() == 0) {
            isNew = true;
        }
        if (isNew) {
            BuildPageEntity pageEntity1 = new BuildPageEntity();
            pageEntity1.setPageName(buildPageEntity.getPageName());
            pageEntity1.setPlatformId(buildPageEntity.getPlatformId());
            if (this.buildPageMapper.existsByEntity(pageEntity1) > 0) {
                return BaseJsonVo.error((String)"\u9875\u9762\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u4fdd\u5b58");
            }
            buildPageEntity.setPageCode(IDGenerate.getUniqueIdStr());
            buildPageEntity.setCreateTime(DateUtils.now());
        }
        String content = "";
        content = buildPageEntity.getPageContent();
        if (buildPageEntity.getSaveType() == 1) {
            buildPageEntity.setPath("");
            String u = this.ossInterface.uploadFile(AliyunOSSDir.HTML_MODULE, buildPageEntity.getPageCode() + ".html", content);
            if (!u.isEmpty()) {
                buildPageEntity.setUrl(u);
            } else {
                return BaseJsonVo.error((String)"\u4e0a\u4f20\u5230oss\u5931\u8d25");
            }
        }
        if (buildPageEntity.getSaveType() == 2) {
            // empty if block
        }
        int count = 0;
        if (isNew) {
            List<PlatFormEntity> list = this.platFormInterface.getPlatFormList(platformGroupId);
            for (PlatFormEntity platFormEntity : list) {
                buildPageEntity.setPlatformId(platFormEntity.getPlatformId());
                count = this.buildPageMapper.insertSelective(buildPageEntity);
            }
        } else {
            count = this.buildPageMapper.updateByPrimaryKeySelective(buildPageEntity);
        }
        if (count == 0) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        this.removeCache(buildPageEntity.getBuildPageId(), buildPageEntity.getPlatformId(), buildPageEntity.getNavType());
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void removeCache(int buildPageId, int platformId, short navType) {
        this.memcachedService.delete("BuildPageEntity", String.valueOf(buildPageId));
        this.memcachedService.delete("BuildPageEntityByNavType", platformId + "" + navType);
        this.memcachedService.delete("BuildPageList", platformId + "" + navType);
    }
}

